/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.table;

import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class TableUtils {
    private static final String INDEX = "index";
    private static final String SELECTED = "selected";
    private static final int DOUBLE_CLICKED = 2;

    public static <T> void isCheckBox(TableColumn<T, Boolean> column) {
        column.setCellFactory(data -> new MxCheckBoxTableCell());
        column.getTableView().setEditable(true);
    }

    public static <T> void isAuto(TableColumn<T, String> index) {
        index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        index.setSortable(false);
    }

    public static <T> void initValueFactory(TableView<T> table) {
        for (TableColumn column : table.getColumns()) {
            String tableId = table.getId();
            if (column.getId() == null) continue;
            String s = column.getId().replace(tableId, "");
            String columnId = Character.toLowerCase(s.charAt(0)) + s.substring(1);
            if (INDEX.equals(columnId)) {
                TableUtils.isAuto(column);
                continue;
            }
            if (SELECTED.equals(columnId)) {
                TableUtils.isCheckBox(column);
            }
            column.setCellValueFactory((Callback)new PropertyValueFactory(columnId));
        }
    }

    public static <T> void initContextMenu(TableView<T> table) {
        ContextMenu contMenu = table.getContextMenu();
        table.setContextMenu(null);
        table.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> table.setContextMenu(now == null ? null : contMenu));
    }

    public static <T> void copyContent(TableView<T> table) {
        TableUtils.copyContent(table, 0, 0);
    }

    public static <T> void copyContent(TableView<T> table, int beginCol, int beginRow) {
        ClipboardContent allContent = new ClipboardContent();
        String rowContent = "";
        int i = beginRow;
        while (i < table.getItems().size()) {
            int r = beginCol;
            while (r < table.getColumns().size()) {
                rowContent = String.valueOf(rowContent) + ((TableColumn)table.getColumns().get(r)).getCellData(i) + "\t";
                ++r;
            }
            rowContent = String.valueOf(rowContent) + "\n";
            allContent.putString(rowContent);
            ++i;
        }
        Clipboard.getSystemClipboard().setContent((Map)allContent);
    }

    public static <T> void copyContentWithHead(TableView<T> table) {
        TableUtils.copyContentWithHead(table, 0, 0);
    }

    public static <T> void copyContentWithHead(TableView<T> table, int beginCol, int beginRow) {
        ClipboardContent allContent = new ClipboardContent();
        StringBuilder rowContent = new StringBuilder();
        StringBuilder rowHead = new StringBuilder();
        boolean flag = true;
        Object obj = null;
        int i = beginRow;
        while (i < table.getItems().size()) {
            int r = beginCol;
            while (r < table.getColumns().size()) {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    if (flag) {
                        rowHead.append(((TableColumn)table.getColumns().get(r)).getText()).append("\t");
                    }
                    if ((obj = ((TableColumn)table.getColumns().get(r)).getCellData(i)) == null || obj instanceof HBox || obj instanceof Label || obj instanceof ArrayList || obj instanceof Boolean) {
                        obj = "";
                    }
                    rowContent.append(obj).append("\t");
                }
                ++r;
            }
            flag = false;
            rowContent.append("\n");
            ++i;
        }
        allContent.putString(rowHead.append("\n").append((CharSequence)rowContent).toString());
        Clipboard.getSystemClipboard().setContent((Map)allContent);
    }

    public static <T> void copyContentWithTwoHead(TableView<T> table, int beginCol, int beginRow) {
        ClipboardContent allContent = new ClipboardContent();
        StringBuilder rowContent = new StringBuilder();
        StringBuilder rowHeadOne = new StringBuilder();
        StringBuilder rowHeadTwo = new StringBuilder();
        boolean flag = true;
        Object obj = null;
        int i = beginRow;
        while (i < table.getItems().size()) {
            int r = beginCol;
            while (r < table.getColumns().size()) {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    ObservableList list;
                    if (flag) {
                        rowHeadOne.append(((TableColumn)table.getColumns().get(r)).getText()).append("\t");
                    }
                    if ((list = ((TableColumn)table.getColumns().get(r)).getColumns()).size() == 0) {
                        if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                            rowHeadTwo.append("\t");
                            obj = ((TableColumn)table.getColumns().get(r)).getCellData(i);
                            if (obj instanceof Number) {
                                BigDecimal big = new BigDecimal(obj.toString());
                                rowContent.append(big.toString()).append("\t");
                            } else if (obj instanceof List) {
                                rowContent.append("").append("\t");
                            } else {
                                rowContent.append(obj == null || obj.toString() == null ? "" : obj).append("\t");
                            }
                        }
                    } else {
                        int x = beginCol;
                        while (x < list.size() - 1) {
                            if (flag) {
                                rowHeadOne.append("").append("\t");
                            }
                            ++x;
                        }
                        x = beginCol;
                        while (x < list.size()) {
                            if (((TableColumn)list.get(x)).isVisible()) {
                                if (flag) {
                                    rowHeadTwo.append(((TableColumn)list.get(x)).getText()).append("\t");
                                }
                                if ((obj = ((TableColumn)list.get(x)).getCellData(i)) instanceof Number) {
                                    BigDecimal big = new BigDecimal(obj.toString());
                                    rowContent.append(big.toString()).append("\t");
                                } else if (obj instanceof List) {
                                    rowContent.append("").append("\t");
                                } else {
                                    rowContent.append(obj == null ? "" : obj).append("\t");
                                }
                            }
                            ++x;
                        }
                    }
                }
                ++r;
            }
            flag = false;
            rowContent.append("\n");
            ++i;
        }
        allContent.putString(rowHeadOne.append("\n").append((CharSequence)rowHeadTwo).append("\n").append((CharSequence)rowContent).toString());
        Clipboard.getSystemClipboard().setContent((Map)allContent);
    }

    public static <T> void copyContentWithTwoHeadList(TableView<T> table, List<T> listData, Map<String, String> reactMap) {
        ClipboardContent allContent = new ClipboardContent();
        StringBuilder rowContent = new StringBuilder();
        StringBuilder rowHeadOne = new StringBuilder();
        StringBuilder rowHeadTwo = new StringBuilder();
        boolean flag = true;
        int i = 0;
        while (i < listData.size()) {
            int r = 0;
            while (r < table.getColumns().size()) {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    ObservableList listColumn;
                    if (flag) {
                        rowHeadOne.append(((TableColumn)table.getColumns().get(r)).getText()).append("\t");
                    }
                    if ((listColumn = ((TableColumn)table.getColumns().get(r)).getColumns()).size() == 0) {
                        if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                            rowHeadTwo.append("\t");
                            String colId = ((TableColumn)table.getColumns().get(r)).getId();
                            if (reactMap.get(colId) == null) {
                                rowContent.append(i + 1).append("\t");
                            } else if (reactMap.get(colId).isEmpty()) {
                                rowContent.append("").append("\t");
                            } else {
                                try {
                                    Class<?> clazz = listData.get(i).getClass();
                                    Method method = clazz.getMethod("get" + reactMap.get(colId), new Class[0]);
                                    Object content = method.invoke(listData.get(i), new Object[0]);
                                    rowContent.append(content == null ? "" : content);
                                }
                                catch (NoSuchMethodException | SecurityException e) {
                                    rowContent.append("");
                                    e.printStackTrace();
                                }
                                catch (IllegalAccessException e) {
                                    rowContent.append("");
                                    e.printStackTrace();
                                }
                                catch (IllegalArgumentException e) {
                                    rowContent.append("");
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    rowContent.append("");
                                    e.printStackTrace();
                                }
                                rowContent.append("\t");
                            }
                        }
                    } else {
                        int x = 0;
                        while (x < listColumn.size() - 1) {
                            if (flag) {
                                rowHeadOne.append("").append("\t");
                            }
                            ++x;
                        }
                        x = 0;
                        while (x < listColumn.size()) {
                            if (((TableColumn)listColumn.get(x)).isVisible()) {
                                String colId;
                                if (flag) {
                                    rowHeadTwo.append(((TableColumn)listColumn.get(x)).getText()).append("\t");
                                }
                                if (reactMap.get(colId = ((TableColumn)listColumn.get(x)).getId()) == null) {
                                    rowContent.append(i + 1);
                                } else if (reactMap.get(colId).isEmpty()) {
                                    rowContent.append("").append("\t");
                                } else {
                                    try {
                                        Class<?> clazz = listData.get(i).getClass();
                                        Method method = clazz.getMethod("get" + reactMap.get(colId), new Class[0]);
                                        Object content = method.invoke(listData.get(i), new Object[0]);
                                        rowContent.append(content == null ? "" : content);
                                    }
                                    catch (NoSuchMethodException | SecurityException e) {
                                        rowContent.append("");
                                        e.printStackTrace();
                                    }
                                    catch (IllegalAccessException e) {
                                        rowContent.append("");
                                        e.printStackTrace();
                                    }
                                    catch (IllegalArgumentException e) {
                                        rowContent.append("");
                                        e.printStackTrace();
                                    }
                                    catch (InvocationTargetException e) {
                                        rowContent.append("");
                                        e.printStackTrace();
                                    }
                                    rowContent.append("\t");
                                }
                            }
                            ++x;
                        }
                    }
                }
                ++r;
            }
            flag = false;
            rowContent.append("\n");
            ++i;
        }
        allContent.putString(rowHeadOne.append("\n").append((CharSequence)rowHeadTwo).append("\n").append((CharSequence)rowContent).toString());
        Clipboard.getSystemClipboard().setContent((Map)allContent);
    }

    public static <T> void basketCopyContentWithTwoHead(TableView<T> table, int beginCol, int beginRow, TableColumn<T, Number> colAbWeight, TableColumn<T, Number> colPct) {
        ClipboardContent allContent = new ClipboardContent();
        StringBuilder rowContent = new StringBuilder();
        StringBuilder rowHeadOne = new StringBuilder();
        StringBuilder rowHeadTwo = new StringBuilder();
        boolean flag = true;
        Object obj = null;
        int i = beginRow;
        while (i < table.getItems().size()) {
            int r = beginCol;
            while (r < table.getColumns().size()) {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    if (flag) {
                        rowHeadOne.append(((TableColumn)table.getColumns().get(r)).getText()).append("\t");
                    }
                    ObservableList list = ((TableColumn)table.getColumns().get(r)).getColumns();
                    int x = beginCol;
                    while (x < list.size() - 1) {
                        if (flag) {
                            rowHeadOne.append("").append("\t");
                        }
                        ++x;
                    }
                    x = beginCol;
                    while (x < list.size()) {
                        if (((TableColumn)list.get(x)).isVisible()) {
                            if (flag) {
                                rowHeadTwo.append(((TableColumn)list.get(x)).getText()).append("\t");
                            }
                            if ((obj = ((TableColumn)list.get(x)).getCellData(i)) == null) {
                                rowContent.append("\t");
                            } else if (colAbWeight.getId().equals(((TableColumn)list.get(x)).getId())) {
                                rowContent.append(obj == null ? "" : String.valueOf(obj.toString()) + "%").append("\t");
                            } else if (colPct.getId().equals(((TableColumn)list.get(x)).getId())) {
                                String percent = StringUtils.toPriceStr((double)Double.parseDouble(obj.toString()), (int)2);
                                rowContent.append(String.valueOf(percent) + "%").append("\t");
                            } else {
                                rowContent.append(obj).append("\t");
                            }
                        }
                        ++x;
                    }
                }
                ++r;
            }
            flag = false;
            rowContent.append("\n");
            ++i;
        }
        allContent.putString(rowHeadOne.append("\n").append((CharSequence)rowHeadTwo).append("\n").append((CharSequence)rowContent).toString());
        Clipboard.getSystemClipboard().setContent((Map)allContent);
    }

    public static <T> void doubleClicked(TableView<T> table, ClickItem<T> mci) {
        table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                Object item;
                if (event.getClickCount() == 2 && !row.isEmpty() && (item = row.getItem()) != null) {
                    mci.click(item);
                }
            });
            return row;
        });
    }

    public static <T> void realClicked(TableView<T> table) {
        table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
                Object item = row.getItem();
                if (item == null) {
                    event.consume();
                }
            });
            return row;
        });
    }

    public static <T> void beforeClick(TableView<T> table, ClickItem<T> mci) {
        table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
                Object item = row.getItem();
                if (!mci.click(item)) {
                    event.consume();
                }
            });
            return row;
        });
    }

    public static <T> void orgnizeClmWidth(TableView<T> table) {
    }

    public static <T> void orgnizeClmWidth(TreeTableView<T> table) {
    }

    public static <T> void copyContentWithHead(TableView<T> table, ObservableList list) {
        ClipboardContent allContent = new ClipboardContent();
        StringBuilder rowContent = new StringBuilder();
        StringBuilder rowHead = new StringBuilder();
        boolean flag = true;
        int i = 0;
        while (i < list.size()) {
            int r = 0;
            while (r < table.getColumns().size()) {
                block10: {
                    if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                        if (flag) {
                            rowHead.append(((TableColumn)table.getColumns().get(r)).getText()).append("\t");
                        }
                        Class<?> clazz = list.get(i).getClass();
                        try {
                            if (((TableColumn)table.getColumns().get(r)).getId() == null) {
                                rowContent.append("");
                                break block10;
                            }
                            Method method = clazz.getMethod("get" + TableUtils.capitalize(((TableColumn)table.getColumns().get(r)).getId()), new Class[0]);
                            Object content = method.invoke(list.get(i), new Object[0]);
                            rowContent.append(content == null ? "" : content);
                        }
                        catch (NoSuchMethodException | SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        rowContent.append("\t");
                    }
                }
                ++r;
            }
            flag = false;
            rowContent.append("\n");
            ++i;
        }
        allContent.putString(rowHead.append("\n").append((CharSequence)rowContent).toString());
        Clipboard.getSystemClipboard().setContent((Map)allContent);
    }

    public static void autoResizeColumns(TableView<?> table) {
        table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        table.getColumns().stream().forEach(column -> {
            Text t = new Text(column.getText());
            double max = t.getLayoutBounds().getWidth();
            int i = 0;
            while (i < table.getItems().size()) {
                double calcwidth;
                if (column.getCellData(i) != null && (calcwidth = (t = new Text(column.getCellData(i).toString())).getLayoutBounds().getWidth()) > max) {
                    max = calcwidth;
                }
                ++i;
            }
            column.setPrefWidth(max + 10.0);
        });
    }

    public static void autoResizeColumns(TreeTableView<?> table) {
        if (table.getRoot() == null || table.getRoot().getChildren() == null) {
            return;
        }
        table.setColumnResizePolicy(TreeTableView.UNCONSTRAINED_RESIZE_POLICY);
        table.getColumns().stream().forEach(column -> {
            if (column.isVisible()) {
                System.err.println(column.getText());
                Text t = new Text(column.getText());
                double max = t.getLayoutBounds().getWidth();
                int i = 0;
                while (i < table.getRoot().getChildren().size()) {
                    double calcwidth;
                    if (column.getCellData(i) != null && (calcwidth = (t = new Text(column.getCellData(i).toString())).getLayoutBounds().getWidth()) > max) {
                        max = calcwidth;
                    }
                    ++i;
                }
                column.setPrefWidth(max + 10.0);
            }
        });
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static <T> void initScroll(TreeTableView<T> table, StringConverter<T> converter) {
        HashMap map = new HashMap();
        table.getRoot().getChildren().forEach(item -> map.put(converter.toString(item.getValue()), item));
        table.getRoot().getChildren().addListener(ob -> {
            map.clear();
            table.getRoot().getChildren().forEach(item -> map.put(converter.toString(item.getValue()), item));
        });
        table.setRowFactory(tv -> {
            TreeTableRow row = new TreeTableRow();
            row.setOnDragDetected(event -> {
                if (row.isEmpty()) {
                    return;
                }
                String key = converter.toString(row.getItem());
                if (key != null && !key.isEmpty()) {
                    Dragboard db = row.startDragAndDrop(TransferMode.COPY_OR_MOVE);
                    ClipboardContent cc = new ClipboardContent();
                    cc.putString(key);
                    db.setContent((Map)cc);
                }
            });
            row.setOnDragOver(event -> event.acceptTransferModes(TransferMode.COPY_OR_MOVE));
            row.setOnDragEntered(event -> {
                double rowY = row.getLayoutY();
                double rowHg = row.getHeight();
                double contentHg = table.getHeight() - 55.0;
                double lastRow = contentHg - rowHg * 1.3;
                if (rowY < rowHg) {
                    table.scrollTo(row.getIndex() - 1);
                } else if (rowY > lastRow) {
                    int showNum = (int)(contentHg / rowHg);
                    int indexTo = row.getIndex() - showNum + 1;
                    table.scrollTo(indexTo);
                }
            });
            row.setOnDragDropped(event -> {
                String code = event.getDragboard().getString();
                TreeItem item = (TreeItem)map.get(code);
                if (item != null) {
                    int dropIndex = row.getIndex();
                    String now = converter.toString(row.getItem());
                    if (map.get(now) == null) {
                        dropIndex = table.getRoot().getChildren().indexOf((Object)row.getTreeItem().getParent());
                    }
                    if (dropIndex >= table.getRoot().getChildren().size()) {
                        dropIndex = table.getRoot().getChildren().size() - 1;
                    }
                    table.getRoot().getChildren().remove((Object)item);
                    table.getRoot().getChildren().add(dropIndex, (Object)item);
                    table.getSelectionModel().select((Object)item);
                }
                event.setDropCompleted(true);
                event.consume();
            });
            return row;
        });
    }

    public static interface ClickItem<T> {
        public boolean click(T var1);
    }
}

