/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.table;

import cms.tmx.control.cvts.NumberCvt;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.TextFieldTreeTableCell;
import javafx.util.StringConverter;

public class EditTreeTableCell<S>
extends TextFieldTreeTableCell<S, Number> {
    public TextField textField;
    private StringConverter<Number> cvt;
    private List<ChangeListener<String>> listLstns = new LinkedList<ChangeListener<String>>();
    private int num = -1;
    private ChangeListener<Boolean> lstnFocus = (ob, old, now) -> {
        if (!now.booleanValue() && this.textField != null) {
            this.commitEdit((Number)this.cvt.fromString(this.textField.getText()));
        }
    };

    public EditTreeTableCell() {
        this("%1$,.2f");
        this.num = 2;
    }

    public EditTreeTableCell(int i) {
        this("%1$,." + i + "f");
        this.num = i;
    }

    public EditTreeTableCell(String format) {
        NumberCvt cvtNum = new NumberCvt(format);
        cvtNum.setFormat(format);
        this.cvt = cvtNum;
        this.setConverter(this.cvt);
    }

    public List<ChangeListener<String>> getListeners() {
        return this.listLstns;
    }

    public void startEdit() {
        super.startEdit();
        try {
            if (this.textField == null) {
                Field field = EditTreeTableCell.class.getSuperclass().getDeclaredField("textField");
                field.setAccessible(true);
                this.textField = (TextField)field.get((Object)this);
                if (this.textField != null) {
                    this.textField.focusedProperty().addListener(this.lstnFocus);
                    for (ChangeListener<String> lstn : this.listLstns) {
                        this.textField.textProperty().addListener(lstn);
                    }
                    if (this.num == 0) {
                        this.textField.textProperty().addListener((ob, old, now) -> {
                            if (!"".equals(now) && !StringUtils.isInt((String)now)) {
                                ((StringProperty)ob).setValue(old);
                            }
                        });
                    } else if (this.num > 0) {
                        this.textField.textProperty().addListener((ob, old, now) -> {
                            if (!"".equals(now) && !StringUtils.isDouble((String)now)) {
                                ((StringProperty)ob).setValue(old);
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
    }

    public void commitEdit(Number item) {
        TreeTableView table;
        if (!this.isEditing() && !item.equals(this.getItem()) && (table = this.getTreeTableView()) != null) {
            TreeTableColumn col = this.getTableColumn();
            TreeTableColumn.CellEditEvent event = new TreeTableColumn.CellEditEvent(table, new TreeTablePosition(table, this.getIndex(), col), TreeTableColumn.editCommitEvent(), (Object)item);
            Event.fireEvent((EventTarget)col, (Event)event);
        }
        super.commitEdit((Object)item);
    }

    public TextField getTextField() {
        return this.textField;
    }

    public void setFormat(String format) {
        NumberCvt cvtNum = new NumberCvt(format);
        cvtNum.setFormat(format);
        this.cvt = cvtNum;
        this.setConverter(this.cvt);
    }

    public void setCvt(StringConverter<Number> cvt) {
        this.cvt = cvt;
    }
}

