/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.table;

import java.lang.reflect.Field;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.StringConverter;

public class EditTableCellString<S>
extends TextFieldTableCell<S, String> {
    protected TextField textField;
    public StringConverter<String> cvt;
    private ChangeListener<Boolean> lstnFocus = (ob, old, now) -> {
        if (!now.booleanValue() && this.textField != null) {
            this.loseFocus();
        }
    };

    public EditTableCellString() {
        this.cvt = new Converter();
        this.setConverter(this.cvt);
    }

    public void commitEdit(String newValue) {
        TableView table;
        if (!this.isEditing() && !newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
            TableColumn col = this.getTableColumn();
            TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), col), TableColumn.editCommitEvent(), (Object)newValue);
            Event.fireEvent((EventTarget)col, (Event)event);
        }
        super.commitEdit((Object)newValue);
    }

    public void startEdit() {
        super.startEdit();
        try {
            if (this.textField == null) {
                Field field = EditTableCellString.class.getSuperclass().getDeclaredField("textField");
                field.setAccessible(true);
                this.textField = (TextField)field.get((Object)this);
                if (this.textField != null) {
                    this.textField.focusedProperty().addListener(this.lstnFocus);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
    }

    public TextField getTextField() {
        return this.textField;
    }

    protected void loseFocus() {
        this.commitEdit(this.textField.getText());
    }

    class Converter
    extends StringConverter<String> {
        Converter() {
        }

        public String toString(String object) {
            return object;
        }

        public String fromString(String string) {
            return string;
        }
    }
}

