/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.table;

import cms.tmx.control.cvts.NumberCvt;
import cms.tmx.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.StringConverter;

public class EditTableCell<S>
extends TextFieldTableCell<S, Number> {
    private TextField textField;
    public StringConverter<Number> cvt;
    private List<ChangeListener<String>> listLstns = new LinkedList<ChangeListener<String>>();
    public boolean canNegtive = false;
    private int num = 2;
    private ChangeListener<Boolean> lstnFocus = (ob, old, now) -> {
        if (!now.booleanValue() && this.textField != null) {
            this.loseFocus();
        }
    };

    public EditTableCell() {
        this("%1$,.2f");
    }

    public EditTableCell(int i) {
        this("%1$,." + i + "f");
        this.num = i;
    }

    public EditTableCell(String format) {
        NumberCvt cvtNum = new NumberCvt(format);
        cvtNum.setFormat(format);
        this.cvt = cvtNum;
        this.setConverter(this.cvt);
    }

    public List<ChangeListener<String>> getListeners() {
        return this.listLstns;
    }

    public void commitEdit(Number newValue) {
        TableView table;
        if (!this.isEditing() && !newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
            TableColumn col = this.getTableColumn();
            TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), col), TableColumn.editCommitEvent(), (Object)newValue);
            Event.fireEvent((EventTarget)col, (Event)event);
        }
        super.commitEdit((Object)newValue);
    }

    public void startEdit() {
        super.startEdit();
        try {
            if (this.textField == null) {
                Field field = EditTableCell.class.getSuperclass().getDeclaredField("textField");
                field.setAccessible(true);
                this.textField = (TextField)field.get((Object)this);
                if (this.textField != null) {
                    this.textField.focusedProperty().addListener(this.lstnFocus);
                    for (ChangeListener<String> lstn : this.listLstns) {
                        this.textField.textProperty().addListener(lstn);
                    }
                    if (this.num == 0) {
                        this.textField.textProperty().addListener((ob, old, now) -> {
                            if (!"".equals(now) && !StringUtils.isInt((String)now)) {
                                ((StringProperty)ob).setValue(old);
                            }
                        });
                    } else if (this.num > 0) {
                        this.textField.textProperty().addListener((ob, old, now) -> {
                            if (this.canNegtive && now.equals("-")) {
                                return;
                            }
                            if (!"".equals(now) && !StringUtils.isMinusDouble1((String)now, (int)this.num)) {
                                ((StringProperty)ob).setValue(old);
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
    }

    public TextField getTextField() {
        return this.textField;
    }

    protected void loseFocus() {
        this.commitEdit((Number)this.cvt.fromString(this.textField.getText()));
    }

    public void setFormat(String format) {
        NumberCvt cvtNum = new NumberCvt(format);
        cvtNum.setFormat(format);
        this.cvt = cvtNum;
        this.setConverter(this.cvt);
    }

    public void setCvt(StringConverter<Number> cvt) {
        this.cvt = cvt;
    }

    public void setNum(int num) {
        this.num = num;
    }
}

