/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.spinner;

import cms.tmx.control.spinner.DoubleValueFactory;
import cms.tmx.control.spinner.IntegerValueFactory;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.control.Spinner;

public class SpinnerUtils {
    public static void addDoubleArrowKeyHandler(Spinner<Double> spinner, ObservableNumberValue ud, ObservableNumberValue lr) {
        spinner.getEditor().setOnKeyPressed(event -> {
            double value = 0.0;
            switch (event.getCode()) {
                case UP: {
                    value = ud.doubleValue();
                    break;
                }
                case DOWN: {
                    value = -ud.doubleValue();
                    break;
                }
                case LEFT: {
                    value = -lr.doubleValue();
                    break;
                }
                case RIGHT: {
                    value = lr.doubleValue();
                    break;
                }
                default: {
                    return;
                }
            }
            DoubleValueFactory vf = (DoubleValueFactory)((Object)((Object)DoubleValueFactory.class.cast(spinner.getValueFactory())));
            if (vf == null) {
                return;
            }
            String text = spinner.getEditor().getText().replaceAll(",", "");
            vf.setValue(text.isEmpty() ? 0.0 : Double.parseDouble(text));
            double now = (Double)vf.getConverter().fromString(text);
            if (vf.getValue() == null) {
                vf.setValue(now);
            }
            event.consume();
            if (value > 0.0) {
                vf.increment(value);
            } else {
                vf.decrement(-value);
            }
            spinner.getEditor().selectAll();
        });
    }

    public static void addDoubleArrowKeyHandler(Spinner<Double> spinner, double ud, double lr) {
        spinner.getEditor().setOnKeyPressed(event -> {
            double value = 0.0;
            switch (event.getCode()) {
                case UP: {
                    value = ud;
                    break;
                }
                case DOWN: {
                    value = -ud;
                    break;
                }
                case LEFT: {
                    value = -lr;
                    break;
                }
                case RIGHT: {
                    value = lr;
                    break;
                }
                default: {
                    return;
                }
            }
            DoubleValueFactory vf = (DoubleValueFactory)((Object)((Object)DoubleValueFactory.class.cast(spinner.getValueFactory())));
            if (vf == null) {
                return;
            }
            String text = spinner.getEditor().getText().replaceAll(",", "");
            vf.setValue(text.isEmpty() ? 0.0 : Double.parseDouble(text));
            double now = (Double)vf.getConverter().fromString(text);
            if (vf.getValue() == null) {
                vf.setValue(now);
            }
            event.consume();
            if (value > 0.0) {
                vf.increment(value);
            } else {
                vf.decrement(-value);
            }
            spinner.getEditor().selectAll();
        });
    }

    public static void addIntArrowKeyHandler(Spinner<Integer> spinner, ObservableNumberValue ud, ObservableNumberValue lr) {
        spinner.getEditor().setOnKeyPressed(event -> {
            int value = 0;
            switch (event.getCode()) {
                case UP: {
                    value = ud.intValue();
                    break;
                }
                case DOWN: {
                    value = -ud.intValue();
                    break;
                }
                case LEFT: {
                    value = -lr.intValue();
                    break;
                }
                case RIGHT: {
                    value = lr.intValue();
                    break;
                }
                default: {
                    return;
                }
            }
            event.consume();
            IntegerValueFactory vf = (IntegerValueFactory)((Object)((Object)IntegerValueFactory.class.cast(spinner.getValueFactory())));
            if (vf == null) {
                return;
            }
            String text = spinner.getEditor().getText().replaceAll(",", "");
            vf.setValue(text.isEmpty() ? 0 : Integer.parseInt(text));
            int now = (Integer)vf.getConverter().fromString(text);
            if (vf.getValue() == null) {
                vf.setValue(now);
            }
            if (value > 0) {
                vf.increment(value / vf.getUnit());
            } else {
                vf.decrement(-value / vf.getUnit());
            }
            spinner.getEditor().selectAll();
        });
    }

    public static void addIntArrowKeyHandler(Spinner<Integer> spinner, int ud, int lr) {
        spinner.getEditor().setOnKeyPressed(event -> {
            int value = 0;
            switch (event.getCode()) {
                case UP: {
                    value = ud;
                    break;
                }
                case DOWN: {
                    value = -ud;
                    break;
                }
                case LEFT: {
                    value = -lr;
                    break;
                }
                case RIGHT: {
                    value = lr;
                    break;
                }
                default: {
                    return;
                }
            }
            event.consume();
            IntegerValueFactory vf = (IntegerValueFactory)((Object)((Object)IntegerValueFactory.class.cast(spinner.getValueFactory())));
            if (vf == null) {
                return;
            }
            String text = spinner.getEditor().getText().replaceAll(",", "");
            vf.setValue(text.isEmpty() ? 0 : Integer.parseInt(text));
            int now = (Integer)vf.getConverter().fromString(text);
            if (vf.getValue() == null) {
                vf.setValue(now);
            }
            if (value > 0) {
                vf.increment(value / vf.getUnit());
            } else {
                vf.decrement(-value / vf.getUnit());
            }
            spinner.getEditor().selectAll();
        });
    }

    public static void arrowsStyle(Spinner<?> spinner) {
        spinner.getStyleClass().add((Object)"split-arrows-horizontal");
    }
}

