/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.spinner;

import cms.tmx.control.cvts.IntegerCvt;
import cms.tmx.utils.DecimalUtils;
import javafx.scene.control.SpinnerValueFactory;

public class IntegerValueFactory
extends SpinnerValueFactory<Integer> {
    private int unit;
    private int len;
    private boolean pos;
    private int max;

    public IntegerValueFactory(boolean pos, int len, int unit) {
        this.pos = pos;
        this.unit = unit;
        this.len = len;
        this.setConverter(new IntegerCvt());
    }

    public void decrement(int steps) {
        int max = DecimalUtils.getIntMax((int)this.len);
        int min = this.pos ? 0 : -max;
        int value = (Integer)this.getValue() - steps * this.unit;
        value = value > min ? value : min;
        this.setValue(value);
    }

    public void increment(int steps) {
        int max = this.max > 0 ? this.max : DecimalUtils.getIntMax((int)this.len);
        int value = (Integer)this.getValue() + steps * this.unit;
        value = value > max ? max : value;
        this.setValue(value);
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public int getUnit() {
        return this.unit;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

