/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.spinner;

import cms.tmx.control.formatters.IntegerFilter;
import cms.tmx.control.formatters.IntegerStrConverter;
import cms.tmx.control.spinner.IntegerValueFactory;
import java.util.function.UnaryOperator;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class IntSpinnerCtrl {
    private int len;
    private boolean pos;
    private IntegerValueFactory vf;
    private IntegerFilter filter;
    private IntegerStringConverter convt;

    public IntSpinnerCtrl(boolean pos, int len, int unit) {
        this.vf = new IntegerValueFactory(pos, len, unit);
        this.filter = new IntegerFilter(pos, len);
        this.convt = new IntegerStrConverter();
    }

    public void ctrl(Spinner<Integer> spinner) {
        spinner.setValueFactory((SpinnerValueFactory)this.vf);
        spinner.getEditor().setTextFormatter(new TextFormatter((StringConverter)this.convt, null, (UnaryOperator)this.filter));
    }

    public int getLen() {
        return this.len;
    }

    public void setUnit(int unit) {
        this.vf.setUnit(unit);
    }

    public void setLen(int len) {
        this.len = len;
        this.filter.setLength(len);
        this.vf.setLen(len);
    }

    public boolean isPos() {
        return this.pos;
    }

    public void setPos(boolean pos) {
        this.pos = pos;
    }

    public IntegerValueFactory getVF() {
        return this.vf;
    }

    public void setMax(int max) {
        this.vf.setMax(max);
        this.filter.setMax(max);
    }
}

