/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.spinner;

import cms.tmx.control.cvts.DoubleCvt;
import cms.tmx.utils.DecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javafx.scene.control.SpinnerValueFactory;

public class DoubleValueFactory
extends SpinnerValueFactory<Double> {
    private boolean pos;
    private int length;
    private int scale;
    private DoubleCvt cvt;
    private Double unit;
    private double max;
    private double min = 0.0;

    public DoubleValueFactory(boolean pos, int length, int scale) {
        this.pos = pos;
        this.length = length;
        this.scale = scale;
        this.cvt = new DoubleCvt(scale);
        this.setConverter(this.cvt);
    }

    public DoubleValueFactory(boolean pos, int length, int scale, double max) {
        this(pos, length, scale);
        this.max = max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void decrement(int steps) {
        double max;
        double d = max = this.max > 0.0 ? this.max : DecimalUtils.getDoubleMax((int)this.length);
        double min = this.min == 0.0 ? (this.pos ? 0.0 : -max) : this.min;
        double unit = this.getUnit();
        BigDecimal bdValue = BigDecimal.valueOf((Double)this.getValue());
        BigDecimal bdMin = BigDecimal.valueOf(min);
        BigDecimal bdUnit = BigDecimal.valueOf(unit);
        BigDecimal bdNow = bdValue.subtract(bdUnit.multiply(BigDecimal.valueOf(steps)));
        if (bdNow.compareTo(bdMin) < 0) {
            bdNow = bdMin;
        }
        double result = bdNow.setScale(this.scale, RoundingMode.DOWN).doubleValue();
        this.setValue(result);
    }

    public void increment(int steps) {
        double max = this.max > 0.0 ? this.max : DecimalUtils.getDoubleMax((int)this.length);
        double unit = this.getUnit();
        BigDecimal bdValue = BigDecimal.valueOf(this.getValue() == null ? 0.0 : (Double)this.getValue());
        BigDecimal bdMax = BigDecimal.valueOf(max);
        BigDecimal bdUnit = BigDecimal.valueOf(unit);
        BigDecimal bdNow = bdValue.add(bdUnit.multiply(BigDecimal.valueOf(steps)));
        if (bdNow.compareTo(bdMax) > 0) {
            bdNow = bdMax;
        }
        double result = bdNow.setScale(this.scale, RoundingMode.DOWN).doubleValue();
        this.setValue(result);
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.cvt.setScale(scale);
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPos(boolean pos) {
        this.pos = pos;
    }

    public void increment(double value) {
        BigDecimal step = BigDecimal.valueOf(value).divide(BigDecimal.valueOf(this.getUnit()));
        this.increment(step.intValue());
    }

    public void decrement(double value) {
        BigDecimal step = BigDecimal.valueOf(value).divide(BigDecimal.valueOf(this.getUnit()));
        this.decrement(step.intValue());
    }

    public void setUnit(double unit) {
        this.unit = unit;
    }

    public double getUnit() {
        if (this.unit != null) {
            return this.unit;
        }
        return DecimalUtils.getUnit((int)this.scale);
    }
}

