/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.spinner;

import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.spinner.DoubleValueFactory;
import java.util.function.UnaryOperator;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;

public class DoubleSpinnerCtrl {
    private DoubleValueFactory vf;
    private DoubleFilter filter;
    private DoubleStrConverter convt;
    private boolean pos;
    private int len;
    private int scale;

    public DoubleSpinnerCtrl(boolean pos, int len, int scale) {
        this.vf = new DoubleValueFactory(pos, len, scale);
        this.filter = new DoubleFilter(pos, len, scale);
        this.convt = new DoubleStrConverter(scale);
    }

    public DoubleSpinnerCtrl(boolean pos, int len, int scale, double max) {
        this(pos, len, scale);
        this.vf.setMax(max);
        this.filter.setMax(max);
    }

    public void setMax(double max) {
        this.vf.setMax(max);
        this.filter.setMax(max);
    }

    public void setMin(double min) {
        this.vf.setMin(min);
        this.filter.setMin(min);
    }

    public void ctrl(Spinner<Double> spinner) {
        spinner.setValueFactory((SpinnerValueFactory)this.vf);
        spinner.getEditor().setTextFormatter(new TextFormatter((StringConverter)this.convt, null, (UnaryOperator)this.filter));
    }

    public DoubleValueFactory getVF() {
        return this.vf;
    }

    public DoubleFilter getFilter() {
        return this.filter;
    }

    public boolean isPos() {
        return this.pos;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
        this.vf.setLength(len);
        this.filter.setLength(len);
    }

    public void setPos(boolean pos) {
        this.pos = pos;
        this.vf.setPos(pos);
        this.filter.setPositive(pos);
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.vf.setScale(scale);
        this.filter.setScale(scale);
        this.convt.setScale(scale);
    }

    public void setUnit(double unit) {
        this.vf.setUnit(unit);
    }
}

