/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.search;

import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.control.search.Match;
import java.util.Comparator;

public class localSuggest
extends BaseSuggestion<Match> {
    private String localSymbol = ".";
    private Comparator<Match> cp = new Comparator<Match>(){

        @Override
        public int compare(Match o1, Match o2) {
            return localSuggest.this.weightLet(o2) - localSuggest.this.weightLet(o1);
        }
    };
    private static final int ACRONYM_LENGTH = 30;

    public localSuggest() {
    }

    public localSuggest(String local) {
        this.localSymbol = local;
    }

    @Override
    protected Comparator<Match> getComparator() {
        return this.cp;
    }

    @Override
    protected boolean isMatch(Match str, BaseAutoCompletion.ISuggestionRequest req) {
        String txtReq = req.getUserText().toLowerCase();
        String txtMatch = str.getCode().toLowerCase();
        int indexComma = txtReq.lastIndexOf(this.localSymbol);
        if (indexComma == -1) {
            return false;
        }
        if (txtReq.length() - this.localSymbol.length() == indexComma) {
            return true;
        }
        String txtCustom = txtReq.substring(indexComma + this.localSymbol.length());
        return txtMatch.contains(txtCustom);
    }

    public int weightLet(Match item) {
        String input = this.getRequest().toUpperCase();
        int index = item.getCode().indexOf(input);
        int base = 30 - index;
        int weight = 1000000 * base;
        char[] chars = item.getCode().toCharArray();
        int letWeight = 0;
        int i = 0;
        while (i < chars.length) {
            letWeight += chars[i];
            ++i;
        }
        return weight - letWeight;
    }

    public String getLocalSymbol() {
        return this.localSymbol;
    }
}

