/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.search;

import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.util.Callback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseSuggestion<T>
implements Callback<BaseAutoCompletion.ISuggestionRequest, Collection<T>> {
    private static final Logger logger = LogManager.getLogger(BaseSuggestion.class);
    private final List<T> possibleSuggestions = new ArrayList<T>();
    private List<T> commonUseSuggestions = new ArrayList<T>();
    private final Object possibleSuggestionsLock = new Object();
    private final Object commonUseSuggestionsLock = new Object();
    private String request = "";
    private boolean letters = false;

    public void addPossibleSuggestions(T ... newPossible) {
        this.addPossibleSuggestions((Collection<T>)Arrays.asList(newPossible));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleSuggestions(Collection<T> newPossible) {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.addAll(newPossible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePossibleSuggestions(T delPossible) {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.remove(delPossible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommonUseSuggestion(T newPossible) {
        Object object = this.commonUseSuggestionsLock;
        synchronized (object) {
            if (!this.commonUseSuggestions.contains(newPossible)) {
                this.commonUseSuggestions.add(newPossible);
                if (this.commonUseSuggestions.size() > 5) {
                    this.commonUseSuggestions.remove(0);
                }
            } else {
                this.commonUseSuggestions.remove(newPossible);
                this.commonUseSuggestions.add(newPossible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommonUseSuggestions(List<T> newPossibles) {
        this.commonUseSuggestions = newPossibles;
        Object object = this.commonUseSuggestionsLock;
        synchronized (object) {
            ArrayList<T> commonSuggestions = new ArrayList<T>();
            if (newPossibles == null) {
                return;
            }
            for (T t : newPossibles) {
                int index = this.possibleSuggestions.indexOf(t);
                if (index < 0) continue;
                commonSuggestions.add(this.possibleSuggestions.get(index));
            }
            this.commonUseSuggestions.clear();
            this.commonUseSuggestions.addAll(commonSuggestions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSuggestions() {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllSuggestions(Collection<T> newPossible) {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.clear();
            this.possibleSuggestions.addAll(newPossible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<T> call(BaseAutoCompletion.ISuggestionRequest request) {
        ArrayList<T> suggestions;
        block11: {
            suggestions = new ArrayList<T>();
            try {
                if (!request.getUserText().isEmpty()) {
                    Object object = this.possibleSuggestionsLock;
                    synchronized (object) {
                        this.setRequest(request.getUserText());
                        this.setLetters(StringUtils.isLetters((String)request.getUserText()));
                        for (T possibleSuggestion : this.possibleSuggestions) {
                            if (!this.isMatch(possibleSuggestion, request)) continue;
                            suggestions.add(possibleSuggestion);
                        }
                    }
                    Collections.sort(suggestions, this.getComparator());
                    break block11;
                }
                Object object = this.commonUseSuggestionsLock;
                synchronized (object) {
                    for (T possibleSuggestion : this.commonUseSuggestions) {
                        suggestions.add(possibleSuggestion);
                    }
                }
                Collections.reverse(suggestions);
            }
            catch (Exception e) {
                logger.error("\u8054\u60f3\u6846\u7b5b\u9009\u51fa\u9519", (Throwable)e);
            }
        }
        return suggestions;
    }

    private void setRequest(String request) {
        this.request = request;
    }

    public String getRequest() {
        return this.request;
    }

    public void setLetters(boolean letters) {
        this.letters = letters;
    }

    protected boolean isLetters() {
        return this.letters;
    }

    protected abstract Comparator<T> getComparator();

    protected abstract boolean isMatch(T var1, BaseAutoCompletion.ISuggestionRequest var2);

    public static <T> BaseSuggestion<T> create(Collection<T> possibleSuggestions) {
        return BaseSuggestion.create(null, possibleSuggestions);
    }

    public static <T> BaseSuggestion<T> create(Callback<T, String> stringConverter, Collection<T> possibleSuggestions) {
        BaseSuggestionString<T> suggest = new BaseSuggestionString<T>(stringConverter);
        suggest.addPossibleSuggestions(possibleSuggestions);
        return suggest;
    }

    private static class BaseSuggestionString<T>
    extends BaseSuggestion<T> {
        private Callback<T, String> stringConverter;
        private final Comparator<T> stringComparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                String o1str = (String)stringConverter.call(o1);
                String o2str = (String)stringConverter.call(o2);
                return o1str.compareTo(o2str);
            }
        };

        public BaseSuggestionString(Callback<T, String> stringConverter) {
            this.stringConverter = stringConverter;
            if (this.stringConverter == null) {
                this.stringConverter = new Callback<T, String>(){

                    public String call(T obj) {
                        return obj != null ? obj.toString() : "";
                    }
                };
            }
        }

        @Override
        protected Comparator<T> getComparator() {
            return this.stringComparator;
        }

        @Override
        protected boolean isMatch(T suggestion, BaseAutoCompletion.ISuggestionRequest request) {
            String userTextLower = request.getUserText().toLowerCase();
            String suggestionStr = ((String)this.stringConverter.call(suggestion)).toLowerCase();
            return suggestionStr.contains(userTextLower);
        }
    }
}

