/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.search;

import com.sun.javafx.event.EventHandlerManager;
import impl.org.controlsfx.skin.AutoCompletePopup;
import impl.org.controlsfx.skin.AutoCompletePopupSkin;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseAutoCompletion<T>
implements EventTarget {
    private static final Logger logger = LogManager.getLogger(BaseAutoCompletion.class);
    private final Node completionTarget;
    private final AutoCompletePopup<T> autoCompletionPopup;
    private final Object suggestionsTaskLock = new Object();
    private FetchSuggestionsTask suggestionsTask = null;
    private Callback<ISuggestionRequest, Collection<T>> suggestionProvider = null;
    private boolean ignoreInputChanges = false;
    private long delay = 1000L;
    private boolean isBottom = false;
    private Lock lock = new ReentrantLock();
    private static ThreadFactory TF = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    };
    private ExecutorService singleEs = Executors.newSingleThreadExecutor(TF);
    private volatile String newInput = "";
    private ObjectProperty<EventHandler<AutoCompletionEvent<T>>> onAutoCompleted;
    final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private StringProperty changed = new SimpleStringProperty("");

    protected BaseAutoCompletion(Node completionTarget, Callback<ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter) {
        this.completionTarget = completionTarget;
        this.suggestionProvider = suggestionProvider;
        this.autoCompletionPopup = new AutoCompletePopup();
        this.autoCompletionPopup.getStyleClass().clear();
        this.autoCompletionPopup.setConverter(converter);
        this.autoCompletionPopup.setOnSuggestion(sce -> {
            try {
                this.setIgnoreInputChanges(true);
                completionTarget.setUserData(sce.getSuggestion());
                this.completeUserInput(sce.getSuggestion());
                this.fireAutoCompletion(sce.getSuggestion());
                this.hidePopup();
                this.changed(((TextField)TextField.class.cast(completionTarget)).getText());
            }
            finally {
                this.setIgnoreInputChanges(false);
            }
        });
    }

    public void setHideOnEscape(boolean value) {
        this.autoCompletionPopup.setHideOnEscape(value);
    }

    public final void setUserInput(String userText) {
        if (!this.isIgnoreInputChanges()) {
            this.onUserInputChanged(userText);
        }
    }

    public final void setDelay(long delay) {
        this.delay = delay;
    }

    public Node getCompletionTarget() {
        return this.completionTarget;
    }

    public abstract void dispose();

    public final void setVisibleRowCount(int value) {
        this.autoCompletionPopup.setVisibleRowCount(value);
    }

    public final int getVisibleRowCount() {
        return this.autoCompletionPopup.getVisibleRowCount();
    }

    public final IntegerProperty visibleRowCountProperty() {
        return this.autoCompletionPopup.visibleRowCountProperty();
    }

    public final void setPrefWidth(double value) {
        this.autoCompletionPopup.setPrefWidth(value);
    }

    public final double getPrefWidth() {
        return this.autoCompletionPopup.getPrefWidth();
    }

    public final DoubleProperty prefWidthProperty() {
        return this.autoCompletionPopup.prefWidthProperty();
    }

    public final void setMinWidth(double value) {
        this.autoCompletionPopup.setMinWidth(value);
    }

    public final double getMinWidth() {
        return this.autoCompletionPopup.getMinWidth();
    }

    public final DoubleProperty minWidthProperty() {
        return this.autoCompletionPopup.minWidthProperty();
    }

    public final void setMaxWidth(double value) {
        this.autoCompletionPopup.setMaxWidth(value);
    }

    public final double getMaxWidth() {
        return this.autoCompletionPopup.getMaxWidth();
    }

    public final DoubleProperty maxWidthProperty() {
        return this.autoCompletionPopup.maxWidthProperty();
    }

    protected abstract void completeUserInput(T var1);

    protected void showPopup(String userText) {
        try {
            this.autoCompletionPopup.show(this.completionTarget);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.selectFirstSuggestion(this.autoCompletionPopup, userText);
    }

    private void show(Node node) {
        if (node.getScene() != null && node.getScene().getWindow() != null) {
            if (!this.autoCompletionPopup.isShowing()) {
                Window parent = node.getScene().getWindow();
                this.autoCompletionPopup.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() - 260.0);
            }
        } else {
            throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
        }
    }

    protected void hidePopup() {
        this.autoCompletionPopup.hide();
    }

    protected void fireAutoCompletion(T completion) {
        Event.fireEvent((EventTarget)this, new AutoCompletionEvent<T>(completion));
    }

    private void selectFirstSuggestion(AutoCompletePopup<?> autoCompletionPopup, String userText) {
        AutoCompletePopupSkin au;
        ListView li;
        Skin skin = autoCompletionPopup.getSkin();
        if (skin instanceof AutoCompletePopupSkin && (li = (ListView)(au = (AutoCompletePopupSkin)skin).getNode()).getItems() != null && !li.getItems().isEmpty()) {
            li.getSelectionModel().select(0);
            if (li.getItems().size() == 1 && !"".equals(userText) && userText.length() == li.getItems().get(0).toString().length()) {
                this.hidePopup();
                this.completionTarget.setUserData(li.getSelectionModel().getSelectedItem());
                this.completeUserInput(li.getSelectionModel().getSelectedItem());
            } else {
                this.completionTarget.setUserData(null);
            }
            this.changed(userText);
        }
    }

    public void setUserData(T data) {
        this.completionTarget.setUserData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onUserInputChanged(String userText) {
        Object object = this.suggestionsTaskLock;
        synchronized (object) {
            if (this.suggestionsTask != null) {
                System.out.println("isrunning");
                try {
                    this.suggestionsTask.cancel();
                }
                catch (Exception e) {
                    logger.error("\u4ee3\u7801\u8fc7\u6ee4\u4efb\u52a1\u7ec8\u6b62\u5f02\u5e38", (Throwable)e);
                }
            }
            this.suggestionsTask = new FetchSuggestionsTask(userText, 300L);
            this.singleEs.execute((Runnable)((Object)this.suggestionsTask));
        }
    }

    private boolean isIgnoreInputChanges() {
        return this.ignoreInputChanges;
    }

    private void setIgnoreInputChanges(boolean state) {
        this.ignoreInputChanges = state;
    }

    public final void setOnAutoCompleted(EventHandler<AutoCompletionEvent<T>> value) {
        this.onAutoCompletedProperty().set(value);
    }

    public final EventHandler<AutoCompletionEvent<T>> getOnAutoCompleted() {
        return this.onAutoCompleted == null ? null : (EventHandler)this.onAutoCompleted.get();
    }

    public final ObjectProperty<EventHandler<AutoCompletionEvent<T>>> onAutoCompletedProperty() {
        if (this.onAutoCompleted == null) {
            this.onAutoCompleted = new ObjectPropertyBase<EventHandler<AutoCompletionEvent<T>>>(){

                protected void invalidated() {
                    BaseAutoCompletion.this.eventHandlerManager.setEventHandler(AutoCompletionEvent.AUTO_COMPLETED, (EventHandler)this.get());
                }

                public Object getBean() {
                    return BaseAutoCompletion.this;
                }

                public String getName() {
                    return "onAutoCompleted";
                }
            };
        }
        return this.onAutoCompleted;
    }

    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend((EventDispatcher)this.eventHandlerManager);
    }

    public StringProperty changedProperty() {
        return this.changed;
    }

    private void changed(String change) {
        if (change != null && change.equals(this.changed.get())) {
            this.changed.set((Object)"");
            this.changed.set((Object)change);
        } else {
            this.changed.set((Object)change);
            System.err.println("change   " + change);
        }
    }

    public void setChange(String text) {
        this.changed.set((Object)text);
    }

    public boolean isBottom() {
        return this.isBottom;
    }

    public void setBottom(boolean isBottom) {
        this.isBottom = isBottom;
    }

    public static class AutoCompletionEvent<TE>
    extends Event {
        public static final EventType<AutoCompletionEvent> AUTO_COMPLETED = new EventType("AUTO_COMPLETED");
        private final TE completion;

        public AutoCompletionEvent(TE completion) {
            super(AUTO_COMPLETED);
            this.completion = completion;
        }

        public TE getCompletion() {
            return this.completion;
        }
    }

    private class FetchSuggestionsTask
    extends Task<Void>
    implements ISuggestionRequest {
        private final String userText;
        private final long delay;

        public FetchSuggestionsTask(String userText, long delay) {
            System.err.println("this.getuserText1 " + userText);
            this.userText = userText;
            this.delay = delay;
        }

        protected Void call() throws Exception {
            Callback provider = BaseAutoCompletion.this.suggestionProvider;
            if (provider != null) {
                if (this.delay > 0L && !this.isCancelled()) {
                    Thread.sleep(this.delay);
                }
                if (!this.isCancelled()) {
                    System.err.println("this.getuserText2 " + this.userText);
                    long begin = System.currentTimeMillis();
                    Collection fetchedSuggestions = (Collection)provider.call((Object)this);
                    System.err.println("this.getuserText3 " + this.userText + "   |   " + (System.currentTimeMillis() - begin));
                    Platform.runLater(() -> {
                        if (fetchedSuggestions != null && !fetchedSuggestions.isEmpty()) {
                            BaseAutoCompletion.this.autoCompletionPopup.getSuggestions().setAll(fetchedSuggestions);
                            System.out.println("this.getuserText4 " + this.getUserText());
                            BaseAutoCompletion.this.showPopup(this.getUserText());
                        } else {
                            BaseAutoCompletion.this.hidePopup();
                            BaseAutoCompletion.this.completionTarget.setUserData(null);
                            System.out.println("textfiled       " + ((TextField)TextField.class.cast(BaseAutoCompletion.this.completionTarget)).getText());
                            BaseAutoCompletion.this.changed(((TextField)TextField.class.cast(BaseAutoCompletion.this.completionTarget)).getText());
                        }
                    });
                }
            } else {
                BaseAutoCompletion.this.hidePopup();
            }
            return null;
        }

        @Override
        public String getUserText() {
            return this.userText;
        }
    }

    public static interface ISuggestionRequest {
        public boolean isCancelled();

        public String getUserText();
    }
}

