/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.search;

import cms.tmx.control.search.BaseAutoCompletion;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class AutoCompletion<T>
extends BaseAutoCompletion<T> {
    private String localSymbol = "";
    private StringConverter<T> converter;
    private final ChangeListener<String> textChangeListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> obs, String oldText, String newText) {
            if (AutoCompletion.this.getCompletionTarget().isFocused()) {
                AutoCompletion.this.setUserInput(newText);
            }
        }
    };
    private final ChangeListener<Boolean> focusChangedListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> obs, Boolean oldFocused, Boolean newFocused) {
            if (!newFocused.booleanValue()) {
                AutoCompletion.this.hidePopup();
            }
        }
    };

    private static <T> StringConverter<T> defaultStringConverter() {
        return new StringConverter<T>(){

            public String toString(T t) {
                return t == null ? null : t.toString();
            }

            public T fromString(String string) {
                return string;
            }
        };
    }

    public AutoCompletion(TextField textField, Callback<BaseAutoCompletion.ISuggestionRequest, Collection<T>> suggestionProvider) {
        this(textField, suggestionProvider, AutoCompletion.defaultStringConverter());
    }

    public AutoCompletion(TextField textField, Callback<BaseAutoCompletion.ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter) {
        super((Node)textField, suggestionProvider, converter);
        this.converter = converter;
        this.getCompletionTarget().textProperty().addListener(this.textChangeListener);
        this.getCompletionTarget().focusedProperty().addListener(this.focusChangedListener);
    }

    public AutoCompletion(TextField textField, Callback<BaseAutoCompletion.ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter, String localSymbol) {
        this(textField, suggestionProvider, converter);
        this.localSymbol = localSymbol;
    }

    public TextField getCompletionTarget() {
        return (TextField)super.getCompletionTarget();
    }

    @Override
    public void dispose() {
        this.getCompletionTarget().textProperty().removeListener(this.textChangeListener);
        this.getCompletionTarget().focusedProperty().removeListener(this.focusChangedListener);
    }

    @Override
    protected void completeUserInput(T completion) {
        String newText = this.converter.toString(completion);
        if (!this.localSymbol.isEmpty()) {
            String nowText = this.getCompletionTarget().getText();
            int index = nowText.lastIndexOf(this.localSymbol);
            if (index == nowText.length() - this.localSymbol.length()) {
                newText = String.valueOf(nowText) + newText;
            } else {
                String foreText = nowText.substring(0, index + this.localSymbol.length());
                newText = String.valueOf(foreText) + newText;
            }
        }
        this.getCompletionTarget().setText(newText);
        this.getCompletionTarget().positionCaret(newText.length());
    }
}

