/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.formatters;

import cms.tmx.utils.StringUtils;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;

public class SecFilter
implements UnaryOperator<TextFormatter.Change> {
    private static final int TWO_LEN = 2;
    private String regExp;
    private int length;

    public SecFilter(String regExp, int length) {
        this.length = length;
        this.regExp = regExp;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public TextFormatter.Change apply(TextFormatter.Change change) {
        String now = change.getControlNewText().replaceAll(",", "");
        if (now.isEmpty()) {
            return change;
        }
        if (now.length() > this.length + 2) {
            int index = now.indexOf(" ");
            if (index == -1) {
                change.setText(change.getControlText());
            } else {
                change.setText(now.substring(0, now.indexOf(" ")));
            }
            now = change.getControlNewText();
        }
        if (!StringUtils.patternCheck((String)this.regExp, (String)now) || now.length() > this.length) {
            return null;
        }
        return change;
    }
}

