/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.formatters;

import cms.tmx.utils.StringUtils;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;

public class LocalFilter
implements UnaryOperator<TextFormatter.Change> {
    private static final int TWO_LEN = 2;
    private String regExp;
    private int length;

    public LocalFilter(String regExp, int length) {
        this.length = length;
        this.regExp = regExp;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public TextFormatter.Change apply(TextFormatter.Change change) {
        String now = change.getControlNewText().replaceAll(",", "");
        String old = change.getControlText();
        if (!change.getControlText().isEmpty() && now.replace(old, "").equals(" ")) {
            return null;
        }
        if (now.isEmpty()) {
            return change;
        }
        int index = now.indexOf(" ");
        if (index != -1) {
            change.setText(now.substring(0, now.indexOf(" ")));
        }
        if (!StringUtils.patternCheck((String)this.regExp, (String)(now = change.getControlNewText())) || now.length() > this.length) {
            return null;
        }
        return change;
    }
}

