/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.formatters;

import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;

public class IntegerFilter
implements UnaryOperator<TextFormatter.Change> {
    private int length;
    private boolean bPositive = true;
    private int max = 0;

    public IntegerFilter(boolean bPositive, int length) {
        this.bPositive = bPositive;
        this.length = length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPositive(boolean bPositive) {
        this.bPositive = bPositive;
    }

    @Override
    public TextFormatter.Change apply(TextFormatter.Change change) {
        String now = change.getControlNewText().replaceAll(",", "");
        if (now.isEmpty()) {
            return change;
        }
        if (DecimalUtils.isInt((String)now, (boolean)this.bPositive, (int)this.length)) {
            int value;
            if (this.max > 0 && ((value = StringUtils.parseInt((String)now)) > this.max || value < -this.max)) {
                return null;
            }
            return change;
        }
        return null;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

