/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.formatters;

import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;

public class DoubleFilter
implements UnaryOperator<TextFormatter.Change> {
    private int scale;
    private int length;
    private boolean bPositive = true;
    private double max = 0.0;
    private double min = 0.0;
    private static String NEGATIVE = "-";

    public DoubleFilter(boolean bPositive, int length, int scale) {
        this.bPositive = bPositive;
        this.length = length;
        this.scale = scale;
    }

    public DoubleFilter(boolean bPositive, int length, int scale, double max) {
        this(bPositive, length, scale);
        this.max = max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPositive(boolean bPositive) {
        this.bPositive = bPositive;
    }

    @Override
    public TextFormatter.Change apply(TextFormatter.Change change) {
        String now = "";
        try {
            now = change.getControlNewText().replaceAll(",", "");
        }
        catch (Exception exception) {}
        if (now.isEmpty()) {
            return change;
        }
        if (!this.bPositive && NEGATIVE.equals(now)) {
            return change;
        }
        if (DecimalUtils.isDecimal((String)now, (boolean)this.bPositive, (int)this.length, (int)this.scale)) {
            double value;
            if (this.max > 0.0 && ((value = StringUtils.parseDouble((String)now)) > this.max || value < -this.max)) {
                return null;
            }
            if (this.min != 0.0 && (value = StringUtils.parseDouble((String)now)) < this.min) {
                return null;
            }
            return change;
        }
        return null;
    }
}

