/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.dialog;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.TableColumnMenu;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class TreeTableMenuBarDialog<T extends MxObject>
extends DialogObj {
    @FXML
    private TableView<TableColumnMenu> table;
    @FXML
    private TableColumn<TableColumnMenu, Boolean> select;
    @FXML
    private TableColumn<TableColumnMenu, String> colName;
    private TreeTableView<T> treeTableSource;
    private ObservableList<TableColumnMenu> list = FxUtils.newList();
    protected CheckBox checkBox = new CheckBox();
    private boolean flag = true;
    private ChangeListener<? super Boolean> lstnCheckbox = (obv, old, now) -> {
        if (this.flag) {
            this.flag = false;
            this.list.forEach(e -> e.setSelected((boolean)now));
            this.flag = true;
        }
    };
    private ChangeListener<Boolean> lstn = (obv, old, now) -> {};

    @Override
    public String getPath() {
        return "TableMenuBarDialog.fxml";
    }

    @FXML
    private void initialize() {
        this.initValues();
        this.createTable();
        this.initComboBox();
        this.initListener();
    }

    private void initListener() {
        for (TableColumnMenu tableColumnMenu : this.list) {
            tableColumnMenu.selectedProperty().addListener(this.lstn);
        }
        this.checkBox.selectedProperty().addListener(this.lstnCheckbox);
    }

    private void initComboBox() {
        boolean selectAll = true;
        for (TableColumnMenu tableColumn : this.list) {
            if (tableColumn.isSelected()) continue;
            selectAll = false;
            break;
        }
        if (selectAll) {
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
        }
    }

    private void initValues() {
        ObservableList treeColumn = this.treeTableSource.getColumns();
        for (TreeTableColumn tableColumn : treeColumn) {
            this.initColumns(tableColumn);
        }
    }

    private void createTable() {
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.select.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.select.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.select.setGraphic((Node)this.checkBox);
        this.table.setItems(this.list);
        this.table.setEditable(true);
    }

    private void initColumns(TreeTableColumn<T, ?> treetreeTableColumn) {
        if (treetreeTableColumn.getColumns() == null || treetreeTableColumn.getColumns().isEmpty()) {
            TableColumnMenu menu = new TableColumnMenu();
            menu.setName(treetreeTableColumn.getParentColumn() != null ? String.valueOf(treetreeTableColumn.getParentColumn().getText()) + ":" + treetreeTableColumn.getText() : treetreeTableColumn.getText());
            menu.setSelected(treetreeTableColumn.isVisible());
            this.list.add((Object)menu);
        } else {
            for (TreeTableColumn tableColumnOthers : treetreeTableColumn.getColumns()) {
                this.initColumns(tableColumnOthers);
            }
        }
    }

    @Override
    protected boolean isOK(ButtonType bt) {
        block0: for (TableColumnMenu tableColumnMenu : this.list) {
            ObservableList columns = this.treeTableSource.getColumns();
            block1: for (TreeTableColumn column : columns) {
                if ((column.getColumns() == null || column.getColumns().isEmpty()) && column.getText().equals(tableColumnMenu.getName())) {
                    column.setVisible(tableColumnMenu.isSelected());
                    continue block0;
                }
                if (column.getColumns().isEmpty()) continue;
                ObservableList columns2 = column.getColumns();
                for (TreeTableColumn tableColumn : columns2) {
                    if (!(String.valueOf(column.getText()) + ":" + tableColumn.getText()).equals(tableColumnMenu.getName())) continue;
                    tableColumn.setVisible(tableColumnMenu.isSelected());
                    continue block1;
                }
            }
        }
        return true;
    }

    public TableView<TableColumnMenu> getTable() {
        return this.table;
    }

    public void setTable(TableView<TableColumnMenu> table) {
        this.table = table;
    }

    public ObservableList<TableColumnMenu> getList() {
        return this.list;
    }

    public void setList(ObservableList<TableColumnMenu> list) {
        this.list = list;
    }

    public TreeTableView<T> getTreeTableSource() {
        return this.treeTableSource;
    }

    public void setTreeTableSource(TreeTableView<T> treeTableSource) {
        this.treeTableSource = treeTableSource;
    }
}

