/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.dialog;

import cms.tmx.control.dialog.BaseValid;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.javafx.utils.FxUtils;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MxTabContent
implements BaseValid {
    private static final Logger logger = LogManager.getLogger(MxTabContent.class);
    protected Map<ObservableBooleanValue, Node> mapValid = new LinkedHashMap<ObservableBooleanValue, Node>();
    protected String path;
    @Inject
    protected Scene s;
    @Inject
    protected MEventService es;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    protected long startDate;
    public Parent content;

    public MxTabContent(String path) {
        this.path = path;
    }

    public MxTabContent() {
        this.path = String.valueOf(this.getClass().getSimpleName()) + ".fxml";
    }

    public void finalize() {
        logger.error("-------- MxTabContent: finalize called " + this.getClass().getSimpleName());
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.checkComBobox();
        }
        catch (IOException e) {
            logger.error("init part failed", (Throwable)e);
        }
    }

    private void checkComBobox() {
        Set lookupAll = this.content.lookupAll(".combo-box");
        for (Node node : lookupAll) {
            if (!(node instanceof ComboBox)) continue;
            ComboBox cast = (ComboBox)ComboBox.class.cast(node);
            FxUtils.initComboBox((ComboBox)cast);
        }
    }

    @Override
    public Map<ObservableBooleanValue, Node> getValids() {
        return this.mapValid;
    }

    protected URL getFXMLLocation() {
        return this.getClass().getResource(this.path);
    }

    protected Parent loadFXML() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(this.getFXMLLocation());
        loader.setController((Object)this);
        this.content = (Parent)loader.load();
        return this.content;
    }

    public Parent getContent() {
        return this.content;
    }
}

