/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.dialog;

import cms.tmx.core.MConfService;
import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MxFileChooser {
    private static Map<String, FileChooser.ExtensionFilter> filter = new HashMap<String, FileChooser.ExtensionFilter>();
    public static final String ALL = "ALL";
    public static final String TXT = "TXT";
    public static final String XLS = "XLS";
    public static final String XLSX = "XLSX";
    public static final String DOC = "DOC";
    public static final String DOCX = "DOCX";
    public static final String PPT = "PPT";
    public static final String PDF = "PDF";
    public static final String JPG = "JPG";
    public static final String PNG = "PNG";
    public static final String ZIP = "ZIP";
    private final Desktop desktop = Desktop.getDesktop();
    private static final Logger logger = LogManager.getLogger(MxFileChooser.class);
    @Inject
    private Stage stage;
    @Inject
    private MConfService cs;

    @PostConstruct
    public void init() {
        filter.put(ALL, new FileChooser.ExtensionFilter(ALL, new String[]{"*.*"}));
        filter.put(TXT, new FileChooser.ExtensionFilter(TXT, new String[]{"*.txt"}));
        filter.put(XLS, new FileChooser.ExtensionFilter(XLS, new String[]{"*.xls"}));
        filter.put(XLSX, new FileChooser.ExtensionFilter(XLSX, new String[]{"*.xlsx"}));
        filter.put(DOC, new FileChooser.ExtensionFilter(DOC, new String[]{"*.doc"}));
        filter.put(DOCX, new FileChooser.ExtensionFilter(DOCX, new String[]{"*.docx"}));
        filter.put(PPT, new FileChooser.ExtensionFilter(PPT, new String[]{"*.ppt"}));
        filter.put(PDF, new FileChooser.ExtensionFilter(PDF, new String[]{"*.pdf"}));
        filter.put(JPG, new FileChooser.ExtensionFilter(JPG, new String[]{"*.jpg"}));
        filter.put(PNG, new FileChooser.ExtensionFilter(PNG, new String[]{"*.png"}));
        filter.put(ZIP, new FileChooser.ExtensionFilter(ZIP, new String[]{"*.zip"}));
    }

    public File open() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("\u6253\u5f00\u6587\u4ef6");
        this.extensionFilters(chooser, "");
        File file = chooser.showOpenDialog((Window)this.stage);
        try {
            this.desktop.open(file);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return file;
    }

    public File get() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("\u9009\u62e9\u6587\u4ef6");
        this.extensionFilters(chooser, "");
        File file = chooser.showOpenDialog((Window)this.stage);
        return file;
    }

    public File save(String url, String format, String name, File directory) {
        try {
            return this.saveFile(url, format, name, directory);
        }
        catch (IOException e) {
            logger.error("save file error " + url, (Throwable)e);
            return null;
        }
    }

    public File saveFile(String url, String format, String name, File directory) throws IOException {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("\u4fdd\u5b58\u6587\u4ef6");
        chooser.setInitialDirectory(directory);
        chooser.setInitialFileName(name);
        this.extensionFilters(chooser, format);
        File file = chooser.showSaveDialog((Window)this.stage);
        if (file != null) {
            this.write(url, file);
        }
        return file;
    }

    private void extensionFilters(FileChooser chooser, String fileformat) {
        for (String key : filter.keySet()) {
            chooser.getExtensionFilters().add((Object)filter.get(key));
        }
        FileChooser.ExtensionFilter value = filter.get(fileformat);
        if (value == null) {
            value = filter.get(ALL);
        }
        chooser.selectedExtensionFilterProperty().set((Object)value);
    }

    private void write(String path, File file) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                URL url = new URL(path);
                URLConnection conn = null;
                conn = url.openConnection();
                in = conn.getInputStream();
                out = new FileOutputStream(file);
                byte[] length = new byte[1024];
                int data = 0;
                while ((data = in.read(length)) != -1) {
                    out.write(length, 0, data);
                }
                logger.info("download successfully! " + file.getName());
            }
            catch (IOException e) {
                logger.error("download file error " + path, (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.close(in);
            this.close(out);
            throw throwable;
        }
        this.close(in);
        this.close(out);
    }

    public void close(Closeable cl) {
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException e) {
                logger.error("close interface error", (Throwable)e);
            }
        }
    }
}

