/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.dialog;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.DlgCtrl;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MxDialog
extends Dialog<ButtonType> {
    private static final Logger logger = LogManager.getLogger(MxDialog.class);
    private DialogObj obj;
    private DlgCtrl ctrl;
    private Node firstNode;
    private Node lastNode;

    public void finalize() {
    }

    public void setFirstNode(Node firstNode) {
        this.firstNode = firstNode;
    }

    public void setLastNode(Node lastNode) {
        this.lastNode = lastNode;
    }

    public MxDialog(DialogObj obj) {
        this.obj = obj;
        this.setOnCloseRequest(event -> {
            if (this.isCancel()) {
                return;
            }
            if (!obj.valid() || !obj.isOK((ButtonType)this.getResult())) {
                event.consume();
            }
        });
    }

    public boolean isCancel() {
        return this.getResult() == ButtonType.CANCEL || this.getResult() == ButtonType.CLOSE;
    }

    public DialogObj getModel() {
        return this.obj;
    }

    public ButtonType launch() {
        this.getDialogPane().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                Button btn = this.getButton(ButtonType.CANCEL);
                if (btn != null && btn.isFocused()) {
                    this.setResult(ButtonType.CANCEL);
                    return;
                }
                btn = this.getButton(ButtonType.CLOSE);
                if (btn != null && btn.isFocused()) {
                    this.setResult(ButtonType.CLOSE);
                    return;
                }
                btn = this.getButton(ButtonType.NO);
                if (btn != null && btn.isFocused()) {
                    this.setResult(ButtonType.NO);
                    return;
                }
            } else if (event.getCode().equals((Object)KeyCode.SPACE)) {
                event.consume();
            } else if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
                this.setResult(ButtonType.CLOSE);
                this.close();
            }
        });
        if (this.lastNode != null) {
            this.lastNode.setOnKeyPressed(event -> {
                if (event.getCode().equals((Object)KeyCode.TAB)) {
                    this.getButton(ButtonType.OK).requestFocus();
                    event.consume();
                }
            });
        }
        if (this.getButton(ButtonType.CANCEL) != null && this.firstNode != null) {
            this.getButton(ButtonType.CANCEL).setOnKeyPressed(event -> {
                if (KeyCode.TAB.equals((Object)event.getCode()) && this.firstNode != null) {
                    Platform.runLater(() -> this.firstNode.requestFocus());
                } else if (KeyCode.ENTER.equals((Object)event.getCode())) {
                    this.getButton(ButtonType.CANCEL).fire();
                }
            });
        }
        try {
            this.showAndWait().ifPresent(ret -> this.obj.onFinished((ButtonType)ret));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.obj.onDlgClosed();
        return (ButtonType)this.getResult();
    }

    public void setCtrl(DlgCtrl ctrl) {
        this.ctrl = ctrl;
    }

    public DlgCtrl getCtrl() {
        return this.ctrl;
    }

    public void setBtnText(ButtonType type, String text) {
        Node node = this.getDialogPane().lookupButton(type);
        if (node instanceof Button) {
            Button btn = (Button)Button.class.cast(node);
            btn.setText(text);
        }
    }

    public void setBtnId(ButtonType type, String text) {
        Node node = this.getDialogPane().lookupButton(type);
        if (node instanceof Button) {
            Button btn = (Button)Button.class.cast(node);
            btn.getStyleClass().add((Object)text);
        }
    }

    public Button getButton(ButtonType type) {
        Node node = this.getDialogPane().lookupButton(type);
        if (node instanceof Button) {
            Button btn = (Button)Button.class.cast(node);
            return btn;
        }
        return null;
    }

    public void focusBtnSure(Node ... nodes) {
        List<Node> conts = Arrays.asList(nodes);
        conts.forEach(node -> node.setOnKeyPressed(event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode())) {
                this.getButton(ButtonType.OK).requestFocus();
            }
        }));
    }
}

