/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.dialog;

import cms.tmx.control.dialog.CloseHandler;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlertObj;
import cms.tmx.control.dialog.MxConfirmAlertObj;
import cms.tmx.control.dialog.MxDialog;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JFrame;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MxAlert {
    private static final String TIP_TEXT = "\u63d0\u793a";
    private Map<Alert.AlertType, String> classMap = new HashMap<Alert.AlertType, String>();
    @Inject
    private DialogFactory df;

    private void initClassMap() {
        this.classMap.put(Alert.AlertType.INFORMATION, "information-content");
        this.classMap.put(Alert.AlertType.WARNING, "warning-content");
        this.classMap.put(Alert.AlertType.CONFIRMATION, "confirmation-content");
        this.classMap.put(Alert.AlertType.ERROR, "error-content");
    }

    private void toggleClass(Node node, Alert.AlertType type) {
        this.initClassMap();
        node.getStyleClass().clear();
        node.getStyleClass().add((Object)"label");
        node.getStyleClass().add((Object)this.classMap.get(type));
    }

    public boolean alert(Alert.AlertType type, String info) {
        return this.alert(type, info, TIP_TEXT);
    }

    public boolean alert(Alert.AlertType type, String info, String okBtnName, String cancelBtnName) {
        MxAlertObj obj = MxAlertFactory.create(type);
        obj.setText(info);
        MxDialog dlg = this.df.create(obj, TIP_TEXT);
        this.toggleClass((Node)obj.getLbAlertContent(), type);
        this.setBtnText(dlg, ButtonType.OK, okBtnName);
        this.setBtnText(dlg, ButtonType.CANCEL, cancelBtnName);
        ButtonType result = dlg.launch();
        if (Alert.AlertType.CONFIRMATION == type) {
            return ButtonType.OK == result;
        }
        return false;
    }

    public boolean alert(Alert.AlertType type, String info, String title) {
        MxAlertObj obj = MxAlertFactory.create(type);
        obj.setText(info);
        MxDialog dlg = this.df.create(obj, title);
        this.toggleClass((Node)obj.getLbAlertContent(), type);
        ButtonType result = dlg.launch();
        if (Alert.AlertType.CONFIRMATION == type) {
            return ButtonType.OK == result;
        }
        return false;
    }

    public boolean alert(Alert.AlertType type, StringProperty info, String title, BooleanProperty disable) {
        MxAlertObj obj = MxAlertFactory.create(type);
        obj.setText((String)info.get());
        MxDialog dlg = this.df.create(obj, title);
        this.toggleClass((Node)obj.getLbAlertContent(), type);
        Button button = dlg.getButton(ButtonType.OK);
        Node close = dlg.getDialogPane().lookup("#btnClose");
        button.setDisable(disable.get());
        close.setDisable(disable.get());
        disable.addListener((oldValue, observable, newValue) -> {
            button.setDisable(newValue.booleanValue());
            close.setDisable(newValue.booleanValue());
        });
        info.addListener((oldValue, observable, newValue) -> Platform.runLater(() -> {
            obj.getLbAlertContent().setText(newValue);
            if (newValue.contains("\u8d85\u65f6") || newValue.contains("\u5931\u8d25")) {
                this.toggleClass((Node)obj.getLbAlertContent(), Alert.AlertType.ERROR);
            }
        }));
        ButtonType result = dlg.launch();
        if (Alert.AlertType.CONFIRMATION == type) {
            return ButtonType.OK == result;
        }
        return false;
    }

    public boolean alert(Alert.AlertType type, String info, String title, CloseHandler handler) {
        MxAlertObj obj = MxAlertFactory.create(type);
        obj.setText(info);
        MxDialog dlg = this.df.create(obj, title);
        this.toggleClass((Node)obj.getLbAlertContent(), type);
        Node lookupButton = dlg.getDialogPane().lookup("#btnClose");
        lookupButton.setOnMouseReleased(event -> handler.onCloseButtonHandler());
        ButtonType result = dlg.launch();
        if (Alert.AlertType.CONFIRMATION == type || Alert.AlertType.WARNING == type) {
            return ButtonType.OK == result;
        }
        return false;
    }

    public boolean check(boolean bFlag, Alert.AlertType type, String errorInfo) {
        if (!bFlag) {
            return this.alert(type, errorInfo, TIP_TEXT);
        }
        return true;
    }

    private void setBtnText(MxDialog alert, ButtonType type, String text) {
        Node node = alert.getDialogPane().lookupButton(type);
        if (node instanceof Button) {
            Button btn = (Button)Button.class.cast(node);
            btn.setText(text);
        }
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("\u8fd9\u662f\u4e00\u4e2aJFrame\u7a97\u4f53");
        jf.setVisible(true);
        jf.setSize(500, 350);
        jf.setDefaultCloseOperation(3);
    }

    private static class MxAlertFactory {
        private MxAlertFactory() {
        }

        public static MxAlertObj create(Alert.AlertType type) {
            if (type.equals((Object)Alert.AlertType.CONFIRMATION)) {
                return new MxConfirmAlertObj();
            }
            return new MxAlertObj();
        }
    }
}

