/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.dialog;

import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;

public class DlgCtrl {
    @FXML
    private Label lbTitle;
    @FXML
    private Button btnClose;
    @FXML
    private Pane paneTitle;
    @FXML
    private GridPane paneMDlg;
    private Dialog<ButtonType> dlg;
    @FXML
    private BorderPane paneCustom;
    private double mouseDragOffsetX;
    private double mouseDragOffsetY;
    private EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                event.consume();
            }
        }
    };

    public DlgCtrl(Dialog<ButtonType> dlg) {
        this.dlg = dlg;
    }

    @FXML
    public void initialize() {
        this.paneTitle.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DlgCtrl.this.mouseDragOffsetX = event.getSceneX();
                DlgCtrl.this.mouseDragOffsetY = event.getSceneY();
            }
        });
        this.paneTitle.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DlgCtrl.this.dlg.setX(event.getScreenX() - DlgCtrl.this.mouseDragOffsetX);
                DlgCtrl.this.dlg.setY(event.getScreenY() - DlgCtrl.this.mouseDragOffsetY);
            }
        });
        this.paneCustom.addEventHandler(KeyEvent.KEY_PRESSED, this.handler);
    }

    public BorderPane getCustomPane() {
        return this.paneCustom;
    }

    public StringProperty titleProperty() {
        return this.lbTitle.textProperty();
    }

    public void setTitle(String text) {
        this.lbTitle.setText(text);
    }

    public EventHandler<KeyEvent> getHandler() {
        return this.handler;
    }

    @FXML
    private void onClose() {
        this.dlg.setResult((Object)ButtonType.CANCEL);
        this.dlg.close();
    }

    public Button getBtnClose() {
        return this.btnClose;
    }
}

