/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.dialog;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.DlgCtrl;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.MxFastWebDialog;
import cms.tmx.control.dialog.MxWebDialog;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.jxb.FastWebBrowserPart;
import cms.tmx.jxb.WebBrowserPart;
import java.io.IOException;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.input.InputEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;

@Creatable
@Singleton
public class DialogFactory {
    private static final Logger logger = LogManager.getLogger(DialogFactory.class);
    private static final String DIALOG_FXML = "MDialog.fxml";
    private static final String DIALOG_CSS = "mdialog.css";
    private static final String CSS_NORMAL_SIZE = "nsize";
    private PseudoClass psNormal = PseudoClass.getPseudoClass((String)"nsize");
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    private MConfService cs;
    @Inject
    @Named(value="base.path")
    private String basePath;

    @PostConstruct
    public void init(IEclipseContext ctxt) {
    }

    public MxDialog create(DialogObj obj, String title) {
        try {
            return this.doCreate(obj, title);
        }
        catch (Exception e) {
            logger.error("create dialog failed", (Throwable)e);
            return null;
        }
    }

    public MxWebDialog createWeb(WebBrowserPart obj, String title, int width, int height) {
        try {
            return this.doCreateWeb(obj, title, width, height);
        }
        catch (Exception e) {
            logger.error("create dialog failed", (Throwable)e);
            return null;
        }
    }

    public MxFastWebDialog createWeb(FastWebBrowserPart obj, String title, int width, int height) {
        try {
            return this.doCreateFastWeb(obj, title, width, height);
        }
        catch (Exception e) {
            logger.error("create dialog failed", (Throwable)e);
            return null;
        }
    }

    private MxDialog doCreate(DialogObj obj, String title) throws IOException {
        Stage stage = (Stage)this.of.getContext().getActiveLeaf().get(Stage.class);
        if (stage.isIconified()) {
            stage.setIconified(false);
        }
        MxDialog dialog = new MxDialog(obj);
        dialog.initOwner((Window)stage);
        dialog.initStyle(StageStyle.UNDECORATED);
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.getDialogPane().setOpacity(1.0);
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(this.getClass().getResource(DIALOG_FXML));
        DlgCtrl ctrl = new DlgCtrl(dialog);
        loader.setController((Object)ctrl);
        Parent parent = (Parent)loader.load();
        dialog.getDialogPane().setContent((Node)parent);
        dialog.setCtrl(ctrl);
        dialog.getDialogPane().getStylesheets().add((Object)this.getClass().getResource(DIALOG_CSS).toString());
        String theme = this.cs.getUserProps().get("app_theme");
        dialog.getDialogPane().getStyleClass().add((Object)(theme == null || theme.isEmpty() ? "blue-theme" : theme));
        ctrl.setTitle(title);
        loader = new FXMLLoader();
        loader.setClassLoader(obj.getClass().getClassLoader());
        loader.setLocation(obj.getClass().getResource(obj.getPath()));
        loader.setController((Object)obj);
        Parent node = (Parent)loader.load();
        this.checkComBobox(node);
        ctrl.getCustomPane().setCenter((Node)node);
        dialog.getDialogPane().addEventFilter(InputEvent.ANY, event -> this.es.sendEvent("window.active", null));
        ButtonType[] buttonTypeArray = obj.getTypes();
        int n = buttonTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ButtonType type = buttonTypeArray[n2];
            dialog.getDialogPane().getButtonTypes().add((Object)type);
            Node btn = dialog.getDialogPane().lookupButton(type);
            if (btn != null) {
                btn.pseudoClassStateChanged(this.psNormal, true);
            }
            ++n2;
        }
        return dialog;
    }

    private void checkComBobox(Parent content) {
        Set lookupAll = content.lookupAll(".combo-box");
        for (Node node : lookupAll) {
            if (!(node instanceof ComboBox)) continue;
            ComboBox cast = (ComboBox)ComboBox.class.cast(node);
            FxUtils.initComboBox((ComboBox)cast);
        }
    }

    private MxWebDialog doCreateWeb(WebBrowserPart obj, String title, Integer width, Integer height) throws IOException {
        Stage stage = null;
        MWindow win = this.of.getWin();
        if (win != null) {
            stage = (Stage)win.getContext().getActiveLeaf().get(Stage.class);
        }
        if (stage == null) {
            stage = (Stage)this.of.getContext().getActiveLeaf().get(Stage.class);
        }
        if (stage == null) {
            logger.error("Can't get active stage");
            stage = (Stage)this.of.getContext().get(Stage.class);
        }
        MxWebDialog dialog = new MxWebDialog(obj);
        dialog.initStyle(StageStyle.UNDECORATED);
        dialog.initModality(Modality.WINDOW_MODAL);
        dialog.getDialogPane().getScene().setFill(null);
        dialog.initOwner((Window)stage);
        dialog.setResult(ButtonType.CANCEL);
        dialog.getDialogPane().setOpacity(1.0);
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(this.getClass().getResource(DIALOG_FXML));
        DlgCtrl ctrl = new DlgCtrl(dialog);
        loader.setController((Object)ctrl);
        Parent parent = (Parent)loader.load();
        dialog.getDialogPane().setContent((Node)parent);
        dialog.setCtrl(ctrl);
        dialog.getDialogPane().getStylesheets().add((Object)this.getClass().getResource(DIALOG_CSS).toString());
        String theme = this.cs.getUserProps().get("app_theme");
        dialog.getDialogPane().getStyleClass().add((Object)(theme == null || theme.isEmpty() ? "blue-theme" : theme));
        ctrl.setTitle(title);
        Stage mainStage = this.of.getMainStage();
        ctrl.getCustomPane().setMinSize((double)width.intValue(), mainStage.getHeight() <= (double)height.intValue() ? mainStage.getHeight() : (double)height.intValue());
        obj.setBorderPane(ctrl.getCustomPane());
        obj.initialize();
        ctrl.getCustomPane().layout();
        dialog.getDialogPane().addEventFilter(InputEvent.ANY, event -> this.es.sendEvent("window.active", null));
        return dialog;
    }

    private MxFastWebDialog doCreateFastWeb(FastWebBrowserPart obj, String title, Integer width, Integer height) throws IOException {
        Stage stage = null;
        MWindow win = this.of.getWin();
        if (win != null) {
            stage = (Stage)win.getContext().getActiveLeaf().get(Stage.class);
        }
        if (stage == null) {
            stage = (Stage)this.of.getContext().getActiveLeaf().get(Stage.class);
        }
        if (stage == null) {
            logger.error("Can't get active stage");
            stage = (Stage)this.of.getContext().get(Stage.class);
        }
        MxFastWebDialog dialog = new MxFastWebDialog(obj);
        dialog.initStyle(StageStyle.UNDECORATED);
        dialog.initModality(Modality.WINDOW_MODAL);
        dialog.getDialogPane().getScene().setFill(null);
        dialog.initOwner((Window)stage);
        dialog.setResult(ButtonType.CANCEL);
        dialog.getDialogPane().setOpacity(1.0);
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(this.getClass().getResource(DIALOG_FXML));
        DlgCtrl ctrl = new DlgCtrl(dialog);
        loader.setController((Object)ctrl);
        Parent parent = (Parent)loader.load();
        dialog.getDialogPane().setContent((Node)parent);
        dialog.setCtrl(ctrl);
        dialog.getDialogPane().getStylesheets().add((Object)this.getClass().getResource(DIALOG_CSS).toString());
        String theme = this.cs.getUserProps().get("app_theme");
        dialog.getDialogPane().getStyleClass().add((Object)(theme == null || theme.isEmpty() ? "blue-theme" : theme));
        ctrl.setTitle(title);
        Stage mainStage = this.of.getMainStage();
        ctrl.getCustomPane().setMinSize((double)width.intValue(), mainStage.getHeight() <= (double)height.intValue() ? mainStage.getHeight() : (double)height.intValue());
        obj.setPane(ctrl.getCustomPane());
        obj.initWebBrowser();
        ctrl.getCustomPane().layout();
        dialog.getDialogPane().addEventFilter(InputEvent.ANY, event -> this.es.sendEvent("window.active", null));
        return dialog;
    }
}

