/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.combobox;

import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxChgSelObj;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class ComboBoxCheckModel<T extends MxChgSelObj> {
    private ComboBox<T> comboBox;
    private MxList<T> mlist = new MxList();
    private List<T> filterList = new LinkedList<T>();
    private Map<String, CheckBox> mapCheckBox = new HashMap<String, CheckBox>();
    private Map<String, Label> mapLabel = new HashMap<String, Label>();
    private Map<String, HBox> mapHbox = new HashMap<String, HBox>();
    private boolean flag = true;
    private static final String CHECK_ALL = "\u5168\u9009";

    public ComboBoxCheckModel(ComboBox<T> comboBox) {
        this.comboBox = comboBox;
    }

    public void initCellFactroy() {
        this.comboBox.setVisibleRowCount(10);
        this.comboBox.setCellFactory(value -> new ListCell<T>(){
            {
                this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                    ((MxChgSelObj)this.getItem()).setSelected(!((MxChgSelObj)this.getItem()).isSelected());
                    e.consume();
                });
                this.setPrefWidth(200.0);
            }

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (item != null) {
                    HBox graphic;
                    CheckBox cBox;
                    Label label = (Label)ComboBoxCheckModel.this.mapLabel.get(item.getId());
                    if (label == null) {
                        label = new Label();
                        ComboBoxCheckModel.this.mapLabel.put(item.getId(), label);
                    }
                    if ((cBox = (CheckBox)ComboBoxCheckModel.this.mapCheckBox.get(item.getId())) == null) {
                        cBox = new CheckBox();
                        ComboBoxCheckModel.this.mapCheckBox.put(item.getId(), cBox);
                    }
                    if ((graphic = (HBox)ComboBoxCheckModel.this.mapHbox.get(item.getId())) == null) {
                        graphic = new HBox(new Node[]{cBox, label});
                        ComboBoxCheckModel.this.mapHbox.put(item.getId(), graphic);
                    }
                    label.setMaxWidth(Double.POSITIVE_INFINITY);
                    HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    cBox.selectedProperty().bindBidirectional((Property)item.selectedProperty());
                    label.textProperty().bind((ObservableValue)item.showNameProperty());
                    item.selectedProperty().addListener((ob, oldV, newV) -> {
                        if (newV.booleanValue()) {
                            if (((String)item.showNameProperty().get()).contains(ComboBoxCheckModel.CHECK_ALL)) {
                                if (ComboBoxCheckModel.this.flag) {
                                    ComboBoxCheckModel.this.flag = false;
                                    ComboBoxCheckModel.this.mapCheckBox.values().forEach(c -> c.setSelected(true));
                                    ComboBoxCheckModel.this.flag = true;
                                }
                            } else if (ComboBoxCheckModel.this.flag) {
                                ComboBoxCheckModel.this.flag = false;
                                if (ComboBoxCheckModel.this.filterList.size() - ComboBoxCheckModel.this.getCheckItems().size() == 1) {
                                    ComboBoxCheckModel.this.mlist.getList().forEach(it -> {
                                        if (((String)it.showNameProperty().get()).contains(ComboBoxCheckModel.CHECK_ALL) && !it.isSelected()) {
                                            it.setSelected(true);
                                        }
                                    });
                                }
                                ComboBoxCheckModel.this.flag = true;
                            }
                        } else if (((String)item.showNameProperty().get()).contains(ComboBoxCheckModel.CHECK_ALL)) {
                            if (ComboBoxCheckModel.this.flag) {
                                ComboBoxCheckModel.this.flag = false;
                                ComboBoxCheckModel.this.mapCheckBox.values().forEach(c -> c.setSelected(false));
                                ComboBoxCheckModel.this.flag = true;
                            }
                        } else if (ComboBoxCheckModel.this.flag) {
                            ComboBoxCheckModel.this.flag = false;
                            ComboBoxCheckModel.this.mlist.getList().forEach(it -> {
                                if (((String)it.showNameProperty().get()).contains(ComboBoxCheckModel.CHECK_ALL) && it.isSelected()) {
                                    it.setSelected(false);
                                }
                            });
                            ComboBoxCheckModel.this.flag = true;
                        }
                    });
                    this.setGraphic((Node)graphic);
                } else if (item == null || empty) {
                    this.setGraphic(null);
                }
            }
        });
        this.comboBox.setSkin((Skin)new ComboBoxListViewSkin<T>(this.comboBox){

            protected boolean isHideOnClickEnabled() {
                return false;
            }
        });
    }

    public void initData(List<T> src, Predicate<T> pd, Comparator<T> cp) {
        Collections.sort(src, cp);
        src.forEach(item -> item.setSelected(true));
        this.mlist.addAll(src);
        this.filterList.addAll(src);
        this.comboBox.setItems(this.mlist.getList());
        this.comboBox.getEditor().focusedProperty().addListener((ob, oldV, newV) -> {
            if (!newV.booleanValue()) {
                this.comboBox.getEditor().setText("");
            }
        });
        this.comboBox.getEditor().textProperty().addListener(ob -> {
            if (this.comboBox.getEditor().getText().isEmpty() && !this.comboBox.isFocused()) {
                this.mlist.update(this.filterList, item -> true);
                Collections.sort(this.mlist.getList(), cp);
                return;
            }
            this.mlist.update(this.filterList, pd);
            Collections.sort(this.mlist.getList(), cp);
            this.comboBox.hide();
            this.comboBox.show();
        });
    }

    public List<T> getCheckItems() {
        return this.comboBox.getItems().filtered(item -> item.isSelected());
    }

    public MxList<T> getMlist() {
        return this.mlist;
    }

    public void setMlist(MxList<T> mlist) {
        this.mlist = mlist;
    }

    public List<T> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(List<T> filterList) {
        this.filterList = filterList;
    }
}

