/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TradeCaptureReportAdvice
extends MxModel {
    private int accntLevel;
    private int side;
    private double price;
    private long orderQty;
    private long orderAvailableQuantity;
    private String portfolioId = "";
    private String portfolioName = "";
    private String productId = "";
    private String productName = "";
    private String flowAttriId = "";
    private String stepAttrId = "";
    private int instructionType;
    private String instructionPanelType = "";
    private String priceLimitUp = "1";
    private String priceLimitDown = "4";
    private int applType;
    private int rtgsFlag;
    private List<AccntSecInfo> accSecInfoList = new ArrayList<AccntSecInfo>();
    private String secId = "";
    private String secName = "";
    private String market = "";
    private String secType = "";
    private String appID = "";
    private double amount;
    private int tradeReportSubType;
    private int holderFlag;
    private String confirmId = "";
    private String traderId = "";
    private String partyId = "";
    private String extAccntId = "";
    private String extSecAccntId = "";
    private String otherTrader = "";

    public PInstruction.Instruction.Builder getInstBuilder() {
        PInstruction.Instruction.Builder insb = PInstruction.Instruction.newBuilder();
        Any any = this.buildAny();
        insb.setPortfolioId(this.portfolioId);
        insb.setProductId(this.productId);
        insb.setStepAttrId(this.getStepAttrId());
        insb.setFlowAttrId(this.getFlowAttriId());
        insb.setDetails(any);
        insb.setType(this.getInstructionType());
        if (StringUtils.isEmpty((String)"")) {
            insb.setExpireDate(DateTimeUtils.getDate());
        }
        return insb;
    }

    public Any buildAny() {
        switch (this.instructionType) {
            case 32: {
                return this.buildTrdCptRptAdvice();
            }
        }
        return null;
    }

    private Any buildTrdCptRptAdvice() {
        PInstruction.TradeCaptureReportAdvice.Builder tcrab = PInstruction.TradeCaptureReportAdvice.newBuilder();
        tcrab.setRtgsFlag(this.rtgsFlag);
        tcrab.setSecurityId(this.secId);
        tcrab.setSecurityName(this.secName);
        tcrab.setMarket(this.market);
        tcrab.setSecurityType(this.secType);
        tcrab.setAccntLevel(PBase.AccntLevel.forNumber((int)this.accntLevel));
        tcrab.setPrice(this.price);
        tcrab.setSide(this.side);
        tcrab.setApplId(this.appID);
        tcrab.setTrdSubType(PField.TradeReportSubType.forNumber((int)this.tradeReportSubType));
        tcrab.setHoldFlag(PField.HolderFlag.forNumber((int)this.holderFlag));
        tcrab.setConfirmId(this.confirmId);
        PPostTrade.Trader.Builder tb = PPostTrade.Trader.newBuilder();
        tb.setTraderId(this.otherTrader);
        tcrab.setTrader(tb.build());
        if (this.side == 49) {
            tcrab.setFixedPriceLimit(PInstruction.FixedPriceLimit.forNumber((int)Integer.valueOf(this.priceLimitUp)));
        } else {
            tcrab.setFixedPriceLimit(PInstruction.FixedPriceLimit.forNumber((int)Integer.valueOf(this.priceLimitDown)));
        }
        tcrab.setApplType(this.getApplType());
        this.sideAndParty(tcrab);
        for (AccntSecInfo accSecInfo : this.accSecInfoList) {
            PInstruction.AccntSecInfo.Builder accSecB = accSecInfo.getBuilder();
            tcrab.addAccntSecInfo(accSecB.build());
        }
        tcrab.setEstimatedOrderAmount(this.getAmount());
        Any any = Any.pack((Message)tcrab.build());
        return any;
    }

    private void sideAndParty(PInstruction.TradeCaptureReportAdvice.Builder tcrab) {
        PPostTrade.TrdCapRptSides.Builder sidesBuilder = PPostTrade.TrdCapRptSides.newBuilder();
        PPostTrade.TrdCapRptSide.Builder sideBuilder = PPostTrade.TrdCapRptSide.newBuilder();
        sideBuilder.setSide(PField.Side.forNumber((int)this.side));
        PComponent.PartyIDs.Builder partyIdsBuilder = PComponent.PartyIDs.newBuilder();
        PComponent.PartyID.Builder idBuilder = PComponent.PartyID.newBuilder();
        idBuilder.setPartyId(this.getPartyId());
        idBuilder.setPartyRole("COUNTERPARTY");
        partyIdsBuilder.addPartyId(idBuilder.build());
        sideBuilder.setPartyIds(partyIdsBuilder.build());
        sidesBuilder.addSide(sideBuilder.build());
        tcrab.setSides(sidesBuilder.build());
    }

    public void update(Object obj) {
        if (obj instanceof PInstruction.TradeCaptureReportAdvice) {
            this.update((PInstruction.TradeCaptureReportAdvice)PInstruction.TradeCaptureReportAdvice.class.cast(obj));
        } else if (obj instanceof TradeCaptureReportAdvice) {
            this.update((TradeCaptureReportAdvice)((Object)TradeCaptureReportAdvice.class.cast(obj)));
        }
    }

    private void update(TradeCaptureReportAdvice ta) {
        this.setSecId(ta.getSecId());
        this.setMarket(ta.getMarket());
        this.setSecType(ta.getSecType());
        this.setAccntLevel(ta.getAccntLevel());
        this.setSide(ta.getSide());
        this.setPrice(ta.getPrice());
        this.setOrderQty(ta.getOrderQty());
        this.getAccSecInfoList().clear();
        this.setPortfolioId(ta.getPortfolioId());
        this.setPortfolioName(ta.getPortfolioName());
        this.setProductId(ta.getProductId());
        this.setProductName(ta.getProductName());
        this.setSecName(ta.getSecName());
        for (AccntSecInfo oldInfo : ta.getAccSecInfoList()) {
            AccntSecInfo accSecInfo = new AccntSecInfo();
            accSecInfo.update((Object)oldInfo);
            this.getAccSecInfoList().add(accSecInfo);
        }
        Collections.sort(this.getAccSecInfoList());
        this.setAppID(ta.getAppID());
        this.setInstructionPanelType(ta.getInstructionPanelType());
        this.setInstructionType(ta.getInstructionType());
        this.setOrderAvailableQuantity(ta.getOrderAvailableQuantity());
        this.setTradeReportSubType(ta.getTradeReportSubType());
        this.setHolderFlag(ta.getHolderFlag());
        this.setConfirmId(ta.getConfirmId());
        this.setTraderId(ta.getTraderId());
        this.setPartyId(ta.getPartyId());
        this.setApplType(ta.getApplType());
        this.setExtAccntId(ta.getExtAccntId());
        this.setExtSecAccntId(ta.getExtSecAccntId());
        this.setOtherTrader(ta.getOtherTrader());
        this.setRtgsFlag(ta.getRtgsFlag());
        this.setAmount(ta.getAmount());
    }

    private void update(PInstruction.TradeCaptureReportAdvice ta) {
        this.setSecId(ta.getSecurityId());
        this.setMarket(ta.getMarket());
        this.setSecType(ta.getSecurityType());
        this.setAccntLevel(ta.getAccntLevelValue());
        this.setSide(ta.getSide());
        this.setPrice(new BigDecimal(Double.toString(ta.getPrice())).doubleValue());
        this.setSecName(ta.getSecurityName());
        long orderQty = 0L;
        this.getAccSecInfoList().clear();
        for (PInstruction.AccntSecInfo accntSecInfo : ta.getAccntSecInfoList()) {
            AccntSecInfo accSecInfo = new AccntSecInfo();
            accSecInfo.update((Object)accntSecInfo);
            orderQty += accSecInfo.getOrderQty();
            this.getAccSecInfoList().add(accSecInfo);
            if (ta.getAccntLevelValue() != 0) continue;
            this.setExtAccntId(accSecInfo.getAccntId());
            this.setExtSecAccntId(accSecInfo.getSecAccntId());
        }
        Collections.sort(this.getAccSecInfoList());
        this.setOrderQty(orderQty);
        this.setOrderAvailableQuantity(orderQty);
        this.setAppID(ta.getApplId());
        this.setTradeReportSubType(ta.getTrdSubTypeValue());
        this.setHolderFlag(ta.getHoldFlagValue());
        this.setConfirmId(ta.getConfirmId());
        this.setTraderId(ta.getTrader().getTraderId());
        if (!ta.getSides().getSideList().isEmpty() && !ta.getSides().getSide(0).getPartyIds().getPartyIdList().isEmpty()) {
            this.setPartyId(((PComponent.PartyID)ta.getSides().getSide(0).getPartyIds().getPartyIdList().get(0)).getPartyId());
        }
        this.setApplType(ta.getApplType());
        this.setRtgsFlag(ta.getRtgsFlag());
        this.setOtherTrader(ta.getTrader().getTraderId());
    }

    public List<AccntSecInfo> getAccSecInfoList() {
        return this.accSecInfoList;
    }

    public void setAccSecInfoList(List<AccntSecInfo> accSecInfoList) {
        this.accSecInfoList = accSecInfoList;
    }

    public boolean isSub() {
        return this.getAccntLevel() == 1;
    }

    public long getOrderAvailableQuantity() {
        return this.orderAvailableQuantity;
    }

    public void setOrderAvailableQuantity(long orderAvailableQuantity) {
        this.orderAvailableQuantity = orderAvailableQuantity;
    }

    public int getAccntLevel() {
        return this.accntLevel;
    }

    public void setAccntLevel(int accntLevel) {
        this.accntLevel = accntLevel;
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int side) {
        this.side = side;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public long getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(long orderQty) {
        this.orderQty = orderQty;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getPortfolioName() {
        return this.portfolioName;
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioName = portfolioName;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getFlowAttriId() {
        return this.flowAttriId;
    }

    public void setFlowAttriId(String flowAttriId) {
        this.flowAttriId = flowAttriId;
    }

    public String getStepAttrId() {
        return this.stepAttrId;
    }

    public void setStepAttrId(String stepAttrId) {
        this.stepAttrId = stepAttrId;
    }

    public int getInstructionType() {
        return this.instructionType;
    }

    public void setInstructionType(int instructionType) {
        this.instructionType = instructionType;
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public int getTradeReportSubType() {
        return this.tradeReportSubType;
    }

    public void setTradeReportSubType(int tradeReportSubType) {
        this.tradeReportSubType = tradeReportSubType;
    }

    public int getHolderFlag() {
        return this.holderFlag;
    }

    public void setHolderFlag(int holderFlag) {
        this.holderFlag = holderFlag;
    }

    public String getConfirmId() {
        return this.confirmId;
    }

    public void setConfirmId(String confirmId) {
        this.confirmId = confirmId;
    }

    public String getTraderId() {
        return this.traderId;
    }

    public void setTraderId(String traderId) {
        this.traderId = traderId;
    }

    public int getApplType() {
        return this.applType;
    }

    public void setApplType(int applType) {
        this.applType = applType;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public int getRtgsFlag() {
        return this.rtgsFlag;
    }

    public void setRtgsFlag(int rtgsFlag) {
        this.rtgsFlag = rtgsFlag;
    }

    public String getOtherTrader() {
        return this.otherTrader;
    }

    public void setOtherTrader(String otherTrader) {
        this.otherTrader = otherTrader;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }
}

