/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.entity.trade.instruction.RiskObjectType;
import cms.tmx.http.instruction.dto.InstrumentValue;
import cms.tmx.http.instruction.dto.Quota;
import cms.tmx.http.instruction.dto.QuotaThreshold;
import cms.tmx.http.instruction.dto.QuotaValue;
import cms.tmx.http.instruction.dto.ThresholdType;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class RiskMonitor {
    private StringProperty objType = new SimpleStringProperty("");
    private StringProperty objName = new SimpleStringProperty("");
    private StringProperty indexName = new SimpleStringProperty("");
    private StringProperty nowValue = new SimpleStringProperty("");
    private StringProperty deptAuthor = new SimpleStringProperty("");
    private StringProperty compAuthor = new SimpleStringProperty("");
    private double nowVal;
    private double deptVal;
    private double compVal;
    private String valueType;

    public void update(QuotaValue quota) {
        this.nowVal = ((InstrumentValue)quota.getInstrumentValue().get(0)).getValue();
        if ("kValueTypePercent".equals(quota.getValueType())) {
            this.setNowValue("\u5f53\u524d\u503c\uff1a" + StringUtils.toThousands((Number)(this.nowVal * 100.0), (int)2) + "%");
        } else {
            this.setNowValue("\u5f53\u524d\u503c\uff1a" + StringUtils.toThousands((Number)this.nowVal, (int)2));
        }
        this.setValueType(quota.getValueType());
    }

    public void update(Quota quota) {
        int type = quota.getObjectType();
        this.setObjType(RiskObjectType.getName(type));
        this.setObjName(quota.getQuotaObject());
        this.setIndexName("\u6307\u6807\uff1a" + quota.getQuotaName());
    }

    public void update(QuotaThreshold threshold) {
        if ("kValueTypePercent".equals(this.getValueType())) {
            if (threshold.getThresholdType().equals((Object)ThresholdType.kDepartMent)) {
                this.deptVal = threshold.getSetValue();
                this.setDeptAuthor("\u90e8\u95e8\u9608\u503c\uff1a" + StringUtils.toThousands((Number)(this.deptVal * 100.0), (int)2) + "%");
            } else if (threshold.getThresholdType().equals((Object)ThresholdType.kCompany)) {
                this.compVal = threshold.getSetValue();
                this.setCompAuthor("\u516c\u53f8\u9608\u503c\uff1a" + StringUtils.toThousands((Number)(this.compVal * 100.0), (int)2) + "%");
            }
        } else if (threshold.getThresholdType().equals((Object)ThresholdType.kDepartMent)) {
            this.deptVal = threshold.getSetValue();
            this.setDeptAuthor("\u90e8\u95e8\u9608\u503c\uff1a" + StringUtils.toThousands((Number)this.deptVal, (int)2));
        } else if (threshold.getThresholdType().equals((Object)ThresholdType.kCompany)) {
            this.compVal = threshold.getSetValue();
            this.setCompAuthor("\u516c\u53f8\u9608\u503c\uff1a" + StringUtils.toThousands((Number)this.compVal, (int)2));
        }
    }

    public final StringProperty objTypeProperty() {
        return this.objType;
    }

    public final String getObjType() {
        return (String)this.objTypeProperty().get();
    }

    public final void setObjType(String objType) {
        this.objTypeProperty().set((Object)objType);
    }

    public final StringProperty objNameProperty() {
        return this.objName;
    }

    public final String getObjName() {
        return (String)this.objNameProperty().get();
    }

    public final void setObjName(String objName) {
        this.objNameProperty().set((Object)objName);
    }

    public final StringProperty indexNameProperty() {
        return this.indexName;
    }

    public final String getIndexName() {
        return (String)this.indexNameProperty().get();
    }

    public final void setIndexName(String indexName) {
        this.indexNameProperty().set((Object)indexName);
    }

    public final StringProperty deptAuthorProperty() {
        return this.deptAuthor;
    }

    public final String getDeptAuthor() {
        return (String)this.deptAuthorProperty().get();
    }

    public final void setDeptAuthor(String deptAuthor) {
        this.deptAuthorProperty().set((Object)deptAuthor);
    }

    public final StringProperty compAuthorProperty() {
        return this.compAuthor;
    }

    public final String getCompAuthor() {
        return (String)this.compAuthorProperty().get();
    }

    public final void setCompAuthor(String compAuthor) {
        this.compAuthorProperty().set((Object)compAuthor);
    }

    public final StringProperty nowValueProperty() {
        return this.nowValue;
    }

    public final String getNowValue() {
        return (String)this.nowValueProperty().get();
    }

    public final void setNowValue(String nowValue) {
        this.nowValueProperty().set((Object)nowValue);
    }

    public double getNowVal() {
        return this.nowVal;
    }

    public void setNowVal(double nowVal) {
        this.nowVal = nowVal;
    }

    public double getDeptVal() {
        return this.deptVal;
    }

    public void setDeptVal(double deptVal) {
        this.deptVal = deptVal;
    }

    public double getCompVal() {
        return this.compVal;
    }

    public void setCompVal(double compVal) {
        this.compVal = compVal;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }
}

