/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.proto.PResource;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class Resource
extends MxObject {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty type = new SimpleStringProperty("");
    private DoubleProperty ratio = new SimpleDoubleProperty();
    private StringProperty endTime = new SimpleStringProperty("");
    private StringProperty reference = new SimpleStringProperty("");
    private StringProperty status = new SimpleStringProperty("");
    private LongProperty totalExpectationQty = new SimpleLongProperty();
    private LongProperty cumQty = new SimpleLongProperty();
    private LongProperty leavesQty = new SimpleLongProperty();
    private LongProperty availOrderQty = new SimpleLongProperty();
    private LongProperty orderQty = new SimpleLongProperty();
    private DoubleProperty orderAvg = new SimpleDoubleProperty(0.0);
    private DoubleProperty orderAmt = new SimpleDoubleProperty(0.0);
    private ObjectProperty<MxNode> ordStatus = new SimpleObjectProperty();
    private DoubleProperty cumAmount = new SimpleDoubleProperty();
    private StringProperty leavesAmt = new SimpleStringProperty("");
    private DoubleProperty avgPx = new SimpleDoubleProperty();
    private DoubleProperty tradeAmount = new SimpleDoubleProperty();
    private DoubleProperty availOrderAmt = new SimpleDoubleProperty(0.0);
    private LongProperty availOrderNum = new SimpleLongProperty(0L);
    private DoubleProperty ordAmt = new SimpleDoubleProperty(0.0);

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Resource() {
        MxNode node = MxNodeFactory.create((String)"ord_status", (String)"");
        this.setOrdStatus(node);
    }

    public void update(Object obj) {
        if (obj instanceof PResource.Resource) {
            PResource.Resource res = (PResource.Resource)PResource.Resource.class.cast(obj);
            this.update(res);
        } else if (obj instanceof Resource) {
            this.update((Resource)((Object)Resource.class.cast(obj)));
        }
    }

    private void update(PResource.Resource res) {
        this.setId(res.getId());
        this.setType(Integer.toString(res.getTypeValue()));
        this.setRatio(res.getRatio() * 100.0);
        this.setEndTime(res.getEndTime());
        this.setReference(res.getReference());
        this.setStatus(String.valueOf(res.getStatus().getNumber()));
        this.setTotalExpectationQty(Double.valueOf(res.getTotalExpectationQty()).longValue());
        this.setCumQty(Double.valueOf(res.getCumQty()).longValue());
        this.setLeavesQty(Double.valueOf(res.getLeavesQty()).longValue());
        this.setAvailOrderQty(Double.valueOf(res.getAvailOrderQty()).longValue());
        this.setAvgPx(res.getAvgPx());
        this.setLeavesAmt(new BigDecimal(res.getLeavesAmt()).setScale(2, 4).toPlainString());
        this.setTradeAmount(res.getTradeAmount());
        this.setOrderQty((long)res.getOrderQty());
        this.setOrderAvg(res.getAvgOrderPrice());
        int ordStatus = res.getOrdStatusValue();
        if (ordStatus != 0) {
            this.getOrdStatus().setRaw(String.valueOf(ordStatus));
        }
        if (!res.getReferencyType().equals("RESOURCE_TRD_CPT_RPT")) {
            this.setOrdAmt(res.getLeavesAmt() + res.getTradeAmount());
        }
    }

    private void update(Resource res) {
        this.setId(res.getId());
        this.setType(res.getType());
        this.setRatio(res.getRatio());
        this.setEndTime(res.getEndTime());
        this.setReference(res.getReference());
        this.setStatus(res.getStatus());
        this.setTotalExpectationQty(res.getTotalExpectationQty());
        this.setCumQty(res.getCumQty());
        this.setOrderQty(res.getOrderQty());
        this.setLeavesQty(res.getLeavesQty());
        this.setAvailOrderQty(res.getAvailOrderQty());
        this.setAvgPx(res.getAvgPx());
        this.setLeavesAmt(res.getLeavesAmt());
        this.setOrderAvg(res.getOrderAvg());
        this.getOrdStatus().setRaw(res.getOrdStatus().getRaw());
        this.setAvailOrderNum(res.getAvailOrderNum());
        this.setTradeAmount(res.getTradeAmount());
        this.setOrdAmt(res.getOrdAmt());
    }

    public StringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return (String)this.idProperty().get();
    }

    public void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public StringProperty typeProperty() {
        return this.type;
    }

    public String getType() {
        return (String)this.typeProperty().get();
    }

    public void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public DoubleProperty ratioProperty() {
        return this.ratio;
    }

    public double getRatio() {
        return this.ratioProperty().get();
    }

    public void setRatio(double ratio) {
        this.ratioProperty().set(ratio);
    }

    public StringProperty endTimeProperty() {
        return this.endTime;
    }

    public String getEndTime() {
        return (String)this.endTimeProperty().get();
    }

    public void setEndTime(String endTime) {
        this.endTimeProperty().set((Object)endTime);
    }

    public StringProperty referenceProperty() {
        return this.reference;
    }

    public String getReference() {
        return (String)this.referenceProperty().get();
    }

    public void setReference(String reference) {
        this.referenceProperty().set((Object)reference);
    }

    public StringProperty statusProperty() {
        return this.status;
    }

    public String getStatus() {
        return (String)this.statusProperty().get();
    }

    public void setStatus(String status) {
        this.statusProperty().set((Object)status);
    }

    public LongProperty totalExpectationQtyProperty() {
        return this.totalExpectationQty;
    }

    public long getTotalExpectationQty() {
        return this.totalExpectationQtyProperty().get();
    }

    public void setTotalExpectationQty(long totalExpectationQty) {
        this.totalExpectationQtyProperty().set(totalExpectationQty);
    }

    public LongProperty cumQtyProperty() {
        return this.cumQty;
    }

    public long getCumQty() {
        return this.cumQtyProperty().get();
    }

    public void setCumQty(long cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public LongProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public long getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public void setLeavesQty(long leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public LongProperty availOrderQtyProperty() {
        return this.availOrderQty;
    }

    public long getAvailOrderQty() {
        return this.availOrderQtyProperty().get();
    }

    public void setAvailOrderQty(long availOrderQty) {
        this.availOrderQtyProperty().set(availOrderQty);
    }

    public DoubleProperty cumAmountProperty() {
        return this.cumAmount;
    }

    public double getCumAmount() {
        return this.cumAmountProperty().get();
    }

    public void setCumAmount(double cumAmount) {
        this.cumAmountProperty().set(cumAmount);
    }

    public DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public StringProperty leavesAmtProperty() {
        return this.leavesAmt;
    }

    public String getLeavesAmt() {
        return (String)this.leavesAmtProperty().get();
    }

    public void setLeavesAmt(String leavesAmt) {
        this.leavesAmtProperty().set((Object)leavesAmt);
    }

    public LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public void setOrderQty(long orderedQty) {
        this.orderQtyProperty().set(orderedQty);
    }

    public final ObjectProperty<MxNode> ordStatusProperty() {
        return this.ordStatus;
    }

    public final MxNode getOrdStatus() {
        return (MxNode)this.ordStatusProperty().get();
    }

    public final void setOrdStatus(MxNode ordStatus) {
        this.ordStatusProperty().set((Object)ordStatus);
    }

    public final DoubleProperty orderAvgProperty() {
        return this.orderAvg;
    }

    public final double getOrderAvg() {
        return this.orderAvgProperty().get();
    }

    public final void setOrderAvg(double orderAvg) {
        double ordAvg = (double)Math.round(orderAvg * 10000.0) / 10000.0;
        this.orderAvgProperty().set(ordAvg);
    }

    public final DoubleProperty orderAmtProperty() {
        return this.orderAmt;
    }

    public final double getOrderAmt() {
        return this.orderAmtProperty().get();
    }

    public final void setOrderAmt(double orderAmt) {
        this.orderAmtProperty().set(orderAmt);
    }

    public final DoubleProperty availOrderAmtProperty() {
        return this.availOrderAmt;
    }

    public final double getAvailOrderAmt() {
        return this.availOrderAmtProperty().get();
    }

    public final void setAvailOrderAmt(double availOrderAmt) {
        this.availOrderAmtProperty().set(availOrderAmt);
    }

    public final LongProperty availOrderNumProperty() {
        return this.availOrderNum;
    }

    public final long getAvailOrderNum() {
        return this.totalExpectationQtyProperty().get() - this.cumQtyProperty().get();
    }

    public final void setAvailOrderNum(long availOrderNum) {
        this.availOrderNumProperty().set(availOrderNum);
    }

    public final DoubleProperty tradeAmountProperty() {
        return this.tradeAmount;
    }

    public final double getTradeAmount() {
        return this.tradeAmountProperty().get();
    }

    public final void setTradeAmount(double tradeAmount) {
        this.tradeAmountProperty().set(tradeAmount);
    }

    public final DoubleProperty ordAmtProperty() {
        return this.ordAmt;
    }

    public final double getOrdAmt() {
        return this.ordAmtProperty().get();
    }

    public final void setOrdAmt(double ordAmt) {
        this.ordAmtProperty().set(ordAmt);
    }
}

