/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.TransferInfo;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OrderAdvice
extends MxModel {
    private StringProperty accntId = new SimpleStringProperty("");
    private IntegerProperty accntLevel = new SimpleIntegerProperty();
    private IntegerProperty ordType = new SimpleIntegerProperty();
    private IntegerProperty side = new SimpleIntegerProperty();
    private int ocFlag;
    private int shFlag;
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty orderQty = new SimpleLongProperty();
    private double amount;
    private LongProperty orderAvailableQuantity = new SimpleLongProperty();
    private StringProperty secAccntId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private IntegerProperty tif = new SimpleIntegerProperty();
    private IntegerProperty maxLevels = new SimpleIntegerProperty();
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty productId = new SimpleStringProperty("");
    private StringProperty productName = new SimpleStringProperty("");
    private IntegerProperty priceLimit = new SimpleIntegerProperty();
    private StringProperty marketPriceLimit = new SimpleStringProperty("");
    private IntegerProperty priceTypeBidAsk = new SimpleIntegerProperty();
    private StringProperty flowAttriId = new SimpleStringProperty("");
    private StringProperty stepAttrId = new SimpleStringProperty("");
    private IntegerProperty instructionType = new SimpleIntegerProperty();
    private StringProperty instructionPanelType = new SimpleStringProperty("");
    private DoubleProperty protectedLimitPrice = new SimpleDoubleProperty(0.0);
    private boolean isStar = false;
    private List<AccntSecInfo> accSecInfoList = new ArrayList<AccntSecInfo>();
    private List<String> traderUserIds = new ArrayList<String>();
    private StringProperty sec = new SimpleStringProperty("");
    private StringProperty secName = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty secType = new SimpleStringProperty("");
    private StringProperty appID = new SimpleStringProperty("");
    private SimpleBooleanProperty canModify = new SimpleBooleanProperty(false);
    private StringProperty clInstructionId = new SimpleStringProperty("");
    private String postil = "";
    private String insExpiredDate = "";
    private String subSecType = "";
    @Inject
    private IInstructionApi insApi;

    public String getPostil() {
        return this.postil;
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public InstructionSubmitResult submit() throws MException {
        InstructionSubmitResult result = new InstructionSubmitResult();
        PInstruction.Instruction.Builder insb = this.buildInstruction();
        String instructionId = this.insApi.newInstruction(insb.build(), this.getActionId());
        String reason = this.insApi.submitInstruction(instructionId, this.getPostil());
        result.setInstructionId(instructionId);
        result.setReason(reason);
        return result;
    }

    public PInstruction.Instruction.Builder buildFastInstruction() {
        PInstruction.SingleOrderAdvice.Builder soab = this.buildFastSingleOrderAdvice();
        PInstruction.Instruction.Builder insb = PInstruction.Instruction.newBuilder();
        insb.setName(this.getSecName());
        insb.setPortfolioId((String)this.portfolioId.get());
        insb.setProductId((String)this.productId.get());
        insb.setStepAttrId(this.getStepAttrId());
        insb.setFlowAttrId(this.getFlowAttriId());
        if (StringUtils.isEmpty((String)this.getInsExpiredDate())) {
            insb.setExpireDate(DateTimeUtils.getDate());
        } else {
            insb.setExpireDate(this.getInsExpiredDate());
        }
        insb.setSingleAdvice(soab.build());
        insb.setType(this.getInstructionType());
        insb.setHasExecSwitchPermit(this.isCanModify());
        insb.setClInstructionId(this.getClInstructionId());
        insb.addAllAuthorizer(this.traderUserIds);
        insb.setEstimatedOrderAmount(this.getAmount());
        return insb;
    }

    public PInstruction.Instruction.Builder buildInstruction() {
        Any any = this.buildAny();
        PInstruction.Instruction.Builder insb = PInstruction.Instruction.newBuilder();
        insb.setName(this.getSecName());
        insb.setPortfolioId((String)this.portfolioId.get());
        insb.setProductId((String)this.productId.get());
        insb.setStepAttrId(this.getStepAttrId());
        insb.setFlowAttrId(this.getFlowAttriId());
        if (StringUtils.isEmpty((String)this.getInsExpiredDate())) {
            insb.setExpireDate(DateTimeUtils.getDate());
        } else {
            insb.setExpireDate(this.getInsExpiredDate());
        }
        insb.setDetails(any);
        insb.setType(this.getInstructionType());
        insb.setHasExecSwitchPermit(this.isCanModify());
        insb.setClInstructionId(this.getClInstructionId());
        insb.addAllAuthorizer(this.traderUserIds);
        insb.setEstimatedOrderAmount(this.getAmount());
        return insb;
    }

    private int getActionId() {
        int actionId = 0;
        if ("2".equals(this.instructionPanelType.get())) {
            actionId = 20;
        } else if ("1".equals(this.instructionPanelType.get())) {
            actionId = 21;
        }
        return actionId;
    }

    public void flow(TransferInfo transferInfo, int actionId) throws MException {
        Any any = this.buildAny();
        PInstruction.Instruction.Builder insb = PInstruction.Instruction.newBuilder();
        insb.setPortfolioId((String)this.portfolioId.get());
        insb.setStepAttrId(this.getStepAttrId());
        insb.setFlowAttrId(this.getFlowAttriId());
        insb.setTransferInfo(transferInfo.getPbTransferInfo());
        insb.setDetails(any);
        this.insApi.updateInstruction(insb.build(), actionId);
    }

    private void buildSingleOrderPriceLimit(PInstruction.SingleOrderAdvice.Builder soab) {
        if (50 == this.ordType.get()) {
            soab.setFixedPriceLimit(PInstruction.FixedPriceLimit.forNumber((int)this.getPriceLimit()));
        } else if (49 == this.ordType.get()) {
            soab.setMarketPriceLimit(PInstruction.MarketPriceLimit.forNumber((int)MarketPriceLimit.getPriceLimitByRaw(this.getMarketPriceLimit()).pbCode));
            soab.setMaxPriceLevels(this.getMaxLevels());
            if (this.isStar()) {
                soab.setProtectedLimitPrice(this.getProtectedLimitPrice());
            }
        } else if (this.ordType.get() == 0) {
            soab.setPlatePrice(PInstruction.PlatePrice.forNumber((int)(this.getPriceTypeBidAsk() + 11)));
        } else if (99 == this.ordType.get()) {
            soab.setPrice(this.getPrice());
        }
    }

    public Any buildAny() {
        switch (this.instructionType.get()) {
            case 2: {
                return this.buildSingleOrderAdvice();
            }
            case 3: {
                return this.buildSingleOrderAdvice();
            }
            case 64: {
                return this.buildSingleOrderAdvice();
            }
        }
        return null;
    }

    private Any buildSingleOrderAdvice() {
        PInstruction.SingleOrderAdvice.Builder soab = this.buildFastSingleOrderAdvice();
        Any any = Any.pack((Message)soab.build());
        return any;
    }

    PInstruction.SingleOrderAdvice.Builder buildFastSingleOrderAdvice() {
        PInstruction.SingleOrderAdvice.Builder soab = PInstruction.SingleOrderAdvice.newBuilder();
        soab.setSecurityId((String)this.sec.get());
        soab.setSecurityName((String)this.secName.get());
        soab.setMarket((String)this.market.get());
        soab.setSecurityType((String)this.secType.get());
        soab.setAccntLevel(PBase.AccntLevel.forNumber((int)this.accntLevel.get()));
        this.buildSingleOrderPriceLimit(soab);
        soab.setApplId((String)this.appID.get());
        soab.setOrdType(this.ordType.get());
        soab.setMaxPriceLevels(this.maxLevels.get());
        soab.setPrice(this.price.get());
        soab.setSide(this.side.get());
        soab.setTif(this.tif.get());
        soab.setPeFlag(this.ocFlag);
        soab.setShFlag(this.shFlag);
        for (AccntSecInfo accSecInfo : this.accSecInfoList) {
            PInstruction.AccntSecInfo.Builder accSecB = accSecInfo.getBuilder();
            soab.addAccntSecInfo(accSecB.build());
        }
        soab.setEstimatedOrderAmount(this.getAmount());
        return soab;
    }

    public void update(Object obj) {
        if (obj instanceof PInstruction.SingleOrderAdvice) {
            this.update((PInstruction.SingleOrderAdvice)PInstruction.SingleOrderAdvice.class.cast(obj));
        } else if (obj instanceof OrderAdvice) {
            this.update((OrderAdvice)((Object)OrderAdvice.class.cast(obj)));
        }
    }

    private void update(OrderAdvice oa) {
        this.setSec(oa.getSec());
        this.setMarket(oa.getMarket());
        this.setSecType(oa.getSecType());
        this.setOrdType(oa.getOrdType());
        this.setAccntLevel(oa.getAccntLevel());
        this.setSide(oa.getSide());
        this.setTif(oa.getTif());
        this.setPrice(oa.getPrice());
        this.setAmount(oa.getAmount());
        this.setPriceLimit(oa.getPriceLimit());
        this.setPriceTypeBidAsk(oa.getPriceTypeBidAsk());
        this.setMaxLevels(oa.getMaxLevels());
        this.setMarketPriceLimit(oa.getMarketPriceLimit());
        this.setOrderQty(oa.getOrderQty());
        this.getAccSecInfoList().clear();
        this.setPortfolioId(oa.getPortfolioId());
        this.setPortfolioName(oa.getPortfolioName());
        this.setProductId(oa.getProductId());
        this.setProductName(oa.getProductName());
        this.setInvestorId(oa.getInvestorId());
        this.setSecName(oa.getSecName());
        this.setOcFlag(oa.getOcFlag());
        this.setShFlag(oa.getShFlag());
        this.setProtectedLimitPrice(oa.getProtectedLimitPrice());
        this.setStar(oa.isStar());
        for (AccntSecInfo oldInfo : oa.getAccSecInfoList()) {
            AccntSecInfo accSecInfo = new AccntSecInfo();
            accSecInfo.update((Object)oldInfo);
            this.getAccSecInfoList().add(accSecInfo);
        }
        Collections.sort(this.getAccSecInfoList());
    }

    private void update(PInstruction.SingleOrderAdvice soa) {
        this.setSec(soa.getSecurityId());
        this.setMarket(soa.getMarket());
        this.setSecType(soa.getSecurityType());
        this.setOrdType(soa.getOrdType());
        this.setAccntLevel(soa.getAccntLevelValue());
        this.setSide(soa.getSide());
        this.setOcFlag(soa.getPeFlag());
        this.setShFlag(soa.getShFlag());
        this.setTif(soa.getTif());
        this.setStar(soa.getSecurityId() != null && soa.getSecurityId().startsWith("688"));
        this.setPrice(new BigDecimal(Double.toString(soa.getPrice())).setScale(4, 4).doubleValue());
        this.setProtectedLimitPrice(new BigDecimal(Double.toString(soa.getProtectedLimitPrice())).setScale(4, 4).doubleValue());
        this.setSecName(soa.getSecurityName());
        if (soa.getFixedPriceLimitValue() > 0) {
            this.setPriceLimit(soa.getFixedPriceLimitValue());
            this.setMaxLevels(soa.getMaxPriceLevels());
        }
        if (soa.getPlatePriceValue() > 0) {
            this.setPriceTypeBidAsk(soa.getPlatePriceValue() - 11);
        }
        if (soa.getMarketPriceLimitValue() > 0) {
            this.setMarketPriceLimit(MarketPriceLimit.getPriceLimitByPbCode(soa.getMarketPriceLimitValue()).raw);
            this.setMaxLevels(soa.getMaxPriceLevels());
        }
        long orderQty = 0L;
        this.getAccSecInfoList().clear();
        for (PInstruction.AccntSecInfo accntSecInfo : soa.getAccntSecInfoList()) {
            AccntSecInfo accSecInfo = new AccntSecInfo();
            accSecInfo.update((Object)accntSecInfo);
            orderQty += accSecInfo.getOrderQty();
            this.getAccSecInfoList().add(accSecInfo);
        }
        Collections.sort(this.getAccSecInfoList());
        this.setOrderQty(orderQty);
    }

    public IntegerProperty sideProperty() {
        return this.side;
    }

    public int getSide() {
        return this.sideProperty().get();
    }

    public void setSide(int side) {
        this.sideProperty().set(side);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public IntegerProperty tifProperty() {
        return this.tif;
    }

    public int getTif() {
        return this.tifProperty().get();
    }

    public void setTif(int tif) {
        this.tifProperty().set(tif);
    }

    public StringProperty secProperty() {
        return this.sec;
    }

    public String getSec() {
        return (String)this.secProperty().get();
    }

    public void setSec(String sec) {
        this.secProperty().set((Object)sec);
    }

    public StringProperty marketProperty() {
        return this.market;
    }

    public String getMarket() {
        return (String)this.marketProperty().get();
    }

    public void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public StringProperty secTypeProperty() {
        return this.secType;
    }

    public String getSecType() {
        return (String)this.secTypeProperty().get();
    }

    public void setSecType(String secType) {
        this.secTypeProperty().set((Object)secType);
    }

    public StringProperty appIDProperty() {
        return this.appID;
    }

    public String getAppID() {
        return (String)this.appIDProperty().get();
    }

    public void setAppID(String appID) {
        this.appIDProperty().set((Object)appID);
    }

    public StringProperty accntIdProperty() {
        return this.accntId;
    }

    public String getAccntId() {
        return (String)this.accntIdProperty().get();
    }

    public void setAccntId(String accntId) {
        this.accntIdProperty().set((Object)accntId);
    }

    public IntegerProperty accntLevelProperty() {
        return this.accntLevel;
    }

    public int getAccntLevel() {
        return this.accntLevelProperty().get();
    }

    public void setAccntLevel(int accntLevel) {
        this.accntLevelProperty().set(accntLevel);
    }

    public IntegerProperty ordTypeProperty() {
        return this.ordType;
    }

    public int getOrdType() {
        return this.ordTypeProperty().get();
    }

    public void setOrdType(int ordType) {
        this.ordTypeProperty().set(ordType);
    }

    public LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public StringProperty secAccntIdProperty() {
        return this.secAccntId;
    }

    public String getSecAccntId() {
        return (String)this.secAccntIdProperty().get();
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntIdProperty().set((Object)secAccntId);
    }

    public StringProperty investorIdProperty() {
        return this.investorId;
    }

    public String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public IntegerProperty maxLevelsProperty() {
        return this.maxLevels;
    }

    public int getMaxLevels() {
        return this.maxLevelsProperty().get();
    }

    public void setMaxLevels(int maxLevels) {
        this.maxLevelsProperty().set(maxLevels);
    }

    public StringProperty secNameProperty() {
        return this.secName;
    }

    public String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public List<AccntSecInfo> getAccSecInfoList() {
        return this.accSecInfoList;
    }

    public void setAccSecInfoList(List<AccntSecInfo> accSecInfoList) {
        this.accSecInfoList = accSecInfoList;
    }

    public IntegerProperty priceLimitProperty() {
        return this.priceLimit;
    }

    public int getPriceLimit() {
        return this.priceLimitProperty().get();
    }

    public void setPriceLimit(int priceLimit) {
        this.priceLimitProperty().set(priceLimit);
    }

    public IntegerProperty priceTypeBidAskProperty() {
        return this.priceTypeBidAsk;
    }

    public int getPriceTypeBidAsk() {
        return this.priceTypeBidAskProperty().get();
    }

    public void setPriceTypeBidAsk(int priceTypeBidAsk) {
        this.priceTypeBidAskProperty().set(priceTypeBidAsk);
    }

    public StringProperty flowAttriIdProperty() {
        return this.flowAttriId;
    }

    public String getFlowAttriId() {
        return (String)this.flowAttriIdProperty().get();
    }

    public void setFlowAttriId(String flowAttriId) {
        this.flowAttriIdProperty().set((Object)flowAttriId);
    }

    public StringProperty marketPriceLimitProperty() {
        return this.marketPriceLimit;
    }

    public String getMarketPriceLimit() {
        return (String)this.marketPriceLimitProperty().get();
    }

    public void setMarketPriceLimit(String marketPriceLimit) {
        this.marketPriceLimitProperty().set((Object)marketPriceLimit);
    }

    public StringProperty stepAttrIdProperty() {
        return this.stepAttrId;
    }

    public String getStepAttrId() {
        return (String)this.stepAttrIdProperty().get();
    }

    public void setStepAttrId(String stepAttrId) {
        this.stepAttrIdProperty().set((Object)stepAttrId);
    }

    public IntegerProperty instructionTypeProperty() {
        return this.instructionType;
    }

    public int getInstructionType() {
        return this.instructionTypeProperty().get();
    }

    public void setInstructionType(int instructionType) {
        this.instructionTypeProperty().set(instructionType);
    }

    public StringProperty productIdProperty() {
        return this.productId;
    }

    public String getProductId() {
        return (String)this.productIdProperty().get();
    }

    public void setProductId(String productId) {
        this.productIdProperty().set((Object)productId);
    }

    public StringProperty productNameProperty() {
        return this.productName;
    }

    public String getProductName() {
        return (String)this.productNameProperty().get();
    }

    public void setProductName(String productName) {
        this.productNameProperty().set((Object)productName);
    }

    public StringProperty instructionPanelTypeProperty() {
        return this.instructionPanelType;
    }

    public String getInstructionPanelType() {
        return (String)this.instructionPanelTypeProperty().get();
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelTypeProperty().set((Object)instructionPanelType);
    }

    public boolean isSub() {
        return this.getAccntLevel() == 1;
    }

    public final SimpleBooleanProperty canModifyProperty() {
        return this.canModify;
    }

    public final boolean isCanModify() {
        return this.canModifyProperty().get();
    }

    public final void setCanModify(boolean canModify) {
        this.canModifyProperty().set(canModify);
    }

    public final LongProperty orderAvailableQuantityProperty() {
        return this.orderAvailableQuantity;
    }

    public final long getOrderAvailableQuantity() {
        return this.orderAvailableQuantityProperty().get();
    }

    public final void setOrderAvailableQuantity(long orderAvailableQuantity) {
        this.orderAvailableQuantityProperty().set(orderAvailableQuantity);
    }

    public int getOcFlag() {
        return this.ocFlag;
    }

    public void setOcFlag(int ocFlag) {
        this.ocFlag = ocFlag;
    }

    public int getShFlag() {
        return this.shFlag;
    }

    public void setShFlag(int shFlag) {
        this.shFlag = shFlag;
    }

    public DoubleProperty protectedLimitPriceProperty() {
        return this.protectedLimitPrice;
    }

    public double getProtectedLimitPrice() {
        return this.protectedLimitPriceProperty().get();
    }

    public void setProtectedLimitPrice(double protectedLimitPrice) {
        this.protectedLimitPriceProperty().set(protectedLimitPrice);
    }

    public boolean isStar() {
        return this.isStar;
    }

    public void setStar(boolean isStar) {
        this.isStar = isStar;
    }

    public StringProperty clInstructionIdProperty() {
        return this.clInstructionId;
    }

    public String getClInstructionId() {
        return (String)this.clInstructionIdProperty().get();
    }

    public void setClInstructionId(String clInstructionId) {
        this.clInstructionIdProperty().set((Object)clInstructionId);
    }

    public List<String> getTraderUsers() {
        return this.traderUserIds;
    }

    public void setTraderUserIds(List<String> traderUserIds) {
        this.traderUserIds = traderUserIds;
    }

    public final double getAmount() {
        return this.amount;
    }

    public final void setAmount(double amount) {
        this.amount = amount;
    }

    public String getInsExpiredDate() {
        return this.insExpiredDate;
    }

    public void setInsExpiredDate(String insExpiredDate) {
        this.insExpiredDate = insExpiredDate;
    }

    public String getSubSecType() {
        return this.subSecType;
    }

    public void setSubSecType(String subSecType) {
        this.subSecType = subSecType;
    }

    public static enum MarketPriceLimit {
        SH1("SH1", 1),
        SH2("SH2", 2),
        SH3("SH3", 8),
        SH4("SH4", 9),
        SZ1("SZ1", 3),
        SZ2("SZ2", 4),
        SZ3("SZ3", 5),
        SZ4("SZ4", 6),
        SZ5("SZ5", 7);

        private String raw;
        private Integer pbCode;

        private MarketPriceLimit(String raw, Integer pbCode) {
            this.raw = raw;
            this.pbCode = pbCode;
        }

        public static MarketPriceLimit getPriceLimitByRaw(String raw) {
            MarketPriceLimit[] marketPriceLimitArray = MarketPriceLimit.values();
            int n = marketPriceLimitArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarketPriceLimit priceLimit = marketPriceLimitArray[n2];
                if (priceLimit.raw.equals(raw)) {
                    return priceLimit;
                }
                ++n2;
            }
            return null;
        }

        public static MarketPriceLimit getPriceLimitByPbCode(Integer pbCode) {
            MarketPriceLimit[] marketPriceLimitArray = MarketPriceLimit.values();
            int n = marketPriceLimitArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarketPriceLimit priceLimit = marketPriceLimitArray[n2];
                if (priceLimit.pbCode == pbCode) {
                    return priceLimit;
                }
                ++n2;
            }
            return null;
        }
    }
}

