/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.define.BsDict;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.strategy.dto.Attachment;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSimpleInstruction
extends MxSelObj {
    private SimpleStringProperty id = new SimpleStringProperty("");
    private SimpleStringProperty securityCode = new SimpleStringProperty("");
    private SimpleStringProperty securityName = new SimpleStringProperty("");
    private SimpleStringProperty portfolioId = new SimpleStringProperty("");
    private SimpleStringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty typeName = new SimpleStringProperty("");
    private StringProperty statusName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private StringProperty securitySubType = new SimpleStringProperty("");
    private SimpleStringProperty tradeDate = new SimpleStringProperty("");
    private StringProperty insStatus = new SimpleStringProperty("");
    private StringProperty errInfo = new SimpleStringProperty("");
    private SimpleStringProperty sideName = new SimpleStringProperty("");
    private SimpleStringProperty marketIndicate = new SimpleStringProperty("");
    private SimpleDetail orderDetail = null;
    private SimpleStringProperty firstOne = new SimpleStringProperty("");
    private DoubleProperty cumAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty cumQty = new SimpleDoubleProperty(0.0);
    private StringProperty leavesAmt = new SimpleStringProperty("");
    private LongProperty availOrderQty = new SimpleLongProperty(0L);
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private StringProperty clInstructionId = new SimpleStringProperty("");
    private StringProperty marketGrp = new SimpleStringProperty("");
    private SimpleStringProperty operators = new SimpleStringProperty("");
    private SimpleStringProperty name = new SimpleStringProperty("");
    private SimpleStringProperty productId = new SimpleStringProperty("");
    private SimpleStringProperty productName = new SimpleStringProperty("");
    private SimpleStringProperty flowAttriId = new SimpleStringProperty("");
    private SimpleStringProperty entryId = new SimpleStringProperty("");
    private SimpleStringProperty beginTime = new SimpleStringProperty("");
    private SimpleStringProperty endTime = new SimpleStringProperty("");
    private SimpleStringProperty lastCaller = new SimpleStringProperty("");
    private SimpleStringProperty belongTo = new SimpleStringProperty("");
    private SimpleStringProperty orderObj = new SimpleStringProperty("");
    private SimpleStringProperty insPriceStr = new SimpleStringProperty("");
    private SimpleStringProperty levelInfo = new SimpleStringProperty("");
    private SimpleStringProperty transferMethod = new SimpleStringProperty("");
    private SimpleStringProperty secId = new SimpleStringProperty("");
    private SimpleBooleanProperty isOrderStep = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty isApproveStep = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty finished = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty workFlowDone = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty tradeDone = new SimpleBooleanProperty(false);
    private SimpleDoubleProperty ratio = new SimpleDoubleProperty(0.0);
    private SimpleDoubleProperty insPrice = new SimpleDoubleProperty(0.0);
    private SimpleDoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private SimpleLongProperty totalExpectationQty = new SimpleLongProperty(0L);
    private SimpleObjectProperty<MxNode> tif = new SimpleObjectProperty();
    private String type = "";
    private String status = "";
    private String secType = "";
    private String secMarket = "";
    private String side = "";
    private List<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>();
    private List<WorkflowAttachment> attachments = new ArrayList<WorkflowAttachment>();
    private Attachment attachment;
    private List<ExecJob> jobs = new ArrayList<ExecJob>();
    private String expireDate;
    private String beginDate;
    private boolean canCancel = false;
    private static final Gson gson = new Gson();
    public static final String TYPE = "type.googleapis.com/proto.instruction.SimpleDetail";

    public ObSimpleInstruction() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.setMarket(node);
        node = MxNodeFactory.create((String)"tif_undefined_str", (String)"");
        this.setTif(node);
    }

    public void update(Object obj) {
        if (obj instanceof ObSimpleInstruction) {
            this.update((ObSimpleInstruction)((Object)ObSimpleInstruction.class.cast(obj)));
        } else if (obj instanceof Instruction) {
            Instruction ins = (Instruction)Instruction.class.cast(obj);
            this.update(ins);
        } else if (obj instanceof HttpInsPushMessage) {
            HttpInsPushMessage push = (HttpInsPushMessage)HttpInsPushMessage.class.cast(obj);
            this.update(push);
        }
    }

    private void update(HttpInsPushMessage push) {
        this.setJobs(push.getJob());
    }

    private void update(ObSimpleInstruction ins) {
        this.setId(ins.getId());
        this.setName(ins.getName());
        this.setType(ins.getType());
        this.setTypeName(ins.getTypeName());
        this.setStatus(ins.getStatus());
        this.setFlowAttriId(ins.getFlowAttriId());
        this.setPortfolioId(ins.getPortfolioId());
        this.setPortfolioName(ins.getPortfolioName());
        this.setEntryId(ins.getEntryId());
        this.setProductName(ins.getProductName());
        this.setProductId(ins.getProductId());
        this.setWorkflowTasks(ins.getWorkflowTasks());
        this.setTradeDate(ins.getTradeDate());
        this.setSide(ins.getSide());
        this.setErrInfo(ins.getErrInfo());
        this.setSideName(ins.getSideName());
        this.setStatusName(ins.getStatusName());
        this.setOperators(ins.getOperators());
        this.setSecurityCode(ins.getSecurityCode());
        this.setSecurityName(ins.getSecurityName());
        this.setIsApproveStep(ins.isIsApproveStep());
        this.setIsOrderStep(ins.getIsOrderStep());
        this.setWorkFlowDone(ins.isWorkFlowDone());
        this.setFinished(ins.isFinished());
        this.setMarketGrp(ins.getMarketGrp());
        this.setFirstOne(ins.getFirstOne());
        this.setCumAmount(ins.getCumAmount());
        this.setAvgPx(ins.getAvgPx());
        this.setTradeDone(ins.isTradeDone());
        this.setClInstructionId(ins.getClInstructionId());
        this.setLeavesAmt(ins.getLeavesAmt());
        this.setAvailOrderQty(ins.getAvailOrderQty());
        this.setAttachments(ins.getAttachments());
        this.setCanCancel(ins.isCanCancel());
        this.setBeginTime(ins.getBeginTime());
        this.setEndTime(ins.getEndTime());
        this.setLastCaller(ins.getLastCaller());
        this.setBelongTo(ins.getBelongTo());
        this.setRatio(ins.getRatio());
        this.setOrderObj(ins.getOrderObj());
        this.setTotalExpectationQty(ins.getTotalExpectationQty());
        this.setInsPrice(ins.getInsPrice());
        this.setInsPriceStr(ins.getInsPriceStr());
        this.setOrderAmount(ins.getOrderAmount());
        this.setLevelInfo(ins.getLevelInfo());
        this.setTransferMethod(ins.getTransferMethod());
        this.setJobs(ins.getJobs());
        this.setSecMarket(ins.getSecMarket());
        this.setMarket(ins.getMarket());
        this.setSecuritySubType(ins.getSecuritySubType());
        this.setExpireDate(ins.getExpireDate());
        this.setBeginDate(ins.getBeginDate());
        this.setSecId(ins.getSecId());
        this.setMarketIndicate(ins.getMarketIndicate());
        this.setCumQty(ins.getCumQty());
    }

    private void update(Instruction<?> ins) {
        LinkedTreeMap map;
        this.setId(ins.getId());
        this.setEntryId(ins.getEntryId());
        this.setOperators(ins.getCreatorName());
        if (ins.getDetail() instanceof LinkedTreeMap && TYPE.equals((map = (LinkedTreeMap)LinkedTreeMap.class.cast(ins.getDetail())).get((Object)"@type"))) {
            this.updateNeeqDetail(ins);
        }
        this.setId(ins.getId());
        this.setName(ins.getName());
        this.setType(ins.getType());
        this.setTypeName((String)BsDict.NEW_INSTRUCTION_TYPE_MAP.get(ins.getType()));
        this.setStatus(ins.getStatus());
        this.setStatusName((String)BsDict.NEW_INSTRUCTION_STATUS_MAP.get(ins.getStatus()));
        this.setFlowAttriId(ins.getFlowAttrId());
        this.setPortfolioId(ins.getPortfolioId());
        this.setPortfolioName(ins.getPortfolioName());
        this.setProductId(ins.getProductId());
        this.setEntryId(ins.getEntryId());
        List job = ins.getJob();
        if (job != null && job.size() > 0) {
            this.setErrInfo(String.valueOf(((ExecJob)job.get(0)).getRiskCheckInfo()) + " " + ((ExecJob)job.get(0)).getErrInfo());
            this.setAvgPx(((ExecJob)job.get(0)).getAvgPx());
            this.setCumAmount(((ExecJob)job.get(0)).getCumQty() * ((ExecJob)job.get(0)).getAvgPx());
            this.setRatio(((ExecJob)job.get(0)).getProgress());
        } else {
            this.setErrInfo("");
        }
        this.setJobs(job);
        this.setBeginTime(ins.getBeginTime());
        this.setEndTime(ins.getEndTime());
        this.setLastCaller(ins.getLastUpdater());
    }

    private void updateNeeqDetail(Instruction ins) {
        int emType;
        JsonElement jeType;
        JsonElement jeTxt;
        SimpleDetail ordDetail = (SimpleDetail)gson.fromJson(gson.toJson(ins.getDetail()), SimpleDetail.class);
        this.setOrderDetail(ordDetail);
        this.setSecurityCode(ordDetail.getInstrument().getSecurityId());
        this.setSecurityName(ordDetail.getInstrument().getSymbol());
        this.setSecType(ordDetail.getInstrument().getSecurityType());
        this.setSecMarket(ordDetail.getInstrument().getMarket());
        this.setMarketGrp(ordDetail.getInstrument().getMarketGroup());
        this.setMarketIndicate(MarketIndicator.getDesc((String)ordDetail.getInstrument().getMarketIndicator()));
        if (this.getMarket() != null) {
            this.getMarket().setRaw(ordDetail.getInstrument().getMarket());
        }
        this.setSecuritySubType(ordDetail.getInstrument().getSecuritySubType());
        this.setSide(ordDetail.getSide().getValue());
        this.setSideName(ordDetail.getSide().getSideName());
        this.setInsPrice(this.orderDetail.getPrice());
        long qty = 0L;
        double orderAmount = 0.0;
        for (AccntSecInfo accSecInfo : ordDetail.getAccntSecInfo()) {
            qty = (long)((double)qty + accSecInfo.getOrderQty());
            orderAmount += accSecInfo.getOrderAmount();
        }
        this.setTotalExpectationQty(qty);
        this.setOrderAmount(orderAmount);
        if (ordDetail.getTif() != null) {
            this.getTif().setRaw(String.valueOf(ordDetail.getTif().getValue()));
        }
        if (ins.getText() != null && ordDetail.getAttachment() != null && (jeTxt = new JsonParser().parse(ins.getText())).isJsonObject() && (jeType = jeTxt.getAsJsonObject().get("emType")) != null && jeType.isJsonPrimitive() && (emType = jeType.getAsJsonPrimitive().getAsInt()) == 3) {
            Attachment attachment = (Attachment)gson.fromJson(ordDetail.getAttachment(), Attachment.class);
            this.setAttachment(attachment);
        }
    }

    public void fillTask(List<WorkflowTask> list) {
        if (list == null) {
            return;
        }
        this.getWorkflowTasks().addAll(list);
        for (WorkflowTask workflowTask : list) {
            this.operators.set(String.valueOf(this.operators.get()) + workflowTask.getPermissibleList());
        }
    }

    public SimpleStringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return this.idProperty().get();
    }

    public void setId(String id) {
        this.idProperty().set(id);
    }

    public StringProperty operatorsProperty() {
        return this.operators;
    }

    public String getOperators() {
        return (String)this.operatorsProperty().get();
    }

    public void setOperators(String operators) {
        this.operatorsProperty().set((Object)operators);
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set(name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : this.id.get().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObSimpleInstruction other = (ObSimpleInstruction)((Object)obj);
        return !(this.id.get() == null ? other.id.get() != null : !this.id.get().equals(other.id.get()));
    }

    public SimpleStringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public String getPortfolioId() {
        return this.portfolioIdProperty().get();
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set(portfolioId);
    }

    public SimpleBooleanProperty isOrderStepProperty() {
        return this.isOrderStep;
    }

    public boolean getIsOrderStep() {
        return this.isOrderStepProperty().get();
    }

    public void setIsOrderStep(boolean isOrderStep) {
        this.isOrderStepProperty().set(isOrderStep);
    }

    public SimpleBooleanProperty finishedProperty() {
        return this.finished;
    }

    public boolean isFinished() {
        return this.finishedProperty().get();
    }

    public void setFinished(boolean finished) {
        this.finishedProperty().set(finished);
    }

    public SimpleStringProperty flowAttriIdProperty() {
        return this.flowAttriId;
    }

    public String getFlowAttriId() {
        return this.flowAttriIdProperty().get();
    }

    public void setFlowAttriId(String flowAttriId) {
        this.flowAttriIdProperty().set(flowAttriId);
    }

    public SimpleStringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set(portfolioName);
    }

    public SimpleStringProperty productNameProperty() {
        return this.productName;
    }

    public String getProductName() {
        return this.productNameProperty().get();
    }

    public void setProductName(String productName) {
        this.productNameProperty().set(productName);
    }

    public StringProperty marketGrpProperty() {
        return this.marketGrp;
    }

    public String getMarketGrp() {
        return (String)this.marketGrpProperty().get();
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrpProperty().set((Object)marketGrp);
    }

    public SimpleBooleanProperty isApproveStepProperty() {
        return this.isApproveStep;
    }

    public boolean isIsApproveStep() {
        return this.isApproveStepProperty().get();
    }

    public void setIsApproveStep(boolean isApproveStep) {
        this.isApproveStepProperty().set(isApproveStep);
    }

    public SimpleBooleanProperty workFlowDoneProperty() {
        return this.workFlowDone;
    }

    public boolean isWorkFlowDone() {
        return this.workFlowDoneProperty().get();
    }

    public void setWorkFlowDone(boolean workFlowDone) {
        this.workFlowDoneProperty().set(workFlowDone);
    }

    public SimpleStringProperty firstOneProperty() {
        return this.firstOne;
    }

    public String getFirstOne() {
        return this.firstOneProperty().get();
    }

    public void setFirstOne(String firstOne) {
        this.firstOneProperty().set(firstOne);
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public final StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public final String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    public DoubleProperty cumAmountProperty() {
        return this.cumAmount;
    }

    public double getCumAmount() {
        return this.cumAmountProperty().get();
    }

    public void setCumAmount(double cumAmount) {
        this.cumAmountProperty().set(cumAmount);
    }

    public DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
    }

    public SimpleBooleanProperty tradeDoneProperty() {
        return this.tradeDone;
    }

    public boolean isTradeDone() {
        return this.tradeDoneProperty().get();
    }

    public void setTradeDone(boolean tradeDone) {
        this.tradeDoneProperty().set(tradeDone);
    }

    public StringProperty clInstructionIdProperty() {
        return this.clInstructionId;
    }

    public String getClInstructionId() {
        return (String)this.clInstructionIdProperty().get();
    }

    public void setClInstructionId(String clInstructionId) {
        this.clInstructionIdProperty().set((Object)clInstructionId);
    }

    public LongProperty availOrderQtyProperty() {
        return this.availOrderQty;
    }

    public long getAvailOrderQty() {
        return this.availOrderQtyProperty().get();
    }

    public void setAvailOrderQty(long availOrderQty) {
        this.availOrderQtyProperty().set(availOrderQty);
    }

    public StringProperty leavesAmtProperty() {
        return this.leavesAmt;
    }

    public String getLeavesAmt() {
        return (String)this.leavesAmtProperty().get();
    }

    public void setLeavesAmt(String leavesAmt) {
        this.leavesAmtProperty().set((Object)leavesAmt);
    }

    public SimpleStringProperty entryIdProperty() {
        return this.entryId;
    }

    public String getEntryId() {
        return this.entryIdProperty().get();
    }

    public void setEntryId(String entryId) {
        this.entryIdProperty().set(entryId);
    }

    public List<WorkflowTask> getWorkflowTasks() {
        return this.workflowTasks;
    }

    public void setWorkflowTasks(List<WorkflowTask> workflowTasks) {
        this.workflowTasks = workflowTasks;
    }

    public SimpleStringProperty securityCodeProperty() {
        return this.securityCode;
    }

    public String getSecurityCode() {
        return this.securityCodeProperty().get();
    }

    public void setSecurityCode(String securityCode) {
        this.securityCodeProperty().set(securityCode);
    }

    public SimpleStringProperty securityNameProperty() {
        return this.securityName;
    }

    public String getSecurityName() {
        return this.securityNameProperty().get();
    }

    public void setSecurityName(String securityName) {
        this.securityNameProperty().set(securityName);
    }

    public SimpleStringProperty tradeDateProperty() {
        return this.tradeDate;
    }

    public String getTradeDate() {
        return this.tradeDateProperty().get();
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDateProperty().set(tradeDate);
    }

    public StringProperty insStatusProperty() {
        return this.insStatus;
    }

    public String getInsStatus() {
        return (String)this.insStatusProperty().get();
    }

    public void setInsStatus(String insStatus) {
        this.insStatusProperty().set((Object)insStatus);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public StringProperty typeNameProperty() {
        return this.typeName;
    }

    public String getTypeName() {
        return (String)this.typeNameProperty().get();
    }

    public void setTypeName(String typeName) {
        this.typeNameProperty().set((Object)typeName);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public StringProperty statusNameProperty() {
        return this.statusName;
    }

    public String getStatusName() {
        return (String)this.statusNameProperty().get();
    }

    public void setStatusName(String statusName) {
        this.statusNameProperty().set((Object)statusName);
    }

    public SimpleStringProperty sideNameProperty() {
        return this.sideName;
    }

    public String getSideName() {
        return this.sideNameProperty().get();
    }

    public void setSideName(String sideName) {
        this.sideNameProperty().set(sideName);
    }

    public List<WorkflowAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<WorkflowAttachment> attachments) {
        this.attachments = attachments;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public String getSecMarket() {
        return this.secMarket;
    }

    public void setSecMarket(String secMarket) {
        this.secMarket = secMarket;
    }

    public StringProperty beginTimeProperty() {
        return this.beginTime;
    }

    public String getBeginTime() {
        return (String)this.beginTimeProperty().get();
    }

    public void setBeginTime(String beginTime) {
        this.beginTimeProperty().set((Object)beginTime);
    }

    public StringProperty endTimeProperty() {
        return this.endTime;
    }

    public String getEndTime() {
        return (String)this.endTimeProperty().get();
    }

    public void setEndTime(String endTime) {
        this.endTimeProperty().set((Object)endTime);
    }

    public StringProperty lastCallerProperty() {
        return this.lastCaller;
    }

    public String getLastCaller() {
        return (String)this.lastCallerProperty().get();
    }

    public void setLastCaller(String lastCaller) {
        this.lastCallerProperty().set((Object)lastCaller);
    }

    public StringProperty belongToProperty() {
        return this.belongTo;
    }

    public String getBelongTo() {
        return (String)this.belongToProperty().get();
    }

    public void setBelongTo(String belongTo) {
        this.belongToProperty().set((Object)belongTo);
    }

    public DoubleProperty ratioProperty() {
        return this.ratio;
    }

    public double getRatio() {
        return this.ratioProperty().get();
    }

    public void setRatio(double ratio) {
        this.ratioProperty().set(ratio);
    }

    public StringProperty orderObjProperty() {
        return this.orderObj;
    }

    public String getOrderObj() {
        return (String)this.orderObjProperty().get();
    }

    public void setOrderObj(String orderObj) {
        this.orderObjProperty().set((Object)orderObj);
    }

    public LongProperty totalExpectationQtyProperty() {
        return this.totalExpectationQty;
    }

    public long getTotalExpectationQty() {
        return this.totalExpectationQtyProperty().get();
    }

    public void setTotalExpectationQty(long totalExpectationQty) {
        this.totalExpectationQtyProperty().set(totalExpectationQty);
    }

    public DoubleProperty insPriceProperty() {
        return this.insPrice;
    }

    public double getInsPrice() {
        return this.insPriceProperty().get();
    }

    public void setInsPrice(double insPrice) {
        this.insPriceProperty().set(insPrice);
    }

    public DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public SimpleDetail getOrderDetail() {
        return this.orderDetail;
    }

    public void setOrderDetail(SimpleDetail orderDetail) {
        this.orderDetail = orderDetail;
    }

    public StringProperty levelInfoProperty() {
        return this.levelInfo;
    }

    public String getLevelInfo() {
        return (String)this.levelInfoProperty().get();
    }

    public void setLevelInfo(String levelInfo) {
        this.levelInfoProperty().set((Object)levelInfo);
    }

    public StringProperty transferMethodProperty() {
        return this.transferMethod;
    }

    public String getTransferMethod() {
        return (String)this.transferMethodProperty().get();
    }

    public void setTransferMethod(String transferMethod) {
        this.transferMethodProperty().set((Object)transferMethod);
    }

    public List<ExecJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<ExecJob> jobs) {
        this.jobs = jobs;
    }

    public SimpleStringProperty productIdProperty() {
        return this.productId;
    }

    public String getProductId() {
        return this.productIdProperty().get();
    }

    public void setProductId(String productId) {
        this.productIdProperty().set(productId);
    }

    public StringProperty insPriceStrProperty() {
        return this.insPriceStr;
    }

    public String getInsPriceStr() {
        return (String)this.insPriceStrProperty().get();
    }

    public void setInsPriceStr(String insPriceStr) {
        this.insPriceStrProperty().set((Object)insPriceStr);
    }

    public final StringProperty securitySubTypeProperty() {
        return this.securitySubType;
    }

    public final String getSecuritySubType() {
        return (String)this.securitySubTypeProperty().get();
    }

    public final void setSecuritySubType(String securitySubType) {
        this.securitySubTypeProperty().set((Object)securitySubType);
    }

    public final ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public final MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public final void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public String getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public final StringProperty secIdProperty() {
        return this.secId;
    }

    public final String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public final void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public final DoubleProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final double getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(double cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final ObjectProperty<MxNode> tifProperty() {
        return this.tif;
    }

    public final MxNode getTif() {
        return (MxNode)this.tifProperty().get();
    }

    public final void setTif(MxNode tif) {
        this.tifProperty().set((Object)tif);
    }

    public final SimpleStringProperty marketIndicateProperty() {
        return this.marketIndicate;
    }

    public final String getMarketIndicate() {
        return this.marketIndicateProperty().get();
    }

    public final void setMarketIndicate(String marketIndicate) {
        this.marketIndicateProperty().set(marketIndicate);
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }
}

