/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.define.BsDict;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.OtcOrderDetail;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObInstruction
extends MxSelObj {
    private SimpleStringProperty id = new SimpleStringProperty("");
    private SimpleStringProperty portfolioId = new SimpleStringProperty("");
    private SimpleStringProperty portfolioName = new SimpleStringProperty("");
    private String type = "";
    private StringProperty typeName = new SimpleStringProperty("");
    private String status = "";
    private StringProperty statusName = new SimpleStringProperty("");
    private SimpleStringProperty securityCode = new SimpleStringProperty("");
    private SimpleStringProperty securityName = new SimpleStringProperty("");
    private String secType = "";
    private String secMarket = "";
    private String underlyingSecType;
    private String underlyingSecMarket;
    private SimpleStringProperty underlyingSecurityCode = new SimpleStringProperty("");
    private SimpleStringProperty underlyingSecurityName = new SimpleStringProperty("");
    private SimpleStringProperty tradeDate = new SimpleStringProperty("");
    private String side = "";
    private SimpleStringProperty sideName = new SimpleStringProperty("");
    private DoubleProperty subscribeAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty redeemQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty transFerQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty provistonQty = new SimpleDoubleProperty(0.0);
    private StringProperty redeemDate = new SimpleStringProperty("");
    private String bonusType = "";
    private StringProperty bonusTypeName = new SimpleStringProperty("");
    private DoubleProperty bonusAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty bonusQty = new SimpleDoubleProperty(0.0);
    private StringProperty insStatus = new SimpleStringProperty("");
    private StringProperty errInfo = new SimpleStringProperty("");
    private OtcOrderDetail otcOrderDetail = null;
    private List<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>();
    private StringProperty operators = new SimpleStringProperty("");
    private SimpleStringProperty name = new SimpleStringProperty("");
    private SimpleStringProperty productName = new SimpleStringProperty("");
    private SimpleStringProperty flowAttriId = new SimpleStringProperty("");
    private SimpleBooleanProperty isOrderStep = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty isApproveStep = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty finished = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty workFlowDone = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty tradeDone = new SimpleBooleanProperty(false);
    private SimpleStringProperty entryId = new SimpleStringProperty("");
    private SimpleStringProperty lastOne = new SimpleStringProperty("");
    private SimpleStringProperty firstOne = new SimpleStringProperty("");
    private StringProperty marketGrp = new SimpleStringProperty("");
    private DoubleProperty cumAmount = new SimpleDoubleProperty(0.0);
    private StringProperty leavesAmt = new SimpleStringProperty("");
    private LongProperty availOrderQty = new SimpleLongProperty(0L);
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private StringProperty clInstructionId = new SimpleStringProperty("");
    private List<WorkflowAttachment> attachments = new ArrayList<WorkflowAttachment>();
    private String marginAttachment;
    private String postil = "";
    private boolean exeManualSelected = false;
    private boolean apprManualSelected = false;
    private boolean canCancel = false;
    private boolean canCancelOrder = false;
    private static final Gson gson = new Gson();
    private StringProperty beginTime = new SimpleStringProperty("");
    private StringProperty endTime = new SimpleStringProperty("");
    private StringProperty lastCaller = new SimpleStringProperty("");
    private List<ExecJob> jobs = new ArrayList<ExecJob>();
    private StringProperty tradePlatform = new SimpleStringProperty("");
    private String counterId;
    private StringProperty belongTo = new SimpleStringProperty("");
    private DoubleProperty totalExpectationQty = new SimpleDoubleProperty(0.0);
    private StringProperty insPriceStr = new SimpleStringProperty("");
    private DoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty ratio = new SimpleDoubleProperty(0.0);
    private DoubleProperty orderRatio = new SimpleDoubleProperty(0.0);
    private StringProperty expireDate = new SimpleStringProperty("");
    private MxNode market;
    private StringProperty levelInfo = new SimpleStringProperty("");
    private StringProperty transferMethod = new SimpleStringProperty("");
    private SimpleDetail orderDetail = null;
    private String productId = "";
    private boolean todo = false;
    private String marketIndicate = "";

    public ObInstruction() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.setMarket(node);
    }

    public void update(Object obj) {
        if (obj instanceof ObInstruction) {
            this.update((ObInstruction)((Object)ObInstruction.class.cast(obj)));
        } else if (obj instanceof Instruction) {
            Instruction ins = (Instruction)Instruction.class.cast(obj);
            this.update(ins);
        }
    }

    private void update(ObInstruction ins) {
        this.setId(ins.getId());
        this.setName(ins.getName());
        this.setType(ins.getType());
        this.setTypeName(ins.getTypeName());
        this.setStatus(ins.getStatus());
        this.setFlowAttriId(ins.getFlowAttriId());
        this.setPortfolioId(ins.getPortfolioId());
        this.setPortfolioName(ins.getPortfolioName());
        this.setEntryId(ins.getEntryId());
        this.setProductName(ins.getProductName());
        this.setWorkflowTasks(ins.getWorkflowTasks());
        this.setTradeDate(ins.getTradeDate());
        this.setSide(ins.getSide());
        this.setSubscribeAmt(ins.getSubscribeAmt());
        this.setRedeemQty(ins.getRedeemQty());
        this.setTransFerQty(ins.getTransFerQty());
        this.setRedeemDate(ins.getRedeemDate());
        this.setBonusType(ins.getBonusType());
        this.setBonusAmt(ins.getBonusAmt());
        this.setBonusQty(ins.getBonusQty());
        this.setProvistonQty(ins.getProvistonQty());
        this.setTransFerQty(ins.getTransFerQty());
        this.setErrInfo(ins.getErrInfo());
        this.setSideName(ins.getSideName());
        this.setStatusName(ins.getStatusName());
        this.setBonusTypeName(ins.getBonusTypeName());
        this.setOperators(ins.getOperators());
        this.setIsApproveStep(ins.isIsApproveStep());
        this.setIsOrderStep(ins.getIsOrderStep());
        this.setWorkFlowDone(ins.isWorkFlowDone());
        this.setFinished(ins.isFinished());
        this.setMarketGrp(ins.getMarketGrp());
        this.setLastOne(ins.getLastOne());
        this.setFirstOne(ins.getFirstOne());
        this.setCumAmount(ins.getCumAmount());
        this.setAvgPx(ins.getAvgPx());
        this.setTradeDone(ins.isTradeDone());
        this.setClInstructionId(ins.getClInstructionId());
        this.setLeavesAmt(ins.getLeavesAmt());
        this.setAvailOrderQty(ins.getAvailOrderQty());
        this.setPostil(ins.getPostil());
        this.setAttachments(ins.getAttachments());
        this.setCanCancel(ins.isCanCancel());
        this.setCanCancelOrder(ins.isCanCancelOrder());
        this.setBeginTime(ins.getBeginTime());
        this.setEndTime(ins.getEndTime());
        this.setLastCaller(ins.getLastCaller());
        this.setJobs(ins.getJobs());
        this.setTradePlatform(ins.getTradePlatform());
        this.setCounterId(ins.getCounterId());
        this.setBelongTo(ins.getBelongTo());
        this.setTotalExpectationQty(ins.getTotalExpectationQty());
        this.setInsPriceStr(ins.getInsPriceStr());
        this.setOrderAmount(ins.getOrderAmount());
        this.setRatio(ins.getRatio());
        this.setOrderRatio(ins.getOrderRatio());
        this.setExpireDate(ins.getExpireDate());
        this.setOrderDetail(ins.getOrderDetail());
        this.setSecurityCode(ins.getSecurityCode());
        this.setSecurityName(ins.getSecurityName());
        this.setSecType(ins.getSecType());
        this.setSecMarket(ins.getSecMarket());
        this.setMarket(ins.getMarket());
        this.setTodo(ins.isTodo());
        this.setMarketIndicate(ins.getMarketIndicate());
    }

    private void update(Instruction ins) {
        block34: {
            LinkedTreeMap map;
            block35: {
                this.setId(ins.getId());
                this.setEntryId(ins.getEntryId());
                this.setOperators(ins.getCreatorName());
                if (!(ins.getDetail() instanceof LinkedTreeMap)) break block34;
                map = (LinkedTreeMap)LinkedTreeMap.class.cast(ins.getDetail());
                if (!"FundDetail".equals(ins.getType())) break block35;
                OtcOrderDetail ordDetail = (OtcOrderDetail)gson.fromJson(gson.toJson(ins.getDetail()), OtcOrderDetail.class);
                this.setOtcOrderDetail(ordDetail);
                this.setSecurityCode(ordDetail.getInstrument().getSecurityId());
                this.setSecurityName(ordDetail.getInstrument().getSymbol());
                this.setSecType(ordDetail.getInstrument().getSecurityType());
                this.setSecMarket(ordDetail.getInstrument().getMarket());
                if (this.getMarket() != null) {
                    this.getMarket().setRaw(ordDetail.getInstrument().getMarket());
                }
                if (ordDetail.getUnderlying() != null) {
                    this.setUnderlyingSecurityCode(ordDetail.getUnderlying().getSecurityId());
                    this.setUnderlyingSecMarket(ordDetail.getUnderlying().getMarket());
                    this.setUnderlyingSecType(ordDetail.getUnderlying().getSecurityType());
                    this.setUnderlyingSecurityName(ordDetail.getUnderlying().getSymbol());
                }
                this.setSide(ordDetail.getSide());
                this.setSideName((String)BsDict.NEW_INSTRUCTION_SIDE_MAP.get(ordDetail.getSide()));
                this.setTradeDate(ordDetail.getTradeDate());
                switch (ordDetail.getSide()) {
                    case "SIDE_CASH_DIVIDEND": {
                        this.setBonusType("0");
                        this.setBonusAmt(ordDetail.getOrderAmount());
                        this.setBonusTypeName((String)BsDict.BONUS_TYPE_MAP.get("0"));
                        break;
                    }
                    case "SIDE_DIVIDEND_REINVEST": {
                        this.setBonusType("1");
                        this.setBonusQty(ordDetail.getOrderQty());
                        this.setBonusTypeName((String)BsDict.BONUS_TYPE_MAP.get("1"));
                        break;
                    }
                    case "SIDE_CREATION": 
                    case "SIDE_SUBSCRIBE": {
                        this.setSubscribeAmt(ordDetail.getOrderAmount());
                        this.setRedeemDate(ordDetail.getContractExpireDate());
                        break;
                    }
                    case "SIDE_REDEEM": {
                        this.setRedeemQty(ordDetail.getOrderQty());
                        break;
                    }
                    case "SIDE_TRANSFER": {
                        this.setTransFerQty(ordDetail.getOrderQty());
                    }
                    case "SIDE_PROVISTON": {
                        this.setProvistonQty(ordDetail.getOrderQty());
                    }
                }
                try {
                    this.setAttachments(Arrays.asList((WorkflowAttachment[])gson.fromJson(ordDetail.getAttachment(), WorkflowAttachment[].class)));
                }
                catch (Exception exception) {}
                break block34;
            }
            if ("SimpleDetail".equals(ins.getType()) && "type.googleapis.com/proto.instruction.SimpleDetail".equals(map.get((Object)"@type"))) {
                this.updateNeeqDetail(ins);
            }
        }
        this.setId(ins.getId());
        this.setName(ins.getName());
        this.setType(ins.getType());
        this.setTypeName((String)BsDict.NEW_INSTRUCTION_TYPE_MAP.get(ins.getType()));
        this.setStatus(ins.getStatus());
        this.setStatusName((String)BsDict.NEW_INSTRUCTION_STATUS_MAP.get(ins.getStatus()));
        this.setFlowAttriId(ins.getFlowAttrId());
        this.setPortfolioId(ins.getPortfolioId());
        this.setPortfolioName(ins.getPortfolioName());
        this.setEntryId(ins.getEntryId());
        this.setProductId(ins.getProductId());
        this.setBelongTo(ins.getPortfolioName());
        this.setExpireDate("0".equals(ins.getExpireDate()) ? "" : ins.getExpireDate());
        List job = ins.getJob();
        if (job != null && job.size() > 0) {
            this.setErrInfo(String.valueOf(((ExecJob)job.get(0)).getRiskCheckInfo()) + " " + ((ExecJob)job.get(0)).getErrInfo());
            this.setTotalExpectationQty((double)Math.round(((ExecJob)job.get(0)).getTargetQty() * 100.0) / 100.0);
            this.setOrderAmount(((ExecJob)job.get(0)).getTargetAmount());
            if (0.0 != ((ExecJob)job.get(0)).getTargetQty()) {
                this.setOrderRatio((double)Math.round(((ExecJob)job.get(0)).getOrderQty() / ((ExecJob)job.get(0)).getTargetQty() * 10000.0) / 100.0);
            }
            this.setRatio(((ExecJob)job.get(0)).getProgress());
            this.setCumAmount(((ExecJob)job.get(0)).getTradeAmount());
            this.setAvgPx(((ExecJob)job.get(0)).getAvgPx());
            this.setMarketGrp(((ExecJob)job.get(0)).getMarketGroup());
            if ("kStatusExecuting".equals(ins.getStatus()) && ((ExecJob)job.get(0)).getStatus() == 6) {
                this.setStatusName("\u6b63\u62a5");
                this.setCanCancelOrder(false);
            } else {
                this.setCanCancelOrder(true);
            }
            this.setJobs(job);
        } else {
            this.setErrInfo("");
        }
        this.setBeginTime(ins.getBeginTime());
        this.setEndTime(ins.getEndTime());
        this.setLastCaller(ins.getLastUpdater());
    }

    private void updateNeeqDetail(Instruction ins) {
        SimpleDetail ordDetail = (SimpleDetail)gson.fromJson(gson.toJson(ins.getDetail()), SimpleDetail.class);
        this.setOrderDetail(ordDetail);
        this.setSecurityCode(ordDetail.getInstrument().getSecurityId());
        this.setSecurityName(ordDetail.getInstrument().getSymbol());
        this.setSecType(ordDetail.getInstrument().getSecurityType());
        this.setSecMarket(ordDetail.getInstrument().getMarket());
        this.setMarketIndicate(MarketIndicator.getDesc((String)ordDetail.getInstrument().getMarketIndicator()));
        if (this.getMarket() != null) {
            this.getMarket().setRaw(ordDetail.getInstrument().getMarket());
        }
        this.setSide(ordDetail.getSide().getValue());
        this.setSideName(ordDetail.getSide().getSideName());
        this.setMarginAttachment(ordDetail.getAttachment());
    }

    public void fillTask(List<WorkflowTask> list) {
        if (list == null) {
            return;
        }
        this.getWorkflowTasks().addAll(list);
    }

    public SimpleStringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return this.idProperty().get();
    }

    public void setId(String id) {
        this.idProperty().set(id);
    }

    public StringProperty operatorsProperty() {
        return this.operators;
    }

    public String getOperators() {
        return (String)this.operatorsProperty().get();
    }

    public void setOperators(String operators) {
        this.operatorsProperty().set((Object)operators);
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set(name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : this.id.get().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObInstruction other = (ObInstruction)((Object)obj);
        return !(this.id.get() == null ? other.id.get() != null : !this.id.get().equals(other.id.get()));
    }

    public SimpleStringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public String getPortfolioId() {
        return this.portfolioIdProperty().get();
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set(portfolioId);
    }

    public SimpleBooleanProperty isOrderStepProperty() {
        return this.isOrderStep;
    }

    public boolean getIsOrderStep() {
        return this.isOrderStepProperty().get();
    }

    public void setIsOrderStep(boolean isOrderStep) {
        this.isOrderStepProperty().set(isOrderStep);
    }

    public SimpleBooleanProperty finishedProperty() {
        return this.finished;
    }

    public boolean isFinished() {
        return this.finishedProperty().get();
    }

    public void setFinished(boolean finished) {
        this.finishedProperty().set(finished);
    }

    public SimpleStringProperty flowAttriIdProperty() {
        return this.flowAttriId;
    }

    public String getFlowAttriId() {
        return this.flowAttriIdProperty().get();
    }

    public void setFlowAttriId(String flowAttriId) {
        this.flowAttriIdProperty().set(flowAttriId);
    }

    public SimpleStringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set(portfolioName);
    }

    public SimpleStringProperty productNameProperty() {
        return this.productName;
    }

    public String getProductName() {
        return this.productNameProperty().get();
    }

    public void setProductName(String productName) {
        this.productNameProperty().set(productName);
    }

    public StringProperty marketGrpProperty() {
        return this.marketGrp;
    }

    public String getMarketGrp() {
        return (String)this.marketGrpProperty().get();
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrpProperty().set((Object)marketGrp);
    }

    public SimpleBooleanProperty isApproveStepProperty() {
        return this.isApproveStep;
    }

    public boolean isIsApproveStep() {
        return this.isApproveStepProperty().get();
    }

    public void setIsApproveStep(boolean isApproveStep) {
        this.isApproveStepProperty().set(isApproveStep);
    }

    public SimpleBooleanProperty workFlowDoneProperty() {
        return this.workFlowDone;
    }

    public boolean isWorkFlowDone() {
        return this.workFlowDoneProperty().get();
    }

    public void setWorkFlowDone(boolean workFlowDone) {
        this.workFlowDoneProperty().set(workFlowDone);
    }

    public SimpleStringProperty lastOneProperty() {
        return this.lastOne;
    }

    public String getLastOne() {
        return this.lastOneProperty().get();
    }

    public void setLastOne(String lastOne) {
        this.lastOneProperty().set(lastOne);
    }

    public SimpleStringProperty firstOneProperty() {
        return this.firstOne;
    }

    public String getFirstOne() {
        return this.firstOneProperty().get();
    }

    public void setFirstOne(String firstOne) {
        this.firstOneProperty().set(firstOne);
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public final StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public final String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    public DoubleProperty cumAmountProperty() {
        return this.cumAmount;
    }

    public double getCumAmount() {
        return this.cumAmountProperty().get();
    }

    public void setCumAmount(double cumAmount) {
        this.cumAmountProperty().set(cumAmount);
    }

    public DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
    }

    public SimpleBooleanProperty tradeDoneProperty() {
        return this.tradeDone;
    }

    public boolean isTradeDone() {
        return this.tradeDoneProperty().get();
    }

    public void setTradeDone(boolean tradeDone) {
        this.tradeDoneProperty().set(tradeDone);
    }

    public boolean isExeManualSelected() {
        return this.exeManualSelected;
    }

    public void setExeManualSelected(boolean exeManualSelected) {
        this.exeManualSelected = exeManualSelected;
    }

    public boolean isApprManualSelected() {
        return this.apprManualSelected;
    }

    public void setApprManualSelected(boolean apprManualSelected) {
        this.apprManualSelected = apprManualSelected;
    }

    public StringProperty clInstructionIdProperty() {
        return this.clInstructionId;
    }

    public String getClInstructionId() {
        return (String)this.clInstructionIdProperty().get();
    }

    public void setClInstructionId(String clInstructionId) {
        this.clInstructionIdProperty().set((Object)clInstructionId);
    }

    public LongProperty availOrderQtyProperty() {
        return this.availOrderQty;
    }

    public long getAvailOrderQty() {
        return this.availOrderQtyProperty().get();
    }

    public void setAvailOrderQty(long availOrderQty) {
        this.availOrderQtyProperty().set(availOrderQty);
    }

    public String getPostil() {
        return this.postil;
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public StringProperty leavesAmtProperty() {
        return this.leavesAmt;
    }

    public String getLeavesAmt() {
        return (String)this.leavesAmtProperty().get();
    }

    public void setLeavesAmt(String leavesAmt) {
        this.leavesAmtProperty().set((Object)leavesAmt);
    }

    public SimpleStringProperty entryIdProperty() {
        return this.entryId;
    }

    public String getEntryId() {
        return this.entryIdProperty().get();
    }

    public void setEntryId(String entryId) {
        this.entryIdProperty().set(entryId);
    }

    public List<WorkflowTask> getWorkflowTasks() {
        return this.workflowTasks;
    }

    public void setWorkflowTasks(List<WorkflowTask> workflowTasks) {
        this.workflowTasks = workflowTasks;
    }

    public SimpleStringProperty securityCodeProperty() {
        return this.securityCode;
    }

    public String getSecurityCode() {
        return this.securityCodeProperty().get();
    }

    public void setSecurityCode(String securityCode) {
        this.securityCodeProperty().set(securityCode);
    }

    public OtcOrderDetail getOtcOrderDetail() {
        return this.otcOrderDetail;
    }

    public void setOtcOrderDetail(OtcOrderDetail otcOrderDetail) {
        this.otcOrderDetail = otcOrderDetail;
    }

    public SimpleStringProperty securityNameProperty() {
        return this.securityName;
    }

    public String getSecurityName() {
        return this.securityNameProperty().get();
    }

    public void setSecurityName(String securityName) {
        this.securityNameProperty().set(securityName);
    }

    public SimpleStringProperty tradeDateProperty() {
        return this.tradeDate;
    }

    public String getTradeDate() {
        return this.tradeDateProperty().get();
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDateProperty().set(tradeDate);
    }

    public DoubleProperty subscribeAmtProperty() {
        return this.subscribeAmt;
    }

    public double getSubscribeAmt() {
        return this.subscribeAmtProperty().get();
    }

    public void setSubscribeAmt(double subscribeAmt) {
        this.subscribeAmtProperty().set(subscribeAmt);
    }

    public DoubleProperty redeemQtyProperty() {
        return this.redeemQty;
    }

    public double getRedeemQty() {
        return this.redeemQtyProperty().get();
    }

    public void setRedeemQty(double redeemQty) {
        this.redeemQtyProperty().set(redeemQty);
    }

    public StringProperty redeemDateProperty() {
        return this.redeemDate;
    }

    public String getRedeemDate() {
        return (String)this.redeemDateProperty().get();
    }

    public void setRedeemDate(String redeemDate) {
        this.redeemDateProperty().set((Object)redeemDate);
    }

    public StringProperty insStatusProperty() {
        return this.insStatus;
    }

    public String getInsStatus() {
        return (String)this.insStatusProperty().get();
    }

    public void setInsStatus(String insStatus) {
        this.insStatusProperty().set((Object)insStatus);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public StringProperty typeNameProperty() {
        return this.typeName;
    }

    public String getTypeName() {
        return (String)this.typeNameProperty().get();
    }

    public void setTypeName(String typeName) {
        this.typeNameProperty().set((Object)typeName);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public StringProperty statusNameProperty() {
        return this.statusName;
    }

    public String getStatusName() {
        return (String)this.statusNameProperty().get();
    }

    public void setStatusName(String statusName) {
        this.statusNameProperty().set((Object)statusName);
    }

    public DoubleProperty bonusAmtProperty() {
        return this.bonusAmt;
    }

    public double getBonusAmt() {
        return this.bonusAmtProperty().get();
    }

    public void setBonusAmt(double bonusAmt) {
        this.bonusAmtProperty().set(bonusAmt);
    }

    public DoubleProperty bonusQtyProperty() {
        return this.bonusQty;
    }

    public double getBonusQty() {
        return this.bonusQtyProperty().get();
    }

    public void setBonusQty(double bonusQty) {
        this.bonusQtyProperty().set(bonusQty);
    }

    public SimpleStringProperty sideNameProperty() {
        return this.sideName;
    }

    public String getSideName() {
        return this.sideNameProperty().get();
    }

    public void setSideName(String sideName) {
        this.sideNameProperty().set(sideName);
    }

    public List<WorkflowAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<WorkflowAttachment> attachments) {
        this.attachments = attachments;
    }

    public String getBonusType() {
        return this.bonusType;
    }

    public void setBonusType(String bonusType) {
        this.bonusType = bonusType;
    }

    public StringProperty bonusTypeNameProperty() {
        return this.bonusTypeName;
    }

    public String getBonusTypeName() {
        return (String)this.bonusTypeNameProperty().get();
    }

    public void setBonusTypeName(String bonusTypeName) {
        this.bonusTypeNameProperty().set((Object)bonusTypeName);
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public String getSecMarket() {
        return this.secMarket;
    }

    public void setSecMarket(String secMarket) {
        this.secMarket = secMarket;
    }

    public StringProperty beginTimeProperty() {
        return this.beginTime;
    }

    public String getBeginTime() {
        return (String)this.beginTimeProperty().get();
    }

    public void setBeginTime(String beginTime) {
        this.beginTimeProperty().set((Object)beginTime);
    }

    public StringProperty endTimeProperty() {
        return this.endTime;
    }

    public String getEndTime() {
        return (String)this.endTimeProperty().get();
    }

    public void setEndTime(String endTime) {
        this.endTimeProperty().set((Object)endTime);
    }

    public StringProperty lastCallerProperty() {
        return this.lastCaller;
    }

    public String getLastCaller() {
        return (String)this.lastCallerProperty().get();
    }

    public void setLastCaller(String lastCaller) {
        this.lastCallerProperty().set((Object)lastCaller);
    }

    public List<ExecJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<ExecJob> jobs) {
        this.jobs = jobs;
    }

    public boolean isCanCancelOrder() {
        return this.canCancelOrder;
    }

    public void setCanCancelOrder(boolean canCancelOrder) {
        this.canCancelOrder = canCancelOrder;
    }

    public final StringProperty tradePlatformProperty() {
        return this.tradePlatform;
    }

    public final String getTradePlatform() {
        return (String)this.tradePlatformProperty().get();
    }

    public final void setTradePlatform(String tradePlatform) {
        this.tradePlatformProperty().set((Object)tradePlatform);
    }

    public String getCounterId() {
        return this.counterId;
    }

    public void setCounterId(String counterId) {
        this.counterId = counterId;
    }

    public final StringProperty belongToProperty() {
        return this.belongTo;
    }

    public final String getBelongTo() {
        return (String)this.belongToProperty().get();
    }

    public final void setBelongTo(String belongTo) {
        this.belongToProperty().set((Object)belongTo);
    }

    public final DoubleProperty totalExpectationQtyProperty() {
        return this.totalExpectationQty;
    }

    public final double getTotalExpectationQty() {
        return this.totalExpectationQtyProperty().get();
    }

    public final void setTotalExpectationQty(double totalExpectationQty) {
        this.totalExpectationQtyProperty().set(totalExpectationQty);
    }

    public final StringProperty insPriceStrProperty() {
        return this.insPriceStr;
    }

    public final String getInsPriceStr() {
        return (String)this.insPriceStrProperty().get();
    }

    public final void setInsPriceStr(String insPriceStr) {
        this.insPriceStrProperty().set((Object)insPriceStr);
    }

    public final DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public final double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public final void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public final DoubleProperty ratioProperty() {
        return this.ratio;
    }

    public final double getRatio() {
        return this.ratioProperty().get();
    }

    public final void setRatio(double ratio) {
        this.ratioProperty().set(ratio);
    }

    public final DoubleProperty orderRatioProperty() {
        return this.orderRatio;
    }

    public final double getOrderRatio() {
        return this.orderRatioProperty().get();
    }

    public final void setOrderRatio(double orderRatio) {
        this.orderRatioProperty().set(orderRatio);
    }

    public final StringProperty expireDateProperty() {
        return this.expireDate;
    }

    public final String getExpireDate() {
        return (String)this.expireDateProperty().get();
    }

    public final void setExpireDate(String expireDate) {
        this.expireDateProperty().set((Object)expireDate);
    }

    public MxNode getMarket() {
        return this.market;
    }

    public void setMarket(MxNode market) {
        this.market = market;
    }

    public final StringProperty levelInfoProperty() {
        return this.levelInfo;
    }

    public final String getLevelInfo() {
        return (String)this.levelInfoProperty().get();
    }

    public final void setLevelInfo(String levelInfo) {
        this.levelInfoProperty().set((Object)levelInfo);
    }

    public final StringProperty transferMethodProperty() {
        return this.transferMethod;
    }

    public final String getTransferMethod() {
        return (String)this.transferMethodProperty().get();
    }

    public final void setTransferMethod(String transferMethod) {
        this.transferMethodProperty().set((Object)transferMethod);
    }

    public SimpleDetail getOrderDetail() {
        return this.orderDetail;
    }

    public void setOrderDetail(SimpleDetail orderDetail) {
        this.orderDetail = orderDetail;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getUnderlyingSecType() {
        return this.underlyingSecType;
    }

    public void setUnderlyingSecType(String underlyingSecType) {
        this.underlyingSecType = underlyingSecType;
    }

    public String getUnderlyingSecMarket() {
        return this.underlyingSecMarket;
    }

    public void setUnderlyingSecMarket(String underlyingSecMarket) {
        this.underlyingSecMarket = underlyingSecMarket;
    }

    public final DoubleProperty transFerQtyProperty() {
        return this.transFerQty;
    }

    public final double getTransFerQty() {
        return this.transFerQtyProperty().get();
    }

    public final void setTransFerQty(double transFerQty) {
        this.transFerQtyProperty().set(transFerQty);
    }

    public boolean isTodo() {
        return this.todo;
    }

    public void setTodo(boolean todo) {
        this.todo = todo;
    }

    public String getMarginAttachment() {
        return this.marginAttachment;
    }

    public void setMarginAttachment(String marginAttachment) {
        this.marginAttachment = marginAttachment;
    }

    public final SimpleStringProperty underlyingSecurityCodeProperty() {
        return this.underlyingSecurityCode;
    }

    public final String getUnderlyingSecurityCode() {
        return this.underlyingSecurityCodeProperty().get();
    }

    public final void setUnderlyingSecurityCode(String underlyingSecurityCode) {
        this.underlyingSecurityCodeProperty().set(underlyingSecurityCode);
    }

    public final SimpleStringProperty underlyingSecurityNameProperty() {
        return this.underlyingSecurityName;
    }

    public final String getUnderlyingSecurityName() {
        return this.underlyingSecurityNameProperty().get();
    }

    public final void setUnderlyingSecurityName(String underlyingSecurityName) {
        this.underlyingSecurityNameProperty().set(underlyingSecurityName);
    }

    public String getMarketIndicate() {
        return this.marketIndicate;
    }

    public void setMarketIndicate(String marketIndicate) {
        this.marketIndicate = marketIndicate;
    }

    public final DoubleProperty provistonQtyProperty() {
        return this.provistonQty;
    }

    public final double getProvistonQty() {
        return this.provistonQtyProperty().get();
    }

    public final void setProvistonQty(double provistonQty) {
        this.provistonQtyProperty().set(provistonQty);
    }
}

