/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class InstructionLog
extends MxObject {
    private StringProperty instructId = new SimpleStringProperty("");
    private StringProperty workflowDesc = new SimpleStringProperty("");
    private StringProperty post = new SimpleStringProperty("");
    private StringProperty userName = new SimpleStringProperty("");
    private StringProperty stepDesc = new SimpleStringProperty("");
    private StringProperty time = new SimpleStringProperty("");
    private StringProperty ip = new SimpleStringProperty("");
    private StringProperty mac = new SimpleStringProperty("");
    private StringProperty info = new SimpleStringProperty("");

    public void update(Object obj) {
        if (obj instanceof PInstructionManagement.TransferLog) {
            PInstructionManagement.TransferLog log = (PInstructionManagement.TransferLog)PInstructionManagement.TransferLog.class.cast(obj);
            this.update(log);
        } else if (obj instanceof InstructionLog) {
            this.update((InstructionLog)((Object)InstructionLog.class.cast(obj)));
        }
    }

    private void update(PInstructionManagement.TransferLog log) {
        this.setInstructId(log.getInstrutionId());
        this.setTime(log.getOperationTime());
        this.setIp(log.getIP());
        StringBuffer mac = new StringBuffer("");
        int i = 0;
        while (i < log.getMAC().length()) {
            if (i != 0 && i != log.getMAC().length() - 1 && i % 2 == 0) {
                mac.append("-");
            }
            mac.append(log.getMAC().substring(i, i + 1));
            ++i;
        }
        this.setMac(mac.toString());
        this.setInfo(log.getReference().replaceAll("\n", " "));
        this.setWorkflowDesc(log.getFlowDescName());
    }

    private void update(InstructionLog log) {
        this.setInstructId(log.getInstructId());
        this.setWorkflowDesc(log.getWorkflowDesc());
        this.setPost(log.getPost());
        this.setUserName(log.getUserName());
        this.setStepDesc(log.getStepDesc());
        this.setTime(log.getTime());
        this.setIp(log.getIp());
        this.setMac(log.getMac());
        this.setInfo(log.getInfo());
    }

    public final StringProperty instructIdProperty() {
        return this.instructId;
    }

    public final String getInstructId() {
        return (String)this.instructIdProperty().get();
    }

    public final void setInstructId(String instructId) {
        this.instructIdProperty().set((Object)instructId);
    }

    public final StringProperty workflowDescProperty() {
        return this.workflowDesc;
    }

    public final String getWorkflowDesc() {
        return (String)this.workflowDescProperty().get();
    }

    public final void setWorkflowDesc(String workflowDesc) {
        this.workflowDescProperty().set((Object)workflowDesc);
    }

    public final StringProperty postProperty() {
        return this.post;
    }

    public final String getPost() {
        return (String)this.postProperty().get();
    }

    public final void setPost(String post) {
        this.postProperty().set((Object)post);
    }

    public final StringProperty userNameProperty() {
        return this.userName;
    }

    public final String getUserName() {
        return (String)this.userNameProperty().get();
    }

    public final void setUserName(String userName) {
        this.userNameProperty().set((Object)userName);
    }

    public final StringProperty stepDescProperty() {
        return this.stepDesc;
    }

    public final String getStepDesc() {
        return (String)this.stepDescProperty().get();
    }

    public final void setStepDesc(String stepDesc) {
        this.stepDescProperty().set((Object)stepDesc);
    }

    public final StringProperty timeProperty() {
        return this.time;
    }

    public final String getTime() {
        return (String)this.timeProperty().get();
    }

    public final void setTime(String time) {
        this.timeProperty().set((Object)time);
    }

    public final StringProperty ipProperty() {
        return this.ip;
    }

    public final String getIp() {
        return (String)this.ipProperty().get();
    }

    public final void setIp(String ip) {
        this.ipProperty().set((Object)ip);
    }

    public final StringProperty macProperty() {
        return this.mac;
    }

    public final String getMac() {
        return (String)this.macProperty().get();
    }

    public final void setMac(String mac) {
        this.macProperty().set((Object)mac);
    }

    public final StringProperty infoProperty() {
        return this.info;
    }

    public final String getInfo() {
        return (String)this.infoProperty().get();
    }

    public final void setInfo(String info) {
        this.infoProperty().set((Object)info);
    }
}

