/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.proto.PResource;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class InstructionExec
extends MxObject {
    private StringProperty instructId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> instructionType = new SimpleObjectProperty();
    private StringProperty basketId = new SimpleStringProperty("");
    private String algoId = "";
    private String portfolioId = "";
    private Instrument instrument;
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private LongProperty expectQty = new SimpleLongProperty(0L);
    private LongProperty orderQty = new SimpleLongProperty(0L);
    private LongProperty cumQty = new SimpleLongProperty(0L);
    private DoubleProperty priceLmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private long availableQty;
    private DoubleProperty executePercent = new SimpleDoubleProperty(0.0);
    private String extAccntId = "";
    private String extSecAccntId = "";
    private String subAccntId = "";
    private String subSecAccntId = "";
    private String market = "";
    private StringProperty secId = new SimpleStringProperty("");
    private StringProperty riskInfo = new SimpleStringProperty("");
    private StringProperty frozenInfo = new SimpleStringProperty("");
    private Integer peFlag;
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private DoubleProperty cumAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty cxlAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty cxlQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty execQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty donePercent = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastDealPx = new SimpleDoubleProperty(0.0);
    private DoubleProperty availOrderQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty leavesQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty relativeWeight = new SimpleDoubleProperty(0.0);
    private DoubleProperty ordRate = new SimpleDoubleProperty(0.0);
    private DoubleProperty ordAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty cxlDateQty = new SimpleDoubleProperty(0.0);

    public void update(Object obj) {
        if (obj instanceof PResource.Resource) {
            PResource.Resource in = (PResource.Resource)PResource.Resource.class.cast(obj);
            this.update(in);
        } else if (obj instanceof PResource.ResourceDetails) {
            PResource.ResourceDetails in = (PResource.ResourceDetails)PResource.ResourceDetails.class.cast(obj);
            this.update(in);
        } else if (obj instanceof PResource.LegDetails) {
            PResource.LegDetails in = (PResource.LegDetails)PResource.LegDetails.class.cast(obj);
            this.update(in);
        } else if (obj instanceof InstructionExec) {
            this.update((InstructionExec)((Object)InstructionExec.class.cast(obj)));
        }
    }

    private void update(PResource.Resource de) {
        this.setInstructId(de.getReference());
        this.getInstructionType().setRaw(Integer.toString(de.getTypeValue()));
        this.setAvailOrderQty(de.getAvailOrderQty());
        this.setLeavesQty(de.getLeavesQty());
        this.setCxlDateQty(de.getCxlQty());
    }

    private void update(PResource.ResourceDetails de) {
        this.setBasketId(de.getBasketId());
        this.setAlgoId(de.getAlgorithmId());
        this.setPortfolioId(de.getPortfolioId());
        this.setLeavesQty(de.getLeavesQty());
    }

    private void update(PResource.LegDetails leg) {
        PComponent.Instrument inst = leg.getInstrument();
        this.getInstrument().update((Object)inst);
        this.getSide().setRaw(Integer.toString(leg.getSideValue()));
        this.setExpectQty(Double.valueOf(leg.getExpectationQty()).longValue());
        this.setOrderQty(Double.valueOf(leg.getOrderQty()).longValue());
        this.setCumQty(Double.valueOf(leg.getCumQty()).longValue());
        this.setExecutePercent(this.formatScale(100.0 * leg.getRatio(), 2));
        this.setAvailableQty(Double.valueOf(leg.getAvailOrderQty()).longValue());
        this.setExtAccntId(leg.getExtAccntId());
        this.setExtSecAccntId(leg.getExtSecAccntId());
        this.setSubAccntId(leg.getSubAccntId());
        this.setSubSecAccntId(leg.getSubSecAccntId());
        this.setSecId(this.getInstrument().getSecId());
        this.setMarket(this.getInstrument().getMarket().getRaw());
        this.setRiskInfo(leg.getRiskCheckInfo());
        this.setFrozenInfo(leg.getFrozenErrInfo());
        this.setPeFlag(leg.getPeFlagValue());
        this.setAvgPx((double)Math.round(leg.getAvgPx() * 10000.0) / 10000.0);
        this.calCumAmount(leg);
        this.setOrderAmount((double)Math.round(leg.getEstimatedOrderAmount() * 1000.0) / 1000.0);
        this.setCxlQty(leg.getCxlQty());
        this.setLeavesQty(leg.getLeavesQty());
        this.setLastDealPx(leg.getLastPx());
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    private void calCumAmount(PResource.LegDetails leg) {
        if ("REPO".equals(leg.getInstrument().getSecurityType())) {
            if ("XSHG".equals(this.getMarket())) {
                this.setCumAmount(this.getCumQty() * 1000L);
            } else if ("XSHE".equals(this.getMarket())) {
                this.setCumAmount(this.getCumQty() * 100L);
            }
        } else if ("FUT".equals(leg.getInstrument().getSecurityType())) {
            this.setCumAmount((double)Math.round(leg.getAvgPx() * (double)this.getCumQty() * 10000.0) / 1000.0);
        } else {
            int i = "XSHG".equals(this.getMarket()) && "BOND".equals(leg.getInstrument().getSecurityType()) ? 10 : 1;
            this.setCumAmount((double)Math.round(leg.getAvgPx() * (double)this.getCumQty() * (double)i * 1000.0) / 1000.0);
        }
    }

    private void update(InstructionExec in) {
        this.setInstructId(in.getInstructId());
        this.setInstructionType(in.getInstructionType());
        this.setBasketId(in.getBasketId());
        this.setAlgoId(in.getAlgoId());
        this.setPortfolioId(in.getPortfolioId());
        this.setInstrument(in.getInstrument());
        this.setSide(in.getSide());
        this.setExpectQty(in.getExpectQty());
        this.setOrderQty(in.getOrderQty());
        this.setCumQty(in.getCumQty());
        this.setExecutePercent(in.getExecutePercent());
        this.setAvailableQty(in.getAvailableQty());
        this.setExtAccntId(in.getExtAccntId());
        this.setExtSecAccntId(in.getExtSecAccntId());
        this.setSubAccntId(in.getSubAccntId());
        this.setSubSecAccntId(in.getSubSecAccntId());
        this.setSecId(in.getSecId());
        this.setMarket(in.getMarket());
        this.setRiskInfo(in.getRiskInfo());
        this.setFrozenInfo(in.getFrozenInfo());
        this.setPeFlag(in.getPeFlag());
        this.setAvgPx(in.getAvgPx());
        this.setLastDealPx(in.getLastDealPx());
        this.setCumAmount((double)Math.round(in.getCumAmount() * 1000.0) / 1000.0);
        this.setCxlDateQty(in.getCxlDateQty());
        this.setOrderAmount(in.getOrderAmount());
        this.setDonePercent(in.getDonePercent());
        this.setOrdRate(in.getOrdRate());
        this.setOrdAmount(in.getOrdAmount());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.extAccntId == null ? 0 : this.extAccntId.hashCode());
        result = 31 * result + (this.extSecAccntId == null ? 0 : this.extSecAccntId.hashCode());
        result = 31 * result + (this.instructId.get() == null ? 0 : ((String)this.instructId.get()).hashCode());
        result = 31 * result + (this.market == null ? 0 : this.market.hashCode());
        result = 31 * result + (this.secId == null ? 0 : ((String)this.secId.get()).hashCode());
        result = 31 * result + (this.subAccntId == null ? 0 : this.subAccntId.hashCode());
        result = 31 * result + (this.subSecAccntId == null ? 0 : this.subSecAccntId.hashCode());
        result = 31 * result + (this.peFlag == null ? 0 : this.peFlag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InstructionExec other = (InstructionExec)((Object)obj);
        if (this.extAccntId == null ? other.extAccntId != null : !this.extAccntId.equals(other.extAccntId)) {
            return false;
        }
        if (this.extSecAccntId == null ? other.extSecAccntId != null : !this.extSecAccntId.equals(other.extSecAccntId)) {
            return false;
        }
        if (this.instructId.get() == null ? other.instructId.get() != null : !((String)this.instructId.get()).equals(other.instructId.get())) {
            return false;
        }
        if (this.market == null ? other.market != null : !this.market.equals(other.market)) {
            return false;
        }
        if (this.secId.get() == null ? other.secId.get() != null : !((String)this.secId.get()).equals(other.secId.get())) {
            return false;
        }
        if (this.subAccntId == null ? other.subAccntId != null : !this.subAccntId.equals(other.subAccntId)) {
            return false;
        }
        if (this.subSecAccntId == null ? other.subSecAccntId != null : !this.subSecAccntId.equals(other.subSecAccntId)) {
            return false;
        }
        return !(this.peFlag == null ? other.peFlag != null : !this.peFlag.equals(other.peFlag));
    }

    public final StringProperty instructIdProperty() {
        return this.instructId;
    }

    public final String getInstructId() {
        return (String)this.instructIdProperty().get();
    }

    public final void setInstructId(String instructId) {
        this.instructIdProperty().set((Object)instructId);
    }

    public final ObjectProperty<MxNode> instructionTypeProperty() {
        return this.instructionType;
    }

    public final MxNode getInstructionType() {
        return (MxNode)this.instructionTypeProperty().get();
    }

    public final void setInstructionType(MxNode instructionType) {
        this.instructionTypeProperty().set((Object)instructionType);
    }

    public String getAlgoId() {
        return this.algoId;
    }

    public void setAlgoId(String algoId) {
        this.algoId = algoId;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final LongProperty expectQtyProperty() {
        return this.expectQty;
    }

    public final long getExpectQty() {
        return this.expectQtyProperty().get();
    }

    public final void setExpectQty(long expectQty) {
        this.expectQtyProperty().set(expectQty);
    }

    public final LongProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final long getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(long cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final DoubleProperty executePercentProperty() {
        return this.executePercent;
    }

    public final double getExecutePercent() {
        return this.executePercentProperty().get();
    }

    public final void setExecutePercent(double executePercent) {
        this.executePercentProperty().set(executePercent);
    }

    public long getAvailableQty() {
        return this.availableQty;
    }

    public void setAvailableQty(long availableQty) {
        this.availableQty = availableQty;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public final StringProperty riskInfoProperty() {
        return this.riskInfo;
    }

    public final String getRiskInfo() {
        return (String)this.riskInfoProperty().get();
    }

    public final void setRiskInfo(String riskInfo) {
        this.riskInfoProperty().set((Object)riskInfo);
    }

    public final StringProperty frozenInfoProperty() {
        return this.frozenInfo;
    }

    public final String getFrozenInfo() {
        return (String)this.frozenInfoProperty().get();
    }

    public final void setFrozenInfo(String frozenInfo) {
        this.frozenInfoProperty().set((Object)frozenInfo);
    }

    public int getPeFlag() {
        return this.peFlag;
    }

    public void setPeFlag(int peFlag) {
        this.peFlag = peFlag;
    }

    public DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public DoubleProperty cumAmountProperty() {
        return this.cumAmount;
    }

    public double getCumAmount() {
        return this.cumAmountProperty().get();
    }

    public void setCumAmount(double cumAmount) {
        this.cumAmountProperty().set(cumAmount);
    }

    public final DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public final double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public final void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public final StringProperty secIdProperty() {
        return this.secId;
    }

    public final String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public final void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public final StringProperty basketIdProperty() {
        return this.basketId;
    }

    public final String getBasketId() {
        return (String)this.basketIdProperty().get();
    }

    public final void setBasketId(String basketId) {
        this.basketIdProperty().set((Object)basketId);
    }

    public final DoubleProperty cxlAmtProperty() {
        return this.cxlAmt;
    }

    public final double getCxlAmt() {
        return this.cxlAmtProperty().get();
    }

    public final void setCxlAmt(double cxlAmt) {
        this.cxlAmtProperty().set(cxlAmt);
    }

    public final DoubleProperty cxlQtyProperty() {
        return this.cxlQty;
    }

    public final double getCxlQty() {
        return this.cxlQtyProperty().get();
    }

    public final void setCxlQty(double cxlQty) {
        this.cxlQtyProperty().set(cxlQty);
    }

    public final DoubleProperty execQtyProperty() {
        return this.execQty;
    }

    public final double getExecQty() {
        return (double)this.expectQtyProperty().get() - this.availOrderQtyProperty().get();
    }

    public final void setExecQty(double execQty) {
        this.execQtyProperty().set(execQty);
    }

    public final DoubleProperty availOrderQtyProperty() {
        return this.availOrderQty;
    }

    public final double getAvailOrderQty() {
        return this.availOrderQtyProperty().get();
    }

    public final void setAvailOrderQty(double availOrderQty) {
        this.availOrderQtyProperty().set(availOrderQty);
    }

    public final DoubleProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public final double getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public final void setLeavesQty(double leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public final LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final DoubleProperty donePercentProperty() {
        return this.donePercent;
    }

    public final double getDonePercent() {
        return this.donePercentProperty().get();
    }

    public final void setDonePercent(double donePercent) {
        this.donePercentProperty().set(donePercent);
    }

    public DoubleProperty priceLmtProperty() {
        return this.priceLmt;
    }

    public double getPriceLmt() {
        return this.priceLmtProperty().get();
    }

    public void setPriceLmt(double priceLmt) {
        this.priceLmtProperty().set(priceLmt);
    }

    public final DoubleProperty relativeWeightProperty() {
        return this.relativeWeight;
    }

    public final double getRelativeWeight() {
        return this.relativeWeightProperty().get();
    }

    public final void setRelativeWeight(double relativeWeight) {
        this.relativeWeightProperty().set(relativeWeight);
    }

    public final DoubleProperty lastDealPxProperty() {
        return this.lastDealPx;
    }

    public final double getLastDealPx() {
        return this.lastDealPxProperty().get();
    }

    public final void setLastDealPx(double lastDealPx) {
        this.lastDealPxProperty().set(lastDealPx);
    }

    public final DoubleProperty ordRateProperty() {
        return this.ordRate;
    }

    public final double getOrdRate() {
        return this.ordRateProperty().get();
    }

    public final void setOrdRate(double ordRate) {
        this.ordRateProperty().set(ordRate);
    }

    public final DoubleProperty ordAmountProperty() {
        return this.ordAmount;
    }

    public final double getOrdAmount() {
        return this.ordAmountProperty().get();
    }

    public final void setOrdAmount(double ordAmount) {
        this.ordAmountProperty().set(ordAmount);
    }

    public final DoubleProperty cxlDateQtyProperty() {
        return this.cxlDateQty;
    }

    public final double getCxlDateQty() {
        return this.cxlDateQtyProperty().get();
    }

    public final void setCxlDateQty(double cxlDateQty) {
        this.cxlDateQtyProperty().set(cxlDateQty);
    }
}

