/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.PInstruction;
import cms.tmx.define.BsDict;
import cms.tmx.define.MxDict;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.ActionInfo;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.entity.trade.instruction.Resource;
import cms.tmx.entity.trade.instruction.TradeCaptureReportAdvice;
import cms.tmx.entity.trade.instruction.TransferInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxDirtySelObj;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.ListUtils;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Instruction
extends MxDirtySelObj {
    private static final Logger logger = LogManager.getLogger(Instruction.class);
    private SimpleStringProperty id = new SimpleStringProperty("");
    private SimpleStringProperty name = new SimpleStringProperty("");
    private SimpleStringProperty investId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private SimpleStringProperty statusName = new SimpleStringProperty("");
    private SimpleStringProperty hisStatus = new SimpleStringProperty("");
    private SimpleStringProperty oprAndStatus = new SimpleStringProperty("");
    private SimpleIntegerProperty progress = new SimpleIntegerProperty();
    private SimpleStringProperty flowAttriId = new SimpleStringProperty("");
    private SimpleStringProperty stepAttriId = new SimpleStringProperty("");
    private SimpleIntegerProperty descId = new SimpleIntegerProperty();
    private SimpleStringProperty descName = new SimpleStringProperty("");
    private SimpleStringProperty partyId = new SimpleStringProperty("");
    private SimpleStringProperty productId = new SimpleStringProperty("");
    private SimpleStringProperty portfolioId = new SimpleStringProperty("");
    private SimpleStringProperty portfolioName = new SimpleStringProperty("");
    private SimpleStringProperty productName = new SimpleStringProperty("");
    private SimpleStringProperty belongTo = new SimpleStringProperty("");
    private SimpleStringProperty insPrice = new SimpleStringProperty("");
    private SimpleStringProperty owner = new SimpleStringProperty("");
    private SimpleStringProperty creator = new SimpleStringProperty("");
    private SimpleStringProperty creatorName = new SimpleStringProperty("");
    private SimpleStringProperty unit = new SimpleStringProperty("");
    private SimpleStringProperty endTime = new SimpleStringProperty("");
    private SimpleStringProperty insEndTime = new SimpleStringProperty("");
    private SimpleStringProperty beginTime = new SimpleStringProperty("");
    private SimpleLongProperty entryId = new SimpleLongProperty();
    private SimpleStringProperty execId = new SimpleStringProperty("");
    private List<String> authorizer = new ArrayList<String>();
    private SimpleStringProperty authorizers = new SimpleStringProperty("");
    private List<String> authorizeRole = new ArrayList<String>();
    private StringProperty operationType = new SimpleStringProperty("");
    private SimpleIntegerProperty enableAction = new SimpleIntegerProperty();
    private SimpleBooleanProperty isOrderStep = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty isApproveStep = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty finished = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty workFlowDone = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty tradeDone = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty canHotApprove = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty canHotKeyExe = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty canCancel = new SimpleBooleanProperty(false);
    private ObjectProperty<OrderAdvice> orderAdvice = new SimpleObjectProperty();
    private ObjectProperty<AlgoParam> algoParam = new SimpleObjectProperty();
    private ObjectProperty<BasketOrderAdvice> basketOrderAdvice = new SimpleObjectProperty();
    private ObjectProperty<AdjustPosAdvice> adjustPosAdvice = new SimpleObjectProperty();
    private ObjectProperty<TradeCaptureReportAdvice> trdCtrRptAdvice = new SimpleObjectProperty();
    private ObjectProperty<TransferInfo> transferInfo = new SimpleObjectProperty();
    private LongProperty totalExpectationQty = new SimpleLongProperty(0L);
    private LongProperty cumQty = new SimpleLongProperty(0L);
    private LongProperty leavesQty = new SimpleLongProperty(0L);
    private DoubleProperty availOrderAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty availOrderNum = new SimpleDoubleProperty(0.0);
    private SimpleStringProperty lastOne = new SimpleStringProperty("");
    private SimpleStringProperty firstOne = new SimpleStringProperty("");
    private StringProperty marketGrp = new SimpleStringProperty("");
    private ObjectProperty<Resource> resource = new SimpleObjectProperty();
    private SimpleBooleanProperty canModify = new SimpleBooleanProperty(false);
    private SimpleStringProperty orderObj = new SimpleStringProperty("");
    private SimpleStringProperty side = new SimpleStringProperty("");
    private StringProperty errInfo = new SimpleStringProperty("");
    private BooleanProperty exeSelected = new SimpleBooleanProperty(false);
    private BooleanProperty distributeSelected = new SimpleBooleanProperty(false);
    private BooleanProperty cancelSelected = new SimpleBooleanProperty(false);
    private boolean isFrozen = false;
    private StringProperty exType = new SimpleStringProperty("");
    private double exRatio;
    private DoubleProperty cumAmount = new SimpleDoubleProperty(0.0);
    private StringProperty leavesAmt = new SimpleStringProperty("");
    private LongProperty availOrderQty = new SimpleLongProperty(0L);
    private DoubleProperty nowPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private StringProperty clInstructionId = new SimpleStringProperty("");
    private DoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty ratio = new SimpleDoubleProperty();
    private StringProperty expireDate = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty marketName = new SimpleStringProperty("");
    private StringProperty securityCode = new SimpleStringProperty("");
    private StringProperty securityType = new SimpleStringProperty("");
    private String postil = "";
    private boolean exeManualSelected = false;
    private boolean apprManualSelected = false;
    private boolean cancelManualSelected = false;
    private LongProperty effectOrderQty = new SimpleLongProperty(0L);
    private DoubleProperty effectOrderAmt = new SimpleDoubleProperty(0.0);
    private StringProperty strategyString = new SimpleStringProperty("");
    private ObjectProperty<MxNode> algoName = new SimpleObjectProperty();
    private StringProperty levelInfo = new SimpleStringProperty("");
    private StringProperty transferMethod = new SimpleStringProperty("");
    private DoubleProperty tradeAmount = new SimpleDoubleProperty(0.0);
    private StringProperty basketName = new SimpleStringProperty("");
    private DoubleProperty plAmount = new SimpleDoubleProperty(0.0);
    private StringProperty priceType = new SimpleStringProperty("");
    private StringProperty priceLimit = new SimpleStringProperty("");
    private DoubleProperty orderPrice = new SimpleDoubleProperty(0.0);
    private LongProperty orderQty = new SimpleLongProperty();
    private BooleanProperty orderSelected = new SimpleBooleanProperty(false);
    private StringProperty lastCaller = new SimpleStringProperty("");
    private DoubleProperty ordRatio = new SimpleDoubleProperty(0.0);
    private StringProperty leaveMessages = new SimpleStringProperty("");
    private Lock lock = new ReentrantLock();
    private ObjectProperty<List<ActionInfo>> actionList = new SimpleObjectProperty((Object)FxUtils.newList());

    public Instruction() {
        MxNode node = MxNodeFactory.create((String)"instruction_type", (String)String.valueOf(2));
        this.setType(node);
        node = MxNodeFactory.create((String)"instruction_status", (String)"0");
        this.setStatus(node);
    }

    public void update(Object obj) {
        if (obj instanceof Instruction) {
            this.update((Instruction)((Object)Instruction.class.cast(obj)));
        } else if (obj instanceof PInstruction.Instruction) {
            PInstruction.Instruction ins = (PInstruction.Instruction)PInstruction.Instruction.class.cast(obj);
            this.update(ins);
        }
    }

    private void update(Instruction ins) {
        this.setId(ins.getId());
        this.setName(ins.getName());
        this.getType().setRaw(ins.getType().getRaw());
        this.setExType(ins.getExType());
        this.getStatus().setRaw(ins.getStatus().getRaw());
        this.setStatusName(this.getStatus().getValue());
        this.setOprAndStatus(ins.getOprAndStatus());
        this.setProgress(ins.getProgress());
        this.setFlowAttrId(ins.getFlowAttrId());
        this.setPartyId(ins.getPartyId());
        this.setPortfolioId(ins.getPortfolioId());
        this.setProductId(ins.getProductId());
        this.setOwner(ins.getOwner());
        this.setEntryId(ins.getEntryId());
        this.setCreator(ins.getCreator());
        this.setCreatorName(ins.getCreatorName());
        this.setBeginTime(ins.getBeginTime());
        this.setAuthorizers(ins.getAuthorizers());
        this.setEndTime(ins.getEndTime());
        this.setInsEndTime(ins.getInsEndTime());
        if (!ins.getAuthorizer().isEmpty()) {
            this.setAuthorizer(ins.getAuthorizer());
        }
        this.setAuthorizeRole(ins.getAuthorizeRole());
        this.setSecurityCode(ins.getSecurityCode());
        this.setOrderObj(ins.getOrderObj());
        this.setExpireDate(ins.getExpireDate());
        this.setFrozen(ins.isFrozen());
        OrderAdvice orderAdvice = new OrderAdvice();
        if (ins.getOrderAdvice() != null) {
            long availabel = this.getOrderAdvice().getOrderAvailableQuantity();
            orderAdvice.update((Object)ins.getOrderAdvice());
            orderAdvice.setOrderAvailableQuantity(availabel);
            if (!this.getOrderAdvice().getAccSecInfoList().isEmpty()) {
                this.getOrderAdvice().getAccSecInfoList().stream().forEach(each -> {
                    for (AccntSecInfo accntSecInfo : orderAdvice.getAccSecInfoList()) {
                        if (!accntSecInfo.equals(each)) continue;
                        accntSecInfo.setOrderAvailableQuantity(each.getOrderAvailableQuantity());
                    }
                });
            }
        }
        this.setOrderAdvice(orderAdvice);
        BasketOrderAdvice basketAdvice = new BasketOrderAdvice();
        if (ins.getBasketOrderAdvice() != null) {
            ArrayList<BasketSecurityInst> itemList = new ArrayList<BasketSecurityInst>();
            itemList.addAll(this.getBasketOrderAdvice().getItemList());
            basketAdvice.update((Object)ins.getBasketOrderAdvice());
            basketAdvice.setItemList(itemList);
        }
        this.setBasketOrderAdvice(basketAdvice);
        AlgoParam algoParam = new AlgoParam();
        if (ins.getAlgoParam() != null) {
            int available = this.getAlgoParam().getOrderAvailableQuantity();
            algoParam.update((Object)ins.getAlgoParam());
            algoParam.setOrderAvailableQuantity(available);
        }
        this.setAlgoParam(algoParam);
        if (ins.getAdjustPosAdvice() != null) {
            this.getAdjustPosAdvice().getAlgoParam().update((Object)ins.getAdjustPosAdvice().getAlgoParam());
        }
        if (ins.getTrdCtrRptAdvice() != null) {
            ArrayList<BasketSecurityInst> itemList = new ArrayList<BasketSecurityInst>();
            itemList.addAll(this.getBasketOrderAdvice().getItemList());
            basketAdvice.update((Object)ins.getBasketOrderAdvice());
            basketAdvice.setItemList(itemList);
        }
        this.setBasketOrderAdvice(basketAdvice);
        this.setProductName(ins.getProductName());
        this.setPortfolioName(ins.getPortfolioName());
        this.setBelongTo(ins.getBelongTo());
        this.setIsOrderStep(ins.getIsOrderStep());
        this.setWorkFlowDone(ins.isWorkFlowDone());
        this.setIsApproveStep(ins.isIsApproveStep());
        if (!this.apprManualSelected) {
            this.setSelected(ins.isIsApproveStep());
        } else if (!ins.isIsApproveStep()) {
            this.setSelected(false);
        }
        this.setLeaveMessages(ins.getLeaveMessages());
        this.lock.lock();
        try {
            TransferInfo transferInfo = new TransferInfo();
            transferInfo.update((Object)ins.getTransferInfo());
            this.setTransferInfo(transferInfo);
            this.setCanHotKeyExe(this.checkHotKeyExeActionId(this.getTransferInfo().getActionInfoList()) && (ins.isProductRegular() && ins.getOrderAdvice().getPriceLimit() == 2 || this.isFutures() && this.getOrderAdvice().getPriceLimit() == 2));
            if (!this.isCanHotKeyExe()) {
                this.setExeSelected(false);
            } else if (!this.exeManualSelected) {
                this.setExeSelected(this.isCanHotKeyExe());
            } else if (!ins.isCanHotKeyExe()) {
                this.setSelected(false);
            }
            this.setExecId(ins.getExecId());
            this.setFinished(ins.isFinished());
            this.setMarketGrp(ins.getMarketGrp());
            this.setResource(ins.getResource());
            this.setDescId(ins.getDescId());
            this.setDescName(ins.getDescName());
            this.setHisStatus(ins.getHisStatus());
            this.setLastOne(ins.getLastOne());
            this.setFirstOne(ins.getFirstOne());
            this.setCanModify(ins.isCanModify());
            this.setSide(ins.getSide());
            this.setErrInfo(ins.getErrInfo());
            this.setInsPrice(ins.getInsPrice());
            this.setCanHotApprove(ins.isCanHotApprove());
            this.setCumAmount(ins.getCumAmount());
            this.setInvestId(ins.getInvestId());
            this.setLeavesQty(ins.getLeavesQty());
            this.setAvgPx(ins.getAvgPx());
            this.setNowPrice(ins.getNowPrice());
            this.setCumQty(ins.getCumQty());
            this.setLeavesQty(ins.getLeavesQty());
            this.setMarket(ins.getMarket());
            this.setMarketName((String)BsDict.MARKET_MAP.get(this.getMarket()));
            this.setSecurityCode(ins.getSecurityCode());
            this.setSecurityType(ins.getSecurityType());
            this.setTradeDone(ins.isTradeDone());
            this.setClInstructionId(ins.getClInstructionId());
            this.setLeavesAmt(ins.getLeavesAmt());
            this.setAvailOrderQty(ins.getAvailOrderQty());
            this.setPostil(ins.getPostil());
            this.setOrderAmount(ins.getOrderAmount());
            this.setRatio(ins.getRatio());
            this.setCanCancel(ins.isCanCancel());
            this.setLevelInfo(ins.getLevelInfo());
            this.setTransferMethod(ins.getTransferMethod());
            if (!this.cancelManualSelected) {
                this.setCancelSelected(ins.isCanCancel());
            } else if (!ins.isCanCancel()) {
                this.setCancelSelected(false);
            }
            this.setAvailOrderNum(ins.getAvailOrderNum());
            this.setAvailOrderAmt(ins.getAvailOrderAmt());
            this.setEffectOrderQty(ins.getLeavesQty() + ins.getCumQty());
            this.setEffectOrderAmt(ins.getEffectOrderAmt());
            this.setTradeAmount(ins.getTradeAmount());
            this.setLastCaller(ins.getLastCaller());
            if ("17".equals(ins.getType().getRaw()) || "16".equals(ins.getType().getRaw())) {
                this.setStrategyString(ins.getAdjustPosAdvice().getAdjWay().getValue());
                this.setBasketName(ins.getAdjustPosAdvice().getBasketName());
            } else {
                this.setBasketName(ins.getName());
            }
            this.setAlgoName(ins.getAlgoName());
            ArrayList<ActionInfo> actions = new ArrayList<ActionInfo>(ins.getTransferInfo().getActionInfoList());
            if (!ListUtils.checkDiffrent(this.getActionList(), actions) || actions.isEmpty()) {
                this.setActionList(actions);
            }
            if (ins.getTotalExpectationQty() != 0L) {
                this.setOrdRatio(ins.getOrdRatio());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void update(PInstruction.Instruction ins) {
        if (ins.getInstructionId().endsWith("4027")) {
            System.out.println();
        }
        this.setId(ins.getInstructionId());
        this.setName(ins.getName());
        this.getType().setRaw(String.valueOf(ins.getType()));
        this.setExType(this.getType().getValue());
        this.getStatus().setRaw(String.valueOf(ins.getStatusValue()));
        this.setStatusName(this.getStatus().getValue());
        this.setProgress(ins.getProgress());
        this.setFlowAttrId(ins.getFlowAttrId());
        this.setEntryId(ins.getEntryId());
        this.setPartyId(ins.getPartyId());
        this.setDescId(ins.getDescId());
        this.setDescName(ins.getDescName());
        this.setPortfolioId(ins.getPortfolioId());
        this.setProductId(ins.getProductId());
        this.setExpireDate(ins.getExpireDate());
        this.setOwner(ins.getOwner());
        this.setCreator(ins.getCreator());
        this.setBeginTime(ins.getBeginTime());
        this.setEndTime(ins.getEndTime());
        this.setInsEndTime(ins.getEndTime());
        this.getAuthorizer().addAll((Collection<String>)ins.getAuthorizerList());
        this.getAuthorizeRole().addAll((Collection<String>)ins.getAuthorizeRoleList());
        this.setFrozen(ins.getIsFrozen());
        this.setCanHotApprove(ins.getHasQuickApprovalPermit());
        this.setLeaveMessages(ins.getLeaveMessages());
        this.setLastCaller(ins.getLastCaller());
        boolean hasDistribution = false;
        for (PInstruction.ActionInfo actionInfo : ins.getTransferInfo().getActionInfoList()) {
            if (actionInfo.getActionId() == MxDict.WORKFLOW_APPROVE) {
                this.setIsApproveStep(true);
                this.setSelected(true);
                break;
            }
            if (actionInfo.getActionId() == MxDict.WORKFLOW_EXECUTE) {
                this.setIsOrderStep(true);
                break;
            }
            if (actionInfo.getActionId() != 15) continue;
            hasDistribution = true;
            break;
        }
        if (ins.getDetails().getSerializedSize() > 0) {
            this.updateAny(ins.getDetails());
            if (this.getOrderAdvice() != null) {
                this.getOrderAdvice().setPortfolioId(ins.getPortfolioId());
                this.getOrderAdvice().setProductId(ins.getProductId());
                this.setTotalExpectationQty(this.getOrderAdvice().getOrderQty());
                this.setOrderObj(this.getOrderAdvice().getSecName());
                this.setSecurityCode(this.getOrderAdvice().getSec());
            }
            if (this.getBasketOrderAdvice() != null) {
                this.getBasketOrderAdvice().setPortfolioId(ins.getPortfolioId());
                this.getBasketOrderAdvice().setProductId(ins.getProductId());
                this.setTotalExpectationQty(this.getBasketOrderAdvice().getOrderQty());
                this.setOrderObj(this.getBasketOrderAdvice().getBasketName());
            }
            if (this.getAlgoParam() != null) {
                this.getAlgoParam().setPortfolio(ins.getPortfolioId());
                this.setTotalExpectationQty(this.getAlgoParam().getCount());
                this.getAlgoParam().setProductId(ins.getProductId());
                this.setOrderObj(this.getAlgoParam().getName());
                this.setSecurityCode(this.getAlgoParam().getCode());
            }
            if (this.getAdjustPosAdvice() != null) {
                this.setTotalExpectationQty(this.getAdjustPosAdvice().getOrderQty());
                this.setOrderObj(this.getAdjustPosAdvice().getBasketName());
            }
            if (this.getTrdCtrRptAdvice() != null) {
                this.setTotalExpectationQty(this.getTrdCtrRptAdvice().getOrderQty());
                this.setOrderObj(this.getTrdCtrRptAdvice().getSecName());
                this.setSecurityCode(this.getTrdCtrRptAdvice().getSecId());
                this.getTrdCtrRptAdvice().setProductId(ins.getProductId());
                this.getTrdCtrRptAdvice().setPortfolioId(ins.getPortfolioId());
            }
        }
        this.lock.lock();
        try {
            TransferInfo transInfo = new TransferInfo();
            transInfo.update((Object)ins.getTransferInfo());
            Iterator<ActionInfo> iterator = transInfo.getActionInfoList().iterator();
            if (!StringUtils.isEmpty((String)ins.getEndTime())) {
                while (iterator.hasNext()) {
                    ActionInfo ai = iterator.next();
                    if (!hasDistribution || ai.getActionId() != 16) continue;
                    iterator.remove();
                }
            }
            if (!StringUtils.isEmpty((String)ins.getEndTime()) && ("9".equals(String.valueOf(ins.getStatusValue())) || "16".equals(String.valueOf(ins.getStatusValue())))) {
                this.setWorkFlowDone(true);
                Iterator<ActionInfo> it = transInfo.getActionInfoList().iterator();
                while (it.hasNext()) {
                    ActionInfo ai = it.next();
                    if (ai.getActionId() >= 13 && ai.getActionId() <= 15) continue;
                    it.remove();
                }
            }
            this.setTransferInfo(transInfo);
            if (StringUtils.isEmpty((String)this.getMarketGrp())) {
                this.setMarketGrp("CCS");
            }
            this.setLastOne(ins.getLastPostId());
            this.setFirstOne(ins.getFirstPostId());
            this.setCanModify(ins.getHasExecSwitchPermit());
            this.setErrInfo(ins.getErrInfo());
            this.setClInstructionId(ins.getClInstructionId());
            this.setCanHotKeyExe(this.checkHotKeyExeActionId(transInfo.getActionInfoList()) && (this.isProductRegular() && this.getOrderAdvice().getPriceLimit() == 2 || this.isFutures() && this.getOrderAdvice().getPriceLimit() == 2));
            this.setExeSelected(this.isCanHotKeyExe());
            this.setCancelSelected(this.isCanHotKeyExe());
            this.setOrderAmount((double)Math.round(ins.getEstimatedOrderAmount() * 1000.0) / 1000.0);
            if (this.getTotalExpectationQty() != 0L && this.getResource() != null) {
                this.setOrdRatio(this.getOrdRatio());
            }
            this.setAvailOrderNum(this.totalExpectationQtyProperty().get() - this.cumQtyProperty().get());
            this.setAvailOrderAmt(this.getAvailOrderAmt());
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean checkHotKeyExeActionId(List<ActionInfo> actionInfoList) {
        for (ActionInfo actionInfo : actionInfoList) {
            if (actionInfo.getActionId() != 5 && actionInfo.getActionId() != 14) continue;
            return true;
        }
        return false;
    }

    private void updateAny(Any details) {
        try {
            if (details.is(PInstruction.SingleOrderAdvice.class)) {
                PInstruction.SingleOrderAdvice soa = (PInstruction.SingleOrderAdvice)details.unpack(PInstruction.SingleOrderAdvice.class);
                this.updateAdvice(soa);
                this.setMarketGrp(MarketUtils.getMarketGroup((String)soa.getMarket()));
            } else if (details.is(PInstruction.BasketOrderAdvice.class)) {
                PInstruction.BasketOrderAdvice boa = (PInstruction.BasketOrderAdvice)details.unpack(PInstruction.BasketOrderAdvice.class);
                this.updateAdvice(boa);
            } else if (details.is(PInstruction.BasketAlgoOrderAdvice.class)) {
                PInstruction.BasketAlgoOrderAdvice boa = (PInstruction.BasketAlgoOrderAdvice)details.unpack(PInstruction.BasketAlgoOrderAdvice.class);
                this.updateAdvice(boa);
            } else if (details.is(PInstruction.AlgorithmOrderAdvice.class)) {
                PInstruction.AlgorithmOrderAdvice algo = (PInstruction.AlgorithmOrderAdvice)details.unpack(PInstruction.AlgorithmOrderAdvice.class);
                this.updateAdvice(algo);
                this.setMarketGrp(MarketUtils.getMarketGroup((String)algo.getInstrument().getMarket()));
            } else if (details.is(PInstruction.AdjustPosAlgoOrderAdvice.class)) {
                PInstruction.AdjustPosAlgoOrderAdvice adj = (PInstruction.AdjustPosAlgoOrderAdvice)details.unpack(PInstruction.AdjustPosAlgoOrderAdvice.class);
                this.updateAdvice(adj);
            } else if (details.is(PInstruction.TradeCaptureReportAdvice.class)) {
                PInstruction.TradeCaptureReportAdvice trd = (PInstruction.TradeCaptureReportAdvice)details.unpack(PInstruction.TradeCaptureReportAdvice.class);
                this.updateAdvice(trd);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("instruction detail unpack failed ", (Throwable)e);
        }
    }

    public PInstruction.Instruction getPbInstruction() {
        PInstruction.Instruction.Builder inB = PInstruction.Instruction.newBuilder();
        inB.addAllAuthorizer(this.getAuthorizer());
        inB.addAllAuthorizeRole(this.getAuthorizeRole());
        inB.setInstructionId(this.getId());
        inB.setName(this.getName());
        inB.setType(Integer.valueOf(this.getType().getRaw()).intValue());
        inB.setStatus(PInstruction.InstructionStatus.forNumber((int)Integer.valueOf(this.getStatus().getRaw())));
        inB.setEntryId(this.getEntryId());
        inB.setFlowAttrId(this.getFlowAttrId());
        inB.setPartyId(this.getPartyId());
        inB.setProductId(this.getProductId());
        inB.setPortfolioId(this.getPortfolioId());
        inB.setOwner(this.getOwner());
        inB.setCreator(this.getCreator());
        inB.setBeginTime(this.getBeginTime());
        inB.setEndTime(this.getEndTime());
        inB.setProgress(this.getProgress());
        inB.setStepAttrId(this.getStepAttrId());
        PInstruction.TransferInfo.Builder trsB = PInstruction.TransferInfo.newBuilder();
        trsB.setEntryId(this.getTransferInfo().getEntryId());
        inB.setTransferInfo(trsB.build());
        Any any = this.getOrderAdvice().buildAny();
        inB.setDetails(any);
        return inB.build();
    }

    private void updateAdvice(PInstruction.BasketOrderAdvice boa) {
        BasketOrderAdvice basketOa = new BasketOrderAdvice();
        basketOa.update((Object)boa);
        this.setBasketOrderAdvice(basketOa);
    }

    private void updateAdvice(PInstruction.BasketAlgoOrderAdvice boa) {
        BasketOrderAdvice basketOa = new BasketOrderAdvice();
        basketOa.update((Object)boa);
        this.setBasketOrderAdvice(basketOa);
    }

    private void updateAdvice(PInstruction.SingleOrderAdvice soa) {
        OrderAdvice oa = new OrderAdvice();
        oa.update((Object)soa);
        this.setOrderAdvice(oa);
        this.setMarket(oa.getMarket());
        this.setMarketName((String)BsDict.MARKET_MAP.get(this.getMarket()));
        this.setSecurityCode(oa.getSec());
        this.setSecurityType(oa.getSecType());
    }

    private void updateAdvice(PInstruction.AlgorithmOrderAdvice soa) {
        AlgoParam oa = new AlgoParam();
        oa.update((Object)soa);
        this.setAlgoParam(oa);
        this.setMarket(oa.getMarket());
        this.setMarketName((String)BsDict.MARKET_MAP.get(this.getMarket()));
        this.setSecurityCode(oa.getCode());
        this.setSecurityType(oa.getType());
    }

    private void updateAdvice(PInstruction.AdjustPosAlgoOrderAdvice apaoa) {
        AdjustPosAdvice adj = new AdjustPosAdvice();
        adj.update((Object)apaoa);
        this.setAdjustPosAdvice(adj);
    }

    private void updateAdvice(PInstruction.TradeCaptureReportAdvice trd) {
        TradeCaptureReportAdvice trdAdvice = new TradeCaptureReportAdvice();
        trdAdvice.update((Object)trd);
        this.setTrdCtrRptAdvice(trdAdvice);
        this.setMarket(trdAdvice.getMarket());
        this.setMarketName((String)BsDict.MARKET_MAP.get(this.getMarket()));
        this.setSecurityCode(trdAdvice.getSecId());
        this.setSecurityType(trdAdvice.getSecType());
    }

    public SimpleStringProperty idProperty() {
        return this.id;
    }

    public String getId() {
        return this.idProperty().get();
    }

    public void setId(String id) {
        this.idProperty().set(id);
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set(name);
    }

    public SimpleIntegerProperty progressProperty() {
        return this.progress;
    }

    public int getProgress() {
        return this.progressProperty().get();
    }

    public void setProgress(int progress) {
        this.progressProperty().set(progress);
    }

    public SimpleStringProperty ownerProperty() {
        return this.owner;
    }

    public String getOwner() {
        return this.ownerProperty().get();
    }

    public void setOwner(String owner) {
        this.ownerProperty().set(owner);
    }

    public SimpleStringProperty creatorProperty() {
        return this.creator;
    }

    public String getCreator() {
        return this.creatorProperty().get();
    }

    public void setCreator(String creator) {
        this.creatorProperty().set(creator);
    }

    public SimpleStringProperty creatorNameProperty() {
        return this.creatorName;
    }

    public String getCreatorName() {
        return this.creatorNameProperty().get();
    }

    public void setCreatorName(String creat) {
        this.creatorNameProperty().set(creat);
    }

    public SimpleStringProperty unitProperty() {
        return this.unit;
    }

    public String getUnits() {
        return this.unitProperty().get();
    }

    public void setUnit(String unit) {
        this.unitProperty().set(unit);
    }

    public List<String> getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(List<String> authorizer) {
        this.authorizer = authorizer;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : this.id.get().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Instruction other = (Instruction)((Object)obj);
        return !(this.id.get() == null ? other.id.get() != null : !this.id.get().equals(other.id.get()));
    }

    public SimpleStringProperty partyIdProperty() {
        return this.partyId;
    }

    public String getPartyId() {
        return this.partyIdProperty().get();
    }

    public void setPartyId(String partyId) {
        this.partyIdProperty().set(partyId);
    }

    public SimpleStringProperty productIdProperty() {
        return this.productId;
    }

    public String getProductId() {
        return this.productIdProperty().get();
    }

    public void setProductId(String productId) {
        this.productIdProperty().set(productId);
    }

    public SimpleStringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public String getPortfolioId() {
        return this.portfolioIdProperty().get();
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set(portfolioId);
    }

    public SimpleStringProperty beginTimeProperty() {
        return this.beginTime;
    }

    public String getBeginTime() {
        return this.beginTimeProperty().get();
    }

    public void setBeginTime(String beginTime) {
        this.beginTimeProperty().set(beginTime);
    }

    public SimpleStringProperty endTimeProperty() {
        return this.endTime;
    }

    public String getEndTime() {
        return this.endTimeProperty().get();
    }

    public void setEndTime(String endTime) {
        this.endTimeProperty().set(endTime);
    }

    public List<String> getAuthorizeRole() {
        return this.authorizeRole;
    }

    public void setAuthorizeRole(List<String> authorizeRole) {
        this.authorizeRole = authorizeRole;
    }

    public StringProperty operationTypeProperty() {
        return this.operationType;
    }

    public String getOperationType() {
        return (String)this.operationTypeProperty().get();
    }

    public void setOperationType(String operationType) {
        this.operationTypeProperty().set((Object)operationType);
    }

    public SimpleBooleanProperty isOrderStepProperty() {
        return this.isOrderStep;
    }

    public boolean getIsOrderStep() {
        return this.isOrderStepProperty().get();
    }

    public void setIsOrderStep(boolean isOrderStep) {
        this.isOrderStepProperty().set(isOrderStep);
    }

    public SimpleStringProperty flowAttrIdProperty() {
        return this.flowAttriId;
    }

    public String getFlowAttrId() {
        return this.flowAttrIdProperty().get();
    }

    public void setFlowAttrId(String flowAttriId) {
        this.flowAttrIdProperty().set(flowAttriId);
    }

    public SimpleBooleanProperty finishedProperty() {
        return this.finished;
    }

    public boolean isFinished() {
        return this.finishedProperty().get();
    }

    public void setFinished(boolean finished) {
        this.finishedProperty().set(finished);
    }

    public SimpleIntegerProperty enableActionProperty() {
        return this.enableAction;
    }

    public int getEnableAction() {
        return this.enableActionProperty().get();
    }

    public void setEnableAction(int enableAction) {
        this.enableActionProperty().set(enableAction);
    }

    public ObjectProperty<OrderAdvice> orderAdviceProperty() {
        return this.orderAdvice;
    }

    public OrderAdvice getOrderAdvice() {
        return (OrderAdvice)((Object)this.orderAdviceProperty().get());
    }

    public void setOrderAdvice(OrderAdvice orderAdvice) {
        this.orderAdviceProperty().set((Object)orderAdvice);
    }

    public SimpleStringProperty stepAttrIdProperty() {
        return this.stepAttriId;
    }

    public String getStepAttrId() {
        return this.stepAttrIdProperty().get();
    }

    public void setStepAttrId(String stepAttriId) {
        this.stepAttrIdProperty().set(stepAttriId);
    }

    public ObjectProperty<TransferInfo> transferInfoProperty() {
        return this.transferInfo;
    }

    public TransferInfo getTransferInfo() {
        return (TransferInfo)((Object)this.transferInfoProperty().get());
    }

    public void setTransferInfo(TransferInfo transferInfo) {
        this.transferInfoProperty().set((Object)transferInfo);
    }

    public ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public SimpleStringProperty flowAttriIdProperty() {
        return this.flowAttriId;
    }

    public String getFlowAttriId() {
        return this.flowAttriIdProperty().get();
    }

    public void setFlowAttriId(String flowAttriId) {
        this.flowAttriIdProperty().set(flowAttriId);
    }

    public SimpleStringProperty stepAttriIdProperty() {
        return this.stepAttriId;
    }

    public String getStepAttriId() {
        return this.stepAttriIdProperty().get();
    }

    public void setStepAttriId(String stepAttriId) {
        this.stepAttriIdProperty().set(stepAttriId);
    }

    public SimpleStringProperty execIdProperty() {
        return this.execId;
    }

    public String getExecId() {
        return this.execIdProperty().get();
    }

    public void setExecId(String execId) {
        this.execIdProperty().set(execId);
    }

    public ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public SimpleStringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set(portfolioName);
    }

    public SimpleStringProperty productNameProperty() {
        return this.productName;
    }

    public String getProductName() {
        return this.productNameProperty().get();
    }

    public void setProductName(String productName) {
        this.productNameProperty().set(productName);
    }

    public SimpleStringProperty belongToProperty() {
        return this.belongTo;
    }

    public String getBelongTo() {
        return this.belongToProperty().get();
    }

    public void setBelongTo(String belongTo) {
        this.belongToProperty().set(belongTo);
    }

    public final ObjectProperty<AlgoParam> algoParamProperty() {
        return this.algoParam;
    }

    public final AlgoParam getAlgoParam() {
        return (AlgoParam)((Object)this.algoParamProperty().get());
    }

    public final void setAlgoParam(AlgoParam algoParam) {
        this.algoParamProperty().set((Object)algoParam);
    }

    public ObjectProperty<BasketOrderAdvice> basketOrderAdviceProperty() {
        return this.basketOrderAdvice;
    }

    public BasketOrderAdvice getBasketOrderAdvice() {
        return (BasketOrderAdvice)((Object)this.basketOrderAdviceProperty().get());
    }

    public void setBasketOrderAdvice(BasketOrderAdvice basketOrderAdvice) {
        this.basketOrderAdviceProperty().set((Object)basketOrderAdvice);
    }

    public StringProperty marketGrpProperty() {
        return this.marketGrp;
    }

    public String getMarketGrp() {
        return (String)this.marketGrpProperty().get();
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrpProperty().set((Object)marketGrp);
    }

    public ObjectProperty<Resource> resourceProperty() {
        return this.resource;
    }

    public Resource getResource() {
        return (Resource)((Object)this.resourceProperty().get());
    }

    public void setResource(Resource resource) {
        this.resourceProperty().set((Object)resource);
        this.setExRatio(resource.getRatio());
    }

    public SimpleBooleanProperty isApproveStepProperty() {
        return this.isApproveStep;
    }

    public boolean isIsApproveStep() {
        return this.isApproveStepProperty().get();
    }

    public void setIsApproveStep(boolean isApproveStep) {
        this.isApproveStepProperty().set(isApproveStep);
    }

    public LongProperty totalExpectationQtyProperty() {
        return this.totalExpectationQty;
    }

    public long getTotalExpectationQty() {
        return this.totalExpectationQtyProperty().get();
    }

    public void setTotalExpectationQty(long totalExpectationQty) {
        this.totalExpectationQtyProperty().set(totalExpectationQty);
    }

    public SimpleBooleanProperty workFlowDoneProperty() {
        return this.workFlowDone;
    }

    public boolean isWorkFlowDone() {
        return this.workFlowDoneProperty().get();
    }

    public void setWorkFlowDone(boolean workFlowDone) {
        this.workFlowDoneProperty().set(workFlowDone);
    }

    public SimpleBooleanProperty canHotApproveProperty() {
        return this.canHotApprove;
    }

    public boolean isCanHotApprove() {
        return this.canHotApproveProperty().get();
    }

    public void setCanHotApprove(boolean canHotApprove) {
        this.canHotApproveProperty().set(canHotApprove);
    }

    public final SimpleStringProperty descNameProperty() {
        return this.descName;
    }

    public final String getDescName() {
        return this.descNameProperty().get();
    }

    public final void setDescName(String descName) {
        this.descNameProperty().set(descName);
    }

    public SimpleStringProperty lastOneProperty() {
        return this.lastOne;
    }

    public String getLastOne() {
        return this.lastOneProperty().get();
    }

    public void setLastOne(String lastOne) {
        this.lastOneProperty().set(lastOne);
    }

    public SimpleStringProperty firstOneProperty() {
        return this.firstOne;
    }

    public String getFirstOne() {
        return this.firstOneProperty().get();
    }

    public void setFirstOne(String firstOne) {
        this.firstOneProperty().set(firstOne);
    }

    public SimpleLongProperty entryIdProperty() {
        return this.entryId;
    }

    public long getEntryId() {
        return this.entryIdProperty().get();
    }

    public void setEntryId(long entryId) {
        this.entryIdProperty().set(entryId);
    }

    public boolean isBasket() {
        if ("4".equals(this.getType().getRaw())) {
            return true;
        }
        return "5".equals(this.getType().getRaw());
    }

    public boolean isBasketOrAlgoBasket() {
        if ("4".equals(this.getType().getRaw())) {
            return true;
        }
        if ("5".equals(this.getType().getRaw())) {
            return true;
        }
        if ("12".equals(this.getType().getRaw())) {
            return true;
        }
        return "13".equals(this.getType().getRaw());
    }

    public boolean isAlgo() {
        return this.getType().is("8") || this.getType().is("9");
    }

    public boolean isRegular() {
        return this.getType().is("2") || this.getType().is("3");
    }

    public boolean isProductRegular() {
        return this.getType().is("2");
    }

    public boolean isProductBasket() {
        return "4".equals(this.getType().getRaw());
    }

    public boolean isBlock() {
        return this.getType().is("32");
    }

    public boolean isFutures() {
        return this.getType().is("64");
    }

    public final SimpleBooleanProperty canModifyProperty() {
        return this.canModify;
    }

    public final boolean isCanModify() {
        return this.canModifyProperty().get();
    }

    public final void setCanModify(boolean canModify) {
        this.canModifyProperty().set(canModify);
    }

    public SimpleStringProperty orderObjProperty() {
        return this.orderObj;
    }

    public String getOrderObj() {
        return this.orderObjProperty().get();
    }

    public void setOrderObj(String orderObj) {
        this.orderObjProperty().set(orderObj);
    }

    public SimpleStringProperty insPriceProperty() {
        return this.insPrice;
    }

    public String getInsPrice() {
        return this.insPriceProperty().get();
    }

    public void setInsPrice(String insPrice) {
        this.insPriceProperty().set(insPrice);
    }

    public ObjectProperty<AdjustPosAdvice> adjustPosAdviceProperty() {
        return this.adjustPosAdvice;
    }

    public AdjustPosAdvice getAdjustPosAdvice() {
        return (AdjustPosAdvice)((Object)this.adjustPosAdviceProperty().get());
    }

    public void setAdjustPosAdvice(AdjustPosAdvice adjustPosAdvice) {
        this.adjustPosAdviceProperty().set((Object)adjustPosAdvice);
    }

    public SimpleStringProperty sideProperty() {
        return this.side;
    }

    public String getSide() {
        return this.sideProperty().get();
    }

    public void setSide(String side) {
        this.sideProperty().set(side);
    }

    public final StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public final String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean isFrozen) {
        this.isFrozen = isFrozen;
    }

    public ObjectProperty<TradeCaptureReportAdvice> trdCtrRptAdviceProperty() {
        return this.trdCtrRptAdvice;
    }

    public TradeCaptureReportAdvice getTrdCtrRptAdvice() {
        return (TradeCaptureReportAdvice)((Object)this.trdCtrRptAdviceProperty().get());
    }

    public void setTrdCtrRptAdvice(TradeCaptureReportAdvice trdCtrRptAdvice) {
        this.trdCtrRptAdviceProperty().set((Object)trdCtrRptAdvice);
    }

    public double getExRatio() {
        return this.exRatio;
    }

    public void setExRatio(double exRatio) {
        this.exRatio = exRatio;
    }

    public DoubleProperty cumAmountProperty() {
        return this.cumAmount;
    }

    public double getCumAmount() {
        return this.cumAmountProperty().get();
    }

    public void setCumAmount(double cumAmount) {
        this.cumAmountProperty().set(cumAmount);
    }

    public DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
    }

    public BooleanProperty exeSelectedProperty() {
        return this.exeSelected;
    }

    public boolean isExeSelected() {
        return this.exeSelectedProperty().get();
    }

    public void setExeSelected(boolean exeSelected) {
        this.exeSelectedProperty().set(exeSelected);
    }

    public BooleanProperty cancelSelectedProperty() {
        return this.cancelSelected;
    }

    public boolean isCancelSelected() {
        return this.cancelSelectedProperty().get();
    }

    public void setCancelSelected(boolean cancelSelected) {
        this.cancelSelectedProperty().set(cancelSelected);
    }

    public SimpleBooleanProperty tradeDoneProperty() {
        return this.tradeDone;
    }

    public boolean isTradeDone() {
        return this.tradeDoneProperty().get();
    }

    public void setTradeDone(boolean tradeDone) {
        this.tradeDoneProperty().set(tradeDone);
    }

    public boolean isExeManualSelected() {
        return this.exeManualSelected;
    }

    public void setExeManualSelected(boolean exeManualSelected) {
        this.exeManualSelected = exeManualSelected;
    }

    public boolean isCancelManualSelected() {
        return this.cancelManualSelected;
    }

    public void setCancelManualSelected(boolean cancelManualSelected) {
        this.cancelManualSelected = cancelManualSelected;
    }

    public boolean isApprManualSelected() {
        return this.apprManualSelected;
    }

    public void setApprManualSelected(boolean apprManualSelected) {
        this.apprManualSelected = apprManualSelected;
    }

    public StringProperty clInstructionIdProperty() {
        return this.clInstructionId;
    }

    public String getClInstructionId() {
        return (String)this.clInstructionIdProperty().get();
    }

    public void setClInstructionId(String clInstructionId) {
        this.clInstructionIdProperty().set((Object)clInstructionId);
    }

    public SimpleBooleanProperty canHotKeyExeProperty() {
        return this.canHotKeyExe;
    }

    public boolean isCanHotKeyExe() {
        return this.canHotKeyExeProperty().get();
    }

    public void setCanHotKeyExe(boolean canHotKeyExe) {
        this.canHotKeyExeProperty().set(canHotKeyExe);
    }

    public LongProperty availOrderQtyProperty() {
        return this.availOrderQty;
    }

    public long getAvailOrderQty() {
        return this.availOrderQtyProperty().get();
    }

    public void setAvailOrderQty(long availOrderQty) {
        this.availOrderQtyProperty().set(availOrderQty);
    }

    public String getPostil() {
        return this.postil;
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public StringProperty leavesAmtProperty() {
        return this.leavesAmt;
    }

    public String getLeavesAmt() {
        return (String)this.leavesAmtProperty().get();
    }

    public void setLeavesAmt(String leavesAmt) {
        this.leavesAmtProperty().set((Object)leavesAmt);
    }

    public final DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public final double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public final void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public final DoubleProperty ratioProperty() {
        return this.ratio;
    }

    public final double getRatio() {
        return this.ratioProperty().get();
    }

    public final void setRatio(double ratio) {
        this.ratioProperty().set(ratio);
    }

    public LongProperty cumQtyProperty() {
        return this.cumQty;
    }

    public long getCumQty() {
        return this.cumQtyProperty().get();
    }

    public void setCumQty(long cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public LongProperty leavesQtyProperty() {
        return this.leavesQty;
    }

    public long getLeavesQty() {
        return this.leavesQtyProperty().get();
    }

    public void setLeavesQty(long leavesQty) {
        this.leavesQtyProperty().set(leavesQty);
    }

    public final SimpleBooleanProperty canCancelProperty() {
        return this.canCancel;
    }

    public final boolean isCanCancel() {
        return this.canCancelProperty().get();
    }

    public final void setCanCancel(boolean canCancel) {
        this.canCancelProperty().set(canCancel);
    }

    public StringProperty expireDateProperty() {
        return this.expireDate;
    }

    public String getExpireDate() {
        return (String)this.expireDateProperty().get();
    }

    public void setExpireDate(String expireDate) {
        this.expireDateProperty().set((Object)expireDate);
    }

    public final DoubleProperty nowPriceProperty() {
        return this.nowPrice;
    }

    public final double getNowPrice() {
        return this.nowPriceProperty().get();
    }

    public final void setNowPrice(double nowPrice) {
        this.nowPriceProperty().set(nowPrice);
    }

    public final DoubleProperty availOrderAmtProperty() {
        return this.availOrderAmt;
    }

    public final double getAvailOrderAmt() {
        if (this.getOrderAdvice() == null || "4".equals(this.getType().getRaw())) {
            return this.getOrderAmount() - this.getTradeAmount();
        }
        double availOrderNum = this.getAvailOrderNum();
        if ("XSHG".equals(this.getMarket()) && "BOND".equals(this.getSecurityType())) {
            availOrderNum *= 10.0;
        }
        return this.getOrderAdvice().getPrice() * availOrderNum;
    }

    public final void setAvailOrderAmt(double availOrderAmt) {
        this.availOrderAmtProperty().set(availOrderAmt);
    }

    public final DoubleProperty availOrderNumProperty() {
        return this.availOrderNum;
    }

    public final double getAvailOrderNum() {
        return this.totalExpectationQtyProperty().get() - this.cumQtyProperty().get();
    }

    public final void setAvailOrderNum(double availOrderNum) {
        this.availOrderNumProperty().set(availOrderNum);
    }

    public final SimpleStringProperty authorizersProperty() {
        return this.authorizers;
    }

    public final String getAuthorizers() {
        return this.authorizersProperty().get();
    }

    public final void setAuthorizers(String authorizers) {
        this.authorizersProperty().set(authorizers);
    }

    public final SimpleIntegerProperty descIdProperty() {
        return this.descId;
    }

    public final int getDescId() {
        return this.descIdProperty().get();
    }

    public final void setDescId(int descId) {
        this.descIdProperty().set(descId);
    }

    public final SimpleStringProperty investIdProperty() {
        return this.investId;
    }

    public final String getInvestId() {
        return this.investIdProperty().get();
    }

    public final void setInvestId(String investId) {
        this.investIdProperty().set(investId);
    }

    public final LongProperty effectOrderQtyProperty() {
        return this.effectOrderQty;
    }

    public final long getEffectOrderQty() {
        return this.getLeavesQty() + this.getCumQty();
    }

    public final void setEffectOrderQty(long effectOrderQty) {
        this.effectOrderQtyProperty().set(effectOrderQty);
    }

    public final DoubleProperty effectOrderAmtProperty() {
        return this.effectOrderAmt;
    }

    public final double getEffectOrderAmt() {
        if (this.getLeavesAmt() == "") {
            return this.getResource().getTradeAmount();
        }
        return this.getResource().getTradeAmount() + Double.valueOf(this.getLeavesAmt());
    }

    public final void setEffectOrderAmt(double effectOrderAmt) {
        this.effectOrderAmtProperty().set(effectOrderAmt);
    }

    public final StringProperty strategyStringProperty() {
        return this.strategyString;
    }

    public final String getStrategyString() {
        return (String)this.strategyStringProperty().get();
    }

    public final void setStrategyString(String strategyString) {
        this.strategyStringProperty().set((Object)strategyString);
    }

    public ObjectProperty<MxNode> algoNameProperty() {
        return this.algoName;
    }

    public MxNode getAlgoName() {
        if (this.getType().getRaw().equals("12")) {
            MxNode node = MxNodeFactory.createNew((String)"basket_algorithm_type", (String)String.valueOf(this.getBasketOrderAdvice().getAlgoTypeBuy()));
            node.setRaw(String.valueOf(this.getBasketOrderAdvice().getAlgoTypeBuy()));
            return node;
        }
        return (MxNode)this.algoNameProperty().get();
    }

    public void setAlgoName(MxNode algoName) {
        this.algoNameProperty().set((Object)algoName);
    }

    public final StringProperty levelInfoProperty() {
        return this.levelInfo;
    }

    public final String getLevelInfo() {
        return (String)this.levelInfoProperty().get();
    }

    public final void setLevelInfo(String levelInfo) {
        this.levelInfoProperty().set((Object)levelInfo);
    }

    public final StringProperty transferMethodProperty() {
        return this.transferMethod;
    }

    public final String getTransferMethod() {
        return (String)this.transferMethodProperty().get();
    }

    public final void setTransferMethod(String transferMethod) {
        this.transferMethodProperty().set((Object)transferMethod);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty securityTypeProperty() {
        return this.securityType;
    }

    public final String getSecurityType() {
        return (String)this.securityTypeProperty().get();
    }

    public final void setSecurityType(String securityType) {
        this.securityTypeProperty().set((Object)securityType);
    }

    public final DoubleProperty tradeAmountProperty() {
        return this.tradeAmount;
    }

    public final double getTradeAmount() {
        return this.tradeAmountProperty().get();
    }

    public final void setTradeAmount(double tradeAmount) {
        this.tradeAmountProperty().set(tradeAmount);
    }

    public final StringProperty basketNameProperty() {
        return this.basketName;
    }

    public final String getBasketName() {
        return (String)this.basketNameProperty().get();
    }

    public final void setBasketName(String basketName) {
        this.basketNameProperty().set((Object)basketName);
    }

    public final DoubleProperty plAmountProperty() {
        return this.plAmount;
    }

    public final double getPlAmount() {
        return this.plAmountProperty().get();
    }

    public final void setPlAmount(double plAmount) {
        this.plAmountProperty().set(plAmount);
    }

    public final StringProperty priceTypeProperty() {
        return this.priceType;
    }

    public final String getPriceType() {
        return (String)this.priceTypeProperty().get();
    }

    public final void setPriceType(String priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public final DoubleProperty orderPriceProperty() {
        return this.orderPrice;
    }

    public final double getOrderPrice() {
        return this.orderPriceProperty().get();
    }

    public final void setOrderPrice(double orderPrice) {
        this.orderPriceProperty().set(orderPrice);
    }

    public final StringProperty priceLimitProperty() {
        return this.priceLimit;
    }

    public final String getPriceLimit() {
        return (String)this.priceLimitProperty().get();
    }

    public final void setPriceLimit(String priceLimit) {
        this.priceLimitProperty().set((Object)priceLimit);
    }

    public BooleanProperty distributeSelectedProperty() {
        return this.distributeSelected;
    }

    public boolean isDistributeSelected() {
        return this.distributeSelectedProperty().get();
    }

    public void setDistributeSelected(boolean distributeSelected) {
        this.distributeSelectedProperty().set(distributeSelected);
    }

    public final BooleanProperty orderSelectedProperty() {
        return this.orderSelected;
    }

    public final boolean isOrderSelected() {
        return this.orderSelectedProperty().get();
    }

    public final void setOrderSelected(boolean orderSelected) {
        this.orderSelectedProperty().set(orderSelected);
    }

    public final LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public ObjectProperty<List<ActionInfo>> actionListProperty() {
        return this.actionList;
    }

    public List<ActionInfo> getActionList() {
        return (List)this.actionListProperty().get();
    }

    public void setActionList(List<ActionInfo> actionList) {
        this.actionListProperty().set(actionList);
    }

    public StringProperty securityCodeProperty() {
        return this.securityCode;
    }

    public String getSecurityCode() {
        return (String)this.securityCodeProperty().get();
    }

    public void setSecurityCode(String securityCode) {
        this.securityCodeProperty().set((Object)securityCode);
    }

    public StringProperty exTypeProperty() {
        return this.exType;
    }

    public String getExType() {
        return (String)this.exTypeProperty().get();
    }

    public void setExType(String exType) {
        this.exTypeProperty().set((Object)exType);
    }

    public SimpleStringProperty statusNameProperty() {
        return this.statusName;
    }

    public String getStatusName() {
        return this.statusNameProperty().get();
    }

    public void setStatusName(String statusName) {
        this.statusNameProperty().set(statusName);
    }

    public final SimpleStringProperty oprAndStatusProperty() {
        return this.oprAndStatus;
    }

    public final String getOprAndStatus() {
        return this.oprAndStatusProperty().get();
    }

    public final void setOprAndStatus(String oprAndStatus) {
        this.oprAndStatusProperty().set(oprAndStatus);
    }

    public SimpleStringProperty insEndTimeProperty() {
        return this.insEndTime;
    }

    public String getInsEndTime() {
        return this.insEndTimeProperty().get();
    }

    public void setInsEndTime(String insEndTime) {
        this.insEndTimeProperty().set(insEndTime);
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public SimpleStringProperty hisStatusProperty() {
        return this.hisStatus;
    }

    public String getHisStatus() {
        return this.hisStatusProperty().get();
    }

    public void setHisStatus(String hisStatus) {
        this.hisStatusProperty().set(hisStatus);
    }

    public final DoubleProperty ordRatioProperty() {
        return this.ordRatio;
    }

    public final double getOrdRatio() {
        return this.ordRatioProperty().get();
    }

    public final void setOrdRatio(double ordRatio) {
        this.ordRatioProperty().set(ordRatio);
    }

    public final StringProperty lastCallerProperty() {
        return this.lastCaller;
    }

    public final String getLastCaller() {
        return (String)this.lastCallerProperty().get();
    }

    public final void setLastCaller(String lastCaller) {
        this.lastCallerProperty().set((Object)lastCaller);
    }

    public StringProperty marketNameProperty() {
        return this.marketName;
    }

    public String getMarketName() {
        return (String)this.marketNameProperty().get();
    }

    public void setMarketName(String marketName) {
        this.marketNameProperty().set((Object)marketName);
    }

    public final StringProperty leaveMessagesProperty() {
        return this.leaveMessages;
    }

    public final String getLeaveMessages() {
        return (String)this.leaveMessagesProperty().get();
    }

    public final void setLeaveMessages(String leaveMessages) {
        this.leaveMessagesProperty().set((Object)leaveMessages);
    }

    public boolean isMail() {
        return this.getDescId() == WorkflowTemplete.MAIL.getId();
    }
}

