/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.message.PInstruction;
import cms.tmx.javafx.obj.MxSelObj;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BasketSecurityInst
extends MxSelObj {
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty symbol = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private IntegerProperty side = new SimpleIntegerProperty();
    private StringProperty securityType = new SimpleStringProperty("");
    private DoubleProperty orderPrice = new SimpleDoubleProperty();
    private DoubleProperty orderQty = new SimpleDoubleProperty();
    private double orderAmount;
    private DoubleProperty weight = new SimpleDoubleProperty();
    private StringProperty extAccntId = new SimpleStringProperty("");
    private StringProperty extSecAccntId = new SimpleStringProperty("");
    private StringProperty subAccntId = new SimpleStringProperty("");
    private StringProperty subSecAccntId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty parentId = new SimpleStringProperty("");
    private StringProperty subParentId = new SimpleStringProperty("");
    private DoubleProperty sampleQty = new SimpleDoubleProperty();
    private DoubleProperty relativeWeight = new SimpleDoubleProperty(0.0);
    private DoubleProperty fixedPrice = new SimpleDoubleProperty();
    private double limitPriceUp = 0.0;
    private double limitPriceLow = 0.0;
    private String clOrderId = "";

    public void update(Object obj) {
        if (obj instanceof BasketSecurityInst) {
            this.update((BasketSecurityInst)((Object)BasketSecurityInst.class.cast(obj)));
        } else if (obj instanceof PInstruction.BasketSecurityInst) {
            PInstruction.BasketSecurityInst basket = (PInstruction.BasketSecurityInst)PInstruction.BasketSecurityInst.class.cast(obj);
            this.update(basket);
        }
    }

    private void update(PInstruction.BasketSecurityInst basket) {
        this.setSecurityId(basket.getSecurityId());
        this.setSymbol(basket.getSymbol());
        this.setMarket(basket.getMarket());
        this.setSide(basket.getSide());
        this.setSecurityType(basket.getSecurityType());
        this.setOrderPrice(new BigDecimal(Double.toString(basket.getOrderPrice())).doubleValue());
        this.setOrderQty(basket.getOrderQty());
        this.setWeight(basket.getWeight());
        this.setExtAccntId(basket.getExtAccntId());
        this.setExtSecAccntId(basket.getExtSecAccntId());
        this.setSubAccntId(basket.getSubAccntId());
        this.setSubSecAccntId(basket.getSubSecAccntId());
        this.setInvestorId(basket.getInvestorId());
        this.setSelected(basket.getSelected());
        this.setParentId(basket.getParentId());
        this.setSubParentId(basket.getSubParentId());
        this.setSampleQty(basket.getSampleQty());
        this.setRelativeWeight(basket.getRelativeWeight());
        this.setFixedPrice(new BigDecimal(Double.toString(basket.getFixedPrice())).doubleValue());
        this.setClOrderId(basket.getClOrdId());
        this.setLimitPriceUp(basket.getPriceUpperLimit());
        this.setLimitPriceLow(basket.getPriceLowerLimit());
    }

    private void update(BasketSecurityInst basket) {
        this.setSecurityId(basket.getSecurityId());
        this.setSymbol(basket.getSymbol());
        this.setMarket(basket.getMarket());
        this.setSide(basket.getSide());
        this.setSecurityType(basket.getSecurityType());
        this.setOrderPrice(basket.getOrderPrice());
        this.setOrderQty(basket.getOrderQty());
        this.setWeight(basket.getWeight());
        this.setExtAccntId(basket.getExtAccntId());
        this.setExtSecAccntId(basket.getExtSecAccntId());
        this.setSubAccntId(basket.getSubAccntId());
        this.setSubSecAccntId(basket.getSubSecAccntId());
        this.setInvestorId(basket.getInvestorId());
        this.setSelected(basket.isSelected());
        this.setParentId(basket.getParentId());
        this.setSubParentId(basket.getSubParentId());
        this.setSampleQty(basket.getSampleQty());
        this.setRelativeWeight(basket.getRelativeWeight());
        this.setFixedPrice(basket.getFixedPrice());
        this.setClOrderId(basket.getClOrderId());
        this.setLimitPriceUp(basket.getLimitPriceUp());
        this.setLimitPriceLow(basket.getLimitPriceLow());
    }

    public PInstruction.BasketSecurityInst.Builder getBuilder() {
        PInstruction.BasketSecurityInst.Builder bsktB = PInstruction.BasketSecurityInst.newBuilder();
        bsktB.setSecurityId(this.getSecurityId());
        bsktB.setSymbol(this.getSymbol());
        bsktB.setParentId(this.getParentId());
        bsktB.setSubParentId(this.getSubParentId());
        bsktB.setMarket(this.getMarket());
        bsktB.setSide(this.getSide());
        bsktB.setSecurityType(this.getSecurityType());
        bsktB.setOrderPrice(this.getOrderPrice());
        bsktB.setOrderQty(this.getOrderQty());
        bsktB.setWeight(this.getWeight());
        bsktB.setExtAccntId(this.getExtAccntId());
        bsktB.setExtSecAccntId(this.getExtSecAccntId());
        bsktB.setSubAccntId(this.getSubAccntId());
        bsktB.setSubSecAccntId(this.getSubSecAccntId());
        bsktB.setInvestorId(this.getInvestorId());
        bsktB.setSelected(this.isSelected());
        bsktB.setSampleQty(this.getSampleQty());
        bsktB.setRelativeWeight(this.getRelativeWeight());
        bsktB.setFixedPrice(this.getFixedPrice());
        bsktB.setClOrdId(this.getClOrderId());
        bsktB.setPriceUpperLimit(this.getLimitPriceUp());
        bsktB.setPriceLowerLimit(this.getLimitPriceLow());
        return bsktB;
    }

    public StringProperty securityIdProperty() {
        return this.securityId;
    }

    public String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public StringProperty symbolProperty() {
        return this.symbol;
    }

    public String getSymbol() {
        return (String)this.symbolProperty().get();
    }

    public void setSymbol(String symbol) {
        this.symbolProperty().set((Object)symbol);
    }

    public StringProperty marketProperty() {
        return this.market;
    }

    public String getMarket() {
        return (String)this.marketProperty().get();
    }

    public void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public IntegerProperty sideProperty() {
        return this.side;
    }

    public int getSide() {
        return this.sideProperty().get();
    }

    public void setSide(int side) {
        this.sideProperty().set(side);
    }

    public StringProperty securityTypeProperty() {
        return this.securityType;
    }

    public String getSecurityType() {
        return (String)this.securityTypeProperty().get();
    }

    public void setSecurityType(String securityType) {
        this.securityTypeProperty().set((Object)securityType);
    }

    public DoubleProperty orderPriceProperty() {
        return this.orderPrice;
    }

    public double getOrderPrice() {
        return this.orderPriceProperty().get();
    }

    public void setOrderPrice(double orderPrice) {
        this.orderPriceProperty().set(orderPrice);
    }

    public DoubleProperty orderQtyProperty() {
        return this.orderQty;
    }

    public double getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public void setOrderQty(double orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public DoubleProperty weightProperty() {
        return this.weight;
    }

    public double getWeight() {
        return this.weightProperty().get();
    }

    public void setWeight(double weight) {
        this.weightProperty().set(weight);
    }

    public StringProperty extAccntIdProperty() {
        return this.extAccntId;
    }

    public String getExtAccntId() {
        return (String)this.extAccntIdProperty().get();
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntIdProperty().set((Object)extAccntId);
    }

    public StringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public String getExtSecAccntId() {
        return (String)this.extSecAccntIdProperty().get();
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set((Object)extSecAccntId);
    }

    public StringProperty subAccntIdProperty() {
        return this.subAccntId;
    }

    public String getSubAccntId() {
        return (String)this.subAccntIdProperty().get();
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntIdProperty().set((Object)subAccntId);
    }

    public StringProperty subSecAccntIdProperty() {
        return this.subSecAccntId;
    }

    public String getSubSecAccntId() {
        return (String)this.subSecAccntIdProperty().get();
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntIdProperty().set((Object)subSecAccntId);
    }

    public StringProperty investorIdProperty() {
        return this.investorId;
    }

    public String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public StringProperty parentIdProperty() {
        return this.parentId;
    }

    public String getParentId() {
        return (String)this.parentIdProperty().get();
    }

    public void setParentId(String parentId) {
        this.parentIdProperty().set((Object)parentId);
    }

    public DoubleProperty sampleQtyProperty() {
        return this.sampleQty;
    }

    public double getSampleQty() {
        return this.sampleQtyProperty().get();
    }

    public void setSampleQty(double sampleQty) {
        this.sampleQtyProperty().set(sampleQty);
    }

    public DoubleProperty relativeWeightProperty() {
        return this.relativeWeight;
    }

    public double getRelativeWeight() {
        return this.relativeWeightProperty().get();
    }

    public void setRelativeWeight(double relativeWeight) {
        this.relativeWeightProperty().set(relativeWeight);
    }

    public DoubleProperty fixedPriceProperty() {
        return this.fixedPrice;
    }

    public double getFixedPrice() {
        return this.fixedPriceProperty().get();
    }

    public void setFixedPrice(double fixedPrice) {
        this.fixedPriceProperty().set(fixedPrice);
    }

    public StringProperty subParentIdProperty() {
        return this.subParentId;
    }

    public String getSubParentId() {
        return (String)this.subParentIdProperty().get();
    }

    public void setSubParentId(String subParentId) {
        this.subParentIdProperty().set((Object)subParentId);
    }

    public String getClOrderId() {
        return this.clOrderId;
    }

    public void setClOrderId(String clOrderId) {
        this.clOrderId = clOrderId;
    }

    public double getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public double getLimitPriceUp() {
        return this.limitPriceUp;
    }

    public void setLimitPriceUp(double limitPriceUp) {
        this.limitPriceUp = limitPriceUp;
    }

    public double getLimitPriceLow() {
        return this.limitPriceLow;
    }

    public void setLimitPriceLow(double limitPriceLow) {
        this.limitPriceLow = limitPriceLow;
    }
}

