/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketOrderAdvice
extends MxModel {
    private StringProperty basketId = new SimpleStringProperty("");
    private StringProperty basketName = new SimpleStringProperty("");
    private IntegerProperty side = new SimpleIntegerProperty();
    private IntegerProperty priceType = new SimpleIntegerProperty();
    private DoubleProperty floatPrice = new SimpleDoubleProperty();
    private DoubleProperty floatPercent = new SimpleDoubleProperty();
    private IntegerProperty strategyType = new SimpleIntegerProperty();
    private DoubleProperty strategyValue = new SimpleDoubleProperty();
    private BooleanProperty usePosition = new SimpleBooleanProperty(false);
    private BooleanProperty autoSell = new SimpleBooleanProperty(false);
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty productId = new SimpleStringProperty("");
    private StringProperty productName = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private List<BasketSecurityInst> itemList = new LinkedList<BasketSecurityInst>();
    private List<InstructionExec> exeList = new LinkedList<InstructionExec>();
    private StringProperty flowAttriId = new SimpleStringProperty("");
    private StringProperty stepAttrId = new SimpleStringProperty("");
    private IntegerProperty instructionType = new SimpleIntegerProperty();
    private StringProperty instructionPanelType = new SimpleStringProperty("");
    private LongProperty orderQty = new SimpleLongProperty();
    private double amount;
    private String postil = "";
    private static final int maxWaitTime = 10000;
    private IntegerProperty algoTypeBuy = new SimpleIntegerProperty();
    private IntegerProperty algoTypeSell = new SimpleIntegerProperty();
    private ObjectProperty<AlgoParam> algoParamBuy = new SimpleObjectProperty((Object)new AlgoParam());
    private ObjectProperty<AlgoParam> algoParamSell = new SimpleObjectProperty((Object)new AlgoParam());
    private String clListId = "";
    private String insExpiredDate = "";
    @Inject
    private IInstructionApi insApi;
    @Inject
    private ExecutorService exe;
    @Inject
    private IBaseApi baseApi;
    private AtomicInteger cfmPacks = new AtomicInteger(0);
    private AtomicInteger packIndex = new AtomicInteger(1);
    private MException exception = null;
    private String uuid = "";
    private String instructionId = "";
    private String fixedPriceLimit = "";
    private boolean canModify = false;
    private List<String> traderUserIds = new ArrayList<String>();

    public InstructionSubmitResult submit() throws MException {
        InstructionSubmitResult result = new InstructionSubmitResult();
        this.initParam();
        if (this.itemList == null || this.itemList.isEmpty()) {
            return result;
        }
        long startTime = System.currentTimeMillis();
        PBase.Fragment fragment = this.baseApi.getFragment(this.itemList.size());
        int index = 0;
        while (this.packIndex.intValue() <= fragment.getTotalFragNum()) {
            int endIndex = index + 150 > fragment.getTotalDataNum() ? fragment.getTotalDataNum() - 1 : index + 150 - 1;
            List<BasketSecurityInst> fragOrderList = this.itemList.subList(index, endIndex + 1);
            this.exe.execute(() -> {
                try {
                    this.fragmentSubmit(fragOrderList, fragment);
                }
                catch (MException e) {
                    this.exception = e;
                }
            });
            index += 150;
            this.packIndex.getAndIncrement();
        }
        while (this.cfmPacks.intValue() < fragment.getTotalFragNum()) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (System.currentTimeMillis() - startTime <= 10000L) continue;
            throw new MException(-1, "\u8d85\u65f6");
        }
        String reason = "";
        if (!StringUtils.isEmpty((String)this.instructionId)) {
            reason = this.insApi.submitInstruction(this.instructionId, this.getPostil());
        }
        result.setInstructionId(this.instructionId);
        result.setReason(reason);
        return result;
    }

    private void initParam() {
        this.uuid = UUID.randomUUID().toString();
        this.packIndex = new AtomicInteger(1);
        this.cfmPacks = new AtomicInteger(0);
        this.exception = null;
    }

    private void fragmentSubmit(List<BasketSecurityInst> fragOrderList, PBase.Fragment fragment) throws MException {
        Any any = this.buildAny(fragOrderList);
        PInstruction.Instruction.Builder insb = PInstruction.Instruction.newBuilder();
        insb.setName(this.getBasketName());
        insb.setPortfolioId((String)this.portfolioId.get());
        insb.setProductId((String)this.productId.get());
        insb.setStepAttrId(this.getStepAttrId());
        insb.setFlowAttrId(this.getFlowAttriId());
        insb.setDetails(any);
        insb.setHasExecSwitchPermit(this.isCanModify());
        insb.setType(this.getInstructionType());
        insb.setClInstructionId(this.getClListId());
        insb.setEstimatedOrderAmount(this.getAmount());
        insb.addAllAuthorizer(this.getTraderUserIds());
        if (StringUtils.isEmpty((String)this.getInsExpiredDate())) {
            insb.setExpireDate(DateTimeUtils.getDate());
        } else {
            insb.setExpireDate(this.getInsExpiredDate());
        }
        int actionId = 0;
        if ("2".equals(this.instructionPanelType.get())) {
            actionId = 20;
        } else if ("1".equals(this.instructionPanelType.get())) {
            actionId = 21;
        }
        this.instructionId = this.insApi.newInstruction(insb.build(), fragment, this.uuid, actionId);
        this.cfmPacks.getAndIncrement();
    }

    public Any buildAny(List<BasketSecurityInst> fragOrderList) {
        switch (this.instructionType.get()) {
            case 4: {
                return this.buildBasketOrderAdvice(fragOrderList);
            }
            case 5: {
                return this.buildBasketOrderAdvice(fragOrderList);
            }
            case 12: 
            case 13: {
                return this.builderBasketAlgoOrderAdvice(fragOrderList);
            }
        }
        return null;
    }

    private Any buildBasketOrderAdvice(List<BasketSecurityInst> fragOrderList) {
        PInstruction.BasketOrderAdvice.Builder bsoa = PInstruction.BasketOrderAdvice.newBuilder();
        bsoa.setBasketId((String)this.basketId.get());
        bsoa.setBasketName((String)this.basketName.get());
        bsoa.setSide(PInstruction.BasketSide.forNumber((int)this.side.get()));
        bsoa.setPriceTypeValue(this.packPriceType());
        bsoa.setFloatPrice(this.floatPrice.get());
        bsoa.setFloatPercent(this.floatPercent.get());
        bsoa.setFixedPriceLimit(PInstruction.FixedPriceLimit.forNumber((int)Integer.valueOf(this.fixedPriceLimit)));
        bsoa.setStrategyType(PInstruction.BasketStrategyType.forNumber((int)this.strategyType.get()));
        bsoa.setStrategyValue(this.strategyValue.get());
        bsoa.setUsePosition(this.usePosition.get());
        bsoa.setAutoSell(this.autoSell.get());
        bsoa.setTotalExpectationQty((double)this.orderQty.get());
        bsoa.setInvestorId((String)this.investorId.get());
        for (BasketSecurityInst bsktInst : fragOrderList) {
            PInstruction.BasketSecurityInst.Builder builder = bsktInst.getBuilder();
            builder.setEstimatedOrderAmount(bsktInst.getOrderAmount());
            bsoa.addBasketSecurityInst(builder.build());
        }
        Any any = Any.pack((Message)bsoa.build());
        return any;
    }

    private Any builderBasketAlgoOrderAdvice(List<BasketSecurityInst> fragOrderList) {
        PInstruction.BasketAlgoOrderAdvice.Builder builder = PInstruction.BasketAlgoOrderAdvice.newBuilder();
        builder.setBasketId((String)this.basketId.get());
        builder.setBasketName((String)this.basketName.get());
        builder.setSide(PInstruction.BasketSide.forNumber((int)this.side.get()));
        builder.setPriceTypeValue(this.packPriceType());
        builder.setFloatPrice(this.floatPrice.get());
        builder.setFloatPercent(this.floatPercent.get());
        builder.setFixedPriceLimit(PInstruction.FixedPriceLimit.forNumber((int)Integer.valueOf(this.fixedPriceLimit)));
        builder.setStrategyType(PInstruction.BasketStrategyType.forNumber((int)this.strategyType.get()));
        builder.setStrategyValue(this.strategyValue.get());
        builder.setUsePosition(this.usePosition.get());
        builder.setAutoSell(this.autoSell.get());
        builder.setTotalExpectationQty((double)this.orderQty.get());
        builder.setInvestorId((String)this.investorId.get());
        builder.setBuyAlgorithmTypeValue(this.getAlgoTypeBuy());
        builder.setSellAlgorithmTypeValue(this.getAlgoTypeSell());
        builder.setBuyAlgorithmParam(this.packAlgoParam(this.getAlgoTypeBuy(), (AlgoParam)((Object)this.algoParamBuy.getValue())));
        builder.setSellAlgorithmParam(this.packAlgoParam(this.getAlgoTypeSell(), (AlgoParam)((Object)this.algoParamSell.getValue())));
        for (BasketSecurityInst bsktInst : fragOrderList) {
            PInstruction.BasketSecurityInst.Builder builder1 = bsktInst.getBuilder();
            builder1.setEstimatedOrderAmount(bsktInst.getOrderAmount());
            builder.addBasketSecurityInst(builder1.build());
        }
        Any any = Any.pack((Message)builder.build());
        return any;
    }

    private int packPriceType() {
        int pType = this.getPriceType();
        switch (pType) {
            case 100: {
                return pType;
            }
            case -100: {
                return 99;
            }
        }
        return pType + 11;
    }

    private int parsePriceType(int priceType) {
        switch (priceType) {
            case 100: {
                return priceType;
            }
            case 99: {
                return -100;
            }
        }
        return priceType - 11;
    }

    private Any packAlgoParam(int type, AlgoParam param) {
        Any any;
        switch (type) {
            case 14: {
                PAlgorithmTrade.BasketTradingParam.Builder bskBuy = PAlgorithmTrade.BasketTradingParam.newBuilder();
                bskBuy.setMisePriceTypeValue(Integer.valueOf(param.getPriceterms().getRaw()).intValue());
                bskBuy.setAbovePriceRate(param.getExceedPrice());
                bskBuy.setMiseVolTypeValue(Integer.valueOf(param.getDatumQty().getRaw()).intValue());
                bskBuy.setBaseVolRate(param.getDatumPercent());
                bskBuy.setEntrustInterval(param.getOrderIntevel());
                bskBuy.setWithdrawInterval(param.getCancelIntevel());
                bskBuy.setAbovePriceIndex(param.getMinitabQty());
                bskBuy.setPriceLimitRange(param.getWaveRang());
                bskBuy.setMinOrderVol(param.getMinQty());
                bskBuy.setMaxOrderVol(param.getMaxQty());
                bskBuy.setStartHour(param.getStartHour());
                bskBuy.setEndHour(param.getEndHour());
                bskBuy.setStartMinute(param.getStartMinute());
                bskBuy.setEndMinute(param.getEndMinute());
                bskBuy.setMaxEntrustNum(param.getOrderTime());
                any = Any.pack((Message)bskBuy.build());
                break;
            }
            case 15: 
            case 16: {
                PAlgorithmTrade.WapAlgoParam.Builder wapBuy = PAlgorithmTrade.WapAlgoParam.newBuilder();
                wapBuy.setStartHour(param.getStartHour());
                wapBuy.setEndHour(param.getEndHour());
                wapBuy.setStartMinute(param.getStartMinute());
                wapBuy.setEndMinute(param.getEndMinute());
                wapBuy.setAlgoBehaviorLevelValue(param.getAggress());
                wapBuy.setTimeSliceCount(param.getSlice());
                any = Any.pack((Message)wapBuy.build());
                break;
            }
            default: {
                PAlgorithmTrade.HighLowLimitWapParam.Builder limit = PAlgorithmTrade.HighLowLimitWapParam.newBuilder();
                limit.setStartHour(param.getStartHour());
                limit.setEndHour(param.getEndHour());
                limit.setStartMinute(param.getStartMinute());
                limit.setEndMinute(param.getEndMinute());
                limit.setAlgoBehaviorLevelValue(param.getAggress());
                limit.setTimeSliceCount(param.getSlice());
                any = Any.pack((Message)limit.build());
            }
        }
        return any;
    }

    public void update(Object obj) {
        if (obj instanceof PInstruction.BasketOrderAdvice) {
            this.update((PInstruction.BasketOrderAdvice)PInstruction.BasketOrderAdvice.class.cast(obj));
        } else if (obj instanceof BasketOrderAdvice) {
            this.update((BasketOrderAdvice)((Object)BasketOrderAdvice.class.cast(obj)));
        } else if (obj instanceof PInstruction.BasketAlgoOrderAdvice) {
            try {
                this.update((PInstruction.BasketAlgoOrderAdvice)PInstruction.BasketAlgoOrderAdvice.class.cast(obj));
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
    }

    private void update(BasketOrderAdvice boa) {
        this.setBasketId(boa.getBasketId());
        this.setBasketName(boa.getBasketName());
        this.setSide(boa.getSide());
        this.setPriceType(boa.getPriceType());
        this.setFloatPrice(boa.getFloatPrice());
        this.setFloatPercent(boa.getFloatPercent());
        this.setStrategyType(boa.getStrategyType());
        this.setStrategyValue(boa.getStrategyValue());
        this.setUsePosition(boa.isUsePosition());
        this.setAutoSell(boa.isAutoSell());
        this.setFlowAttriId(boa.getFlowAttriId());
        this.setStepAttrId(boa.getStepAttrId());
        this.setInstructionType(boa.getInstructionType());
        this.setPortfolioId(boa.getProductId());
        this.setPortfolioName(boa.getPortfolioName());
        this.setProductId(boa.getProductId());
        this.setProductName(boa.getProductName());
        this.setInvestorId(boa.getInvestorId());
        this.setOrderQty(boa.getOrderQty());
        this.setAmount(boa.getAmount());
        this.setAlgoTypeBuy(boa.getAlgoTypeBuy());
        this.setAlgoTypeSell(boa.getAlgoTypeSell());
        this.setFixedPriceLimit(boa.getFixedPriceLimit());
        this.getAlgoParamBuy().update((Object)boa.getAlgoParamBuy());
        this.getAlgoParamSell().update((Object)boa.getAlgoParamSell());
        if (this.getItemList() == boa.getItemList() || boa.getItemList().isEmpty()) {
            return;
        }
        this.getItemList().clear();
        for (BasketSecurityInst basketSecurityInst : boa.getItemList()) {
            BasketSecurityInst basketInst = new BasketSecurityInst();
            basketInst.update((Object)basketSecurityInst);
            this.getItemList().add(basketInst);
        }
    }

    private void update(PInstruction.BasketOrderAdvice boa) {
        this.setBasketId(boa.getBasketId());
        this.setBasketName(boa.getBasketName());
        this.setSide(boa.getSideValue());
        this.setPriceType(this.parsePriceType(boa.getPriceTypeValue()));
        this.setFloatPrice(boa.getFloatPrice());
        this.setFloatPercent(boa.getFloatPercent());
        this.setStrategyType(boa.getStrategyTypeValue());
        this.setStrategyValue(boa.getStrategyValue());
        this.setUsePosition(boa.getUsePosition());
        this.setAutoSell(boa.getAutoSell());
        this.setOrderQty(Double.valueOf(boa.getTotalExpectationQty()).longValue());
        this.setInvestorId(boa.getInvestorId());
        this.setFixedPriceLimit(String.valueOf(boa.getFixedPriceLimit().getNumber()));
    }

    private void update(PInstruction.BasketAlgoOrderAdvice boa) throws InvalidProtocolBufferException {
        this.setBasketId(boa.getBasketId());
        this.setBasketName(boa.getBasketName());
        this.setSide(boa.getSideValue());
        this.setPriceType(this.parsePriceType(boa.getPriceTypeValue()));
        this.setFloatPrice(boa.getFloatPrice());
        this.setFloatPercent(boa.getFloatPercent());
        this.setStrategyType(boa.getStrategyTypeValue());
        this.setStrategyValue(boa.getStrategyValue());
        this.setUsePosition(boa.getUsePosition());
        this.setAutoSell(boa.getAutoSell());
        this.setOrderQty(Double.valueOf(boa.getTotalExpectationQty()).longValue());
        this.setInvestorId(boa.getInvestorId());
        this.setAlgoTypeBuy(boa.getBuyAlgorithmTypeValue());
        this.setAlgoTypeSell(boa.getSellAlgorithmTypeValue());
        this.setAlgoParamBuy(this.parseAlgoParam(boa.getBuyAlgorithmParam()));
        this.setAlgoParamSell(this.parseAlgoParam(boa.getSellAlgorithmParam()));
        this.setFixedPriceLimit(String.valueOf(boa.getFixedPriceLimit().getNumber()));
    }

    private AlgoParam parseAlgoParam(Any any) throws InvalidProtocolBufferException {
        AlgoParam param = new AlgoParam();
        if (any.is(PAlgorithmTrade.BasketTradingParam.class)) {
            PAlgorithmTrade.BasketTradingParam bt = (PAlgorithmTrade.BasketTradingParam)any.unpack(PAlgorithmTrade.BasketTradingParam.class);
            param.getPriceterms().setRaw(String.valueOf(bt.getMisePriceTypeValue()));
            param.setExceedPrice(bt.getAbovePriceRate());
            param.getDatumQty().setRaw(String.valueOf(bt.getMiseVolTypeValue()));
            param.setDatumPercent(bt.getBaseVolRate());
            param.setOrderIntevel(bt.getEntrustInterval());
            param.setCancelIntevel(bt.getWithdrawInterval());
            param.setMinitabQty(bt.getAbovePriceIndex());
            param.setWaveRang(bt.getPriceLimitRange());
            param.setMinQty(bt.getMinOrderVol());
            param.setMaxQty(bt.getMaxOrderVol());
            param.setStartHour(bt.getStartHour());
            param.setStartMinute(bt.getStartMinute());
            param.setEndHour(bt.getEndHour());
            param.setEndMinute(bt.getEndMinute());
            param.setOrderTime(bt.getMaxEntrustNum());
            this.setAlgoParamSell(param);
        } else if (any.is(PAlgorithmTrade.WapAlgoParam.class)) {
            PAlgorithmTrade.WapAlgoParam bt = (PAlgorithmTrade.WapAlgoParam)any.unpack(PAlgorithmTrade.WapAlgoParam.class);
            param.setStartHour(bt.getStartHour());
            param.setStartMinute(bt.getStartMinute());
            param.setEndHour(bt.getEndHour());
            param.setEndMinute(bt.getEndMinute());
            param.setSlice(bt.getTimeSliceCount());
            param.setAggress(bt.getAlgoBehaviorLevelValue());
            this.setAlgoParamSell(param);
        } else if (any.is(PAlgorithmTrade.HighLowLimitWapParam.class)) {
            PAlgorithmTrade.HighLowLimitWapParam bt = (PAlgorithmTrade.HighLowLimitWapParam)any.unpack(PAlgorithmTrade.HighLowLimitWapParam.class);
            param.setStartHour(bt.getStartHour());
            param.setStartMinute(bt.getStartMinute());
            param.setEndHour(bt.getEndHour());
            param.setEndMinute(bt.getEndMinute());
            param.setSlice(bt.getTimeSliceCount());
            param.setAggress(bt.getAlgoBehaviorLevelValue());
            this.setAlgoParamSell(param);
        }
        return param;
    }

    public StringProperty basketIdProperty() {
        return this.basketId;
    }

    public String getBasketId() {
        return (String)this.basketIdProperty().get();
    }

    public void setBasketId(String basketId) {
        this.basketIdProperty().set((Object)basketId);
    }

    public StringProperty basketNameProperty() {
        return this.basketName;
    }

    public String getBasketName() {
        return (String)this.basketNameProperty().get();
    }

    public void setBasketName(String basketName) {
        this.basketNameProperty().set((Object)basketName);
    }

    public IntegerProperty sideProperty() {
        return this.side;
    }

    public int getSide() {
        return this.sideProperty().get();
    }

    public void setSide(int side) {
        this.sideProperty().set(side);
    }

    public IntegerProperty priceTypeProperty() {
        return this.priceType;
    }

    public int getPriceType() {
        return this.priceTypeProperty().get();
    }

    public void setPriceType(int priceType) {
        this.priceTypeProperty().set(priceType);
    }

    public DoubleProperty floatPriceProperty() {
        return this.floatPrice;
    }

    public double getFloatPrice() {
        return this.floatPriceProperty().get();
    }

    public void setFloatPrice(double floatPrice) {
        this.floatPriceProperty().set(floatPrice);
    }

    public DoubleProperty floatPercentProperty() {
        return this.floatPercent;
    }

    public double getFloatPercent() {
        return this.floatPercentProperty().get();
    }

    public void setFloatPercent(double floatPercent) {
        this.floatPercentProperty().set(floatPercent);
    }

    public IntegerProperty strategyTypeProperty() {
        return this.strategyType;
    }

    public int getStrategyType() {
        return this.strategyTypeProperty().get();
    }

    public void setStrategyType(int strategyType) {
        this.strategyTypeProperty().set(strategyType);
    }

    public DoubleProperty strategyValueProperty() {
        return this.strategyValue;
    }

    public double getStrategyValue() {
        return this.strategyValueProperty().get();
    }

    public void setStrategyValue(double strategyValue) {
        this.strategyValueProperty().set(strategyValue);
    }

    public BooleanProperty usePositionProperty() {
        return this.usePosition;
    }

    public boolean isUsePosition() {
        return this.usePositionProperty().get();
    }

    public void setUsePosition(boolean usePosition) {
        this.usePositionProperty().set(usePosition);
    }

    public BooleanProperty autoSellProperty() {
        return this.autoSell;
    }

    public boolean isAutoSell() {
        return this.autoSellProperty().get();
    }

    public void setAutoSell(boolean autoSell) {
        this.autoSellProperty().set(autoSell);
    }

    public StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public StringProperty productIdProperty() {
        return this.productId;
    }

    public String getProductId() {
        return (String)this.productIdProperty().get();
    }

    public void setProductId(String productId) {
        this.productIdProperty().set((Object)productId);
    }

    public StringProperty productNameProperty() {
        return this.productName;
    }

    public String getProductName() {
        return (String)this.productNameProperty().get();
    }

    public void setProductName(String productName) {
        this.productNameProperty().set((Object)productName);
    }

    public StringProperty flowAttriIdProperty() {
        return this.flowAttriId;
    }

    public String getFlowAttriId() {
        return (String)this.flowAttriIdProperty().get();
    }

    public void setFlowAttriId(String flowAttriId) {
        this.flowAttriIdProperty().set((Object)flowAttriId);
    }

    public StringProperty stepAttrIdProperty() {
        return this.stepAttrId;
    }

    public String getStepAttrId() {
        return (String)this.stepAttrIdProperty().get();
    }

    public void setStepAttrId(String stepAttrId) {
        this.stepAttrIdProperty().set((Object)stepAttrId);
    }

    public IntegerProperty instructionTypeProperty() {
        return this.instructionType;
    }

    public int getInstructionType() {
        return this.instructionTypeProperty().get();
    }

    public void setInstructionType(int instructionType) {
        this.instructionTypeProperty().set(instructionType);
    }

    public List<BasketSecurityInst> getItemList() {
        return this.itemList;
    }

    public void setItemList(List<BasketSecurityInst> itemList) {
        this.itemList = itemList;
    }

    public LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public StringProperty instructionPanelTypeProperty() {
        return this.instructionPanelType;
    }

    public String getInstructionPanelType() {
        return (String)this.instructionPanelTypeProperty().get();
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelTypeProperty().set((Object)instructionPanelType);
    }

    public StringProperty investorIdProperty() {
        return this.investorId;
    }

    public String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final IntegerProperty algoTypeBuyProperty() {
        return this.algoTypeBuy;
    }

    public final int getAlgoTypeBuy() {
        return this.algoTypeBuyProperty().get();
    }

    public final void setAlgoTypeBuy(int algoTypeBuy) {
        this.algoTypeBuyProperty().set(algoTypeBuy);
    }

    public final IntegerProperty algoTypeSellProperty() {
        return this.algoTypeSell;
    }

    public final int getAlgoTypeSell() {
        return this.algoTypeSellProperty().get();
    }

    public final void setAlgoTypeSell(int algoTypeSell) {
        this.algoTypeSellProperty().set(algoTypeSell);
    }

    public final ObjectProperty<AlgoParam> algoParamBuyProperty() {
        return this.algoParamBuy;
    }

    public final AlgoParam getAlgoParamBuy() {
        return (AlgoParam)((Object)this.algoParamBuyProperty().get());
    }

    public final void setAlgoParamBuy(AlgoParam algoParamBuy) {
        this.algoParamBuyProperty().set((Object)algoParamBuy);
    }

    public final ObjectProperty<AlgoParam> algoParamSellProperty() {
        return this.algoParamSell;
    }

    public final AlgoParam getAlgoParamSell() {
        return (AlgoParam)((Object)this.algoParamSellProperty().get());
    }

    public final void setAlgoParamSell(AlgoParam algoParamSell) {
        this.algoParamSellProperty().set((Object)algoParamSell);
    }

    public List<InstructionExec> getExeList() {
        return this.exeList;
    }

    public void setExeList(List<InstructionExec> exeList) {
        this.exeList = exeList;
    }

    public String getClListId() {
        return this.clListId;
    }

    public void setClListId(String clListId) {
        this.clListId = clListId;
    }

    public String getPostil() {
        return this.postil;
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public final double getAmount() {
        return this.amount;
    }

    public final void setAmount(double amount) {
        this.amount = amount;
    }

    public String getInsExpiredDate() {
        return this.insExpiredDate;
    }

    public void setInsExpiredDate(String insExpiredDate) {
        this.insExpiredDate = insExpiredDate;
    }

    public String getFixedPriceLimit() {
        return this.fixedPriceLimit;
    }

    public void setFixedPriceLimit(String fixedPriceLimit) {
        this.fixedPriceLimit = fixedPriceLimit;
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public List<String> getTraderUserIds() {
        return this.traderUserIds;
    }

    public void setTraderUserIds(List<String> traderUserIds) {
        this.traderUserIds = traderUserIds;
    }
}

