/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AdjustPosAdvice
extends MxChgObj {
    private static final Logger logger = LogManager.getLogger(AdjustPosAdvice.class);
    private StringProperty basketId = new SimpleStringProperty("");
    private StringProperty basketName = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty productId = new SimpleStringProperty("");
    private StringProperty productName = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty secIdXshg = new SimpleStringProperty("");
    private StringProperty secIdXshe = new SimpleStringProperty("");
    private StringProperty flowAttriId = new SimpleStringProperty("");
    private StringProperty stepAttrId = new SimpleStringProperty("");
    private IntegerProperty instructionType = new SimpleIntegerProperty();
    private List<BasketAlgoItem> items = new LinkedList<BasketAlgoItem>();
    private List<InstructionExec> exes = new LinkedList<InstructionExec>();
    private LongProperty orderQty = new SimpleLongProperty();
    protected ObjectProperty<MxNode> adjType = new SimpleObjectProperty();
    protected ObjectProperty<MxNode> adjWay = new SimpleObjectProperty();
    private DoubleProperty countBsk = new SimpleDoubleProperty(1.0);
    private DoubleProperty moneyStg = new SimpleDoubleProperty();
    private DoubleProperty pctStg = new SimpleDoubleProperty();
    private BooleanProperty ptcStgBuy = new SimpleBooleanProperty(false);
    protected Basket basket = null;
    protected int adjScale = 0;
    protected AlgoParam algoParam = null;
    protected boolean controlMoney = false;
    protected double money = 0.0;
    protected int destPos = 0;
    protected boolean controlImpact = false;
    protected double percent = 10.0;
    protected String reference = "";
    protected String resource = "";
    protected String instructionPanelType = "";

    public AdjustPosAdvice() {
        MxNode node = MxNodeFactory.create((String)"adj_type", (String)"0");
        this.setAdjType(node);
        node = MxNodeFactory.create((String)"adj_way_type", (String)"1");
        this.setAdjWay(node);
    }

    public void update(Object obj) {
        if (obj instanceof PInstruction.AdjustPosAlgoOrderAdvice) {
            try {
                this.update((PInstruction.AdjustPosAlgoOrderAdvice)PInstruction.AdjustPosAlgoOrderAdvice.class.cast(obj));
            }
            catch (InvalidProtocolBufferException e) {
                logger.error((Object)e);
            }
        } else if (obj instanceof AdjustPosAdvice) {
            this.update((AdjustPosAdvice)((Object)AdjustPosAdvice.class.cast(obj)));
        }
    }

    private void update(AdjustPosAdvice boa) {
        this.setBasketId(boa.getBasketId());
        this.setBasketName(boa.getBasketName());
        this.setFlowAttriId(boa.getFlowAttriId());
        this.setStepAttrId(boa.getStepAttrId());
        this.setInstructionType(boa.getInstructionType());
        this.setPortfolioId(boa.getProductId());
        this.setPortfolioName(boa.getPortfolioName());
        this.setProductId(boa.getProductId());
        this.setProductName(boa.getProductName());
        this.setInvestorId(boa.getInvestorId());
        this.setOrderQty(boa.getOrderQty());
        if (this.getItems() == boa.getItems() || boa.getItems().isEmpty()) {
            return;
        }
        this.getItems().clear();
        for (BasketAlgoItem basketSecurityInst : boa.getItems()) {
            BasketAlgoItem basketInst = new BasketAlgoItem();
            basketInst.update((Object)basketSecurityInst);
            this.getItems().add(basketInst);
        }
    }

    private void update(PInstruction.AdjustPosAlgoOrderAdvice advice) throws InvalidProtocolBufferException {
        this.setInvestorId(advice.getInvestorId());
        this.setSecIdXshg(advice.getShgSecAccntId());
        this.setSecIdXshe(advice.getSheSecAccntId());
        this.setBasketId(advice.getBasketId());
        this.setBasketName(advice.getBasketName());
        this.getAdjType().setRaw(String.valueOf(advice.getAdjMethodValue()));
        this.getAdjWay().setRaw(String.valueOf(advice.getStrategyTypeValue()));
        if ("1".equals(this.getAdjWay().getRaw())) {
            this.setCountBsk(advice.getStrategyValue());
        } else if ("2".equals(this.getAdjWay().getRaw())) {
            this.setMoneyStg(advice.getStrategyValue());
        } else if ("7".equals(this.getAdjWay().getRaw())) {
            this.setPctStg(advice.getStrategyValue());
        }
        this.setAdjScale(advice.getAdjScaleValue());
        AlgoParam param = new AlgoParam();
        Any any = advice.getAlgorithmParam();
        if (any.is(PAlgorithmTrade.AdjustPosParam.class)) {
            PAlgorithmTrade.AdjustPosParam app = (PAlgorithmTrade.AdjustPosParam)any.unpack(PAlgorithmTrade.AdjustPosParam.class);
            param.setStartHour(app.getStartHour());
            param.setStartMinute(app.getStartMinute());
            param.setEndHour(app.getEndHour());
            param.setEndMinute(app.getEndMinute());
            param.setSlice(app.getTimeSliceCount());
            param.setDepth(app.getOrderDepth());
            param.setPercentDepth(app.getSweepRatio());
            param.setDelay(app.getWithdrawInterval());
        }
        this.setAlgoParam(param);
        this.setControlMoney(advice.getMoneyControl());
        this.setMoney(advice.getMoneyControlValue());
        this.setControlImpact(advice.getImpactControl());
        this.setPercent(advice.getImpactControlValue());
        for (PInstruction.AdjustPosSecInst inst : advice.getAdjustPosSecInstList()) {
            BasketAlgoItem basketInst = new BasketAlgoItem();
            basketInst.update((Object)inst);
            this.getItems().add(basketInst);
            if (!"7".equals(this.getAdjWay().getRaw())) continue;
            this.setPtcStgBuy(basketInst.isBs());
        }
        this.setOrderQty((int)advice.getTotalExpectationQty());
    }

    public final StringProperty basketIdProperty() {
        return this.basketId;
    }

    public final String getBasketId() {
        return (String)this.basketIdProperty().get();
    }

    public final void setBasketId(String basketId) {
        this.basketIdProperty().set((Object)basketId);
    }

    public final StringProperty basketNameProperty() {
        return this.basketName;
    }

    public final String getBasketName() {
        return (String)this.basketNameProperty().get();
    }

    public final void setBasketName(String basketName) {
        this.basketNameProperty().set((Object)basketName);
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public final StringProperty productIdProperty() {
        return this.productId;
    }

    public final String getProductId() {
        return (String)this.productIdProperty().get();
    }

    public final void setProductId(String productId) {
        this.productIdProperty().set((Object)productId);
    }

    public final StringProperty productNameProperty() {
        return this.productName;
    }

    public final String getProductName() {
        return (String)this.productNameProperty().get();
    }

    public final void setProductName(String productName) {
        this.productNameProperty().set((Object)productName);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty flowAttriIdProperty() {
        return this.flowAttriId;
    }

    public final String getFlowAttriId() {
        return (String)this.flowAttriIdProperty().get();
    }

    public final void setFlowAttriId(String flowAttriId) {
        this.flowAttriIdProperty().set((Object)flowAttriId);
    }

    public final StringProperty stepAttrIdProperty() {
        return this.stepAttrId;
    }

    public final String getStepAttrId() {
        return (String)this.stepAttrIdProperty().get();
    }

    public final void setStepAttrId(String stepAttrId) {
        this.stepAttrIdProperty().set((Object)stepAttrId);
    }

    public final IntegerProperty instructionTypeProperty() {
        return this.instructionType;
    }

    public final int getInstructionType() {
        return this.instructionTypeProperty().get();
    }

    public final void setInstructionType(int instructionType) {
        this.instructionTypeProperty().set(instructionType);
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
    }

    public final LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public List<BasketAlgoItem> getItems() {
        return this.items;
    }

    public void setItems(List<BasketAlgoItem> items) {
        this.items = items;
        if ("7".equals(this.getAdjWay().getRaw()) && items != null && !items.isEmpty()) {
            this.setPtcStgBuy(items.get(0).isBs());
        }
    }

    public Basket getBasket() {
        return this.basket;
    }

    public void setBasket(Basket basket) {
        this.basket = basket;
    }

    public int getAdjScale() {
        return this.adjScale;
    }

    public void setAdjScale(int adjScale) {
        this.adjScale = adjScale;
    }

    public AlgoParam getAlgoParam() {
        return this.algoParam;
    }

    public void setAlgoParam(AlgoParam algoParam) {
        this.algoParam = algoParam;
    }

    public boolean isControlMoney() {
        return this.controlMoney;
    }

    public void setControlMoney(boolean controlMoney) {
        this.controlMoney = controlMoney;
    }

    public double getMoney() {
        return this.money;
    }

    public void setMoney(double money) {
        this.money = money;
    }

    public boolean isControlImpact() {
        return this.controlImpact;
    }

    public void setControlImpact(boolean controlImpact) {
        this.controlImpact = controlImpact;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public int getActionId() {
        String paneTyp = this.getInstructionPanelType();
        int actionId = 0;
        if ("2".equals(paneTyp)) {
            actionId = 20;
        } else if ("1".equals(paneTyp)) {
            actionId = 21;
        }
        return actionId;
    }

    public StringProperty secIdXshgProperty() {
        return this.secIdXshg;
    }

    public String getSecIdXshg() {
        return (String)this.secIdXshgProperty().get();
    }

    public void setSecIdXshg(String secIdXshg) {
        this.secIdXshgProperty().set((Object)secIdXshg);
    }

    public StringProperty secIdXsheProperty() {
        return this.secIdXshe;
    }

    public String getSecIdXshe() {
        return (String)this.secIdXsheProperty().get();
    }

    public void setSecIdXshe(String secIdXshe) {
        this.secIdXsheProperty().set((Object)secIdXshe);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public final DoubleProperty countBskProperty() {
        return this.countBsk;
    }

    public final double getCountBsk() {
        return this.countBskProperty().get();
    }

    public final void setCountBsk(double countBsk) {
        this.countBskProperty().set(countBsk);
    }

    public final DoubleProperty moneyStgProperty() {
        return this.moneyStg;
    }

    public final double getMoneyStg() {
        return this.moneyStgProperty().get();
    }

    public final void setMoneyStg(double moneyStg) {
        this.moneyStgProperty().set(moneyStg);
    }

    public final ObjectProperty<MxNode> adjWayProperty() {
        return this.adjWay;
    }

    public final MxNode getAdjWay() {
        return (MxNode)this.adjWayProperty().get();
    }

    public final void setAdjWay(MxNode adjWay) {
        this.adjWayProperty().set((Object)adjWay);
    }

    public List<InstructionExec> getExes() {
        return this.exes;
    }

    public void setExes(List<InstructionExec> exes) {
        this.exes = exes;
    }

    public final DoubleProperty pctStgProperty() {
        return this.pctStg;
    }

    public final double getPctStg() {
        return this.pctStgProperty().get();
    }

    public final void setPctStg(double pctStg) {
        this.pctStgProperty().set(pctStg);
    }

    public final ObjectProperty<MxNode> adjTypeProperty() {
        return this.adjType;
    }

    public final MxNode getAdjType() {
        return (MxNode)this.adjTypeProperty().get();
    }

    public final void setAdjType(MxNode adjType) {
        this.adjTypeProperty().set((Object)adjType);
    }

    public final BooleanProperty ptcStgBuyProperty() {
        return this.ptcStgBuy;
    }

    public final boolean isPtcStgBuy() {
        return this.ptcStgBuyProperty().get();
    }

    public final void setPtcStgBuy(boolean ptcStgBuy) {
        this.ptcStgBuyProperty().set(ptcStgBuy);
    }
}

