/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.instruction;

import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.strategy.PFollowUp;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class AccntSecInfo
extends MxObject
implements Comparable<AccntSecInfo> {
    private StringProperty accntId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private LongProperty orderQty = new SimpleLongProperty();
    private LongProperty orderAvailableQuantity = new SimpleLongProperty();
    private IntegerProperty orderWeight = new SimpleIntegerProperty(1);
    private StringProperty secAccntId = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty();
    private StringProperty instructionId = new SimpleStringProperty("");
    private StringProperty infoId = new SimpleStringProperty("");
    private StringProperty parentId = new SimpleStringProperty("");
    private StringProperty subParentId = new SimpleStringProperty("");

    public void update(Object obj) {
        if (obj instanceof PInstruction.AccntSecInfo) {
            PInstruction.AccntSecInfo secInfo = (PInstruction.AccntSecInfo)PInstruction.AccntSecInfo.class.cast(obj);
            this.update(secInfo);
        } else if (obj instanceof AccntSecInfo) {
            this.update((AccntSecInfo)AccntSecInfo.class.cast(obj));
        } else if (obj instanceof PFollowUp.FundAccountSetting) {
            this.update((PFollowUp.FundAccountSetting)PFollowUp.FundAccountSetting.class.cast(obj));
        } else if (obj instanceof PFollowUp.SecAccountSetting) {
            this.update((PFollowUp.SecAccountSetting)PFollowUp.SecAccountSetting.class.cast(obj));
        }
    }

    private void update(PFollowUp.FundAccountSetting accSecInfo) {
        this.setAccntId(accSecInfo.getExtFundAccntId());
        this.setInvestorId(accSecInfo.getExtFundAccntId().replaceAll("_CNY", ""));
    }

    private void update(PFollowUp.SecAccountSetting accSecInfo) {
        this.setOrderQty(accSecInfo.getQty());
        this.setSecAccntId(accSecInfo.getExtSecAccntId().replaceAll("_CNY", ""));
    }

    private void update(AccntSecInfo accSecInfo) {
        this.setAccntId(accSecInfo.getAccntId());
        this.setInvestorId(accSecInfo.getInvestorId());
        this.setOrderQty(accSecInfo.getOrderQty());
        this.setSecAccntId(accSecInfo.getSecAccntId());
        this.setMarket(accSecInfo.getMarket());
        this.setInstructionId(accSecInfo.getInstructionId());
        this.setInfoId(accSecInfo.getInfoId());
        this.setParentId(accSecInfo.getParentId());
        this.setSubParentId(accSecInfo.getSubParentId());
        this.setOrderAvailableQuantity(accSecInfo.getOrderAvailableQuantity());
    }

    private void update(PInstruction.AccntSecInfo accSecInfo) {
        this.setAccntId(accSecInfo.getAccntId());
        this.setInvestorId(accSecInfo.getInvestorId());
        this.setOrderQty(Double.valueOf(accSecInfo.getOrderQty()).longValue());
        this.setSecAccntId(accSecInfo.getSecAccntId());
        this.setMarket(accSecInfo.getMarketId());
        this.setInstructionId(accSecInfo.getInstructionId());
        this.setInfoId(accSecInfo.getInfoId());
        this.setParentId(accSecInfo.getParentId());
        this.setSubParentId(accSecInfo.getSubParentId());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.accntId.get() == null ? 0 : ((String)this.accntId.get()).hashCode());
        result = 31 * result + (this.infoId.get() == null ? 0 : ((String)this.infoId.get()).hashCode());
        result = 31 * result + (this.secAccntId.get() == null ? 0 : ((String)this.secAccntId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccntSecInfo other = (AccntSecInfo)obj;
        if (this.accntId.get() == null ? other.accntId.get() != null : !((String)this.accntId.get()).equals(other.accntId.get())) {
            return false;
        }
        if (this.infoId.get() == null ? other.infoId.get() != null : !((String)this.infoId.get()).equals(other.infoId.get())) {
            return false;
        }
        return !(this.secAccntId.get() == null ? other.secAccntId.get() != null : !((String)this.secAccntId.get()).equals(other.secAccntId.get()));
    }

    public PInstruction.AccntSecInfo.Builder getBuilder() {
        PInstruction.AccntSecInfo.Builder accSecB = PInstruction.AccntSecInfo.newBuilder();
        accSecB.setAccntId(this.getAccntId());
        accSecB.setInvestorId(this.getInvestorId());
        accSecB.setOrderQty((double)this.getOrderQty());
        accSecB.setParentId(this.getParentId());
        accSecB.setSubParentId(this.getSubParentId());
        accSecB.setSecAccntId(this.getSecAccntId());
        accSecB.setMarketId(this.getMarket());
        accSecB.setInstructionId(this.getInstructionId());
        accSecB.setInfoId(this.getInfoId());
        return accSecB;
    }

    public StringProperty accntIdProperty() {
        return this.accntId;
    }

    public String getAccntId() {
        return (String)this.accntIdProperty().get();
    }

    public void setAccntId(String accntId) {
        this.accntIdProperty().set((Object)accntId);
    }

    public StringProperty investorIdProperty() {
        return this.investorId;
    }

    public String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    @Override
    public int compareTo(AccntSecInfo o) {
        return this.getAccntId().compareTo(o.getAccntId()) == 0 ? this.getSecAccntId().compareTo(o.getSecAccntId()) : this.getAccntId().compareTo(o.getAccntId());
    }

    public StringProperty secAccntIdProperty() {
        return this.secAccntId;
    }

    public String getSecAccntId() {
        return (String)this.secAccntIdProperty().get();
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntIdProperty().set((Object)secAccntId);
    }

    public StringProperty marketProperty() {
        return this.market;
    }

    public String getMarket() {
        return (String)this.marketProperty().get();
    }

    public void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public StringProperty instructionIdProperty() {
        return this.instructionId;
    }

    public String getInstructionId() {
        return (String)this.instructionIdProperty().get();
    }

    public void setInstructionId(String instructionId) {
        this.instructionIdProperty().set((Object)instructionId);
    }

    public StringProperty infoIdProperty() {
        return this.infoId;
    }

    public String getInfoId() {
        return (String)this.infoIdProperty().get();
    }

    public void setInfoId(String infoId) {
        this.infoIdProperty().set((Object)infoId);
    }

    public IntegerProperty orderWeightProperty() {
        return this.orderWeight;
    }

    public int getOrderWeight() {
        return this.orderWeightProperty().get();
    }

    public void setOrderWeight(int orderWeight) {
        this.orderWeightProperty().set(orderWeight);
    }

    public StringProperty parentIdProperty() {
        return this.parentId;
    }

    public String getParentId() {
        return (String)this.parentIdProperty().get();
    }

    public void setParentId(String parentId) {
        this.parentIdProperty().set((Object)parentId);
    }

    public final LongProperty orderAvailableQuantityProperty() {
        return this.orderAvailableQuantity;
    }

    public final long getOrderAvailableQuantity() {
        return this.orderAvailableQuantityProperty().get();
    }

    public final void setOrderAvailableQuantity(long orderAvailableQuantity) {
        this.orderAvailableQuantityProperty().set(orderAvailableQuantity);
    }

    public StringProperty subParentIdProperty() {
        return this.subParentId;
    }

    public String getSubParentId() {
        return (String)this.subParentIdProperty().get();
    }

    public void setSubParentId(String subParentId) {
        this.subParentIdProperty().set((Object)subParentId);
    }
}

