/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.basket;

import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BasketTrialCalAsset
extends MxObject {
    private StringProperty secId = new SimpleStringProperty("");
    private StringProperty secName = new SimpleStringProperty("");
    private StringProperty secType = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private DoubleProperty weight = new SimpleDoubleProperty();
    private DoubleProperty nowPrice = new SimpleDoubleProperty();
    private LongProperty minQty = new SimpleLongProperty();
    private LongProperty orderQty = new SimpleLongProperty();
    private DoubleProperty ordAmount = new SimpleDoubleProperty();
    private BooleanProperty isMin = new SimpleBooleanProperty(false);
    private BooleanProperty isBuy = new SimpleBooleanProperty(false);
    private boolean isXshgBond = false;
    private boolean isXsheBond = false;
    private int unitWeight = 100;
    private StringProperty unit = new SimpleStringProperty("");
    private RefItem refItem;

    public void update(Object obj) {
        if (obj instanceof BasketTrialCalAsset) {
            this.update((BasketTrialCalAsset)((Object)BasketTrialCalAsset.class.cast(obj)));
        } else if (obj instanceof BasketTradeItem) {
            BasketTradeItem bsk = (BasketTradeItem)((Object)BasketTradeItem.class.cast(obj));
            this.update(bsk);
        }
    }

    private void update(BasketTradeItem basket) {
        this.setSecId(basket.getItem().getSecurityId());
        this.setSecName(basket.getItem().getSecurityName());
        this.setWeight(basket.getAbWeight());
        this.setUnitWeight(basket.getUnitWeight());
        if (basket.getItem().getMktItem() != null) {
            if (basket.getItem().getMktItem().getNowPrice() != 0.0) {
                this.setNowPrice(basket.getItem().getMktItem().getNowPrice());
            } else {
                this.setNowPrice(basket.getItem().getMktItem().getClosePrice());
            }
            this.setSecType(basket.getItem().getSecurityType());
            this.setMarket(basket.getItem().getMarket().getRaw());
            this.setUnit(basket.getItem().getUnit());
            if ("BOND".equals(this.getSecType()) || "REPO".equals(this.getSecType())) {
                if ("XSHG".equals(this.getMarket())) {
                    this.setXshgBond(true);
                } else if ("XSHE".equals(this.getMarket())) {
                    this.setXsheBond(true);
                }
            }
        }
        if ("49".equals(basket.getBsTrade().getRaw())) {
            this.setIsBuy(true);
            this.setOrderQty(basket.getBuyCount());
        } else {
            this.setOrderQty(basket.getSellCount());
        }
        this.setRefItem(basket.getItem().getRefItem());
    }

    private void update(BasketTrialCalAsset trial) {
        this.setSecId(trial.getSecId());
        this.setSecName(trial.getSecName());
        this.setWeight(trial.getWeight());
        this.setNowPrice(trial.getNowPrice());
        this.setMinQty(trial.getMinQty());
        this.setOrderQty(trial.getOrderQty());
        this.setOrdAmount(trial.getOrdAmount());
        this.setIsMin(trial.isIsMin());
        this.setSecType(trial.getSecName());
        this.setMarket(trial.getMarket());
        this.setIsBuy(trial.isBuy());
        this.setXshgBond(trial.isXshgBond());
        this.setXsheBond(trial.isXsheBond());
        this.setUnit(trial.getUnit());
        this.setUnitWeight(trial.getUnitWeight());
        this.setRefItem(trial.getRefItem());
    }

    public StringProperty secIdProperty() {
        return this.secId;
    }

    public String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public StringProperty secNameProperty() {
        return this.secName;
    }

    public String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public DoubleProperty weightProperty() {
        return this.weight;
    }

    public double getWeight() {
        return this.weightProperty().get();
    }

    public void setWeight(double weight) {
        this.weightProperty().set(weight);
    }

    public DoubleProperty nowPriceProperty() {
        return this.nowPrice;
    }

    public double getNowPrice() {
        return this.nowPriceProperty().get();
    }

    public void setNowPrice(double nowPrice) {
        this.nowPriceProperty().set(nowPrice);
    }

    public DoubleProperty ordAmountProperty() {
        return this.ordAmount;
    }

    public double getOrdAmount() {
        return this.ordAmountProperty().get();
    }

    public void setOrdAmount(double ordAmount) {
        this.ordAmountProperty().set(ordAmount);
    }

    public BooleanProperty isMinProperty() {
        return this.isMin;
    }

    public boolean isIsMin() {
        return this.isMinProperty().get();
    }

    public void setIsMin(boolean isMin) {
        this.isMinProperty().set(isMin);
    }

    public LongProperty minQtyProperty() {
        return this.minQty;
    }

    public long getMinQty() {
        return this.minQtyProperty().get();
    }

    public void setMinQty(long minQty) {
        this.minQtyProperty().set(minQty);
    }

    public LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public BooleanProperty isBuyProperty() {
        return this.isBuy;
    }

    public boolean isBuy() {
        return this.isBuyProperty().get();
    }

    public void setIsBuy(boolean isBuy) {
        this.isBuyProperty().set(isBuy);
    }

    public StringProperty secTypeProperty() {
        return this.secType;
    }

    public String getSecType() {
        return (String)this.secTypeProperty().get();
    }

    public void setSecType(String secType) {
        this.secTypeProperty().set((Object)secType);
    }

    public StringProperty marketProperty() {
        return this.market;
    }

    public String getMarket() {
        return (String)this.marketProperty().get();
    }

    public void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public boolean isXshgBond() {
        return this.isXshgBond;
    }

    public void setXshgBond(boolean isXshgBond) {
        this.isXshgBond = isXshgBond;
    }

    public int getUnitWeight() {
        return this.unitWeight;
    }

    public void setUnitWeight(int unitWeight) {
        this.unitWeight = unitWeight;
    }

    public StringProperty unitProperty() {
        return this.unit;
    }

    public String getUnit() {
        return (String)this.unitProperty().get();
    }

    public void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public boolean isXsheBond() {
        return this.isXsheBond;
    }

    public void setXsheBond(boolean isXsheBond) {
        this.isXsheBond = isXsheBond;
    }

    public RefItem getRefItem() {
        return this.refItem;
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }
}

