/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.basket;

import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelDisObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketTradeItem
extends MxChgSelDisObj {
    private ObjectProperty<BasketItem> item = new SimpleObjectProperty();
    private ObjectProperty<CcsFundAccount> acc = new SimpleObjectProperty();
    private ObjectProperty<SecAccount> secAcc = new SimpleObjectProperty();
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty basketName = new SimpleStringProperty("");
    private IntegerProperty basketCount = new SimpleIntegerProperty();
    private IntegerProperty unitWeight = new SimpleIntegerProperty(1);
    private IntegerProperty position = new SimpleIntegerProperty();
    private IntegerProperty canSell = new SimpleIntegerProperty();
    private LongProperty buyCount = new SimpleLongProperty();
    private LongProperty sellCount = new SimpleLongProperty();
    private DoubleProperty buyPrice = new SimpleDoubleProperty();
    private DoubleProperty sellPrice = new SimpleDoubleProperty();
    private DoubleBinding buyAmt = this.buyPrice.multiply((ObservableNumberValue)this.buyCount).multiply((ObservableNumberValue)this.unitWeight);
    private DoubleBinding sellAmt = this.sellPrice.multiply((ObservableNumberValue)this.sellCount).multiply((ObservableNumberValue)this.unitWeight);
    private DoubleProperty basketTotalAmt = new SimpleDoubleProperty();
    private BooleanProperty disabled = new SimpleBooleanProperty(false);
    private DoubleProperty abWeight = new SimpleDoubleProperty(0.0);
    private DoubleProperty rlWeight = new SimpleDoubleProperty(0.0);
    private StringBinding tip;
    private BooleanBinding trigged;
    private BooleanProperty manuallySelected = new SimpleBooleanProperty(false);
    private boolean visible = true;
    private BooleanProperty unPickInAdvice = new SimpleBooleanProperty(false);
    private LongProperty targetCount = new SimpleLongProperty();
    private LongProperty availableQty = new SimpleLongProperty();
    private BooleanProperty basketTrigged = new SimpleBooleanProperty(false);
    private StringProperty basketSide = new SimpleStringProperty("");
    private StringProperty basketStrategy = new SimpleStringProperty("");
    private StringProperty basketTip = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private ObjectProperty<MxNode> bsTrade = new SimpleObjectProperty();
    private BooleanProperty positionExisted = new SimpleBooleanProperty(false);
    private StringProperty clOrderId = new SimpleStringProperty("");
    private DoubleProperty upperLimitPrice = new SimpleDoubleProperty();
    private DoubleProperty lowerLimitPrice = new SimpleDoubleProperty();
    private DoubleBinding lmtBuyAmt = this.upperLimitPrice.multiply((ObservableNumberValue)this.buyCount).multiply((ObservableNumberValue)this.unitWeight);
    private DoubleBinding lmtSellAmt = this.lowerLimitPrice.multiply((ObservableNumberValue)this.sellCount).multiply((ObservableNumberValue)this.unitWeight);
    private BooleanProperty isLmt = new SimpleBooleanProperty(false);
    private boolean manualModify = false;

    public BasketTradeItem() {
        MxNode bsTradeNode = MxNodeFactory.create((String)"basket_bs", (String)"49");
        this.setBsTrade(bsTradeNode);
        this.setSelected(true);
        this.setManuallySelected(true);
        this.item.addListener(ob -> this.calUnitWeight());
    }

    public StringBinding tipProperty() {
        return this.tip;
    }

    public String getTip() {
        return this.tip.get();
    }

    public void clear() {
        this.setBuyCount(0L);
        this.setSellCount(0L);
        this.setBuyPrice(0.0);
        this.setSellPrice(0.0);
        this.setUpperLimitPrice(0.0);
        this.setLowerLimitPrice(0.0);
        this.changed();
    }

    public void clear(boolean clearLmtPrice) {
        this.setBuyCount(0L);
        this.setSellCount(0L);
        if (!this.isManualModify()) {
            this.setBuyPrice(0.0);
            this.setSellPrice(0.0);
        }
        if (clearLmtPrice) {
            this.setUpperLimitPrice(0.0);
            this.setLowerLimitPrice(0.0);
        }
        this.changed();
    }

    public final ObjectProperty<BasketItem> itemProperty() {
        return this.item;
    }

    public final BasketItem getItem() {
        return (BasketItem)((Object)this.itemProperty().get());
    }

    public double getAmt(boolean bBuy) {
        if (this.isLmt.get()) {
            return this.getLmtAmt(bBuy);
        }
        return bBuy ? this.getBuyAmt().get() : this.getSellAmt().get();
    }

    public double getLmtAmt(boolean bBuy) {
        return bBuy ? this.getLmtBuyAmt().get() : this.getLmtSellAmt().get();
    }

    public DoubleBinding getBuyAmt() {
        if (this.isLmt.get()) {
            return this.getLmtBuyAmt();
        }
        return this.buyAmt;
    }

    public DoubleBinding getSellAmt() {
        if (this.isLmt.get()) {
            return this.getLmtSellAmt();
        }
        return this.sellAmt;
    }

    public DoubleBinding getLmtBuyAmt() {
        return this.lmtBuyAmt;
    }

    public DoubleBinding getLmtSellAmt() {
        return this.lmtSellAmt;
    }

    public final void setItem(BasketItem item) {
        this.itemProperty().set((Object)item);
    }

    public final ObjectProperty<CcsFundAccount> accProperty() {
        return this.acc;
    }

    public final CcsFundAccount getAcc() {
        return (CcsFundAccount)((Object)this.accProperty().get());
    }

    public final void setAcc(CcsFundAccount acc) {
        this.accProperty().set((Object)acc);
        this.tip = Bindings.createStringBinding(() -> {
            if (this.buyAmt.get() > acc.getAvailable()) {
                return "\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3";
            }
            if (this.sellCount.get() > (long)this.canSell.get()) {
                return "\u53ef\u5356\u6570\u4e0d\u8db3";
            }
            if (this.getItem() != null && !this.isLmt.get() && this.getItem().getMktItem() != null && !this.getItem().getMktItem().getStop().get()) {
                if (this.getItem().getMktItem().getUpLimitPrice() > 0.0 && this.getPrice("49".equals(((MxNode)this.bsTrade.getValue()).getRaw())) > this.getItem().getMktItem().getUpLimitPrice()) {
                    return "\u5927\u4e8e\u6da8\u505c\u4ef7";
                }
                if (!this.isLmt.get() && this.getItem().getMktItem().getDownLimitPrice() > 0.0 && this.getPrice("49".equals(((MxNode)this.bsTrade.getValue()).getRaw())) < this.getItem().getMktItem().getDownLimitPrice()) {
                    return "\u5c0f\u4e8e\u8dcc\u505c\u4ef7";
                }
            }
            return "";
        }, (Observable[])new Observable[]{this.buyCount, this.sellCount, acc.availableProperty(), this.canSell, this.item, this.buyPrice, this.sellPrice});
        this.trigged = Bindings.createBooleanBinding(() -> {
            if (this.buyAmt.get() > acc.getAvailable()) {
                return true;
            }
            if (this.sellCount.get() > (long)this.canSell.get()) {
                return true;
            }
            if (this.getItem() != null && !this.isLmt.get() && this.getItem().getMktItem() != null && !this.getItem().getMktItem().getStop().get()) {
                if (this.getItem().getMktItem().getUpLimitPrice() > 0.0 && this.getPrice("49".equals(((MxNode)this.bsTrade.getValue()).getRaw())) > this.getItem().getMktItem().getUpLimitPrice()) {
                    return true;
                }
                if (!this.isLmt.get() && this.getItem().getMktItem().getDownLimitPrice() > 0.0 && this.getPrice("49".equals(((MxNode)this.bsTrade.getValue()).getRaw())) < this.getItem().getMktItem().getDownLimitPrice()) {
                    return true;
                }
            }
            return false;
        }, (Observable[])new Observable[]{this.buyCount, this.sellCount, acc.availableProperty(), this.canSell, this.item, this.buyPrice, this.sellPrice});
    }

    public final IntegerProperty positionProperty() {
        return this.position;
    }

    public final int getPosition() {
        return this.positionProperty().get();
    }

    public final void setPosition(int position) {
        this.positionProperty().set(position);
    }

    public final IntegerProperty canSellProperty() {
        return this.canSell;
    }

    public final int getCanSell() {
        return this.canSellProperty().get();
    }

    public final void setCanSell(int canSell) {
        this.canSellProperty().set(canSell);
    }

    public final LongProperty buyCountProperty() {
        return this.buyCount;
    }

    public final long getBuyCount() {
        return this.buyCountProperty().get();
    }

    public final void setBuyCount(long buyCount) {
        this.buyCountProperty().set(buyCount);
    }

    public final LongProperty sellCountProperty() {
        return this.sellCount;
    }

    public final long getSellCount() {
        return this.sellCountProperty().get();
    }

    public final void setSellCount(long sellCount) {
        this.sellCountProperty().set(sellCount);
    }

    public final DoubleProperty buyPriceProperty() {
        return this.buyPrice;
    }

    public final double getBuyPrice() {
        return this.buyPriceProperty().get();
    }

    public final void setBuyPrice(double buyPrice) {
        this.buyPriceProperty().set(buyPrice < 0.0 ? 0.0 : buyPrice);
    }

    public final DoubleProperty sellPriceProperty() {
        return this.sellPrice;
    }

    public final double getSellPrice() {
        return this.sellPriceProperty().get();
    }

    public final void setSellPrice(double sellPrice) {
        this.sellPriceProperty().set(sellPrice < 0.0 ? 0.0 : sellPrice);
    }

    public double getPrice(boolean bBuy) {
        return bBuy ? this.getBuyPrice() : this.getSellPrice();
    }

    public double getLmtPrice(boolean bBuy) {
        return bBuy ? this.getUpperLimitPrice() : this.getLowerLimitPrice();
    }

    public void setPrice(boolean bBuy, double price) {
        if (bBuy) {
            this.setBuyPrice(price);
        } else {
            this.setSellPrice(price);
        }
    }

    public void setCount(boolean bBuy, int count) {
        if (bBuy) {
            this.setBuyCount(count);
        } else {
            this.setSellCount(count);
        }
    }

    public long getCount(boolean bBuy) {
        return bBuy ? this.getBuyCount() : this.getSellCount();
    }

    public void update(Object obj) {
    }

    public BooleanProperty disabledProperty() {
        return this.disabled;
    }

    public boolean isDisabled() {
        return this.disabledProperty().get();
    }

    public void setDisabled(boolean disabled) {
        this.disabledProperty().set(disabled);
    }

    public final ObjectProperty<SecAccount> secAccProperty() {
        return this.secAcc;
    }

    public final SecAccount getSecAcc() {
        return (SecAccount)((Object)this.secAccProperty().get());
    }

    public final void setSecAcc(SecAccount secAcc) {
        this.secAccProperty().set((Object)secAcc);
    }

    public final DoubleProperty abWeightProperty() {
        return this.abWeight;
    }

    public final double getAbWeight() {
        return this.abWeightProperty().get();
    }

    public final void setAbWeight(double abWeight) {
        this.abWeightProperty().set(abWeight);
    }

    private boolean isSHbond(RefItem refItem) {
        return refItem.getType().equals("BOND") && refItem.getMarket().equals("XSHG");
    }

    public IntegerProperty unitWeightProperty() {
        return this.unitWeight;
    }

    public void calUnitWeight() {
        if (this.getItem() == null) {
            this.setUnitWeight(1);
            return;
        }
        RefItem refItem = this.getItem().getRefItem();
        if (refItem == null) {
            this.setUnitWeight(1);
            return;
        }
        int unitConvert = this.isSHbond(refItem) ? 10 : 1;
        this.setUnitWeight(unitConvert);
    }

    public int getUnitWeight() {
        return this.unitWeight.get();
    }

    public void setUnitWeight(int unitWeight) {
        this.unitWeightProperty().set(unitWeight);
    }

    public BooleanBinding triggedProperty() {
        return this.trigged;
    }

    public boolean isTrigged() {
        return this.triggedProperty().get();
    }

    public BooleanProperty manuallySelectedProperty() {
        return this.manuallySelected;
    }

    public boolean isManuallySelected() {
        return this.manuallySelectedProperty().get();
    }

    public void setManuallySelected(boolean manuallySelected) {
        this.manuallySelectedProperty().set(manuallySelected);
    }

    public StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public StringProperty basketNameProperty() {
        return this.basketName;
    }

    public String getBasketName() {
        return (String)this.basketNameProperty().get();
    }

    public void setBasketName(String basketName) {
        this.basketNameProperty().set((Object)basketName);
    }

    public DoubleProperty basketTotalAmtProperty() {
        return this.basketTotalAmt;
    }

    public double getBasketTotalAmt() {
        return this.basketTotalAmtProperty().get();
    }

    public void setBasketTotalAmt(double basketTotalAmt) {
        this.basketTotalAmtProperty().set(basketTotalAmt);
    }

    public IntegerProperty basketCountProperty() {
        return this.basketCount;
    }

    public int getBasketCount() {
        return this.basketCountProperty().get();
    }

    public void setBasketCount(int count) {
        this.basketCountProperty().set(count);
    }

    public StringProperty basketSideProperty() {
        return this.basketSide;
    }

    public String getBasketSide() {
        return (String)this.basketSideProperty().get();
    }

    public void setBasketSide(String basketSide) {
        this.basketSideProperty().set((Object)basketSide);
    }

    public StringProperty basketStrategyProperty() {
        return this.basketStrategy;
    }

    public String getBasketStrategy() {
        return (String)this.basketStrategyProperty().get();
    }

    public void setBasketStrategy(String basketStrategy) {
        this.basketStrategyProperty().set((Object)basketStrategy);
    }

    public BooleanProperty basketTriggedProperty() {
        return this.basketTrigged;
    }

    public boolean isBasketTrigged() {
        return this.basketTriggedProperty().get();
    }

    public void setBasketTrigged(boolean basketTrigged) {
        this.basketTriggedProperty().set(basketTrigged);
    }

    public StringProperty basketTipProperty() {
        return this.basketTip;
    }

    public String getBasketTip() {
        return (String)this.basketTipProperty().get();
    }

    public void setBasketTip(String basketTip) {
        this.basketTipProperty().set((Object)basketTip);
    }

    public LongProperty targetCountProperty() {
        return this.targetCount;
    }

    public long getTargetCount() {
        return this.targetCountProperty().get();
    }

    public void setTargetCount(long targetCount) {
        this.targetCountProperty().set(targetCount);
    }

    public BooleanProperty unPickInAdviceProperty() {
        return this.unPickInAdvice;
    }

    public boolean isUnPickInAdvice() {
        return this.unPickInAdviceProperty().get();
    }

    public void setUnPickInAdvice(boolean unPickInAdvice) {
        this.unPickInAdviceProperty().set(unPickInAdvice);
    }

    public ObjectProperty<MxNode> bsTradeProperty() {
        return this.bsTrade;
    }

    public MxNode getBsTrade() {
        return (MxNode)this.bsTradeProperty().get();
    }

    public void setBsTrade(MxNode bsTrade) {
        this.bsTradeProperty().set((Object)bsTrade);
    }

    public final BooleanProperty positionExistedProperty() {
        return this.positionExisted;
    }

    public final boolean isPositionExisted() {
        return this.positionExistedProperty().get();
    }

    public final void setPositionExisted(boolean positionExisted) {
        this.positionExistedProperty().set(positionExisted);
    }

    public LongProperty availableQtyProperty() {
        return this.availableQty;
    }

    public long getAvailableQty() {
        return this.availableQtyProperty().get();
    }

    public void setAvailableQty(long availableQty) {
        this.availableQtyProperty().set(availableQty);
    }

    public final StringProperty clOrderIdProperty() {
        return this.clOrderId;
    }

    public final String getClOrderId() {
        return (String)this.clOrderIdProperty().get();
    }

    public final void setClOrderId(String clOrderId) {
        this.clOrderIdProperty().set((Object)clOrderId);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public DoubleProperty upperLimitPriceProperty() {
        return this.upperLimitPrice;
    }

    public double getUpperLimitPrice() {
        return this.upperLimitPriceProperty().get();
    }

    public void setUpperLimitPrice(double upperLimitPrice) {
        this.upperLimitPriceProperty().set(upperLimitPrice);
    }

    public DoubleProperty lowerLimitPriceProperty() {
        return this.lowerLimitPrice;
    }

    public double getLowerLimitPrice() {
        return this.lowerLimitPriceProperty().get();
    }

    public void setLowerLimitPrice(double lowerLimitPrice) {
        this.lowerLimitPriceProperty().set(lowerLimitPrice);
    }

    public BooleanProperty isLmtProperty() {
        return this.isLmt;
    }

    public boolean isIsLmt() {
        return this.isLmtProperty().get();
    }

    public void setIsLmt(boolean isLmt) {
        this.isLmtProperty().set(isLmt);
    }

    public boolean isManualModify() {
        return this.manualModify;
    }

    public void setManualModify(boolean manualModify) {
        this.manualModify = manualModify;
    }

    public DoubleProperty rlWeightProperty() {
        return this.rlWeight;
    }

    public double getRlWeight() {
        return this.rlWeightProperty().get();
    }

    public void setRlWeight(double rlWeight) {
        this.rlWeightProperty().set(rlWeight);
    }

    public StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

