/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.basket;

import cms.tmx.datatype.message.PBasketService;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketItem
extends MxObject {
    private StringProperty securityId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private StringProperty securityName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> bs = new SimpleObjectProperty();
    private DoubleProperty weight = new SimpleDoubleProperty();
    private DoubleProperty absWeight = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private StringProperty unit = new SimpleStringProperty("");
    private StringProperty securityType = new SimpleStringProperty("");
    private IntegerProperty id = new SimpleIntegerProperty(0);
    private RefItem refItem;
    private MarketItem mktItem;

    public BasketItem() {
        MxNode node = MxNodeFactory.create((String)"basket_bs", (String)"0");
        this.setBs(node);
        node = MxNodeFactory.create((String)"market_code", (String)"");
        this.setMarket(node);
    }

    public void update(Object obj) {
        if (obj instanceof BasketItem) {
            this.update((BasketItem)((Object)BasketItem.class.cast(obj)));
        } else if (obj instanceof PBasketService.BasketSecurity) {
            PBasketService.BasketSecurity bsk = (PBasketService.BasketSecurity)PBasketService.BasketSecurity.class.cast(obj);
            this.update(bsk);
        }
    }

    private void update(PBasketService.BasketSecurity bsk) {
        this.setId(bsk.getSequence());
        this.setSecurityId(bsk.getSecurityId());
        this.setSecurityName(bsk.getSymbol());
        this.setWeight((double)Math.round(bsk.getRelativeWeight() * 10000.0) / 10000.0);
        this.getMarket().setRaw(bsk.getMarket());
        this.getBs().setRaw(Integer.toString(bsk.getSideValue()));
        this.setCount((long)bsk.getSampleQty());
        this.setPrice(bsk.getPrice());
        this.setSecurityType(bsk.getSecurityType());
    }

    private void update(BasketItem bsk) {
        this.setId(bsk.getId());
        this.setSecurityId(bsk.getSecurityId());
        this.setSecurityName(bsk.getSecurityName());
        this.setWeight(bsk.getWeight());
        this.getMarket().setRaw(bsk.getMarket().getRaw());
        this.getBs().setRaw(bsk.getBs().getRaw());
        this.setAbsWeight(bsk.getAbsWeight());
        this.setCount(bsk.getCount());
        this.setPrice(bsk.getPrice());
        this.setUnit(bsk.getUnit());
        this.setSecurityType(bsk.getSecurityType());
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
        if (refItem == null) {
            return;
        }
        this.getMarket().setRaw(refItem.getMarket());
        this.setSecurityId(refItem.getCode());
        this.setSecurityName(refItem.getName());
    }

    public RefItem getRefItem() {
        return this.refItem;
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public final MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public final void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final ObjectProperty<MxNode> bsProperty() {
        return this.bs;
    }

    public final MxNode getBs() {
        return (MxNode)this.bsProperty().get();
    }

    public final void setBs(MxNode bs) {
        this.bsProperty().set((Object)bs);
    }

    public final DoubleProperty weightProperty() {
        return this.weight;
    }

    public final double getWeight() {
        return this.weightProperty().get();
    }

    public final void setWeight(double weight) {
        this.weightProperty().set(weight);
    }

    public final LongProperty countProperty() {
        return this.count;
    }

    public final long getCount() {
        return this.countProperty().get();
    }

    public final void setCount(long l) {
        this.countProperty().set(l);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public void setMktItem(MarketItem item) {
        this.mktItem = item;
    }

    public MarketItem getMktItem() {
        return this.mktItem;
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final DoubleProperty absWeightProperty() {
        return this.absWeight;
    }

    public final double getAbsWeight() {
        return this.absWeightProperty().get();
    }

    public final void setAbsWeight(double absWeight) {
        this.absWeightProperty().set(absWeight);
    }

    public final IntegerProperty idProperty() {
        return this.id;
    }

    public final int getId() {
        return this.idProperty().get();
    }

    public final void setId(int id) {
        this.idProperty().set(id);
    }

    public final StringProperty securityTypeProperty() {
        return this.securityType;
    }

    public final String getSecurityType() {
        return (String)this.securityTypeProperty().get();
    }

    public final void setSecurityType(String securityType) {
        this.securityTypeProperty().set((Object)securityType);
    }
}

