/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.basket;

import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BasketCcsOrder
extends MxSelObj {
    private static final List<String> CAN_CANCEL_STATUS = Arrays.asList("48", "49");
    private StringProperty basketName = new SimpleStringProperty("");
    private String listId = "";
    private StringProperty batchId = new SimpleStringProperty("");
    private String legId = "";
    private String extAccntId = "";
    private String extSecAccntId = "";
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private String subAccntId = "";
    private String subSecAccntId = "";
    private Instrument instrument;
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private int ordType;
    private ObjectProperty<MxNode> ordStatus = new SimpleObjectProperty();
    private ObjectProperty<MxNode> batchStatus = new SimpleObjectProperty();
    private StringProperty batchStringStatus = new SimpleStringProperty("");
    private LongProperty orderQty = new SimpleLongProperty(0L);
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private DoubleProperty tradeAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty cxlAmount = new SimpleDoubleProperty(0.0);
    private double lastQty;
    private double lastPx;
    private LongProperty cumQty = new SimpleLongProperty(0L);
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private StringProperty ordDate = new SimpleStringProperty("");
    private StringProperty ordTime = new SimpleStringProperty("");
    private StringProperty userId = new SimpleStringProperty("");
    private DoubleProperty donePercent = new SimpleDoubleProperty(0.0);
    private boolean batch = false;
    private int errorCode = 0;
    private StringProperty errorInfo = new SimpleStringProperty("");
    private int wthErrCode;
    private String wthErrInfo = "";
    private String riskDetail = "";
    private BooleanProperty canCancel = new SimpleBooleanProperty(false);
    private boolean isShow = true;
    private double newPrice;
    private String portfolioId = "";
    private StringProperty portfolioName = new SimpleStringProperty("");
    private String sysOrderId = "";
    private StringProperty extOrderId = new SimpleStringProperty("");
    private String resourceId = "";
    private String reference = "";
    private boolean canCancelReplace = true;
    private String exBatchStatus;
    private String clOrderId = "";
    private String clListId = "";

    public void update(Object obj) {
        if (obj instanceof POrderService.ListOrderLeg) {
            POrderService.ListOrderLeg order = (POrderService.ListOrderLeg)POrderService.ListOrderLeg.class.cast(obj);
            this.update(order);
        } else if (obj instanceof BasketCcsOrder) {
            BasketCcsOrder order = (BasketCcsOrder)((Object)BasketCcsOrder.class.cast(obj));
            this.update(order);
        } else if (obj instanceof POrderService.ListOrder) {
            POrderService.ListOrder order = (POrderService.ListOrder)POrderService.ListOrder.class.cast(obj);
            this.update(order);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ordDate.get() == null ? 0 : ((String)this.ordDate.get()).hashCode());
        result = 31 * result + (this.batchId.get() == null ? 0 : ((String)this.batchId.get()).hashCode());
        result = 31 * result + (this.listId == null ? 0 : this.listId.hashCode());
        result = 31 * result + (this.legId == null ? 0 : this.legId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BasketCcsOrder other = (BasketCcsOrder)((Object)obj);
        if (this.batchId.get() == null ? other.batchId.get() != null : !((String)this.batchId.get()).equals(other.batchId.get())) {
            return false;
        }
        if (this.ordDate.get() == null ? other.ordDate.get() != null : !((String)this.ordDate.get()).equals(other.ordDate.get())) {
            return false;
        }
        if (this.listId == null ? other.listId != null : !this.listId.equals(other.listId)) {
            return false;
        }
        return !(this.legId == null ? other.legId != null : !this.legId.equals(other.legId));
    }

    private void update(BasketCcsOrder order) {
        this.setAvgPx(order.getAvgPx());
        this.setBasketName(order.getBasketName());
        this.setBatchId(order.getBatchId());
        this.setOrdTime(order.getOrdTime());
        this.setCumQty(order.getCumQty());
        this.setDonePercent(order.getDonePercent());
        this.setExtAccntId(order.getExtAccntId());
        this.setExtSecAccntId(order.getExtSecAccntId());
        this.setInvestorId(order.getInvestorId());
        this.setInverstorSecId(order.getInverstorSecId());
        this.setInstrument(order.getInstrument());
        this.setLastPx(order.getLastPx());
        this.setLastQty(order.getLastQty());
        this.setLegId(order.getLegId());
        this.setListId(order.getListId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdStatus(order.getOrdStatus());
        this.setBatchStatus(order.getBatchStatus());
        if (StringUtils.isEmpty((String)this.getLegId())) {
            this.setBatchStatusRaw(order.getBatchStatus().getRaw());
        } else {
            this.setOrdStatusRaw(order.getOrdStatus().getRaw());
        }
        this.setOrdType(order.getOrdType());
        this.setPrice(order.getPrice());
        this.getSide().setRaw(order.getSide().getRaw());
        this.setSubAccntId(order.getSubAccntId());
        this.setSubSecAccntId(order.getSubSecAccntId());
        this.setUserId(order.getUserId());
        this.setErrorCode(order.getErrorCode());
        this.setErrorInfo(order.getErrorInfo());
        this.setWthErrCode(order.getWthErrCode());
        this.setWthErrInfo(order.getWthErrInfo());
        this.setRiskDetail(order.getRiskDetail());
        this.setPortfolioId(order.getPortfolioId());
        this.setPortfolioName(order.getPortfolioName());
        this.setTradeAmount(order.getTradeAmount());
        this.setCxlAmount(order.getCxlAmount());
        this.setOrderAmount(order.getOrderAmount());
        this.setUserId(order.getUserId());
        this.setSysOrderId(order.getSysOrderId());
        this.setExtOrderId(order.getExtOrderId());
        this.setOrderQty(order.getOrderQty());
        this.setResourceId(order.getResourceId());
        this.setReference(order.getReference());
        this.setCanCancelReplace(order.isCanCancelReplace());
        this.setExBatchStatus(order.getExBatchStatus());
        this.setClOrderId(order.getClOrderId());
        if (StringUtils.isEmpty((String)this.getLegId())) {
            this.setBatchStringStatus(order.getBatchStatus().getValue());
        } else {
            this.setBatchStringStatus(order.getOrdStatus().getValue());
        }
    }

    private void update(POrderService.ListOrderLeg order) {
        double per = 0.0;
        if (order.getOrderQty() > 0.0) {
            per = new BigDecimal(order.getCumQty()).divide(new BigDecimal(order.getOrderQty()), 4, 4).doubleValue() * 100.0;
        }
        this.setPrice(BigDecimal.valueOf(order.getPrice()).setScale(3, 4).doubleValue());
        this.setDonePercent(per);
        this.setCumQty(Double.valueOf(order.getCumQty()).longValue());
        this.setOrderQty(Double.valueOf(order.getOrderQty()).longValue());
        this.setLegId(order.getLegId());
        this.setListId(order.getListId());
        this.setBatchId(order.getListId());
        this.getInstrument().setSymbol(order.getInstrument().getSymbol());
        this.getInstrument().setSecId(order.getInstrument().getSecurityId());
        this.getInstrument().getMarket().setRaw(order.getInstrument().getMarket());
        this.getInstrument().setSecType(order.getInstrument().getSecurityType());
        this.setOrdTime(order.getOrdTime());
        this.setOrdDate(order.getOrdDate());
        this.setOrdStatusRaw(Integer.toString(order.getOrdStatusValue()));
        this.getSide().setRaw(Integer.toString(order.getSide().getNumber()));
        this.setExtAccntId(order.getExtAccntId());
        this.setExtSecAccntId(order.getExtSecAccntId());
        this.setErrorCode(order.getErrCode());
        this.setErrorInfo(order.getErrInfo());
        this.setWthErrCode(order.getWthErrCode());
        this.setWthErrInfo(order.getWthErrInfo());
        this.setRiskDetail(order.getRiskDetail());
        this.setTradeAmount(order.getTradeAmount());
        this.setCxlAmount(order.getCxlAmount());
        this.setOrderAmount(order.getOrderAmount());
        this.setSysOrderId(order.getSysOrderId());
        this.setExtOrderId(order.getExtOrderId());
        this.setUserId(order.getUserId());
        this.setAvgPx(order.getAvgPx());
        this.setSubAccntId(order.getSubAccntId());
        this.setSubSecAccntId(order.getSubSecAccntId());
        this.setExBatchStatus(this.getBatchStatus().getValue());
        this.setClOrderId(order.getClOrdId());
    }

    private void setOrdStatusRaw(String raw) {
        this.getOrdStatus().setRaw(raw);
        if (CAN_CANCEL_STATUS.contains(raw)) {
            this.setCanCancel(true);
        } else {
            this.setCanCancel(false);
        }
    }

    public void setBatchStatusRaw(String raw) {
        this.getBatchStatus().setRaw(raw);
        if ("1".equals(raw)) {
            this.setCanCancel(true);
        } else {
            this.setCanCancel(false);
        }
    }

    public void update(POrderService.ListOrder order) {
        double per = 0.0;
        if (order.getTotalOrderQty() > 0.0) {
            per = new BigDecimal(order.getTotalCumQty()).divide(new BigDecimal(order.getTotalOrderQty()), 4, 4).doubleValue() * 100.0;
        }
        this.setDonePercent(per);
        this.setBatch(true);
        this.setExtAccntId(order.getExtAccntId());
        this.setOrderQty(Double.valueOf(order.getTotalOrderQty()).longValue());
        this.setBatchId(order.getListId());
        this.setListId(order.getListId());
        this.setBasketName(order.getBasketName());
        this.setOrdTime(order.getOrdTime());
        this.getBatchStatus().setRaw(Integer.toString(order.getOrdStatus().getNumber()));
        this.setBatchStatusRaw(Integer.toString(order.getOrdStatus().getNumber()));
        this.setPortfolioId(order.getPortfolioId());
        this.setOrdDate(order.getOrdDate());
        this.setTradeAmount(order.getTradeAmount());
        this.setCxlAmount(order.getCxlAmount());
        this.setOrderAmount(order.getOrderAmount());
        this.setUserId(order.getUserId());
        this.setReference(order.getReference());
        this.setResourceId(order.getResourceId());
        this.setSubAccntId(order.getSubAccntId());
        this.setExBatchStatus(this.getBatchStatus().getValue());
    }

    public final StringProperty batchIdProperty() {
        return this.batchId;
    }

    public final String getBatchId() {
        return (String)this.batchIdProperty().get();
    }

    public final void setBatchId(String batchId) {
        this.batchIdProperty().set((Object)batchId);
    }

    public final BooleanProperty canCancelProperty() {
        return this.canCancel;
    }

    public final boolean canCancel() {
        return this.canCancelProperty().get();
    }

    public final void setCanCancel(boolean canCancel) {
        this.canCancelProperty().set(canCancel);
    }

    public final StringProperty basketNameProperty() {
        return this.basketName;
    }

    public final String getBasketName() {
        return (String)this.basketNameProperty().get();
    }

    public final void setBasketName(String basketName) {
        this.basketNameProperty().set((Object)basketName);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final ObjectProperty<MxNode> ordStatusProperty() {
        return this.ordStatus;
    }

    public final MxNode getOrdStatus() {
        return (MxNode)this.ordStatusProperty().get();
    }

    public final void setOrdStatus(MxNode ordStatus) {
        this.ordStatusProperty().set((Object)ordStatus);
    }

    public final ObjectProperty<MxNode> batchStatusProperty() {
        return this.batchStatus;
    }

    public final MxNode getBatchStatus() {
        return (MxNode)this.batchStatusProperty().get();
    }

    public final void setBatchStatus(MxNode batchStatus) {
        this.batchStatusProperty().set((Object)batchStatus);
    }

    public final LongProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final long getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(long orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final LongProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final long getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(long cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public final StringProperty ordDateProperty() {
        return this.ordDate;
    }

    public final String getOrdDate() {
        return (String)this.ordDateProperty().get();
    }

    public final void setOrdDate(String ordDate) {
        this.ordDateProperty().set((Object)ordDate);
    }

    public final StringProperty errorInfoProperty() {
        return this.errorInfo;
    }

    public final String getErrorInfo() {
        return (String)this.errorInfoProperty().get();
    }

    public final void setErrorInfo(String errorInfo) {
        this.errorInfoProperty().set((Object)errorInfo);
    }

    public final StringProperty ordTimeProperty() {
        return this.ordTime;
    }

    public final String getOrdTime() {
        return (String)this.ordTimeProperty().get();
    }

    public final void setOrdTime(String ordTime) {
        this.ordTimeProperty().set((Object)ordTime);
    }

    public final StringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public final DoubleProperty donePercentProperty() {
        return this.donePercent;
    }

    public final double getDonePercent() {
        return this.donePercentProperty().get();
    }

    public final void setDonePercent(double donePercent) {
        this.donePercentProperty().set(donePercent);
    }

    public StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public DoubleProperty tradeAmountProperty() {
        return this.tradeAmount;
    }

    public double getTradeAmount() {
        return this.tradeAmountProperty().get();
    }

    public void setTradeAmount(double tradeAmount) {
        this.tradeAmountProperty().set(tradeAmount);
    }

    public DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public DoubleProperty cxlAmountProperty() {
        return this.cxlAmount;
    }

    public double getCxlAmount() {
        return this.cxlAmountProperty().get();
    }

    public void setCxlAmount(double cxlAmount) {
        this.cxlAmountProperty().set(cxlAmount);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public StringProperty extOrderIdProperty() {
        return this.extOrderId;
    }

    public String getExtOrderId() {
        return (String)this.extOrderIdProperty().get();
    }

    public void setExtOrderId(String extOrderId) {
        this.extOrderIdProperty().set((Object)extOrderId);
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean isCanCancelReplace() {
        return this.canCancelReplace;
    }

    public void setCanCancelReplace(boolean canCancelReplace) {
        this.canCancelReplace = canCancelReplace;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public int getOrdType() {
        return this.ordType;
    }

    public void setOrdType(int ordType) {
        this.ordType = ordType;
    }

    public double getLastQty() {
        return this.lastQty;
    }

    public void setLastQty(double lastQty) {
        this.lastQty = lastQty;
    }

    public double getLastPx() {
        return this.lastPx;
    }

    public void setLastPx(double lastPx) {
        this.lastPx = lastPx;
    }

    public int getWthErrCode() {
        return this.wthErrCode;
    }

    public void setWthErrCode(int wthErrCode) {
        this.wthErrCode = wthErrCode;
    }

    public String getWthErrInfo() {
        return this.wthErrInfo;
    }

    public void setWthErrInfo(String wthErrInfo) {
        this.wthErrInfo = wthErrInfo;
    }

    public boolean isShow() {
        return this.isShow;
    }

    public void setShow(boolean isShow) {
        this.isShow = isShow;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getSysOrderId() {
        return this.sysOrderId;
    }

    public void setSysOrderId(String sysOrderId) {
        this.sysOrderId = sysOrderId;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getLegId() {
        return this.legId;
    }

    public void setLegId(String legId) {
        this.legId = legId;
    }

    public String getListId() {
        return this.listId;
    }

    public void setListId(String listId) {
        this.listId = listId;
    }

    public String getExBatchStatus() {
        return this.exBatchStatus;
    }

    public void setExBatchStatus(String exBatchStatus) {
        this.exBatchStatus = exBatchStatus;
    }

    public String getClOrderId() {
        return this.clOrderId;
    }

    public void setClOrderId(String clOrderId) {
        this.clOrderId = clOrderId;
    }

    public String getClListId() {
        return this.clListId;
    }

    public void setClListId(String clListId) {
        this.clListId = clListId;
    }

    public String getRiskDetail() {
        return this.riskDetail;
    }

    public void setRiskDetail(String riskDetail) {
        this.riskDetail = riskDetail;
    }

    public final StringProperty batchStringStatusProperty() {
        return this.batchStringStatus;
    }

    public final void setBatchStringStatus(String batchStringStatus) {
        this.batchStringStatusProperty().set((Object)batchStringStatus);
    }
}

