/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.basket;

import cms.tmx.core.MEvent;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BasketAlgoStrategy
extends MxObject {
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty exeBuy = new SimpleStringProperty("");
    private StringProperty exeSell = new SimpleStringProperty("");
    private IntegerProperty dealBuy = new SimpleIntegerProperty();
    private IntegerProperty dealSell = new SimpleIntegerProperty();
    private StringProperty orderDate = new SimpleStringProperty("");
    private StringProperty orderStartTime = new SimpleStringProperty("");
    private StringProperty orderEndTime = new SimpleStringProperty("");
    private StringProperty errorMsg = new SimpleStringProperty("");
    private StringProperty bizAcct = new SimpleStringProperty("");
    private String instructionId = "";
    private String investorId = "";
    private boolean derict = false;
    private String beLong;
    private String exType;
    private String exStatus;
    public static final String STRATEGY_STATUS = "strategy_status";
    public static final String STRATEGY_STATUS_Q = "1";
    public static final String STRATEGY_TYPE = "strategy_type";
    public static final String STRATEGY_TYPE_Q = "1";

    public BasketAlgoStrategy() {
        MxNode node = MxNodeFactory.create((String)STRATEGY_STATUS, (String)"1");
        this.setStatus(node);
        node = MxNodeFactory.create((String)STRATEGY_TYPE, (String)"1");
        this.setType(node);
    }

    public void update(Object obj) {
        if (obj instanceof BasketAlgoStrategy) {
            this.update((BasketAlgoStrategy)((Object)BasketAlgoStrategy.class.cast(obj)));
        } else if (obj instanceof MEvent) {
            MEvent bsk = (MEvent)MEvent.class.cast(obj);
            this.update(bsk);
        }
    }

    private void update(BasketAlgoStrategy bsk) {
        this.getStatus().setRaw(bsk.getStatus().getRaw());
        this.getType().setRaw(bsk.getType().getRaw());
        this.id.set((Object)bsk.getId());
        this.exeBuy.set((Object)bsk.getExeBuy());
        this.dealBuy.set(bsk.getDealBuy());
        this.exeSell.set((Object)bsk.getExeSell());
        this.dealSell.set(bsk.getDealSell());
        this.orderStartTime.set((Object)bsk.getOrderStartTime());
        this.orderEndTime.set((Object)bsk.getOrderEndTime());
        this.errorMsg.set((Object)bsk.getErrorMsg());
        this.bizAcct.set((Object)bsk.getBizAcct());
        this.setExType(bsk.getExType());
        this.setExStatus(bsk.getExStatus());
        this.setInvestorId(bsk.getInvestorId());
        this.setInstructionId(bsk.getInstructionId());
    }

    private void update(MEvent event) {
        JsonObject remark;
        String[] temp;
        this.getStatus().setRaw(event.getStr("algo_status"));
        this.getType().setRaw(event.getStr("algo_type"));
        this.id.set((Object)event.getStr("algo_order_id"));
        this.orderDate.set((Object)event.getStr("entrust_date"));
        this.orderStartTime.set((Object)event.getStr("entrust_time"));
        if (this.getStatus().getRaw().equals("2") || this.getStatus().getRaw().equals("3") || this.getStatus().getRaw().equals("5")) {
            this.orderEndTime.set((Object)event.getStr("update_time"));
        }
        this.errorMsg.set((Object)event.getStr("remark"));
        this.bizAcct.set((Object)event.getStr("biz_acct"));
        String extra = event.getStr("extra_fields");
        JsonObject json = (JsonObject)new Gson().fromJson(extra, JsonObject.class);
        this.dealBuy.set(json.get("buy_executed_qty").getAsInt());
        this.dealSell.set(json.get("sale_executed_qty").getAsInt());
        this.exeBuy.set((Object)this.convert(json.get("buy_executed_percent").getAsDouble() * 100.0, 2));
        this.exeSell.set((Object)this.convert(json.get("sale_executed_percent").getAsDouble() * 100.0, 2));
        this.setExType(this.getType().getValue());
        this.setExStatus(this.getStatus().getValue());
        this.setInvestorId(event.getStr("investorId"));
        if (json != null && json.get("gateway_data") != null && (temp = json.get("gateway_data").getAsString().split("#")).length >= 7) {
            this.setInstructionId(temp[6]);
        }
        if (json.get("remark") != null && (remark = (JsonObject)new Gson().fromJson(json.get("remark").getAsString(), JsonObject.class)).get("adj_type") != null && "1".equals(remark.get("adj_type").getAsString())) {
            this.setDerict(true);
        }
    }

    private String convert(double num, int scale) {
        BigDecimal big = new BigDecimal(num);
        double decimal = big.setScale(scale, 4).doubleValue();
        return StringUtils.toStr((double)decimal, (int)scale);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty orderStartTimeProperty() {
        return this.orderStartTime;
    }

    public final String getOrderStartTime() {
        return (String)this.orderStartTimeProperty().get();
    }

    public final void setOrderStartTime(String orderStartTime) {
        this.orderStartTimeProperty().set((Object)orderStartTime);
    }

    public final StringProperty orderEndTimeProperty() {
        return this.orderEndTime;
    }

    public final String getOrderEndTime() {
        return (String)this.orderEndTimeProperty().get();
    }

    public final void setOrderEndTime(String orderEndTime) {
        this.orderEndTimeProperty().set((Object)orderEndTime);
    }

    public final StringProperty errorMsgProperty() {
        return this.errorMsg;
    }

    public final String getErrorMsg() {
        return (String)this.errorMsgProperty().get();
    }

    public final void setErrorMsg(String errorMsg) {
        this.errorMsgProperty().set((Object)errorMsg);
    }

    public final StringProperty bizAcctProperty() {
        return this.bizAcct;
    }

    public final String getBizAcct() {
        return (String)this.bizAcctProperty().get();
    }

    public final void setBizAcct(String bizAcct) {
        this.bizAcctProperty().set((Object)bizAcct);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : ((String)this.id.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BasketAlgoStrategy other = (BasketAlgoStrategy)((Object)obj);
        return !(this.id.get() == null ? other.id.get() != null : !((String)this.id.get()).equals(other.id.get()));
    }

    public final StringProperty exeBuyProperty() {
        return this.exeBuy;
    }

    public final String getExeBuy() {
        return (String)this.exeBuyProperty().get();
    }

    public final void setExeBuy(String exeBuy) {
        this.exeBuyProperty().set((Object)exeBuy);
    }

    public final StringProperty exeSellProperty() {
        return this.exeSell;
    }

    public final String getExeSell() {
        return (String)this.exeSellProperty().get();
    }

    public final void setExeSell(String exeSell) {
        this.exeSellProperty().set((Object)exeSell);
    }

    public final IntegerProperty dealBuyProperty() {
        return this.dealBuy;
    }

    public final int getDealBuy() {
        return this.dealBuyProperty().get();
    }

    public final void setDealBuy(int dealBuy) {
        this.dealBuyProperty().set(dealBuy);
    }

    public final IntegerProperty dealSellProperty() {
        return this.dealSell;
    }

    public final int getDealSell() {
        return this.dealSellProperty().get();
    }

    public final void setDealSell(int dealSell) {
        this.dealSellProperty().set(dealSell);
    }

    public final StringProperty orderDateProperty() {
        return this.orderDate;
    }

    public final String getOrderDate() {
        return (String)this.orderDateProperty().get();
    }

    public final void setOrderDate(String orderDate) {
        this.orderDateProperty().set((Object)orderDate);
    }

    public String getBeLong() {
        return this.beLong;
    }

    public void setBeLong(String beLong) {
        this.beLong = beLong;
    }

    public String getExType() {
        return this.exType;
    }

    public void setExType(String exType) {
        this.exType = exType;
    }

    public String getExStatus() {
        return this.exStatus;
    }

    public void setExStatus(String exStatus) {
        this.exStatus = exStatus;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(String instructionId) {
        this.instructionId = instructionId;
    }

    public boolean isDerict() {
        return this.derict;
    }

    public void setDerict(boolean derict) {
        this.derict = derict;
    }
}

