/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.basket;

import cms.tmx.datatype.message.PBasketService;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Basket
extends MxObject {
    private SimpleStringProperty id = new SimpleStringProperty("");
    private SimpleStringProperty name = new SimpleStringProperty("");
    private BooleanProperty direction = new SimpleBooleanProperty();
    private String op;
    private ObservableList<BasketItem> list = FxUtils.newList();
    private BooleanProperty unModified = new SimpleBooleanProperty(true);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Basket other = (Basket)((Object)obj);
        return !(this.id.get() == null ? other.id.get() != null : !this.id.get().equals(other.id.get()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : this.id.get().hashCode());
        return result;
    }

    public void update(Object obj) {
        if (obj instanceof Basket) {
            this.update((Basket)((Object)Basket.class.cast(obj)));
        } else if (obj instanceof PBasketService.Basket) {
            PBasketService.Basket bsk = (PBasketService.Basket)PBasketService.Basket.class.cast(obj);
            this.update(bsk);
        }
    }

    private void update(Basket bsk) {
        this.id = bsk.id;
        this.name = bsk.name;
        this.op = bsk.op;
        this.list = bsk.list;
        this.unModified = bsk.unModified;
    }

    private void update(PBasketService.Basket bsk) {
        this.setName(bsk.getBasketName());
        this.setId(bsk.getBasketId());
        this.setUnModified(true);
    }

    public Basket copy(boolean filterHK) {
        Basket basket = new Basket();
        basket.setId(this.getId());
        basket.setName(this.getName());
        basket.op = this.op;
        basket.setDirection(this.directionProperty().get());
        basket.setUnModified(this.isUnModified());
        ArrayList<BasketItem> itemList = new ArrayList<BasketItem>();
        List items = this.getList().stream().filter(item -> !filterHK || !"SHSC".equals(item.getMarket().getRaw()) && !"SZSC".equals(item.getMarket().getRaw())).collect(Collectors.toList());
        for (BasketItem basketItem : items) {
            BasketItem bitem = new BasketItem();
            bitem.update((Object)basketItem);
            bitem.setRefItem(basketItem.getRefItem());
            bitem.setMktItem(basketItem.getMktItem());
            itemList.add(bitem);
        }
        basket.setList(itemList);
        return basket;
    }

    public ObservableList<BasketItem> getList() {
        return this.list;
    }

    public void setList(List<BasketItem> list) {
        this.list = FXCollections.observableList(list);
    }

    public final SimpleStringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set(id);
    }

    public final SimpleStringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set(name);
    }

    public final BooleanProperty unModifiedProperty() {
        return this.unModified;
    }

    public final boolean isUnModified() {
        return this.unModifiedProperty().get();
    }

    public final void setUnModified(boolean unModified) {
        this.unModifiedProperty().set(unModified);
    }

    public String toString() {
        return this.getName();
    }

    public final BooleanProperty directionProperty() {
        return this.direction;
    }

    public final boolean hasDirection() {
        return this.directionProperty().get();
    }

    public final void setDirection(boolean direction) {
        this.directionProperty().set(direction);
    }
}

