/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade.basket;

import cms.tmx.core.MEvent;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class AlgoStrategyDetails
extends MxObject {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty secId = new SimpleStringProperty("");
    private String secType = "";
    private StringProperty secName = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty side = new SimpleStringProperty();
    private DoubleProperty orderVol = new SimpleDoubleProperty(0.0);
    private DoubleProperty deal = new SimpleDoubleProperty(0.0);
    private DoubleProperty avgPrice = new SimpleDoubleProperty(0.0);
    private StringProperty exeDeal = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private DoubleProperty priceLmt = new SimpleDoubleProperty(0.0);
    private ObjectProperty<MxNode> status = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty remark = new SimpleStringProperty("");
    private StringProperty fundAccntId = new SimpleStringProperty("");
    private StringProperty secAccntId = new SimpleStringProperty("");
    private String subFundId = "";
    private String subSecId = "";
    private String portfolioId = "";
    private StringProperty portfolioName = new SimpleStringProperty("");
    private String evaluationVersion = "";
    private boolean isBuy = true;
    private StringProperty other = new SimpleStringProperty("");

    public AlgoStrategyDetails() {
        MxNode node = MxNodeFactory.create((String)"algo_exec_status");
        this.setStatus(node);
    }

    public AlgoStrategyDetails(String orderId) {
        this.setId(orderId);
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty secIdProperty() {
        return this.secId;
    }

    public final String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public final void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public final StringProperty secNameProperty() {
        return this.secName;
    }

    public final String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public final void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public final DoubleProperty dealProperty() {
        return this.deal;
    }

    public final double getDeal() {
        return this.dealProperty().get();
    }

    public final void setDeal(double deal) {
        this.dealProperty().set(deal);
    }

    public final StringProperty otherProperty() {
        return this.other;
    }

    public final String getOther() {
        return (String)this.otherProperty().get();
    }

    public final void setOther(String other) {
        this.otherProperty().set((Object)other);
    }

    public void update(Object obj) {
        if (obj instanceof AlgoStrategyDetails) {
            this.update((AlgoStrategyDetails)((Object)AlgoStrategyDetails.class.cast(obj)));
        } else if (obj instanceof JsonElement) {
            JsonElement bsk = (JsonElement)JsonElement.class.cast(obj);
            this.update(bsk);
        } else if (obj instanceof MEvent) {
            this.update((MEvent)MEvent.class.cast(obj));
        }
    }

    private void update(AlgoStrategyDetails obj) {
        this.secId.set((Object)obj.getSecId());
        this.side.set((Object)obj.getSide());
        this.orderVol.set(obj.getOrderVol());
        this.deal.set(obj.getDeal());
        this.exeDeal.set((Object)obj.getExeDeal());
        this.avgPrice.set(obj.getAvgPrice());
        this.setBuy(obj.isBuy());
    }

    private void update(JsonElement json) {
        JsonArray arr = json.getAsJsonArray();
        String market = arr.get(0).getAsString().equals("1") ? "XSHG" : "XSHE";
        String secId = arr.get(1).getAsString();
        this.setMarket(market);
        this.setSecId(secId);
        String secAccntId = arr.get(2).getAsString();
        String[] reserved2 = arr.get(8).getAsString().split("#");
        if (this.getEvaluationVersion().equals("2")) {
            if (reserved2.length >= 3 && !reserved2[2].isEmpty()) {
                this.setSubSecId(secAccntId);
                this.setSecAccntId(reserved2[2]);
            } else {
                this.setSecAccntId(secAccntId);
            }
            if (reserved2.length >= 1) {
                this.setSecType(reserved2[0]);
            }
            String price_lmt = arr.get(7).getAsString();
            if ("02".equals(arr.get(4).getAsString())) {
                if (price_lmt != null && price_lmt.startsWith("#")) {
                    price_lmt = price_lmt.replace("#", "");
                    this.setPriceLmt(StringUtils.parseDouble((String)price_lmt));
                }
            } else if (price_lmt != null && price_lmt.endsWith("#")) {
                price_lmt = price_lmt.replace("#", "");
                this.setPriceLmt(StringUtils.parseDouble((String)price_lmt));
            }
        } else {
            String fund_sec = arr.get(7).getAsString();
            String[] fs = fund_sec.split("#");
            if (fs.length >= 2) {
                this.setFundAccntId(fs[0]);
                this.setSecAccntId(fs[1]);
            }
            if (fs.length >= 4) {
                this.setSubFundId(fs[2]);
                this.setSubSecId(fs[3]);
            }
            if (fs.length >= 6) {
                this.setPortfolioId(fs[4]);
                this.setPortfolioName(fs[5]);
            }
        }
        boolean isRepo = arr.get(8).getAsString().split("#")[1].equals("110");
        boolean isBuy = "01".equals(arr.get(4).getAsString());
        if (isRepo) {
            this.side.set((Object)(isBuy ? "\u6b63\u56de\u8d2d" : "\u9006\u56de\u8d2d"));
        } else {
            this.side.set((Object)(isBuy ? "\u4e70\u5165" : "\u5356\u51fa"));
        }
        this.setBuy(isBuy);
        this.orderVol.set(arr.get(3).getAsDouble());
        this.deal.set(arr.get(9).getAsDouble());
        double exe = arr.get(10).getAsDouble();
        this.exeDeal.set((Object)this.convert(exe * 100.0, 2));
        double avg = arr.get(12).getAsDouble();
        this.avgPrice.set((double)Math.round(avg * 10000.0) / 10000.0);
        if (arr.size() >= 16) {
            String status = arr.get(15).getAsString();
            this.getStatus().setRaw(status);
        }
        if (arr.size() >= 17) {
            String remark = arr.get(16).getAsString();
            this.setRemark(remark);
        }
    }

    private void update(MEvent event) {
        String remark;
        String extra = event.getStr("extra_fields");
        JsonObject json = (JsonObject)new Gson().fromJson(extra, JsonObject.class);
        if (json != null && json.get("gateway_data") != null) {
            String[] temp = json.get("gateway_data").getAsString().split("#");
            if (temp.length >= 4) {
                this.setPortfolioId(temp[3]);
            }
            if (temp.length >= 5) {
                this.setSubFundId(temp[4]);
            }
        }
        if (json != null && json.get("remark") != null && !(remark = json.get("remark").getAsString()).isEmpty()) {
            JsonObject jsonRemark = (JsonObject)new Gson().fromJson(remark, JsonObject.class);
            if (jsonRemark.get("portfolio_name") != null) {
                this.setPortfolioName(jsonRemark.get("portfolio_name").getAsString());
            }
            if (jsonRemark.get("investorId") != null) {
                this.setFundAccntId(jsonRemark.get("investorId").getAsString());
            }
            if (jsonRemark.get("evaluation_version") != null) {
                this.setEvaluationVersion(jsonRemark.get("evaluation_version").getAsString());
            }
        }
        if (!this.getPortfolioId().isEmpty() && !this.getPortfolioName().isEmpty()) {
            this.setSubFundId(event.getStr("biz_acct"));
        } else {
            this.setFundAccntId(event.getStr("biz_acct"));
        }
    }

    private String convert(double num, int scale) {
        BigDecimal big = new BigDecimal(num);
        double decimal = big.setScale(scale, 4).doubleValue();
        return StringUtils.toStr((double)decimal, (int)scale);
    }

    public final StringProperty sideProperty() {
        return this.side;
    }

    public final String getSide() {
        return (String)this.sideProperty().get();
    }

    public final void setSide(String side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty orderVolProperty() {
        return this.orderVol;
    }

    public final double getOrderVol() {
        return this.orderVolProperty().get();
    }

    public final void setOrderVol(double orderVol) {
        this.orderVolProperty().set(orderVol);
    }

    public final StringProperty exeDealProperty() {
        return this.exeDeal;
    }

    public final String getExeDeal() {
        return (String)this.exeDealProperty().get();
    }

    public final void setExeDeal(String exeDeal) {
        this.exeDealProperty().set((Object)exeDeal);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : ((String)this.id.get()).hashCode());
        result = 31 * result + (this.secId.get() == null ? 0 : ((String)this.secId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AlgoStrategyDetails other = (AlgoStrategyDetails)((Object)obj);
        if (this.id.get() == null ? other.id.get() != null : !((String)this.id.get()).equals(other.id.get())) {
            return false;
        }
        return !(this.secId.get() == null ? other.secId.get() != null : !((String)this.secId.get()).equals(other.secId.get()));
    }

    public final DoubleProperty avgPriceProperty() {
        return this.avgPrice;
    }

    public final double getAvgPrice() {
        return this.avgPriceProperty().get();
    }

    public final void setAvgPrice(double avgPrice) {
        this.avgPriceProperty().set(avgPrice);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty fundAccntIdProperty() {
        return this.fundAccntId;
    }

    public final String getFundAccntId() {
        return (String)this.fundAccntIdProperty().get();
    }

    public final void setFundAccntId(String fundAccntId) {
        this.fundAccntIdProperty().set((Object)fundAccntId);
    }

    public final StringProperty secAccntIdProperty() {
        return this.secAccntId;
    }

    public final String getSecAccntId() {
        return (String)this.secAccntIdProperty().get();
    }

    public final void setSecAccntId(String secAccntId) {
        this.secAccntIdProperty().set((Object)secAccntId);
    }

    public String getSubFundId() {
        return this.subFundId;
    }

    public void setSubFundId(String subFundId) {
        this.subFundId = subFundId;
    }

    public String getSubSecId() {
        return this.subSecId;
    }

    public void setSubSecId(String subSecId) {
        this.subSecId = subSecId;
    }

    public final String getPortfolioId() {
        return this.portfolioId;
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public String getEvaluationVersion() {
        return this.evaluationVersion;
    }

    public void setEvaluationVersion(String evaluationVersion) {
        this.evaluationVersion = evaluationVersion;
    }

    public DoubleProperty priceLmtProperty() {
        return this.priceLmt;
    }

    public double getPriceLmt() {
        return this.priceLmtProperty().get();
    }

    public void setPriceLmt(double priceLmt) {
        this.priceLmtProperty().set(priceLmt);
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty remarkProperty() {
        return this.remark;
    }

    public final String getRemark() {
        return (String)this.remarkProperty().get();
    }

    public final void setRemark(String remark) {
        this.remarkProperty().set((Object)remark);
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public void setBuy(boolean isBuy) {
        this.isBuy = isBuy;
    }
}

