/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.http.api.strategy.dto.HedgeTaskInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class XswapHedgeTask
extends MxSelObj {
    private StringProperty taskId = new SimpleStringProperty("");
    private StringProperty strategyName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> hedgeStatus = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty code = new SimpleStringProperty("");
    private IntegerProperty execQty = new SimpleIntegerProperty();
    private DoubleProperty execPrice = new SimpleDoubleProperty();
    private StringProperty hedgeCode1 = new SimpleStringProperty("");
    private ObjectProperty<MxNode> hedgeOrdSide1 = new SimpleObjectProperty((Object)new MxNode());
    private DoubleProperty hedgePrice1 = new SimpleDoubleProperty();
    private StringProperty hedgeCode2 = new SimpleStringProperty("");
    private ObjectProperty<MxNode> hedgeOrdSide2 = new SimpleObjectProperty((Object)new MxNode());
    private DoubleProperty hedgePrice2 = new SimpleDoubleProperty();

    public XswapHedgeTask() {
        MxNode node = new MxNode().load("status_hedge", "");
        this.setHedgeStatus(node);
        node = new MxNode().load("side", "");
        this.setHedgeOrdSide1(node);
        node = new MxNode().load("side", "");
        this.setHedgeOrdSide2(node);
    }

    public void update(Object obj) {
        if (obj instanceof XswapHedgeTask) {
            XswapHedgeTask en = (XswapHedgeTask)((Object)XswapHedgeTask.class.cast(obj));
            this.update(en);
        } else if (obj instanceof HedgeTaskInfo) {
            try {
                this.update((HedgeTaskInfo)HedgeTaskInfo.class.cast(obj));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void update(XswapHedgeTask task) {
        this.setExecQty(task.getExecQty());
        this.setExecPrice(task.getExecPrice());
        this.setStrategyName(task.getStrategyName());
        this.setTaskId(task.getTaskId());
        this.setCode(task.getCode());
        this.setHedgeCode1(task.getHedgeCode1());
        this.setHedgeOrdSide1(task.getHedgeOrdSide1());
        this.setHedgePrice1(task.getHedgePrice1());
        this.setHedgeCode2(task.getHedgeCode2());
        this.setHedgeOrdSide2(task.getHedgeOrdSide2());
        this.setHedgePrice2(task.getHedgePrice2());
    }

    private void update(HedgeTaskInfo task) {
        this.setTaskId(task.getTaskId());
        if (task.getOrigAlgoName() != null) {
            this.setStrategyName(task.getOrigAlgoName());
        }
        this.getHedgeStatus().setRaw(String.valueOf(task.getHedgeStatus().getValue()));
        this.setCode(task.getInstrument().getSecurityId());
        this.setExecQty(task.getDetails().getExecQty());
        this.setExecPrice((double)Math.round(task.getDetails().getExecPrice() * 1000.0) / 1000.0);
        this.setHedgeCode1(task.getDetails().getBond1().getSecurityId());
        this.getHedgeOrdSide1().setRaw(String.valueOf(task.getDetails().getBond1HedgeOrdSide().getValue()));
        Double hedgePrice1 = task.getDetails().getBond1HedgePrice();
        this.setHedgePrice1(hedgePrice1 == null ? 0.0 : this.formatScale(hedgePrice1, 4));
        this.setHedgeCode2(task.getDetails().getBond2().getSecurityId());
        this.getHedgeOrdSide2().setRaw(String.valueOf(task.getDetails().getBond2HedgeOrdSide().getValue()));
        Double hedgePrice2 = task.getDetails().getBond2HedgePrice();
        this.setHedgePrice2(hedgePrice2 == null ? 0.0 : this.formatScale(hedgePrice2, 4));
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : ((String)this.taskId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        XswapHedgeTask other = (XswapHedgeTask)((Object)obj);
        return !(this.taskId == null ? other.taskId != null : !((String)this.taskId.get()).equals(other.taskId.get()));
    }

    public final StringProperty taskIdProperty() {
        return this.taskId;
    }

    public final String getTaskId() {
        return (String)this.taskIdProperty().get();
    }

    public final void setTaskId(String taskId) {
        this.taskIdProperty().set((Object)taskId);
    }

    public final StringProperty strategyNameProperty() {
        return this.strategyName;
    }

    public final String getStrategyName() {
        return (String)this.strategyNameProperty().get();
    }

    public final void setStrategyName(String strategyName) {
        this.strategyNameProperty().set((Object)strategyName);
    }

    public final ObjectProperty<MxNode> hedgeStatusProperty() {
        return this.hedgeStatus;
    }

    public final MxNode getHedgeStatus() {
        return (MxNode)this.hedgeStatusProperty().get();
    }

    public final void setHedgeStatus(MxNode hedgeStatus) {
        this.hedgeStatusProperty().set((Object)hedgeStatus);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty hedgeCode1Property() {
        return this.hedgeCode1;
    }

    public final String getHedgeCode1() {
        return (String)this.hedgeCode1Property().get();
    }

    public final void setHedgeCode1(String hedgeCode1) {
        this.hedgeCode1Property().set((Object)hedgeCode1);
    }

    public final ObjectProperty<MxNode> hedgeOrdSide1Property() {
        return this.hedgeOrdSide1;
    }

    public final MxNode getHedgeOrdSide1() {
        return (MxNode)this.hedgeOrdSide1Property().get();
    }

    public final void setHedgeOrdSide1(MxNode hedgeOrdSide1) {
        this.hedgeOrdSide1Property().set((Object)hedgeOrdSide1);
    }

    public final DoubleProperty hedgePrice1Property() {
        return this.hedgePrice1;
    }

    public final double getHedgePrice1() {
        return this.hedgePrice1Property().get();
    }

    public final void setHedgePrice1(double hedgePrice1) {
        this.hedgePrice1Property().set(hedgePrice1);
    }

    public final StringProperty hedgeCode2Property() {
        return this.hedgeCode2;
    }

    public final String getHedgeCode2() {
        return (String)this.hedgeCode2Property().get();
    }

    public final void setHedgeCode2(String hedgeCode2) {
        this.hedgeCode2Property().set((Object)hedgeCode2);
    }

    public final ObjectProperty<MxNode> hedgeOrdSide2Property() {
        return this.hedgeOrdSide2;
    }

    public final MxNode getHedgeOrdSide2() {
        return (MxNode)this.hedgeOrdSide2Property().get();
    }

    public final void setHedgeOrdSide2(MxNode hedgeOrdSide2) {
        this.hedgeOrdSide2Property().set((Object)hedgeOrdSide2);
    }

    public final DoubleProperty hedgePrice2Property() {
        return this.hedgePrice2;
    }

    public final double getHedgePrice2() {
        return this.hedgePrice2Property().get();
    }

    public final void setHedgePrice2(double hedgePrice2) {
        this.hedgePrice2Property().set(hedgePrice2);
    }

    public final IntegerProperty execQtyProperty() {
        return this.execQty;
    }

    public final int getExecQty() {
        return this.execQtyProperty().get();
    }

    public final void setExecQty(int execQty) {
        this.execQtyProperty().set(execQty);
    }

    public final DoubleProperty execPriceProperty() {
        return this.execPrice;
    }

    public final double getExecPrice() {
        return this.execPriceProperty().get();
    }

    public final void setExecPrice(double execPrice) {
        this.execPriceProperty().set(execPrice);
    }
}

