/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.entity.trade.XSwapStrategySerialize;
import cms.tmx.http.api.strategy.dto.ActiveBenchmarkPricingSettings;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.HedgeBenchmarkPricingSettings;
import cms.tmx.http.api.strategy.dto.SecuritySettings;
import cms.tmx.http.api.strategy.dto.XSwapContextSettings;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XSwapStrategy
extends MxSelObj {
    private static final Logger logger = LogManager.getLogger(XSwapStrategy.class);
    private StringProperty name = new SimpleStringProperty("");
    protected StringProperty contextId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty((Object)new MxNode());
    protected StringProperty statusName = new SimpleStringProperty("");
    private StringProperty errorMsg = new SimpleStringProperty("");
    private String extFundAccntId = new String("");
    private String extSecAccntId = new String("");
    private String parentExtAccntId = new String("");
    private String market = new String("");
    private StringProperty securityId = new SimpleStringProperty("");
    private String securityType = "";
    private StringProperty securityName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> type = new SimpleObjectProperty((Object)new MxNode());
    public BooleanProperty showUpdateBtn = new SimpleBooleanProperty(false);
    private IntegerProperty filledQty = new SimpleIntegerProperty();
    boolean template = false;
    private ObjectProperty<MxNode> cancelType = new SimpleObjectProperty((Object)new MxNode());
    private String customBs = "";
    private ObjectProperty<MxNode> positionEffect = new SimpleObjectProperty((Object)new MxNode());
    private ActiveBenchmarkPricingSettings activeBenchmark;
    private String refPriceFormula = "";
    private boolean attackBuy = true;
    private boolean attackSell = true;
    private StringProperty bidRefPriceFormula = new SimpleStringProperty("");
    private StringProperty offerRefPriceFormula = new SimpleStringProperty("");
    private DoubleProperty bidQty = new SimpleDoubleProperty();
    private DoubleProperty offerQty = new SimpleDoubleProperty();
    private double bidPriceSlip;
    private double offerPriceSlip;
    private double bidSpread;
    private double askSpread;
    private String bidUpLimit = "";
    private String bidFloorLimit = "";
    private String offerUpLimit = "";
    private String offerFloorLimit = "";
    private DoubleProperty maxDeal = new SimpleDoubleProperty();
    private HedgeBenchmarkPricingSettings hedgeBenchmark;
    private String hedgePriceFormula;
    private String bid1HedgePriceFormula;
    private String bid2HedgePriceFormula;
    private String offer1HedgePriceFormula;
    private String offer2HedgePriceFormula;

    public XSwapStrategy() {
        MxNode node = new MxNode().load("status_strategy", "");
        this.setStatus(node);
        node = new MxNode().load("xswap_strategy_type", "");
        this.setType(node);
        node = MxNodeFactory.create((String)"strategy_cancel_type", (String)"false");
        this.setCancelType(node);
    }

    public void update(Object obj) {
        if (obj instanceof ContextSettings) {
            this.update((ContextSettings)ContextSettings.class.cast(obj));
        } else if (obj instanceof XSwapStrategy) {
            this.update((XSwapStrategy)((Object)XSwapStrategy.class.cast(obj)));
        } else if (obj instanceof XSwapStrategySerialize) {
            this.update((XSwapStrategySerialize)XSwapStrategySerialize.class.cast(obj));
        }
    }

    private void update(XSwapStrategySerialize strategy) {
        this.setName(strategy.getName());
        this.setContextId(strategy.getContextId());
        this.getType().setRaw(strategy.getType());
        this.setParentExtAccntId(strategy.getParentExtAccntId());
        this.setExtFundAccntId(strategy.getExtFundAccntId());
        this.setExtSecAccntId(strategy.getExtSecAccntId());
        this.setMarket(strategy.getMarket());
        this.setSecurityId(strategy.getSecurityId());
        this.setSecurityType(strategy.getSecurityType());
        this.setSecurityName(strategy.getSecurityName());
        this.setCustomBs(strategy.getType());
        this.getCancelType().setRaw(strategy.getCancelType());
        this.getPositionEffect().setRaw(strategy.getPositionEffect());
        this.setActiveBenchmark(strategy.getActiveBenchmark());
        this.setBidRefPriceFormula(strategy.getBidRefPriceFormula());
        this.setOfferRefPriceFormula(strategy.getOfferRefPriceFormula());
        this.setBidSpread(strategy.getBidSpread());
        this.setAskSpread(strategy.getAskSpread());
        this.setBidUpLimit(strategy.getBidUpLimit());
        this.setBidFloorLimit(strategy.getBidFloorLimit());
        this.setOfferUpLimit(strategy.getOfferUpLimit());
        this.setOfferFloorLimit(strategy.getOfferFloorLimit());
        this.setBidPriceSlip(strategy.getBidPriceSlip());
        this.setOfferPriceSlip(this.getOfferPriceSlip());
        this.setMaxDeal(strategy.getMaxDeal());
        this.setBidQty(strategy.getBidQty());
        this.setOfferQty(strategy.getOfferQty());
        this.setHedgeBenchmark(strategy.getHedgeBenchmark());
        this.setBid1HedgePriceFormula(strategy.getBid1HedgePriceFormula());
        this.setBid2HedgePriceFormula(strategy.getBid2HedgePriceFormula());
        this.setOffer1HedgePriceFormula(strategy.getOffer1HedgePriceFormula());
        this.setOffer2HedgePriceFormula(strategy.getOffer2HedgePriceFormula());
    }

    private void update(XSwapStrategy strategy) {
        this.setName(strategy.getName());
        this.setContextId(strategy.getContextId());
        this.setType(strategy.getType());
        this.setStatus(strategy.getStatus());
        this.setStatusName(strategy.getStatusName());
        this.setErrorMsg(strategy.getErrorMsg());
        this.setParentExtAccntId(strategy.getParentExtAccntId());
        this.setExtFundAccntId(strategy.getExtFundAccntId());
        this.setExtSecAccntId(strategy.getExtSecAccntId());
        this.setMarket(strategy.getMarket());
        this.setSecurityId(strategy.getSecurityId());
        this.setSecurityType(strategy.getSecurityType());
        this.setSecurityName(strategy.getSecurityName());
        this.setFilledQty(strategy.getFilledQty());
        this.setTemplate(strategy.isTemplate());
        this.setShowUpdateBtn(strategy.isShowUpdateBtn());
        this.setCustomBs(strategy.getType().getRaw());
        this.setCancelType(strategy.getCancelType());
        this.setPositionEffect(strategy.getPositionEffect());
        this.setActiveBenchmark(strategy.getActiveBenchmark());
        this.setBidRefPriceFormula(strategy.getBidRefPriceFormula());
        this.setOfferRefPriceFormula(strategy.getOfferRefPriceFormula());
        this.setAttackBuy(strategy.isAttackBuy());
        this.setAttackSell(strategy.isAttackSell());
        this.setBidSpread(strategy.getBidSpread());
        this.setAskSpread(strategy.getAskSpread());
        this.setBidUpLimit(strategy.getBidUpLimit());
        this.setBidFloorLimit(strategy.getBidFloorLimit());
        this.setOfferUpLimit(strategy.getOfferUpLimit());
        this.setOfferFloorLimit(strategy.getOfferFloorLimit());
        this.setBidPriceSlip(strategy.getBidPriceSlip());
        this.setOfferPriceSlip(this.getOfferPriceSlip());
        this.setMaxDeal(strategy.getMaxDeal());
        this.setBidQty(strategy.getBidQty());
        this.setOfferQty(strategy.getOfferQty());
        this.setHedgeBenchmark(strategy.getHedgeBenchmark());
        this.setBid1HedgePriceFormula(strategy.getBid1HedgePriceFormula());
        this.setBid2HedgePriceFormula(strategy.getBid2HedgePriceFormula());
        this.setOffer1HedgePriceFormula(strategy.getOffer1HedgePriceFormula());
        this.setOffer2HedgePriceFormula(strategy.getOffer2HedgePriceFormula());
    }

    private void update(ContextSettings context) {
        this.setName(context.getName());
        if (context.getAlgoId() != null) {
            this.setContextId(context.getAlgoId());
        }
        if (context.getAlgoStatus() != null) {
            this.getStatus().setRaw(String.valueOf(context.getAlgoStatus().ordinal()));
        } else {
            this.getStatus().setRaw("2");
        }
        this.setStatusName(this.getStatus().getValue());
        if (this.getStatus().getRaw().equals("2")) {
            this.setShowUpdateBtn(true);
        } else {
            this.setShowUpdateBtn(false);
        }
        this.getType().setRaw(String.valueOf(context.getExecModeType()));
        if (context.getText() != null) {
            this.setErrorMsg(context.getText());
        }
        this.setTemplate(context.isTemplate());
        Gson gson = new Gson();
        String json = gson.toJson(context.getDetails());
        JsonObject jo = (JsonObject)gson.fromJson(json, JsonObject.class);
        if (jo.get("@type").getAsString().contains("ContextSettings")) {
            XSwapContextSettings custom = (XSwapContextSettings)gson.fromJson((JsonElement)jo, XSwapContextSettings.class);
            this.contextSettingsParse(custom);
        }
    }

    private void contextSettingsParse(XSwapContextSettings context) {
        String offerFloorLimit;
        String offerUpLimit;
        String bidFloorLimit;
        String offerRefPriceFormula;
        double base = 1.0E7;
        this.setExtFundAccntId(context.getAccount().getExtFundAccntId());
        this.setExtSecAccntId(context.getAccount().getExtSecAccntId());
        this.setParentExtAccntId(context.getAccount().getParentExtAccntId());
        SecuritySettings security = context.getSecurity();
        this.setMarket(security.getInstrument().getMarket());
        this.setSecurityId(security.getInstrument().getSecurityId());
        this.setSecurityType(security.getInstrument().getSecurityType());
        this.setSecurityName(security.getInstrument().getSymbol());
        this.setCustomBs(this.getType().getRaw());
        if (security.getPositionEffect() != null) {
            this.getPositionEffect().setRaw(String.valueOf(security.getPositionEffect().getValue()));
        }
        this.setActiveBenchmark(context.getSecurity().getPricSetting());
        String bidRefPriceFormula = context.getSecurity().getBidRefPriceFormula();
        if (bidRefPriceFormula != null) {
            int sub;
            int add = bidRefPriceFormula.lastIndexOf("+");
            int indexBid = add > (sub = bidRefPriceFormula.lastIndexOf("-")) ? add : sub;
            this.setAttackBuy(add > sub);
            if (indexBid > -1) {
                this.setBidRefPriceFormula(bidRefPriceFormula.substring(0, indexBid));
                this.setBidSpread(Double.parseDouble(bidRefPriceFormula.substring(indexBid + 1)));
            }
        }
        if ((offerRefPriceFormula = context.getSecurity().getOfferRefPriceFormula()) != null) {
            int sub;
            int add = offerRefPriceFormula.lastIndexOf("+");
            int indexOffer = add > (sub = offerRefPriceFormula.lastIndexOf("-")) ? add : sub;
            this.setAttackSell(sub > add);
            if (indexOffer > -1) {
                this.setOfferRefPriceFormula(offerRefPriceFormula.substring(0, indexOffer));
                this.setAskSpread(Double.parseDouble(offerRefPriceFormula.substring(indexOffer + 1)));
            }
        }
        if (context.getSecurity().getBidPriceSlip() != null) {
            this.setBidPriceSlip(context.getSecurity().getBidPriceSlip());
        }
        if (context.getSecurity().getOfferPriceSlip() != null) {
            this.setOfferPriceSlip(context.getSecurity().getOfferPriceSlip());
        }
        this.setMaxDeal((double)context.getSecurity().getMaxAllowFilledQty().intValue() / base);
        Integer bidQty = context.getSecurity().getBidQty();
        this.setBidQty(bidQty == null ? 0.0 : (double)bidQty.intValue() / base);
        Integer offerQty = context.getSecurity().getOfferQty();
        this.setOfferQty(offerQty == null ? 0.0 : (double)offerQty.intValue() / base);
        String bidUpLimit = context.getSecurity().getBidUpLimit();
        if (bidUpLimit != null) {
            this.setBidUpLimit(bidUpLimit);
        }
        if ((bidFloorLimit = context.getSecurity().getBidFloorLimit()) != null) {
            this.setBidFloorLimit(bidFloorLimit);
        }
        if ((offerUpLimit = context.getSecurity().getOfferUpLimit()) != null) {
            this.setOfferUpLimit(offerUpLimit);
        }
        if ((offerFloorLimit = context.getSecurity().getOfferFloorLimit()) != null) {
            this.setOfferFloorLimit(offerFloorLimit);
        }
        if (context.getSecurity().getMaxHaveFilledQty() != null) {
            this.setFilledQty(context.getSecurity().getMaxHaveFilledQty() / 10000 / 1000);
        }
        this.setHedgeBenchmark(context.getHedge().getPricSetting());
        this.setBid1HedgePriceFormula(context.getHedge().getBid1HedgePriceFormula());
        this.setBid2HedgePriceFormula(context.getHedge().getBid2HedgePriceFormula());
        this.setOffer1HedgePriceFormula(context.getHedge().getOffer1HedgePriceFormula());
        this.setOffer2HedgePriceFormula(context.getHedge().getOffer2HedgePriceFormula());
        this.getCancelType().setRaw(String.valueOf(context.getSecurity().isFullFilledCancel()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextId == null ? 0 : ((String)this.contextId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        XSwapStrategy other = (XSwapStrategy)((Object)obj);
        return !(this.contextId == null ? other.contextId != null : !((String)this.contextId.get()).equals(other.contextId.get()));
    }

    public String getParentExtAccntId() {
        return this.parentExtAccntId;
    }

    public void setParentExtAccntId(String parentExtAccntId) {
        this.parentExtAccntId = parentExtAccntId;
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty contextIdProperty() {
        return this.contextId;
    }

    public final String getContextId() {
        return (String)this.contextIdProperty().get();
    }

    public final void setContextId(String contextId) {
        this.contextIdProperty().set((Object)contextId);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty errorMsgProperty() {
        return this.errorMsg;
    }

    public final String getErrorMsg() {
        return (String)this.errorMsgProperty().get();
    }

    public final void setErrorMsg(String errorMsg) {
        this.errorMsgProperty().set((Object)errorMsg);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final BooleanProperty showUpdateBtnProperty() {
        return this.showUpdateBtn;
    }

    public final boolean isShowUpdateBtn() {
        return this.showUpdateBtnProperty().get();
    }

    public final void setShowUpdateBtn(boolean showUpdateBtn) {
        this.showUpdateBtnProperty().set(showUpdateBtn);
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean inExe) {
        this.template = inExe;
    }

    public String getExtFundAccntId() {
        return this.extFundAccntId;
    }

    public void setExtFundAccntId(String extFundAccntId) {
        this.extFundAccntId = extFundAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public final IntegerProperty filledQtyProperty() {
        return this.filledQty;
    }

    public final int getFilledQty() {
        return this.filledQtyProperty().get();
    }

    public final void setFilledQty(int filledQty) {
        this.filledQtyProperty().set(filledQty);
    }

    public String getCustomBs() {
        return this.customBs;
    }

    public void setCustomBs(String customBs) {
        this.customBs = customBs;
    }

    public String getBid1HedgePriceFormula() {
        return this.bid1HedgePriceFormula;
    }

    public void setBid1HedgePriceFormula(String bid1HedgePriceFormula) {
        this.bid1HedgePriceFormula = bid1HedgePriceFormula;
    }

    public String getBid2HedgePriceFormula() {
        return this.bid2HedgePriceFormula;
    }

    public void setBid2HedgePriceFormula(String bid2HedgePriceFormula) {
        this.bid2HedgePriceFormula = bid2HedgePriceFormula;
    }

    public String getOffer1HedgePriceFormula() {
        return this.offer1HedgePriceFormula;
    }

    public void setOffer1HedgePriceFormula(String offer1HedgePriceFormula) {
        this.offer1HedgePriceFormula = offer1HedgePriceFormula;
    }

    public String getOffer2HedgePriceFormula() {
        return this.offer2HedgePriceFormula;
    }

    public void setOffer2HedgePriceFormula(String offer2HedgePriceFormula) {
        this.offer2HedgePriceFormula = offer2HedgePriceFormula;
    }

    public double getBidPriceSlip() {
        return this.bidPriceSlip;
    }

    public void setBidPriceSlip(double bidPriceSlip) {
        this.bidPriceSlip = bidPriceSlip;
    }

    public double getOfferPriceSlip() {
        return this.offerPriceSlip;
    }

    public void setOfferPriceSlip(double offerPriceSlip) {
        this.offerPriceSlip = offerPriceSlip;
    }

    public ActiveBenchmarkPricingSettings getActiveBenchmark() {
        return this.activeBenchmark;
    }

    public void setActiveBenchmark(ActiveBenchmarkPricingSettings activeBenchmark) {
        this.activeBenchmark = activeBenchmark;
    }

    public HedgeBenchmarkPricingSettings getHedgeBenchmark() {
        return this.hedgeBenchmark;
    }

    public void setHedgeBenchmark(HedgeBenchmarkPricingSettings hedgeBenchmark) {
        this.hedgeBenchmark = hedgeBenchmark;
    }

    public String getRefPriceFormula() {
        return this.refPriceFormula;
    }

    public void setRefPriceFormula(String refPriceFormula) {
        this.refPriceFormula = refPriceFormula;
    }

    public String getHedgePriceFormula() {
        return this.hedgePriceFormula;
    }

    public void setHedgePriceFormula(String hedgePriceFormula) {
        this.hedgePriceFormula = hedgePriceFormula;
    }

    public final DoubleProperty bidQtyProperty() {
        return this.bidQty;
    }

    public final double getBidQty() {
        return this.bidQtyProperty().get();
    }

    public final void setBidQty(double bidQty) {
        this.bidQtyProperty().set(bidQty);
    }

    public final DoubleProperty offerQtyProperty() {
        return this.offerQty;
    }

    public final double getOfferQty() {
        return this.offerQtyProperty().get();
    }

    public final void setOfferQty(double offerQty) {
        this.offerQtyProperty().set(offerQty);
    }

    public final DoubleProperty maxDealProperty() {
        return this.maxDeal;
    }

    public final double getMaxDeal() {
        return this.maxDealProperty().get();
    }

    public final void setMaxDeal(double maxDeal) {
        this.maxDealProperty().set(maxDeal);
    }

    public final ObjectProperty<MxNode> positionEffectProperty() {
        return this.positionEffect;
    }

    public final MxNode getPositionEffect() {
        return (MxNode)this.positionEffectProperty().get();
    }

    public final void setPositionEffect(MxNode positionEffect) {
        this.positionEffectProperty().set((Object)positionEffect);
    }

    public final StringProperty bidRefPriceFormulaProperty() {
        return this.bidRefPriceFormula;
    }

    public final String getBidRefPriceFormula() {
        return (String)this.bidRefPriceFormulaProperty().get();
    }

    public final void setBidRefPriceFormula(String bidRefPriceFormula) {
        this.bidRefPriceFormulaProperty().set((Object)bidRefPriceFormula);
    }

    public final StringProperty offerRefPriceFormulaProperty() {
        return this.offerRefPriceFormula;
    }

    public final String getOfferRefPriceFormula() {
        return (String)this.offerRefPriceFormulaProperty().get();
    }

    public final void setOfferRefPriceFormula(String offerRefPriceFormula) {
        this.offerRefPriceFormulaProperty().set((Object)offerRefPriceFormula);
    }

    public final ObjectProperty<MxNode> cancelTypeProperty() {
        return this.cancelType;
    }

    public final MxNode getCancelType() {
        return (MxNode)this.cancelTypeProperty().get();
    }

    public final void setCancelType(MxNode cancelType) {
        this.cancelTypeProperty().set((Object)cancelType);
    }

    public double getBidSpread() {
        return this.bidSpread;
    }

    public void setBidSpread(double bidSpread) {
        this.bidSpread = bidSpread;
    }

    public double getAskSpread() {
        return this.askSpread;
    }

    public void setAskSpread(double askSpread) {
        this.askSpread = askSpread;
    }

    public boolean isAttackBuy() {
        return this.attackBuy;
    }

    public void setAttackBuy(boolean attackBuy) {
        this.attackBuy = attackBuy;
    }

    public boolean isAttackSell() {
        return this.attackSell;
    }

    public void setAttackSell(boolean attackSell) {
        this.attackSell = attackSell;
    }

    public String getBidUpLimit() {
        return this.bidUpLimit;
    }

    public void setBidUpLimit(String bidUpLimit) {
        this.bidUpLimit = bidUpLimit;
    }

    public String getBidFloorLimit() {
        return this.bidFloorLimit;
    }

    public void setBidFloorLimit(String bidFloorLimit) {
        this.bidFloorLimit = bidFloorLimit;
    }

    public String getOfferUpLimit() {
        return this.offerUpLimit;
    }

    public void setOfferUpLimit(String offerUpLimit) {
        this.offerUpLimit = offerUpLimit;
    }

    public String getOfferFloorLimit() {
        return this.offerFloorLimit;
    }

    public void setOfferFloorLimit(String offerFloorLimit) {
        this.offerFloorLimit = offerFloorLimit;
    }

    public final StringProperty statusNameProperty() {
        return this.statusName;
    }

    public final String getStatusName() {
        return (String)this.statusNameProperty().get();
    }

    public final void setStatusName(String statusName) {
        this.statusNameProperty().set((Object)statusName);
    }
}

