/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.entity.trade.XBondStrategySerialize;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.RepoContextSettings;
import cms.tmx.http.api.strategy.dto.SecuritySettings;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XRepoStrategy
extends MxSelObj
implements Serializable {
    private static final long serialVersionUID = -5343627064063654418L;
    private static final Logger logger = LogManager.getLogger(XRepoStrategy.class);
    private StringProperty name = new SimpleStringProperty("");
    protected StringProperty contextId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty errorMsg = new SimpleStringProperty("");
    private String extFundAccntId = "";
    private String extSecAccntId = "";
    private String parentExtAccntId = "";
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private String market = "";
    private String securityType = "";
    private ObjectProperty<MxNode> type = new SimpleObjectProperty((Object)new MxNode());
    Side side;
    String startTime;
    String endTime;
    protected DoubleProperty totalQty = new SimpleDoubleProperty();
    protected DoubleProperty filledQty = new SimpleDoubleProperty();
    protected DoubleProperty filledPercent = new SimpleDoubleProperty();
    protected DoubleProperty upLimit = new SimpleDoubleProperty();
    protected DoubleProperty floorLimit = new SimpleDoubleProperty();
    protected DoubleProperty avgPx = new SimpleDoubleProperty();
    private String traderId = "";

    public XRepoStrategy() {
        MxNode node = new MxNode().load("status_strategy", "");
        this.setStatus(node);
        node = new MxNode().load("xbond_strategy_type", "");
        this.setType(node);
    }

    public void update(Object obj) {
        if (obj instanceof ContextSettings) {
            ContextSettings en = (ContextSettings)ContextSettings.class.cast(obj);
            this.update(en);
        } else if (obj instanceof XRepoStrategy) {
            XRepoStrategy en = (XRepoStrategy)XRepoStrategy.class.cast(obj);
            this.update(en);
        } else if (obj instanceof XBondStrategySerialize) {
            this.update(XBondStrategySerialize.class.cast(obj));
        }
    }

    private void update(XRepoStrategy strategy) {
        this.setName(strategy.getName());
        this.setContextId(strategy.getContextId());
        this.setType(strategy.getType());
        this.setStatus(strategy.getStatus());
        this.setErrorMsg(strategy.getErrorMsg());
        this.setParentExtAccntId(strategy.getParentExtAccntId());
        this.setExtFundAccntId(strategy.getExtFundAccntId());
        this.setExtSecAccntId(strategy.getExtSecAccntId());
        this.setTraderId(strategy.getTraderId());
        this.setMarket(strategy.getMarket());
        this.setSecurityId(strategy.getSecurityId());
        this.setSecurityType(strategy.getSecurityType());
        this.setSecurityName(strategy.getSecurityName());
        this.setSide(strategy.getSide());
        this.setStartTime(strategy.getStartTime());
        this.setEndTime(strategy.getEndTime());
        this.setUpLimit(strategy.getUpLimit());
        this.setFloorLimit(strategy.getFloorLimit());
        this.setTotalQty(strategy.getTotalQty());
        this.setFilledQty(strategy.getFilledQty());
        this.setFilledPercent(strategy.getFilledPercent());
    }

    private void update(ContextSettings context) {
        String json;
        Gson gson;
        JsonObject jo;
        this.setName(context.getName());
        if (context.getAlgoId() != null) {
            this.setContextId(context.getAlgoId());
        }
        if (context.getAlgoStatus() != null) {
            this.getStatus().setRaw(String.valueOf(context.getAlgoStatus().ordinal()));
        } else {
            this.getStatus().setRaw("2");
        }
        this.getType().setRaw(String.valueOf(context.getExecModeType()));
        if (context.getText() != null) {
            this.setErrorMsg(context.getText());
        }
        if ((jo = (JsonObject)(gson = new Gson()).fromJson(json = gson.toJson(context.getDetails()), JsonObject.class)).get("@type").getAsString().contains("RepoContextSettings")) {
            RepoContextSettings repo = (RepoContextSettings)gson.fromJson((JsonElement)jo, RepoContextSettings.class);
            this.repoParamParse(repo);
        }
    }

    private void repoParamParse(RepoContextSettings custom) {
        this.setExtFundAccntId(custom.getAccount().getExtFundAccntId());
        this.setExtSecAccntId(custom.getAccount().getExtSecAccntId());
        this.setParentExtAccntId(custom.getAccount().getParentExtAccntId());
        SecuritySettings security = custom.getSecurity();
        if (security.getCfetsTraderId() != null) {
            this.setTraderId(security.getCfetsTraderId());
        }
        this.setMarket(security.getInstrument().getMarket());
        this.setSecurityId(security.getInstrument().getSecurityId());
        this.setSecurityType(security.getInstrument().getSecurityType());
        this.setSecurityName(security.getInstrument().getSymbol());
        this.setSide(security.getSide());
        this.setStartTime(security.getStartTime());
        this.setEndTime(security.getEndTime());
        this.setUpLimit(security.getUpLimit());
        this.setFloorLimit(security.getFloorLimit());
        double unit = 1.0E8;
        this.setTotalQty(security.getTotalQty() / unit);
        this.setFilledQty((double)security.getFilledQty().longValue() / unit);
        this.setFilledPercent(security.getFilledPercent() * 100.0);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextId == null ? 0 : ((String)this.contextId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XRepoStrategy other = (XRepoStrategy)obj;
        return !(this.contextId == null ? other.contextId != null : !((String)this.contextId.get()).equals(other.contextId.get()));
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty contextIdProperty() {
        return this.contextId;
    }

    public final String getContextId() {
        return (String)this.contextIdProperty().get();
    }

    public final void setContextId(String contextId) {
        this.contextIdProperty().set((Object)contextId);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty errorMsgProperty() {
        return this.errorMsg;
    }

    public final String getErrorMsg() {
        return (String)this.errorMsgProperty().get();
    }

    public final void setErrorMsg(String errorMsg) {
        this.errorMsgProperty().set((Object)errorMsg);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public String getExtFundAccntId() {
        return this.extFundAccntId;
    }

    public void setExtFundAccntId(String extFundAccntId) {
        this.extFundAccntId = extFundAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getParentExtAccntId() {
        return this.parentExtAccntId;
    }

    public void setParentExtAccntId(String parentExtAccntId) {
        this.parentExtAccntId = parentExtAccntId;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public final DoubleProperty totalQtyProperty() {
        return this.totalQty;
    }

    public final double getTotalQty() {
        return this.totalQtyProperty().get();
    }

    public final void setTotalQty(double totalQty) {
        this.totalQtyProperty().set(totalQty);
    }

    public final DoubleProperty filledQtyProperty() {
        return this.filledQty;
    }

    public final double getFilledQty() {
        return this.filledQtyProperty().get();
    }

    public final void setFilledQty(double filledQty) {
        this.filledQtyProperty().set(filledQty);
    }

    public final DoubleProperty filledPercentProperty() {
        return this.filledPercent;
    }

    public final double getFilledPercent() {
        return this.filledPercentProperty().get();
    }

    public final void setFilledPercent(double filledPercent) {
        this.filledPercentProperty().set(filledPercent);
    }

    public final DoubleProperty upLimitProperty() {
        return this.upLimit;
    }

    public final double getUpLimit() {
        return this.upLimitProperty().get();
    }

    public final void setUpLimit(double upLimit) {
        this.upLimitProperty().set(upLimit);
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public final DoubleProperty floorLimitProperty() {
        return this.floorLimit;
    }

    public final double getFloorLimit() {
        return this.floorLimitProperty().get();
    }

    public final void setFloorLimit(double floorLimit) {
        this.floorLimitProperty().set(floorLimit);
    }

    public String getTraderId() {
        return this.traderId;
    }

    public void setTraderId(String traderId) {
        this.traderId = traderId;
    }
}

