/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.entity.data.XBond;
import cms.tmx.entity.trade.XBondStrategySerialize;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.CustomContextSettings;
import cms.tmx.http.api.strategy.dto.CustomSecuritySettings;
import cms.tmx.http.api.strategy.dto.StrategyCondition;
import cms.tmx.http.api.strategy.dto.XbondContextSettings;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondStrategy
extends MxSelObj
implements Serializable {
    private static final long serialVersionUID = -5343627064063654418L;
    private static final Logger logger = LogManager.getLogger(XBondStrategy.class);
    private StringProperty name = new SimpleStringProperty("");
    protected StringProperty contextId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty((Object)new MxNode());
    private StringProperty errorMsg = new SimpleStringProperty("");
    private String extFundAccntId = new String("");
    private String extSecAccntId = new String("");
    private String parentExtAccntId = new String("");
    private String market = new String("");
    private StringProperty securityId = new SimpleStringProperty("");
    private String securityType = new String("");
    private StringProperty securityName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> type = new SimpleObjectProperty((Object)new MxNode());
    private double ask1MinusBid1;
    private double ask2MinusBid2;
    private double askQty1;
    private double bidQty1;
    private double askQty1PlusAskQty2;
    private ObjectProperty<MxNode> basePrice = new SimpleObjectProperty((Object)new MxNode());
    private ObjectProperty<MxNode> basePriceHedge = new SimpleObjectProperty((Object)new MxNode());
    private IntegerProperty qty = new SimpleIntegerProperty();
    private DoubleProperty dealLimit = new SimpleDoubleProperty();
    private DoubleProperty spread = new SimpleDoubleProperty();
    private DoubleProperty spreadHedge = new SimpleDoubleProperty();
    public BooleanProperty showUpdateBtn = new SimpleBooleanProperty(false);
    private IntegerProperty filledQty = new SimpleIntegerProperty();
    boolean template = false;
    private StringProperty yieldBid = new SimpleStringProperty("");
    private StringProperty yieldOffer = new SimpleStringProperty("");
    private StringProperty priceBid = new SimpleStringProperty("");
    private StringProperty priceOffer = new SimpleStringProperty("");
    private String customBs = "";
    private ObjectProperty<MxNode> cancelType = new SimpleObjectProperty((Object)new MxNode());
    private boolean attackBuy = true;
    private boolean attackSell = true;
    private String bidRefPriceFormula = "";
    private String offerRefPriceFormula = "";
    private double bidSpread;
    private double askSpread;
    private double bidPriceSlip;
    private double offerPriceSlip;
    private double maxDeal;
    private double bidQty;
    private double askQty;
    private String bidUpLimit = "";
    private String bidFloorLimit = "";
    private String offerUpLimit = "";
    private String offerFloorLimit = "";
    protected XBond hedgeContract;
    private String bidHedgePriceFormula = "";
    private String offerHedgePriceFormula = "";
    private int marketMakingCount;
    private int hedgeCount;
    private int timeoutFill;
    private double stoplossFill;

    public XBondStrategy() {
        MxNode node = new MxNode().load("status_strategy", "");
        this.setStatus(node);
        node = new MxNode().load("xbond_strategy_type", "");
        this.setType(node);
        node = new MxNode().load("xbond_price", "");
        this.setBasePrice(node);
        node = new MxNode().load("xbond_price", "");
        this.setBasePriceHedge(node);
        node = MxNodeFactory.create((String)"strategy_cancel_type", (String)"false");
        this.setCancelType(node);
    }

    public void update(Object obj) {
        if (obj instanceof ContextSettings) {
            ContextSettings en = (ContextSettings)ContextSettings.class.cast(obj);
            this.update(en);
        } else if (obj instanceof XBondStrategy) {
            XBondStrategy en = (XBondStrategy)XBondStrategy.class.cast(obj);
            this.update(en);
        } else if (obj instanceof XBondStrategySerialize) {
            this.update((XBondStrategySerialize)XBondStrategySerialize.class.cast(obj));
        }
    }

    private void update(XBondStrategySerialize strategy) {
        this.setName(strategy.getName());
        this.setContextId(strategy.getContextId());
        this.getType().setRaw(strategy.getType());
        this.setParentExtAccntId(strategy.getParentExtAccntId());
        this.setExtFundAccntId(strategy.getExtFundAccntId());
        this.setExtSecAccntId(strategy.getExtSecAccntId());
        this.setMarket(strategy.getMarket());
        this.setSecurityId(strategy.getSecurityId());
        this.setSecurityName(strategy.getSecurityName());
        this.setSecurityType(strategy.getSecurityType());
        this.setDealLimit(strategy.getDealLimit());
        this.setTemplate(true);
        this.getBasePrice().setRaw(strategy.getBasePrice());
        this.getBasePriceHedge().setRaw(strategy.getBasePriceHedge());
        this.setQty(strategy.getQty());
        this.setSpread(strategy.getSpread());
        this.setSpreadHedge(strategy.getSpreadHedge());
        this.setAsk1MinusBid1(strategy.getAsk1MinusBid1());
        this.setAsk2MinusBid2(strategy.getAsk2MinusBid2());
        this.setAskQty1(strategy.getAskQty1());
        this.setBidQty1(strategy.getBidQty1());
        this.setAskQty1PlusAskQty2(strategy.getAskQty1PlusAskQty2());
        this.setCustomBs(strategy.getCustomBs());
        this.getCancelType().setRaw(strategy.getCancelType());
        this.setAttackBuy(strategy.isAttackBuy());
        this.setAttackSell(strategy.isAttackSell());
        this.setBidRefPriceFormula(strategy.getBidRefPriceFormula());
        this.setOfferRefPriceFormula(strategy.getOfferRefPriceFormula());
        this.setBidSpread(strategy.getBidSpread());
        this.setAskSpread(strategy.getAskSpread());
        this.setBidPriceSlip(strategy.getBidPriceSlip());
        this.setOfferPriceSlip(this.getOfferPriceSlip());
        this.setMaxDeal(strategy.getMaxDeal());
        this.setBidQty(strategy.getBidQty());
        this.setAskQty(strategy.getAskQty());
        this.setBidUpLimit(strategy.getBidUpLimit());
        this.setBidFloorLimit(strategy.getBidFloorLimit());
        this.setOfferUpLimit(strategy.getOfferUpLimit());
        this.setOfferFloorLimit(strategy.getOfferFloorLimit());
        XBond xbond = new XBond();
        xbond.update(strategy.getHedgeContract());
        this.setHedgeContract(xbond);
        this.setMarketMakingCount(strategy.getMarketMakingCount());
        this.setHedgeCount(strategy.getHedgeCount());
        this.setBidHedgePriceFormula(strategy.getBidHedgePriceFormula());
        this.setOfferHedgePriceFormula(strategy.getOfferHedgePriceFormula());
        this.setTimeoutFill(strategy.getTimeoutFill());
        this.setStoplossFill(strategy.getStoplossFill());
    }

    private void update(XBondStrategy strategy) {
        this.setName(strategy.getName());
        this.setContextId(strategy.getContextId());
        this.setType(strategy.getType());
        this.setStatus(strategy.getStatus());
        this.setErrorMsg(strategy.getErrorMsg());
        this.setParentExtAccntId(strategy.getParentExtAccntId());
        this.setExtFundAccntId(strategy.getExtFundAccntId());
        this.setExtSecAccntId(strategy.getExtSecAccntId());
        this.setMarket(strategy.getMarket());
        this.setSecurityId(strategy.getSecurityId());
        this.setSecurityType(strategy.getSecurityType());
        this.setSecurityName(strategy.getSecurityName());
        this.setDealLimit(strategy.getDealLimit());
        this.setFilledQty(strategy.getFilledQty());
        this.setTemplate(strategy.isTemplate());
        this.setShowUpdateBtn(strategy.isShowUpdateBtn());
        this.getBasePrice().setRaw(strategy.getBasePrice().getRaw());
        this.getBasePriceHedge().setRaw(strategy.getBasePriceHedge().getRaw());
        this.setQty(strategy.getQty());
        this.setSpread(strategy.getSpread());
        this.setSpreadHedge(strategy.getSpreadHedge());
        this.setAsk1MinusBid1(strategy.getAsk1MinusBid1());
        this.setAsk2MinusBid2(strategy.getAsk2MinusBid2());
        this.setAskQty1(strategy.getAskQty1());
        this.setBidQty1(strategy.getBidQty1());
        this.setAskQty1PlusAskQty2(strategy.getAskQty1PlusAskQty2());
        this.setCancelType(strategy.getCancelType());
        this.setCustomBs(strategy.getType().getRaw());
        this.setAttackBuy(strategy.isAttackBuy());
        this.setAttackSell(strategy.isAttackSell());
        this.setBidRefPriceFormula(strategy.getBidRefPriceFormula());
        this.setOfferRefPriceFormula(strategy.getOfferRefPriceFormula());
        this.setBidSpread(strategy.getBidSpread());
        this.setAskSpread(strategy.getAskSpread());
        this.setBidPriceSlip(strategy.getBidPriceSlip());
        this.setOfferPriceSlip(this.getOfferPriceSlip());
        this.setMaxDeal(strategy.getMaxDeal());
        this.setBidQty(strategy.getBidQty());
        this.setAskQty(strategy.getAskQty());
        this.setBidUpLimit(strategy.getBidUpLimit());
        this.setBidFloorLimit(strategy.getBidFloorLimit());
        this.setOfferUpLimit(strategy.getOfferUpLimit());
        this.setOfferFloorLimit(strategy.getOfferFloorLimit());
        this.setHedgeContract(strategy.getHedgeContract());
        this.setMarketMakingCount(strategy.getMarketMakingCount());
        this.setHedgeCount(strategy.getHedgeCount());
        this.setBidHedgePriceFormula(strategy.getBidHedgePriceFormula());
        this.setOfferHedgePriceFormula(strategy.getOfferHedgePriceFormula());
        this.setTimeoutFill(strategy.getTimeoutFill());
        this.setStoplossFill(strategy.getStoplossFill());
        this.setYieldBid(strategy.getYieldBid());
        this.setYieldOffer(strategy.getYieldOffer());
        this.setPriceBid(strategy.getYieldBid());
        this.setPriceOffer(strategy.getYieldOffer());
    }

    private void update(ContextSettings context) {
        this.setName(context.getName());
        if (context.getAlgoId() != null) {
            this.setContextId(context.getAlgoId());
        }
        if (context.getAlgoStatus() != null) {
            this.getStatus().setRaw(String.valueOf(context.getAlgoStatus().ordinal()));
        } else {
            this.getStatus().setRaw("2");
        }
        if (this.getStatus().getRaw().equals("2")) {
            this.setShowUpdateBtn(true);
        } else {
            this.setShowUpdateBtn(false);
        }
        this.getType().setRaw(String.valueOf(context.getExecModeType()));
        if (context.getText() != null) {
            this.setErrorMsg(context.getText());
        }
        this.setTemplate(context.isTemplate());
        Gson gson = new Gson();
        String json = gson.toJson(context.getDetails());
        JsonObject jo = (JsonObject)gson.fromJson(json, JsonObject.class);
        if (jo.get("@type").getAsString().contains("XbondContextSettings")) {
            XbondContextSettings xbond = (XbondContextSettings)gson.fromJson((JsonElement)jo, XbondContextSettings.class);
            this.xbondParamParse(xbond);
        } else if (jo.get("@type").getAsString().contains("CustomContextSettings")) {
            CustomContextSettings custom = (CustomContextSettings)gson.fromJson((JsonElement)jo, CustomContextSettings.class);
            this.customParamParse(custom);
        }
    }

    private void customParamParse(CustomContextSettings custom) {
        String offerFloorLimit;
        String offerUpLimit;
        String bidFloorLimit;
        String offerRefPriceFormula;
        double base = 1.0E7;
        this.setExtFundAccntId(custom.getAccount().getExtFundAccntId());
        this.setExtSecAccntId(custom.getAccount().getExtSecAccntId());
        this.setParentExtAccntId(custom.getAccount().getParentExtAccntId());
        CustomSecuritySettings security = custom.getSecurity();
        this.setMarket(security.getInstrument().getMarket());
        this.setSecurityId(security.getInstrument().getSecurityId());
        this.setSecurityType(security.getInstrument().getSecurityType());
        this.setSecurityName(security.getInstrument().getSymbol());
        this.setCustomBs(this.getType().getRaw());
        String bidRefPriceFormula = custom.getSecurity().getBidRefPriceFormula();
        if (bidRefPriceFormula != null) {
            int sub;
            int add = bidRefPriceFormula.lastIndexOf("+");
            int indexBid = add > (sub = bidRefPriceFormula.lastIndexOf("-")) ? add : sub;
            this.setAttackBuy(sub > add);
            if (indexBid > -1) {
                this.setBidRefPriceFormula(bidRefPriceFormula.substring(0, indexBid));
                this.setBidSpread(Double.parseDouble(bidRefPriceFormula.substring(indexBid + 1)) * 100.0);
            }
        }
        if ((offerRefPriceFormula = custom.getSecurity().getOfferRefPriceFormula()) != null) {
            int sub;
            int add = offerRefPriceFormula.lastIndexOf("+");
            int indexOffer = add > (sub = offerRefPriceFormula.lastIndexOf("-")) ? add : sub;
            this.setAttackSell(add > sub);
            if (indexOffer > -1) {
                this.setOfferRefPriceFormula(offerRefPriceFormula.substring(0, indexOffer));
                this.setAskSpread(Double.parseDouble(offerRefPriceFormula.substring(indexOffer + 1)) * 100.0);
            }
        }
        this.setBidPriceSlip(custom.getSecurity().getBidPriceSlip() * 100.0);
        this.setOfferPriceSlip(custom.getSecurity().getOfferPriceSlip() * 100.0);
        this.setMaxDeal((double)custom.getSecurity().getMaxAllowFilledQty() / base);
        this.setBidQty((double)custom.getSecurity().getBidQty() / base);
        this.setAskQty((double)custom.getSecurity().getOfferQty() / base);
        String bidUpLimit = custom.getSecurity().getBidUpLimit();
        if (bidUpLimit != null) {
            this.setBidUpLimit(bidUpLimit);
        }
        if ((bidFloorLimit = custom.getSecurity().getBidFloorLimit()) != null) {
            this.setBidFloorLimit(bidFloorLimit);
        }
        if ((offerUpLimit = custom.getSecurity().getOfferUpLimit()) != null) {
            this.setOfferUpLimit(offerUpLimit);
        }
        if ((offerFloorLimit = custom.getSecurity().getOfferFloorLimit()) != null) {
            this.setOfferFloorLimit(offerFloorLimit);
        }
        XBond xbond = new XBond();
        xbond.update(custom.getHedge().getHedgeInstrument());
        this.setHedgeContract(xbond);
        String bidFormula = custom.getHedge().getBidHedgePriceFormula();
        String offerFormula = custom.getHedge().getOfferHedgePriceFormula();
        if (bidFormula != null || offerFormula != null) {
            this.setBidHedgePriceFormula(bidFormula == null ? "" : bidFormula);
            this.setOfferHedgePriceFormula(offerFormula == null ? "" : offerFormula);
            this.setMarketMakingCount(custom.getHedge().getAlgoContractQtyScale());
            this.setHedgeCount(custom.getHedge().getHedgeContractQtyScale());
            if (custom.getHedge().getTimeoutFill() != null) {
                this.setTimeoutFill(custom.getHedge().getTimeoutFill() / 1000);
            }
            if (custom.getHedge().getStoplossFill() != null) {
                this.setStoplossFill(custom.getHedge().getStoplossFill() * 100.0);
            }
        }
        this.setDealLimit((double)custom.getSecurity().getMaxAllowFilledQty() / base);
        this.setFilledQty(custom.getSecurity().getMaxHaveFilledQty() / 10000 / 1000);
        this.getCancelType().setRaw(String.valueOf(custom.getSecurity().isFullFilledCancel()));
    }

    private void xbondParamParse(XbondContextSettings xbond) {
        String priceType;
        int base = 10000000;
        this.setExtFundAccntId(xbond.getAccount().getExtFundAccntId());
        this.setExtSecAccntId(xbond.getAccount().getExtSecAccntId());
        this.setParentExtAccntId(xbond.getAccount().getParentExtAccntId());
        this.setMarket(xbond.getSecurity().getInstrument().getMarket());
        this.setSecurityId(xbond.getSecurity().getInstrument().getSecurityId());
        this.setSecurityType(xbond.getSecurity().getInstrument().getSecurityType());
        this.setSecurityName(xbond.getSecurity().getInstrument().getSymbol());
        String code = "[" + xbond.getSecurity().getInstrument().getSecurityId() + "].";
        for (StrategyCondition condition : xbond.getSecurity().getStrategyCondition()) {
            switch (condition.getFormula().replace(code, "")) {
                case "ASK_1-BID_1": {
                    this.setAsk1MinusBid1(condition.getRefValue());
                    break;
                }
                case "ASK_2-BID_2": {
                    this.setAsk2MinusBid2(condition.getRefValue());
                    break;
                }
                case "ASK_QTY_1": {
                    this.setAskQty1(condition.getRefValue() / (double)base);
                    break;
                }
                case "BID_QTY_1": {
                    this.setBidQty1(condition.getRefValue() / (double)base);
                    break;
                }
                case "ASK_QTY_1+ASK_QTY_2": {
                    this.setAskQty1PlusAskQty2(condition.getRefValue() / (double)base);
                }
            }
        }
        String formula = xbond.getSecurity().getBidRefPriceFormula();
        this.getBasePrice().setRaw(this.getBasePriceByFormula(formula));
        this.setSpread(this.getSpreadByFormula(formula));
        if (this.getType().getRaw().equals("13") && StringUtils.isEmpty((String)formula) && (formula = xbond.getSecurity().getOfferRefPriceFormula()) != null) {
            priceType = "";
            priceType = this.getBasePriceByFormula(formula).contains("ASK") ? this.getBasePriceByFormula(formula).replace("ASK", "BID") : this.getBasePriceByFormula(formula).replace("BID", "ASK");
            this.getBasePrice().setRaw(priceType);
            this.setSpread(this.getSpreadByFormula(formula));
        }
        if ((formula = xbond.getSecurity().getBidHedgePriceFormula()) != null) {
            priceType = "";
            priceType = this.getBasePriceByFormula(formula).contains("ASK") ? this.getBasePriceByFormula(formula).replace("ASK", "BID") : this.getBasePriceByFormula(formula).replace("BID", "ASK");
            this.getBasePriceHedge().setRaw(priceType);
            this.setSpreadHedge(this.getSpreadByFormula(formula));
        }
        if (this.getType().getRaw().equals("13") && StringUtils.isEmpty((String)formula) && (formula = xbond.getSecurity().getOfferHedgePriceFormula()) != null) {
            this.setSpreadHedge(this.getSpreadByFormula(formula));
        }
        this.setQty(xbond.getSecurity().getQty() / base);
        this.setDealLimit(xbond.getSecurity().getMaxAllowFilledQty() / base);
        if (xbond.getSecurity().getMaxHaveFilledQty() != null) {
            this.setFilledQty(xbond.getSecurity().getMaxHaveFilledQty() / base);
        }
    }

    private String getBasePriceByFormula(String formula) {
        try {
            int begin = formula.indexOf(46);
            int end = formula.indexOf(43);
            if (end < 0) {
                end = formula.indexOf(45);
            }
            if (end > 0) {
                return formula.substring(begin + 1, end).trim();
            }
            return formula.substring(begin + 1).trim();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return "";
        }
    }

    private double getSpreadByFormula(String formula) {
        if (formula == null) {
            return 0.0;
        }
        int index = formula.indexOf(43);
        if (index < 0) {
            index = formula.indexOf(45);
        }
        if (index > 0) {
            return Double.valueOf(formula.substring(index + 1).trim().replaceAll(",", ""));
        }
        return 0.0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextId == null ? 0 : ((String)this.contextId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XBondStrategy other = (XBondStrategy)obj;
        return !(this.contextId == null ? other.contextId != null : !((String)this.contextId.get()).equals(other.contextId.get()));
    }

    public String getParentExtAccntId() {
        return this.parentExtAccntId;
    }

    public void setParentExtAccntId(String parentExtAccntId) {
        this.parentExtAccntId = parentExtAccntId;
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty contextIdProperty() {
        return this.contextId;
    }

    public final String getContextId() {
        return (String)this.contextIdProperty().get();
    }

    public final void setContextId(String contextId) {
        this.contextIdProperty().set((Object)contextId);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty errorMsgProperty() {
        return this.errorMsg;
    }

    public final String getErrorMsg() {
        return (String)this.errorMsgProperty().get();
    }

    public final void setErrorMsg(String errorMsg) {
        this.errorMsgProperty().set((Object)errorMsg);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final ObjectProperty<MxNode> basePriceProperty() {
        return this.basePrice;
    }

    public final MxNode getBasePrice() {
        return (MxNode)this.basePriceProperty().get();
    }

    public final void setBasePrice(MxNode basePrice) {
        this.basePriceProperty().set((Object)basePrice);
    }

    public final ObjectProperty<MxNode> basePriceHedgeProperty() {
        return this.basePriceHedge;
    }

    public final MxNode getBasePriceHedge() {
        return (MxNode)this.basePriceHedgeProperty().get();
    }

    public final void setBasePriceHedge(MxNode basePriceHedge) {
        this.basePriceHedgeProperty().set((Object)basePriceHedge);
    }

    public final IntegerProperty qtyProperty() {
        return this.qty;
    }

    public final int getQty() {
        return this.qtyProperty().get();
    }

    public final void setQty(int qty) {
        this.qtyProperty().set(qty);
    }

    public final DoubleProperty spreadProperty() {
        return this.spread;
    }

    public final double getSpread() {
        return this.spreadProperty().get();
    }

    public final void setSpread(double spread) {
        this.spreadProperty().set(spread);
    }

    public final DoubleProperty spreadHedgeProperty() {
        return this.spreadHedge;
    }

    public final double getSpreadHedge() {
        return this.spreadHedgeProperty().get();
    }

    public final void setSpreadHedge(double spreadHedge) {
        this.spreadHedgeProperty().set(spreadHedge);
    }

    public final BooleanProperty showUpdateBtnProperty() {
        return this.showUpdateBtn;
    }

    public final boolean isShowUpdateBtn() {
        return this.showUpdateBtnProperty().get();
    }

    public final void setShowUpdateBtn(boolean showUpdateBtn) {
        this.showUpdateBtnProperty().set(showUpdateBtn);
    }

    public double getAsk1MinusBid1() {
        return this.ask1MinusBid1;
    }

    public void setAsk1MinusBid1(double ask1MinusBid1) {
        this.ask1MinusBid1 = ask1MinusBid1;
    }

    public double getAsk2MinusBid2() {
        return this.ask2MinusBid2;
    }

    public void setAsk2MinusBid2(double ask2MinusBid2) {
        this.ask2MinusBid2 = ask2MinusBid2;
    }

    public double getAskQty1() {
        return this.askQty1;
    }

    public void setAskQty1(double askQty1) {
        this.askQty1 = askQty1;
    }

    public double getAskQty1PlusAskQty2() {
        return this.askQty1PlusAskQty2;
    }

    public void setAskQty1PlusAskQty2(double askQty1PlusAskQty2) {
        this.askQty1PlusAskQty2 = askQty1PlusAskQty2;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean inExe) {
        this.template = inExe;
    }

    public String getExtFundAccntId() {
        return this.extFundAccntId;
    }

    public void setExtFundAccntId(String extFundAccntId) {
        this.extFundAccntId = extFundAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public final IntegerProperty filledQtyProperty() {
        return this.filledQty;
    }

    public final int getFilledQty() {
        return this.filledQtyProperty().get();
    }

    public final void setFilledQty(int filledQty) {
        this.filledQtyProperty().set(filledQty);
    }

    public double getBidQty1() {
        return this.bidQty1;
    }

    public void setBidQty1(double bidQty1) {
        this.bidQty1 = bidQty1;
    }

    public String getCustomBs() {
        return this.customBs;
    }

    public void setCustomBs(String customBs) {
        this.customBs = customBs;
    }

    public double getBidSpread() {
        return this.bidSpread;
    }

    public void setBidSpread(double bidSpread) {
        this.bidSpread = bidSpread;
    }

    public double getAskSpread() {
        return this.askSpread;
    }

    public void setAskSpread(double askSpread) {
        this.askSpread = askSpread;
    }

    public double getBidPriceSlip() {
        return this.bidPriceSlip;
    }

    public void setBidPriceSlip(double bidPriceSlip) {
        this.bidPriceSlip = bidPriceSlip;
    }

    public double getOfferPriceSlip() {
        return this.offerPriceSlip;
    }

    public void setOfferPriceSlip(double offerPriceSlip) {
        this.offerPriceSlip = offerPriceSlip;
    }

    public double getMaxDeal() {
        return this.maxDeal;
    }

    public void setMaxDeal(double maxDeal) {
        this.maxDeal = maxDeal;
    }

    public double getBidQty() {
        return this.bidQty;
    }

    public void setBidQty(double bidQty) {
        this.bidQty = bidQty;
    }

    public double getAskQty() {
        return this.askQty;
    }

    public void setAskQty(double askQty) {
        this.askQty = askQty;
    }

    public XBond getHedgeContract() {
        return this.hedgeContract;
    }

    public void setHedgeContract(XBond hedgeContract) {
        this.hedgeContract = hedgeContract;
    }

    public String getBidHedgePriceFormula() {
        return this.bidHedgePriceFormula;
    }

    public void setBidHedgePriceFormula(String bidHedgePriceFormula) {
        this.bidHedgePriceFormula = bidHedgePriceFormula;
    }

    public String getOfferHedgePriceFormula() {
        return this.offerHedgePriceFormula;
    }

    public void setOfferHedgePriceFormula(String offerHedgePriceFormula) {
        this.offerHedgePriceFormula = offerHedgePriceFormula;
    }

    public int getMarketMakingCount() {
        return this.marketMakingCount;
    }

    public void setMarketMakingCount(int marketMakingCount) {
        this.marketMakingCount = marketMakingCount;
    }

    public int getHedgeCount() {
        return this.hedgeCount;
    }

    public void setHedgeCount(int hedgeCount) {
        this.hedgeCount = hedgeCount;
    }

    public int getTimeoutFill() {
        return this.timeoutFill;
    }

    public void setTimeoutFill(int timeoutFill) {
        this.timeoutFill = timeoutFill;
    }

    public double getStoplossFill() {
        return this.stoplossFill;
    }

    public void setStoplossFill(double stoplossFill) {
        this.stoplossFill = stoplossFill;
    }

    public final DoubleProperty dealLimitProperty() {
        return this.dealLimit;
    }

    public final double getDealLimit() {
        return this.dealLimitProperty().get();
    }

    public final void setDealLimit(double dealLimit) {
        this.dealLimitProperty().set(dealLimit);
    }

    public boolean isAttackBuy() {
        return this.attackBuy;
    }

    public void setAttackBuy(boolean attackBuy) {
        this.attackBuy = attackBuy;
    }

    public boolean isAttackSell() {
        return this.attackSell;
    }

    public void setAttackSell(boolean attackSell) {
        this.attackSell = attackSell;
    }

    public String getBidRefPriceFormula() {
        return this.bidRefPriceFormula;
    }

    public void setBidRefPriceFormula(String bidRefPriceFormula) {
        this.bidRefPriceFormula = bidRefPriceFormula;
    }

    public String getOfferRefPriceFormula() {
        return this.offerRefPriceFormula;
    }

    public void setOfferRefPriceFormula(String offerRefPriceFormula) {
        this.offerRefPriceFormula = offerRefPriceFormula;
    }

    public final ObjectProperty<MxNode> cancelTypeProperty() {
        return this.cancelType;
    }

    public final MxNode getCancelType() {
        return (MxNode)this.cancelTypeProperty().get();
    }

    public final void setCancelType(MxNode cancelType) {
        this.cancelTypeProperty().set((Object)cancelType);
    }

    public String getBidUpLimit() {
        return this.bidUpLimit;
    }

    public void setBidUpLimit(String bidUpLimit) {
        this.bidUpLimit = bidUpLimit;
    }

    public String getBidFloorLimit() {
        return this.bidFloorLimit;
    }

    public void setBidFloorLimit(String bidFloorLimit) {
        this.bidFloorLimit = bidFloorLimit;
    }

    public String getOfferUpLimit() {
        return this.offerUpLimit;
    }

    public void setOfferUpLimit(String offerUpLimit) {
        this.offerUpLimit = offerUpLimit;
    }

    public String getOfferFloorLimit() {
        return this.offerFloorLimit;
    }

    public void setOfferFloorLimit(String offerFloorLimit) {
        this.offerFloorLimit = offerFloorLimit;
    }

    public static void main(String[] args) {
        String formula = "[180021].ASK_2+[180021].BID_2-0.0001";
        int index = formula.lastIndexOf("[+]|[-]");
        System.out.println(index);
    }

    public final StringProperty yieldBidProperty() {
        return this.yieldBid;
    }

    public final String getYieldBid() {
        return (String)this.yieldBidProperty().get();
    }

    public final void setYieldBid(String yieldBid) {
        this.yieldBidProperty().set((Object)yieldBid);
    }

    public final StringProperty yieldOfferProperty() {
        return this.yieldOffer;
    }

    public final String getYieldOffer() {
        return (String)this.yieldOfferProperty().get();
    }

    public final void setYieldOffer(String yieldOffer) {
        this.yieldOfferProperty().set((Object)yieldOffer);
    }

    public final StringProperty priceBidProperty() {
        return this.priceBid;
    }

    public final String getPriceBid() {
        return (String)this.priceBidProperty().get();
    }

    public final void setPriceBid(String priceBid) {
        this.priceBidProperty().set((Object)priceBid);
    }

    public final StringProperty priceOfferProperty() {
        return this.priceOffer;
    }

    public final String getPriceOffer() {
        return (String)this.priceOfferProperty().get();
    }

    public final void setPriceOffer(String priceOffer) {
        this.priceOfferProperty().set((Object)priceOffer);
    }
}

