/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.trade;

import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.http.trans.record.OtcTransRecords;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class TransRecord
extends MxObject {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty fundAccId = new SimpleStringProperty("");
    private StringProperty masterPortId = new SimpleStringProperty("");
    private StringProperty masterPortName = new SimpleStringProperty("");
    private StringProperty slavePortId = new SimpleStringProperty("");
    private StringProperty slavePortName = new SimpleStringProperty("");
    private StringProperty masterPartyId = new SimpleStringProperty("");
    private StringProperty userId = new SimpleStringProperty("");
    private StringProperty partyId = new SimpleStringProperty("");
    private StringProperty operDate = new SimpleStringProperty("");
    private StringProperty operTime = new SimpleStringProperty("");
    private StringProperty transAmt = new SimpleStringProperty("");
    private StringProperty currency = new SimpleStringProperty("");
    private DoubleProperty srcPreAmt = new SimpleDoubleProperty();
    private DoubleProperty dstPreAmt = new SimpleDoubleProperty();
    private DoubleProperty srcPostAmt = new SimpleDoubleProperty();
    private DoubleProperty dstPostAmt = new SimpleDoubleProperty();
    private StringProperty SecAccId = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private IntegerProperty count = new SimpleIntegerProperty();
    private DoubleProperty countDouble = new SimpleDoubleProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private static MxNode nodeCurr;

    @PostConstruct
    public void init() {
        if (nodeCurr == null) {
            nodeCurr = MxNodeFactory.create((String)"currency_type", (String)"\u4eba\u6c11\u5e01");
        }
    }

    public void update(Object obj) {
        if (obj instanceof PCashService.CashTransRecord) {
            this.update((PCashService.CashTransRecord)PCashService.CashTransRecord.class.cast(obj));
        } else if (obj instanceof PCashService.PosTransRecord) {
            this.update((PCashService.PosTransRecord)PCashService.PosTransRecord.class.cast(obj));
        } else if (obj instanceof OtcTransRecords) {
            this.update((OtcTransRecords)OtcTransRecords.class.cast(obj));
        }
    }

    private void update(OtcTransRecords record) {
        this.setFundAccId(record.getInvestorId());
        this.setSecAccId(record.getInvestorSecId());
        if (record.getTransType() == 1) {
            this.setMasterPortId(record.getInvestorId());
            this.setSlavePortId(record.getDstPortfolioId());
        } else if (record.getTransType() == 2) {
            this.setMasterPortId(record.getSrcPortfolioId());
            this.setSlavePortId(record.getInvestorId());
        } else if (record.getTransType() == 3) {
            this.setMasterPortId(record.getSrcPortfolioId());
            this.setSlavePortId(record.getDstPortfolioId());
        }
        if (record.getInstrument() != null) {
            this.setCode(record.getInstrument().getSecurityId());
            this.setName(record.getInstrument().getSymbol());
        }
        this.setCountDouble(record.getTransQty());
        this.setPrice(record.getTransPrice());
        this.setOperDate(record.getTransDate());
        this.setOperTime(record.getTransTime());
        this.setUserId(record.getUserId());
    }

    private void update(PCashService.CashTransRecord record) {
        this.setId(record.getTransBatchId());
        this.setFundAccId(record.getExtAccntId().replaceAll("[_A-Z]$*", ""));
        String srcProtf = record.getSrcPortfolioId();
        String dstProtf = record.getDstPortfolioId();
        this.setMasterPortId(srcProtf.isEmpty() ? this.getFundAccId() : srcProtf);
        this.setSlavePortId(dstProtf.isEmpty() ? this.getFundAccId() : dstProtf);
        this.setMasterPartyId(record.getSrcPartyId());
        BigDecimal big = new BigDecimal(record.getTransAmt());
        String amt = big.setScale(2, 4).toString();
        this.setTransAmt(amt);
        nodeCurr.setRaw(record.getCurrency());
        this.setCurrency(nodeCurr.getValue());
        this.setSrcPreAmt(record.getSrcPreAmt());
        this.setDstPreAmt(record.getDstPreAmt());
        this.setSrcPostAmt(record.getSrcPostAmt());
        this.setDstPostAmt(record.getDstPostAmt());
        this.setUserId(record.getUserId());
        this.setPartyId(record.getUserPartyId());
        this.setOperDate(record.getOperDate());
        this.setOperTime(record.getOperTime());
    }

    private void update(PCashService.PosTransRecord record) {
        this.setId(record.getTransBatchId());
        this.setFundAccId(record.getExtAccntId().replaceAll("[_A-Z]*", ""));
        String srcProtf = record.getSrcPortfolioId();
        String dstProtf = record.getDstPortfolioId();
        this.setMasterPortId(srcProtf.isEmpty() ? this.getFundAccId() : srcProtf);
        this.setSlavePortId(dstProtf.isEmpty() ? this.getFundAccId() : dstProtf);
        this.setMasterPartyId(record.getSrcPartyId());
        this.setUserId(record.getUserId());
        this.setPartyId(record.getUserPartyId());
        this.setOperDate(record.getOperDate());
        this.setOperTime(record.getOperTime());
        PCashService.TransPositionElem elem = record.getElem();
        String SecAccnt2 = elem.getSecAccntId().substring(0, elem.getSecAccntId().indexOf("_"));
        this.setSecAccId(SecAccnt2);
        this.setMarket(elem.getMic());
        this.setCode(elem.getSecurityId());
        this.setName(elem.getSymbol());
        this.setCount((int)elem.getQuantity());
        this.setPrice(BigDecimal.valueOf(elem.getCostPrice()).setScale(2, 4).doubleValue());
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty fundAccIdProperty() {
        return this.fundAccId;
    }

    public final String getFundAccId() {
        return (String)this.fundAccIdProperty().get();
    }

    public final void setFundAccId(String fundAccId) {
        this.fundAccIdProperty().set((Object)fundAccId);
    }

    public final StringProperty masterPortIdProperty() {
        return this.masterPortId;
    }

    public final String getMasterPortId() {
        return (String)this.masterPortIdProperty().get();
    }

    public final void setMasterPortId(String masterPortId) {
        this.masterPortIdProperty().set((Object)masterPortId);
    }

    public final StringProperty slavePortIdProperty() {
        return this.slavePortId;
    }

    public final String getSlavePortId() {
        return (String)this.slavePortIdProperty().get();
    }

    public final void setSlavePortId(String slavePortId) {
        this.slavePortIdProperty().set((Object)slavePortId);
    }

    public final StringProperty masterPartyIdProperty() {
        return this.masterPartyId;
    }

    public final String getMasterPartyId() {
        return (String)this.masterPartyIdProperty().get();
    }

    public final void setMasterPartyId(String masterPartyId) {
        this.masterPartyIdProperty().set((Object)masterPartyId);
    }

    public final StringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public final StringProperty partyIdProperty() {
        return this.partyId;
    }

    public final String getPartyId() {
        return (String)this.partyIdProperty().get();
    }

    public final void setPartyId(String partyId) {
        this.partyIdProperty().set((Object)partyId);
    }

    public final StringProperty operDateProperty() {
        return this.operDate;
    }

    public final String getOperDate() {
        return (String)this.operDateProperty().get();
    }

    public final void setOperDate(String operDate) {
        this.operDateProperty().set((Object)operDate);
    }

    public final StringProperty operTimeProperty() {
        return this.operTime;
    }

    public final String getOperTime() {
        return (String)this.operTimeProperty().get();
    }

    public final void setOperTime(String operTime) {
        this.operTimeProperty().set((Object)operTime);
    }

    public final DoubleProperty srcPreAmtProperty() {
        return this.srcPreAmt;
    }

    public final double getSrcPreAmt() {
        return this.srcPreAmtProperty().get();
    }

    public final void setSrcPreAmt(double srcPreAmt) {
        this.srcPreAmtProperty().set(srcPreAmt);
    }

    public final DoubleProperty dstPreAmtProperty() {
        return this.dstPreAmt;
    }

    public final double getDstPreAmt() {
        return this.dstPreAmtProperty().get();
    }

    public final void setDstPreAmt(double dstPreAmt) {
        this.dstPreAmtProperty().set(dstPreAmt);
    }

    public final DoubleProperty srcPostAmtProperty() {
        return this.srcPostAmt;
    }

    public final double getSrcPostAmt() {
        return this.srcPostAmtProperty().get();
    }

    public final void setSrcPostAmt(double srcPostAmt) {
        this.srcPostAmtProperty().set(srcPostAmt);
    }

    public final DoubleProperty dstPostAmtProperty() {
        return this.dstPostAmt;
    }

    public final double getDstPostAmt() {
        return this.dstPostAmtProperty().get();
    }

    public final void setDstPostAmt(double dstPostAmt) {
        this.dstPostAmtProperty().set(dstPostAmt);
    }

    public final StringProperty SecAccIdProperty() {
        return this.SecAccId;
    }

    public final String getSecAccId() {
        return (String)this.SecAccIdProperty().get();
    }

    public final void setSecAccId(String SecAccId) {
        this.SecAccIdProperty().set((Object)SecAccId);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final IntegerProperty countProperty() {
        return this.count;
    }

    public final int getCount() {
        return this.countProperty().get();
    }

    public final void setCount(int count) {
        this.countProperty().set(count);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final StringProperty currencyProperty() {
        return this.currency;
    }

    public final String getCurrency() {
        return (String)this.currencyProperty().get();
    }

    public final void setCurrency(String currency) {
        this.currencyProperty().set((Object)currency);
    }

    public final StringProperty transAmtProperty() {
        return this.transAmt;
    }

    public final String getTransAmt() {
        return (String)this.transAmtProperty().get();
    }

    public final void setTransAmt(String transAmt) {
        this.transAmtProperty().set((Object)transAmt);
    }

    public final DoubleProperty countDoubleProperty() {
        return this.countDouble;
    }

    public final double getCountDouble() {
        return this.countDoubleProperty().get();
    }

    public final void setCountDouble(double countDouble) {
        this.countDoubleProperty().set(countDouble);
    }

    public final StringProperty masterPortNameProperty() {
        return this.masterPortName;
    }

    public final String getMasterPortName() {
        return (String)this.masterPortNameProperty().get();
    }

    public final void setMasterPortName(String masterPortName) {
        this.masterPortNameProperty().set((Object)masterPortName);
    }

    public final StringProperty slavePortNameProperty() {
        return this.slavePortName;
    }

    public final String getSlavePortName() {
        return (String)this.slavePortNameProperty().get();
    }

    public final void setSlavePortName(String slavePortName) {
        this.slavePortNameProperty().set((Object)slavePortName);
    }
}

